/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.block;

import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.tools.output.OutputBlock;
import plugins.adufour.blocks.util.BlockListener;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.protocols.gui.block.WorkFlowPanel;
import plugins.adufour.protocols.gui.link.DragDropZone;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.model.TypeSelectionModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarReferencingPolicy;

public class BlockPanel
extends JPanel
implements ActionListener,
BlockListener {
    protected static final int SHADOW_SIZE = 4;
    protected static final int MIN_HEIGHT = 34;
    protected static final int BORDER_SIZE_X = 8;
    protected static final int BORDER_SIZE_Y = 8;
    protected int ARC_SIZE = 12;
    protected static final int ICON_SIZE = 16;
    private static final Image BLOCKS = new Protocols().getDescriptor().getIconAsImage();
    private static final ImageIcon ICON_BLOCKS = new ImageIcon(BLOCKS.getScaledInstance(20, 20, 4));
    private static final IcyIcon ICON_EXPAND = new IcyIcon(ResourceUtil.ICON_WINDOW_EXPAND, 16);
    private static final IcyIcon ICON_COLLAPSE = new IcyIcon(ResourceUtil.ICON_WINDOW_COLLAPSE, 16);
    protected static final IcyIcon ICON_REMOVE = new IcyIcon(ResourceUtil.ICON_DELETE, 16);
    protected static final Image DIRTY = ResourceUtil.getColorIconAsImage("attn");
    protected static final Image READY = ResourceUtil.getColorIconAsImage("check");
    protected static final Image ERROR = ResourceUtil.getColorIconAsImage("stop");
    private static final ImageIcon ICON_DIRTY = new ImageIcon(DIRTY.getScaledInstance(16, 16, 4));
    private static final IcyIcon ICON_RUNNING = new IcyIcon(ResourceUtil.ICON_LIGHTING, 16);
    private static final ImageIcon ICON_READY = new ImageIcon(READY.getScaledInstance(16, 16, 4));
    private static final ImageIcon ICON_ERROR = new ImageIcon(ERROR.getScaledInstance(16, 16, 4));
    private static final IcyIcon ICON_RUN_TIL_HERE = new IcyIcon(ResourceUtil.ICON_PLAY, 16);
    private static final IcyIcon ICON_EMPTY = new IcyIcon(ResourceUtil.ICON_NULL, 16);
    protected final JPanel jPanelTitle = new JPanel(new GridBagLayout());
    protected final JPanel jPanelContent = new JPanel(new GridBagLayout());
    protected final JButton bMenu = new JButton(ICON_BLOCKS);
    protected final JButton bRunUntilHere = new JButton((Icon)((Object)ICON_RUN_TIL_HERE));
    protected final JButton bID = new JButton((Icon)((Object)ICON_EMPTY));
    protected final JButton bStatus = new JButton(ICON_DIRTY);
    protected final JPopupMenu menu = new JPopupMenu();
    protected final JCheckBox menuKeepResults = new JCheckBox("Remember results");
    protected final JMenuItem menuCollapse = new JMenuItem("Collapse");
    protected final JMenuItem menuRemove = new JMenuItem("Remove block");
    private final ShadowRenderer renderer = new ShadowRenderer(4, 0.5f, Color.BLACK);
    private BufferedImage backgroundImage;
    protected GradientPaint gradient;
    private Dimension expandedSize = new Dimension();
    private final BlockMotionManager mouseAdapter = new BlockMotionManager();
    public final BlockDescriptor blockDesc;
    protected final WorkFlowContainer workFlowPane;
    protected final HashMap<Var<?>, DragDropZone> varDragZones = new HashMap();
    protected final HashMap<Var<?>, DragDropZone> varDropZones = new HashMap();
    protected final HashMap<Var<?>, VarEditor<?>> varEditors = new HashMap();
    protected final Runnable refresher;
    private final JLabel name;
    private boolean selected = false;

    public BlockPanel(WorkFlowContainer wfPane, BlockDescriptor blockDesc) {
        this.blockDesc = blockDesc;
        this.workFlowPane = wfPane;
        this.name = new JLabel(blockDesc.getDefinedName() + " ", 0);
        this.setLayout(new BorderLayout());
        this.jPanelTitle.setOpaque(false);
        this.add((Component)this.jPanelTitle, "North");
        this.bMenu.setComponentPopupMenu(this.menu);
        for (AbstractButton button : new AbstractButton[]{this.bMenu, this.menuCollapse, this.bRunUntilHere, this.menuKeepResults, this.menuRemove, this.bID}) {
            button.setFocusable(false);
            button.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            if (button instanceof JButton) {
                button.setPreferredSize(new Dimension(19, 19));
                button.setBorderPainted(false);
            }
            button.addActionListener(this);
        }
        this.bStatus.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.bStatus.setPreferredSize(new Dimension(19, 19));
        this.bStatus.setEnabled(false);
        this.jPanelContent.setOpaque(false);
        this.add((Component)this.jPanelContent, "Center");
        this.expandedSize.setSize(blockDesc.getDimension());
        this.setOpaque(false);
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        blockDesc.addBlockListener(this);
        this.setBorder(new EmptyBorder(8, 0, 8, 0));
        this.setDoubleBuffered(true);
        this.setResizeable(true);
        this.refresher = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        BlockPanel.this.refreshNow();
                    }
                });
                ThreadUtil.sleep(100);
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bMenu) {
            this.bMenu.getComponentPopupMenu().show(this.bMenu, 0, this.bMenu.getHeight());
        } else if (e.getSource() == this.bStatus && this.blockDesc.getStatus() == BlockDescriptor.BlockStatus.RUNNING) {
            this.blockDesc.setFinalBlock(true);
            this.workFlowPane.getWorkFlow().interrupt();
        } else if (e.getSource() == this.menuRemove) {
            this.workFlowPane.getWorkFlow().removeBlock(this.blockDesc, false);
        } else if (e.getSource() == this.menuCollapse) {
            this.blockDesc.setCollapsed(!this.blockDesc.isCollapsed());
        } else if (e.getSource() == this.bRunUntilHere || e.getSource() == this.bID) {
            WorkFlow workflow = null;
            BlockDescriptor tmp = this.blockDesc;
            while (tmp.getContainer() != null) {
                workflow = tmp.getContainer();
                if (e.getSource() == this.bID) {
                    workflow.prioritize(tmp);
                }
                tmp = workflow.getBlockDescriptor();
            }
            if (e.getSource() == this.bRunUntilHere) {
                this.blockDesc.setFinalBlock(true);
                workflow.runWorkFlow();
            }
        } else if (e.getSource() == this.menuKeepResults) {
            this.blockDesc.keepResults(!this.blockDesc.keepsResults());
            this.menuKeepResults.setSelected(this.blockDesc.keepsResults());
            if (!this.blockDesc.keepsResults()) {
                this.blockDesc.reset();
            }
        }
    }

    @Override
    public void blockCollapsed(BlockDescriptor block, final boolean collapsed) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                BlockPanel.this.refreshNow();
                BlockPanel.this.menuCollapse.setText(BlockPanel.this.blockDesc.isCollapsed() ? "Expand" : "Collapse");
                BlockPanel.this.menuCollapse.setIcon((Icon)((Object)(collapsed ? ICON_EXPAND : ICON_COLLAPSE)));
                BlockPanel.this.setResizeable(!collapsed);
                BlockPanel.this.workFlowPane.updatePreferredSize();
            }
        });
    }

    @Override
    public void blockDimensionChanged(BlockDescriptor block, int newWidth, int newHeight) {
    }

    @Override
    public void blockLocationChanged(BlockDescriptor block, int newX, int newY) {
    }

    @Override
    public void blockStatusChanged(BlockDescriptor blockInfo, BlockDescriptor.BlockStatus status) {
        this.updateStatusIcon(status);
    }

    @Override
    public void blockVariableAdded(BlockDescriptor block, Var<?> variable) {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                BlockPanel.this.refreshNow();
            }
        });
    }

    @Override
    public <T> void blockVariableChanged(BlockDescriptor block, Var<T> variable, T newValue) {
    }

    protected DragDropZone createVarDragZone(final Var<?> variable, boolean allowExposure) {
        final DragDropZone dragZone = DragDropZone.createDragZone(DragDropZone.LINK_RIGHT, this.workFlowPane.getWorkFlow(), this.blockDesc, variable);
        if (allowExposure) {
            final JPopupMenu popup = new JPopupMenu();
            final JMenuItem itemExposeVar = new JMenuItem("Expose variable");
            popup.add(itemExposeVar);
            dragZone.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WorkFlow parent = BlockPanel.this.blockDesc.getContainer();
                    if (parent.getBlockDescriptor().isTopLevelWorkFlow()) {
                        return;
                    }
                    if (e.getButton() == 2 || e.isMetaDown()) {
                        VarList parentOutputs = parent.getBlockDescriptor().outputVars;
                        itemExposeVar.setText(parentOutputs.isVisible(variable) ? "Hide variable" : "Expose variable");
                        popup.show(dragZone, 5, 10);
                    }
                }
            });
            itemExposeVar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ThreadUtil.bgRun(new Runnable(){

                        @Override
                        public void run() {
                            VarList outputWorkFlowVars = BlockPanel.this.blockDesc.getContainer().getBlockDescriptor().outputVars;
                            outputWorkFlowVars.setVisible(variable, !outputWorkFlowVars.isVisible(variable));
                        }
                    });
                }
            });
        }
        return dragZone;
    }

    protected DragDropZone createVarDropZone(final Var<?> variable, boolean allowExposure, Image icon) {
        final DragDropZone dropZone = DragDropZone.createDropZone(icon, this.workFlowPane.getWorkFlow(), this.blockDesc, variable);
        if (allowExposure) {
            final JPopupMenu popup = new JPopupMenu();
            final JMenuItem itemExposeVar = new JMenuItem("Expose variable");
            popup.add(itemExposeVar);
            final WorkFlow parent = this.blockDesc.getContainer();
            dropZone.addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (parent.getBlockDescriptor().isTopLevelWorkFlow()) {
                        return;
                    }
                    if (variable.getReference() != null) {
                        return;
                    }
                    if (e.getButton() == 2 || e.isMetaDown()) {
                        VarList parentInputs = parent.getBlockDescriptor().inputVars;
                        itemExposeVar.setText(parentInputs.isVisible(variable) ? "Hide variable" : "Expose variable");
                        popup.show(dropZone, 5, 10);
                    }
                }
            });
            itemExposeVar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ThreadUtil.bgRun(new Runnable(){

                        @Override
                        public void run() {
                            VarList inputWorkFlowVars = BlockPanel.this.blockDesc.getContainer().getBlockDescriptor().inputVars;
                            inputWorkFlowVars.setVisible(variable, !inputWorkFlowVars.isVisible(variable));
                        }
                    });
                }
            });
        }
        return dropZone;
    }

    protected <T> VarEditor<T> createVarEditor(Var<T> variable) {
        VarEditor<T> editor = variable.isEnabled() ? variable.createVarEditor() : variable.createVarViewer();
        editor.setEnabled(true);
        return editor;
    }

    void dispose() {
        this.setVisible(false);
        this.removeAll();
        this.getUI().uninstallUI(this);
        for (AbstractButton button : new AbstractButton[]{this.bMenu, this.menuCollapse, this.bRunUntilHere, this.menuKeepResults, this.menuRemove, this.bID}) {
            button.removeActionListener(this);
        }
        this.removeMouseListener(this.mouseAdapter);
        this.removeMouseMotionListener(this.mouseAdapter);
        this.blockDesc.removeBlockListener(this);
        for (VarEditor varEditor : this.varEditors.values()) {
            varEditor.dispose();
        }
        this.varEditors.clear();
        for (DragDropZone dragDropZone : this.varDropZones.values()) {
            dragDropZone.dispose();
        }
        this.varDropZones.clear();
        for (DragDropZone dragDropZone : this.varDragZones.values()) {
            dragDropZone.dispose();
        }
        this.varDragZones.clear();
    }

    public void drawPanel() {
        Dimension oldSize = this.getSize();
        if (oldSize.width == 0 || oldSize.height == 0) {
            this.drawContent();
        }
        this.jPanelContent.removeAll();
        this.jPanelTitle.removeAll();
        this.menu.removeAll();
        this.drawMenu();
        this.drawTitle();
        if (!this.blockDesc.isCollapsed()) {
            this.drawContent();
            if (this.expandedSize.width == 0 || this.expandedSize.height == 0) {
                this.expandedSize.setSize(this.getPreferredSize());
            }
            oldSize = this.expandedSize;
        } else {
            oldSize = oldSize.width == 0 || oldSize.height == 0 ? (!this.blockDesc.isCollapsed() && this.blockDesc.getDimension().width != 0 ? this.blockDesc.getDimension() : this.getPreferredSize()) : this.getPreferredSize();
        }
        this.setBounds(this.blockDesc.getLocation().x, this.blockDesc.getLocation().y, oldSize.width, oldSize.height);
    }

    protected void drawMenu() {
        this.menu.add(this.menuCollapse);
        this.menuCollapse.setText(this.blockDesc.isCollapsed() ? "Expand" : "Collapse");
        this.menuCollapse.setIcon((Icon)((Object)(this.blockDesc.isCollapsed() ? ICON_EXPAND : ICON_COLLAPSE)));
        this.menuCollapse.setToolTipText("<html><h4>Expand or collapse this block</h4></html>");
        this.menu.addSeparator();
        if (this.blockDesc.getBlock() instanceof InputBlock || this.blockDesc.getBlock() instanceof OutputBlock) {
            String tooltip = "<html><h4>Identifier used to set the value from the command line</h4></html>";
            JPanel menuCLID = new JPanel(new FlowLayout(3));
            menuCLID.setOpaque(false);
            menuCLID.setToolTipText(tooltip);
            menuCLID.add(new JLabel("ID"));
            final JTextField fieldID = new JTextField(this.blockDesc.getCommandLineID());
            fieldID.setPreferredSize(new Dimension(80, 20));
            fieldID.setToolTipText(tooltip);
            menuCLID.add(fieldID);
            JButton bStoreFieldID = new JButton((Icon)((Object)new IcyIcon(ResourceUtil.ICON_CHECKED, 16)));
            bStoreFieldID.setFocusable(false);
            bStoreFieldID.setBorderPainted(false);
            bStoreFieldID.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
            bStoreFieldID.setToolTipText("Save the new ID");
            bStoreFieldID.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlockPanel.this.blockDesc.setCommandLineID(fieldID.getText());
                }
            });
            menuCLID.add(bStoreFieldID);
            this.menu.add(menuCLID);
        } else {
            this.menu.add(this.menuKeepResults);
            this.menuKeepResults.setSelected(this.blockDesc.keepsResults());
        }
        this.menu.addSeparator();
        this.menu.add(this.menuRemove);
        this.menuRemove.setIcon((Icon)((Object)ICON_REMOVE));
        this.menuRemove.setToolTipText("<html><h4>Remove this block from the protocol</h4></html>");
    }

    protected void drawContent() {
        int row = 1;
        for (Var<?> input : this.blockDesc.inputVars) {
            if (!this.varDropZones.containsKey(input)) {
                this.varDropZones.put(input, this.createVarDropZone(input, true, DragDropZone.LINK_RIGHT));
            }
            if (!this.varEditors.containsKey(input)) {
                this.varEditors.put(input, this.createVarEditor(input));
            }
            if (!this.varDragZones.containsKey(input)) {
                this.varDragZones.put(input, this.createVarDragZone(input, false));
            }
            JLabel inputName = new JLabel(input.getName());
            Dimension inputNameDim = inputName.getPreferredSize();
            inputNameDim.height = 20;
            inputName.setPreferredSize(inputNameDim);
            VarEditor<?> varEditor = this.varEditors.get(input);
            JComponent inputComponent = (JComponent)varEditor.getEditorComponent();
            VarReferencingPolicy policy = input.getReferencingPolicy();
            if (policy == VarReferencingPolicy.IN || policy == VarReferencingPolicy.BOTH) {
                GridBagConstraints gbc_dropZone = new GridBagConstraints();
                gbc_dropZone.anchor = 17;
                gbc_dropZone.fill = 0;
                gbc_dropZone.insets = new Insets(2, 0, 0, 0);
                gbc_dropZone.gridx = 0;
                gbc_dropZone.gridy = row;
                this.jPanelContent.add((Component)this.varDropZones.get(input), gbc_dropZone);
            }
            if (!this.blockDesc.isSingleBlock() && varEditor.isNameVisible()) {
                GridBagConstraints gbc_inputName = new GridBagConstraints();
                gbc_inputName.anchor = 10;
                gbc_inputName.fill = 2;
                gbc_inputName.insets = new Insets(2, 5, 0, 0);
                gbc_inputName.gridx = 1;
                gbc_inputName.gridy = row;
                gbc_inputName.weightx = 0.0;
                this.jPanelContent.add((Component)inputName, gbc_inputName);
            }
            if (inputComponent != null) {
                GridBagConstraints gbc_inputComponent = new GridBagConstraints();
                gbc_inputComponent.anchor = 10;
                gbc_inputComponent.fill = 1;
                gbc_inputComponent.insets = new Insets(2, 5, 0, 0);
                if (!this.blockDesc.isSingleBlock() && varEditor.isNameVisible()) {
                    gbc_inputComponent.gridwidth = 1;
                    gbc_inputComponent.gridx = 2;
                } else {
                    gbc_inputComponent.gridwidth = 2;
                    gbc_inputComponent.gridx = 1;
                }
                gbc_inputComponent.gridy = row;
                gbc_inputComponent.weightx = varEditor.getComponentHorizontalResizeFactor();
                gbc_inputComponent.weighty = varEditor.getComponentVerticalResizeFactor();
                inputComponent.setOpaque(varEditor.isComponentOpaque());
                inputComponent.setFocusable(varEditor.isComponentFocusable());
                inputComponent.setEnabled(varEditor.isComponentEnabled());
                inputComponent.setPreferredSize(varEditor.getPreferredSize());
                this.jPanelContent.add((Component)inputComponent, gbc_inputComponent);
            }
            if (policy == VarReferencingPolicy.OUT || policy == VarReferencingPolicy.BOTH) {
                GridBagConstraints gbc_dragZone = new GridBagConstraints();
                gbc_dragZone.anchor = 13;
                gbc_dragZone.fill = 0;
                gbc_dragZone.insets = new Insets(2, 5, 0, 0);
                gbc_dragZone.gridx = 3;
                gbc_dragZone.gridy = row;
                this.jPanelContent.add((Component)this.varDragZones.get(input), gbc_dragZone);
            }
            ++row;
        }
        for (Var<?> output : this.blockDesc.outputVars) {
            GridBagConstraints gbc_outputName = new GridBagConstraints();
            gbc_outputName.fill = 0;
            gbc_outputName.anchor = 13;
            gbc_outputName.insets = new Insets(2, 0, 0, 0);
            gbc_outputName.gridx = 2;
            gbc_outputName.gridy = row;
            if (this.blockDesc.inputVars.size() == 0) {
                gbc_outputName.weightx = 1.0;
                gbc_outputName.insets.right = 5;
            }
            JLabel label = new JLabel(output.getName());
            Dimension dim = label.getPreferredSize();
            dim.height = 20;
            label.setPreferredSize(dim);
            if (output instanceof VarMutable && output.getDefaultEditorModel() instanceof TypeSelectionModel) {
                if (!this.varEditors.containsKey(output)) {
                    this.varEditors.put(output, this.createVarEditor(output));
                }
                JPanel panel = new JPanel(new FlowLayout());
                panel.add(label);
                panel.add((JComponent)this.varEditors.get(output).getEditorComponent());
                panel.setOpaque(false);
                this.jPanelContent.add((Component)panel, gbc_outputName);
            } else {
                this.jPanelContent.add((Component)label, gbc_outputName);
            }
            if (!this.varDragZones.containsKey(output)) {
                this.varDragZones.put(output, this.createVarDragZone(output, true));
            }
            GridBagConstraints gbc_dragZone = new GridBagConstraints();
            gbc_dragZone.anchor = 13;
            gbc_dragZone.fill = 0;
            gbc_dragZone.insets = new Insets(2, 0, 0, 0);
            gbc_dragZone.gridx = 3;
            gbc_dragZone.gridy = row++;
            this.jPanelContent.add((Component)this.varDragZones.get(output), gbc_dragZone);
        }
    }

    protected void drawTitle() {
        GridBagConstraints gbc_icon = new GridBagConstraints();
        gbc_icon.insets = new Insets(0, 8, 4, 2);
        gbc_icon.gridx = 0;
        gbc_icon.gridy = 0;
        gbc_icon.anchor = 17;
        gbc_icon.fill = 0;
        this.jPanelTitle.add((Component)this.bMenu, gbc_icon);
        gbc_icon.insets = new Insets(0, -1, 4, 2);
        gbc_icon.gridx = 1;
        this.jPanelTitle.add((Component)this.bRunUntilHere, gbc_icon);
        this.bRunUntilHere.setToolTipText("<html><h4>Run the work-flow until this block (inclusive)</h4></html>");
        GridBagConstraints gbc_name = new GridBagConstraints();
        gbc_name.insets = new Insets(0, 3, 4, 3);
        gbc_name.anchor = 10;
        gbc_name.fill = 2;
        gbc_name.gridx = 2;
        gbc_name.gridy = 0;
        gbc_name.weightx = 1.0;
        this.name.setFont(this.name.getFont().deriveFont(3, 12.0f));
        this.jPanelTitle.add((Component)this.name, gbc_name);
        int id = 1 + this.workFlowPane.getWorkFlow().indexOf(this.blockDesc);
        GridBagConstraints gbc_id = new GridBagConstraints();
        gbc_id.insets = new Insets(0, 0, 4, 0);
        gbc_id.gridx = 3;
        gbc_id.gridy = 0;
        gbc_id.anchor = 13;
        gbc_id.fill = 2;
        BufferedImage idImage = new BufferedImage(16, 16, 2);
        Graphics2D g = idImage.createGraphics();
        g.setColor(Color.black);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font(id > 99 ? "Arial Narrow" : "Arial", 1, id > 99 ? 12 : 13));
        GraphicsUtil.drawCenteredString(g, "" + id, 8, 9, false);
        this.bID.setIcon(new ImageIcon(idImage));
        this.jPanelTitle.add((Component)this.bID, gbc_id);
        GridBagConstraints gbc_right = new GridBagConstraints();
        gbc_right.insets = new Insets(0, 0, 4, 6);
        gbc_right.gridx = 4;
        gbc_right.gridy = 0;
        gbc_right.anchor = 13;
        gbc_right.fill = 2;
        this.jPanelTitle.add((Component)this.bStatus, gbc_right);
        this.updateStatusIcon(this.blockDesc.getStatus());
    }

    private void updateStatusIcon(BlockDescriptor.BlockStatus status) {
        switch (status) {
            case READY: {
                this.bStatus.setDisabledIcon(ICON_READY);
                break;
            }
            case DIRTY: {
                this.bStatus.setDisabledIcon(ICON_DIRTY);
                break;
            }
            case RUNNING: {
                this.bStatus.setDisabledIcon((Icon)((Object)ICON_RUNNING));
                break;
            }
            case ERROR: {
                this.bStatus.setDisabledIcon(ICON_ERROR);
            }
        }
        this.bStatus.setToolTipText("<html><h4>" + status.toString().replace("\n", "<br/>") + "</h4></html>");
    }

    public WorkFlowContainer getWorkFlowContainer() {
        return this.workFlowPane;
    }

    public DragDropZone getDragZone(Var<?> input) {
        return this.varDragZones.get(input);
    }

    public DragDropZone getDropZone(Var<?> output) {
        return this.varDropZones.get(output);
    }

    public Point getDragZoneLocation(Var<?> output) {
        if (this.blockDesc.isCollapsed() && !(this instanceof WorkFlowPanel)) {
            return new Point(this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() / 2);
        }
        DragDropZone dz = this.getDragZone(output);
        if (!dz.isVisible()) {
            return new Point(this.getX() + this.getWidth() - 4, this.getY() + this.getHeight() / 2);
        }
        int x = dz.getLocationOnScreen().x - this.getParent().getLocationOnScreen().x;
        int y = dz.getLocationOnScreen().y - this.getParent().getLocationOnScreen().y;
        return new Point(x + dz.getWidth(), y + dz.getHeight() / 2);
    }

    public Point getDropZoneLocation(Var<?> input) {
        if (this.blockDesc.isCollapsed() && !(this instanceof WorkFlowPanel)) {
            return new Point(this.getX() + 4, this.getY() + this.getHeight() / 2);
        }
        DragDropZone dz = this.getDropZone(input);
        if (!dz.isVisible()) {
            return new Point(this.getX() + 4, this.getY() + this.getHeight() / 2);
        }
        int x = dz.getLocationOnScreen().x - this.getParent().getLocationOnScreen().x;
        int y = dz.getLocationOnScreen().y - this.getParent().getLocationOnScreen().y;
        return new Point(x, y + dz.getHeight() / 2);
    }

    public int getVarPanelHeight() {
        return this.getHeight();
    }

    public int getVarPanelWidth() {
        return this.getWidth();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.blockDesc.isCollapsed()) {
            return new Dimension(this.jPanelTitle.getPreferredSize().width, 34);
        }
        return super.getPreferredSize();
    }

    public VarEditor<?> getVarEditor(Var<?> variable) {
        return this.varEditors.get(variable);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.backgroundImage != null) {
            g2.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        super.paintComponent(g);
        if (this.selected) {
            g2.setColor(WorkFlowContainer.TRANSPARENT_BLUE);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 12, 12);
        }
    }

    public void refresh() {
        ThreadUtil.bgRunSingle(this.refresher);
    }

    public void refreshNow() {
        this.setVisible(false);
        this.drawPanel();
        this.setVisible(true);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == this.getWidth() && height == this.getHeight() && x == this.getX() && y == this.getY()) {
            return;
        }
        if (width != this.getWidth() || height != this.getHeight()) {
            this.backgroundImage = new BufferedImage(width, height, 2);
            Graphics2D g2 = this.backgroundImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fillRoundRect(4, 4, width - 12, height - 12, this.ARC_SIZE, this.ARC_SIZE);
            g2.dispose();
            this.backgroundImage = this.renderer.createShadow(this.backgroundImage);
            SubstanceColorScheme colors = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)this, ComponentState.PRESSED_SELECTED);
            Color brightColor = colors.isDark() ? Color.gray : Color.lightGray.brighter();
            Color darkColor = colors.isDark() ? Color.darkGray.darker().darker() : Color.darkGray.brighter();
            g2 = this.backgroundImage.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color centerColor = new Color(brightColor.getRed() - 32, brightColor.getGreen() - 32, brightColor.getBlue() - 32);
            this.gradient = new GradientPaint(new Point2D.Float(), centerColor, new Point2D.Float(0.0f, 34.0f), brightColor.darker());
            g2.setPaint(this.gradient);
            g2.fillRoundRect(4, 4, width - 8, height - 8, this.ARC_SIZE, this.ARC_SIZE);
            g2.setColor(new Color(240, 240, 240));
            g2.drawRoundRect(4, 5, width - 8, height - 1 - 8, this.ARC_SIZE, this.ARC_SIZE);
            if (!this.blockDesc.isCollapsed()) {
                g2.setColor(darkColor);
                g2.drawLine(4, 29, width - 4, 29);
                boolean uniformSkin = true;
                if (uniformSkin) {
                    g2.setColor(centerColor);
                    g2.drawLine(4, 30, width - 4, 30);
                } else {
                    g2.setColor(this.getBackground());
                    g2.fillRect(4, 31, width - 8, height - 34);
                }
            }
            g2.setColor(darkColor.brighter());
            g2.drawRoundRect(4, 4, width - 8, height - 8, this.ARC_SIZE, this.ARC_SIZE);
            g2.dispose();
            if (!this.blockDesc.isCollapsed()) {
                this.expandedSize.setSize(width, height);
            }
            this.blockDesc.setDimension(this.expandedSize.width, this.expandedSize.height);
        }
        this.blockDesc.setLocation(x, y);
        super.setBounds(x, y, width, height);
    }

    protected void setResizeable(boolean resizeable) {
        this.mouseAdapter.setResizeable(resizeable);
    }

    public void toFront() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).setLayer(this, this.blockDesc.isWorkFlow() ? 1 : 0, 0);
        }
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    private class BlockMotionManager
    implements MouseInputListener {
        private int pressedX;
        private int pressedY;
        private boolean dragging;
        private boolean resizing_EAST;
        private boolean resizing_SOUTH;
        private boolean resizing_NORTH;
        private boolean resizing_WEST;
        private boolean resizeable = false;

        private BlockMotionManager() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int h;
            int x = BlockPanel.this.getX();
            int y = BlockPanel.this.getY();
            int dx = e.getX();
            int dy = e.getY();
            int minWidth = BlockPanel.this.jPanelTitle.getPreferredSize().width;
            int w = this.resizing_EAST ? Math.max(minWidth, dx) : BlockPanel.this.getWidth();
            int minHeight = 39;
            int n = h = this.resizing_SOUTH ? Math.max(minHeight, dy) : BlockPanel.this.getHeight();
            if (this.dragging) {
                WorkFlow wf = BlockPanel.this.workFlowPane.getWorkFlow();
                if (wf.isBlockSelected(BlockPanel.this.blockDesc)) {
                    for (BlockDescriptor bd : wf.getBlockSelection()) {
                        BlockPanel bp = BlockPanel.this.workFlowPane.getBlockPanel(bd);
                        if (bp == null) continue;
                        bp.setBounds(Math.max(0, dx - this.pressedX + bp.getX()), Math.max(0, dy - this.pressedY + bp.getY()), bp.getWidth(), bp.getHeight());
                    }
                } else {
                    BlockPanel.this.setBounds(Math.max(0, dx - this.pressedX + x), Math.max(0, dy - this.pressedY + y), w, h);
                }
            } else if (this.resizeable) {
                if (this.resizing_WEST) {
                    if (w - dx < minWidth) {
                        dx = w - minWidth;
                    }
                    x += dx;
                    w -= dx;
                }
                if (this.resizing_NORTH) {
                    if (h - dy < minHeight) {
                        dy = h - minHeight;
                    }
                    y += dy;
                    h -= dy;
                }
                if (x >= 0 && y >= 0) {
                    BlockPanel.this.setBounds(x, y, w, h);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            BlockPanel.this.toFront();
            this.pressedX = e.getX();
            this.pressedY = e.getY();
            if (this.resizeable && !e.getSource().equals(BlockPanel.this.name)) {
                if (this.pressedX < 8) {
                    this.resizing_WEST = true;
                } else if (this.pressedX > BlockPanel.this.getWidth() - 8) {
                    this.resizing_EAST = true;
                }
                if (this.pressedY < 8) {
                    this.resizing_NORTH = true;
                } else if (this.pressedY > BlockPanel.this.getHeight() - 8) {
                    this.resizing_SOUTH = true;
                }
                this.dragging = !this.resizing_NORTH && !this.resizing_EAST && !this.resizing_WEST && !this.resizing_SOUTH;
            } else {
                this.dragging = true;
            }
            if ((e.getModifiers() & Protocols.MENU_SHORTCUT_KEY) == Protocols.MENU_SHORTCUT_KEY) {
                ((WorkFlowContainer)BlockPanel.this.getParent()).dispatchEvent(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.dragging = false;
            this.resizing_EAST = false;
            this.resizing_SOUTH = false;
            this.resizing_WEST = false;
            this.resizing_NORTH = false;
            if ((e.getModifiers() & Protocols.MENU_SHORTCUT_KEY) == Protocols.MENU_SHORTCUT_KEY) {
                ((WorkFlowContainer)BlockPanel.this.getParent()).dispatchEvent(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Component c = BlockPanel.this.getComponentAt(e.getX(), e.getY());
            if (e.getClickCount() == 2 && !e.isConsumed() && c != null && c.equals(BlockPanel.this.jPanelTitle)) {
                e.consume();
                final JPanel renamePanel = new JPanel();
                final JTextField newName = new JTextField(BlockPanel.this.blockDesc.getDefinedName());
                JPanel buttonPanel = new JPanel();
                JButton ok = new JButton("OK");
                JButton cancel = new JButton("Cancel");
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent okEvent) {
                        BlockPanel.this.blockDesc.setDefinedName(newName.getText());
                        BlockPanel.this.name.setText(BlockPanel.this.blockDesc.getDefinedName() + " ");
                        BlockPanel.this.workFlowPane.moveToBack(renamePanel);
                        BlockPanel.this.workFlowPane.remove(renamePanel);
                        BlockPanel.this.setSize(BlockPanel.this.getPreferredSize());
                    }
                });
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent cancelEvent) {
                        BlockPanel.this.workFlowPane.moveToBack(renamePanel);
                        BlockPanel.this.workFlowPane.remove(renamePanel);
                    }
                });
                buttonPanel.add(ok);
                buttonPanel.add(cancel);
                renamePanel.setLayout(new GridLayout(2, 1));
                renamePanel.add(newName);
                renamePanel.add(buttonPanel);
                renamePanel.setOpaque(false);
                renamePanel.setSize(new Dimension(180, 60));
                renamePanel.setBorder(BorderFactory.createRaisedBevelBorder());
                renamePanel.setLocation(BlockPanel.this.jPanelTitle.getLocationOnScreen().x - BlockPanel.this.workFlowPane.getLocationOnScreen().x, BlockPanel.this.jPanelTitle.getLocationOnScreen().y - BlockPanel.this.workFlowPane.getLocationOnScreen().y - renamePanel.getHeight());
                BlockPanel.this.workFlowPane.add(renamePanel);
                BlockPanel.this.workFlowPane.moveToFront(renamePanel);
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            BlockPanel.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            int x = arg0.getX();
            int y = arg0.getY();
            if (this.resizeable && !arg0.getSource().equals(BlockPanel.this.name)) {
                if (x < 8) {
                    if (y < 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (y > BlockPanel.this.getHeight() - 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (x > BlockPanel.this.getWidth() - 8) {
                    if (y < 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (y > BlockPanel.this.getHeight() - 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (y < 8) {
                    if (x < 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (x > BlockPanel.this.getWidth() - 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (y > BlockPanel.this.getHeight() - 8) {
                    if (x < 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (x > BlockPanel.this.getWidth() - 8) {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        BlockPanel.this.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    BlockPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else {
                BlockPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void setResizeable(boolean resizeable) {
            this.resizeable = resizeable;
        }
    }
}

