/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.livebar;

import icy.network.NetworkUtil;
import icy.search.OnlineSearchResultProducer;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.livebar.ProtocolDescriptor;
import plugins.adufour.protocols.livebar.ProtocolRichToolTip;

public class OnlineProtocolProducer
extends OnlineSearchResultProducer {
    private static final String ID_TEXT = "string";
    private static final String ID_SEARCH_RESULT = "searchresult";
    private static final String ID_PROTOCOL = "protocol";

    @Override
    public void doSearch(Document doc, String[] words, SearchResultConsumer consumer) {
        if (doc == null) {
            return;
        }
        if (this.getClass().getClassLoader() != SystemUtil.getSystemClassLoader() && this.hasWaitingSearch()) {
            return;
        }
        Element resultElement = XMLUtil.getElement(doc.getDocumentElement(), ID_SEARCH_RESULT);
        if (resultElement == null) {
            return;
        }
        ArrayList<OnlineProtocolResult> tmpResults = new ArrayList<OnlineProtocolResult>();
        for (Element protocol : XMLUtil.getElements(resultElement, ID_PROTOCOL)) {
            if (this.getClass().getClassLoader() != SystemUtil.getSystemClassLoader() && this.hasWaitingSearch()) {
                return;
            }
            ProtocolDescriptor onlineProtocol = new ProtocolDescriptor(protocol);
            String text = XMLUtil.getElementValue(protocol, ID_TEXT, "");
            OnlineProtocolResult result = new OnlineProtocolResult(this, onlineProtocol, text, words);
            if (result == null) continue;
            tmpResults.add(result);
        }
        this.results = tmpResults;
        consumer.resultsChanged(this);
    }

    @Override
    public String getName() {
        return "Online Protocols";
    }

    private class OnlineProtocolResult
    extends SearchResult {
        final ProtocolDescriptor protocol;
        private String description;

        public OnlineProtocolResult(SearchResultProducer provider, ProtocolDescriptor protocol, String text, String[] searchWords) {
            super(provider);
            this.protocol = protocol;
            this.description = "";
            for (int wi = 0; StringUtil.isEmpty(this.description) && wi < searchWords.length; ++wi) {
                this.description = StringUtil.trunc(text, searchWords[wi], 80);
            }
            if (!StringUtil.isEmpty(this.description)) {
                this.description = this.description.replace("\n", "");
                if (searchWords.length > 1 || searchWords[0].length() > 2) {
                    for (String word : searchWords) {
                        this.description = StringUtil.htmlBoldSubstring(this.description, word, true);
                    }
                }
            }
        }

        @Override
        public String getTitle() {
            return this.protocol.getName();
        }

        @Override
        public Image getImage() {
            ImageIcon icon = this.protocol.getIcon();
            if (icon != null) {
                return icon.getImage();
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getTooltip() {
            return "Left click: Open   -   Right click: Online documentation";
        }

        @Override
        public void execute() {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Protocols.loadWorkFlow(OnlineProtocolResult.this.protocol.getFile());
                }
            });
        }

        @Override
        public void executeAlternate() {
            NetworkUtil.openBrowser(this.protocol.getWeb());
        }

        @Override
        public RichTooltip getRichToolTip() {
            return new ProtocolRichToolTip(this.protocol);
        }
    }
}

