/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.trackprocessors.speed;

import icy.gui.component.NumberTextField;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.adufour.trackprocessors.speed.FilterTracks;
import plugins.adufour.trackprocessors.speed.SpeedProfiler;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;

public class FilterTracksProcessor
extends PluginTrackManagerProcessor
implements PluginBundled {
    private JPanel options;
    private JLabel dispUnit;
    private JPanel filter_panel;
    private JCheckBox useRealUnits;
    private JComboBox filter_criterion;
    private JComboBox filter_operation;
    private NumberTextField filter_value;
    private final ActionListener updater = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            FilterTracksProcessor.this.updateUnit();
            FilterTracksProcessor.this.trackPool.fireTrackEditorProcessorChange();
        }
    };

    public FilterTracksProcessor() {
        this.setName("Track filter");
        if (!Icy.getMainInterface().isHeadLess()) {
            this.buildGui();
        }
        this.updateUnit();
    }

    private void buildGui() {
        this.options = new JPanel();
        this.filter_panel = new JPanel();
        this.dispUnit = new JLabel();
        this.useRealUnits = new JCheckBox("Use real units (\u03bcm/sec)", false);
        this.useRealUnits.addActionListener(this.updater);
        this.filter_criterion = new JComboBox<FilterTracks.Criterion>(FilterTracks.Criterion.values());
        this.filter_operation = new JComboBox<FilterTracks.ComparisonType>(FilterTracks.ComparisonType.values());
        this.filter_value = new NumberTextField(false);
        this.options.setLayout(new BoxLayout(this.options, 0));
        this.options.add(this.useRealUnits);
        this.options.add(Box.createHorizontalGlue());
        this.filter_panel.setLayout(new BoxLayout(this.filter_panel, 0));
        this.filter_panel.add(new JLabel(" Keep tracks with "));
        this.filter_criterion.setFocusable(false);
        this.filter_criterion.addActionListener(this.updater);
        this.filter_panel.add(this.filter_criterion);
        this.filter_operation.setFocusable(false);
        this.filter_operation.addActionListener(this.updater);
        this.filter_panel.add(this.filter_operation);
        this.filter_panel.add(this.filter_value);
        this.filter_panel.add(this.dispUnit);
        this.filter_value.setNumericValue(3.0);
        this.filter_value.addValueListener(new NumberTextField.ValueChangeListener(){

            @Override
            public void valueChanged(double newValue, boolean validate) {
                if (validate) {
                    FilterTracksProcessor.this.trackPool.fireTrackEditorProcessorChange();
                }
            }
        });
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.options);
        this.panel.add(this.filter_panel);
    }

    void updateUnit() {
        switch ((FilterTracks.Criterion)((Object)this.filter_criterion.getSelectedItem())) {
            case CRITERION_T_START: 
            case CRITERION_CURRENT_T: 
            case CRITERION_T_END: 
            case CRITERION_DURATION: {
                this.dispUnit.setText(this.useRealUnits.isSelected() ? "sec" : "frames");
                break;
            }
            case CRITERION_EXTENT: 
            case CRITERION_TOT_DISP: 
            case CRITERION_NET_DISP: {
                this.dispUnit.setText(this.useRealUnits.isSelected() ? "\u03bcm" : "px");
                break;
            }
            case CRITERION_MIN_DISP: 
            case CRITERION_MAX_DISP: 
            case CRITERION_AVG_DISP: {
                this.dispUnit.setText(this.useRealUnits.isSelected() ? "\u03bcm/sec" : "px/frame");
                break;
            }
            case CRITERION_LINEARITY: {
                this.dispUnit.setText("%");
                break;
            }
            default: {
                this.dispUnit.setText("");
            }
        }
    }

    @Override
    public void Compute() {
        if (!this.isEnabled()) {
            return;
        }
        Sequence sequence = this.trackPool.getDisplaySequence();
        if (sequence == null && this.useRealUnits.isSelected()) {
            this.useRealUnits.setSelected(false);
        }
        this.useRealUnits.setEnabled(sequence != null);
        ArrayList<TrackSegment> tracksToFilter = new ArrayList<TrackSegment>();
        for (TrackSegment ts : this.trackPool.getTrackSegmentList()) {
            if (!FilterTracks.isTrackEnabled(ts)) continue;
            tracksToFilter.add(ts);
        }
        FilterTracks.filterTracks(tracksToFilter, (FilterTracks.Criterion)((Object)this.filter_criterion.getSelectedItem()), (FilterTracks.ComparisonType)((Object)this.filter_operation.getSelectedItem()), this.filter_value.getNumericValue(), this.useRealUnits.isSelected() ? sequence : null, true);
        if (sequence != null) {
            sequence.overlayChanged((Overlay)null);
        }
    }

    @Override
    public void Close() {
    }

    @Override
    public void displaySequenceChanged() {
        this.Compute();
    }

    @Override
    public String getMainPluginClassName() {
        return SpeedProfiler.class.getName();
    }
}

