/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.trackprocessors.speed;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import icy.util.XLSUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.PlotPanel;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.trackprocessors.speed.SpeedProfiler;
import plugins.adufour.trackprocessors.speed.TrackStatistic;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarSequence;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;

public class MotionProfiler
extends Plugin
implements Block,
PluginBundled {
    private static final int COL_TRACK_GP = 0;
    private static final int COL_TRACK_ID = 1;
    private static final int COL_TRACK_START = 2;
    private static final int COL_TRACK_END = 3;
    private static final int COL_DURATION = 4;
    private static final int COL_TOT_DISP = 5;
    private static final int COL_NET_DISP = 6;
    private static final int COL_LINEARITY = 7;
    private static final int COL_RADIUS = 8;
    private static final int COL_MIN_DISP = 9;
    private static final int COL_MAX_DISP = 10;
    private static final int COL_AVG_DISP = 11;
    public final Var<TrackGroup> tracks = new Var<TrackGroup>("Track group", new TrackGroup(null));
    public final VarSequence sequence = new VarSequence("Sequence (for units info.)", null);
    public final VarBoolean displaySpeed = new VarBoolean("Get speed instead of disp.", false);
    public final VarMutable outputFile = new VarMutable("Output file", null){

        @Override
        public boolean isAssignableFrom(Var source) {
            return String.class == source.getType() || File.class == source.getType();
        }
    };

    public static List<TrackStatistic> computeTracksStatistics(Collection<TrackSegment> tracks, Sequence sequence, boolean computeSpeed, boolean ignoreFilteredDetection, Plot2DPanel xPlotPanel, Plot2DPanel yPlotPanel, Plot2DPanel zPlotPanel, PlotPanel globalPlotPanel) throws IOException, WriteException {
        double tScale;
        double zScale;
        double yScale;
        double xScale;
        ArrayList<TrackStatistic> result = new ArrayList<TrackStatistic>();
        if (sequence != null) {
            xScale = sequence.getPixelSizeX();
            yScale = sequence.getPixelSizeY();
            zScale = sequence.getPixelSizeZ();
            tScale = sequence.getTimeInterval();
        } else {
            xScale = 1.0;
            yScale = 1.0;
            zScale = 1.0;
            tScale = 1.0;
        }
        if (xPlotPanel != null) {
            xPlotPanel.removeAllPlots();
        }
        if (yPlotPanel != null) {
            yPlotPanel.removeAllPlots();
        }
        if (zPlotPanel != null) {
            zPlotPanel.removeAllPlots();
        }
        if (globalPlotPanel != null) {
            globalPlotPanel.removeAllPlots();
        }
        int index = 0;
        for (TrackSegment track : tracks) {
            TrackStatistic stat = TrackStatistic.computeStatistic(track, xScale, yScale, zScale, tScale, true, computeSpeed, ignoreFilteredDetection, xPlotPanel, yPlotPanel, zPlotPanel, globalPlotPanel);
            if (stat != null) {
                if (StringUtil.isEmpty(stat.groupName)) {
                    stat.groupName = "TrackGroup";
                }
                if (stat.id == -1) {
                    stat.id = index;
                }
            }
            result.add(stat);
            ++index;
        }
        if (globalPlotPanel != null) {
            double minX = globalPlotPanel.plotCanvas.base.getMinBounds()[0];
            double minY = globalPlotPanel.plotCanvas.base.getMinBounds()[1];
            double maxX = globalPlotPanel.plotCanvas.base.getMaxBounds()[0];
            double maxY = globalPlotPanel.plotCanvas.base.getMaxBounds()[1];
            double maxVal = 0.0;
            maxVal = Math.max(maxVal, Math.max(maxX, maxY));
            double minVal = 0.0;
            minVal = Math.min(minVal, Math.min(minX, minY));
            if (globalPlotPanel instanceof Plot3DPanel) {
                double minZ = globalPlotPanel.plotCanvas.base.getMinBounds()[2];
                double maxZ = globalPlotPanel.plotCanvas.base.getMaxBounds()[2];
                maxVal = Math.max(maxVal, maxZ);
                minVal = Math.min(minVal, minZ);
            }
            double setVal = Math.ceil(Math.max(Math.abs(maxVal), Math.abs(minVal)));
            globalPlotPanel.plotCanvas.setFixedBounds(0, -setVal, setVal);
            globalPlotPanel.plotCanvas.setFixedBounds(1, -setVal, setVal);
            if (globalPlotPanel instanceof Plot3DPanel) {
                globalPlotPanel.plotCanvas.setFixedBounds(2, -setVal, setVal);
            }
        }
        return result;
    }

    public static WritableWorkbook getTrackMotionXLS(Collection<TrackSegment> tracks, Sequence sequence, boolean displaySpeed, boolean ignoreFilteredDetection, String outputPath, Plot2DPanel xPlotPanel, Plot2DPanel yPlotPanel, Plot2DPanel zPlotPanel, PlotPanel globalPlotPanel) throws IOException, WriteException {
        WritableWorkbook book = XLSUtil.createWorkbook(outputPath);
        WritableSheet globalSheet = XLSUtil.createNewPage(book, "Global");
        WritableSheet xSheet = XLSUtil.createNewPage(book, "X");
        WritableSheet ySheet = XLSUtil.createNewPage(book, "Y");
        WritableSheet zSheet = XLSUtil.createNewPage(book, "Z");
        String timeUnit = sequence != null ? "sec" : "frames";
        String spaceUnit = sequence != null ? "\u03bcm" : "px";
        String speedUnit = displaySpeed ? "speed (" + spaceUnit + "/" + timeUnit + ")" : "disp. (" + spaceUnit + ")";
        ArrayList<WritableSheet> sheets = new ArrayList<WritableSheet>(4);
        sheets.add(globalSheet);
        sheets.add(xSheet);
        sheets.add(ySheet);
        sheets.add(zSheet);
        for (WritableSheet sheet : sheets) {
            XLSUtil.setCellString(sheet, 0, 0, "Group");
            XLSUtil.setCellString(sheet, 1, 0, "Track #");
            XLSUtil.setCellString(sheet, 2, 0, "Start (" + timeUnit + ")");
            XLSUtil.setCellString(sheet, 3, 0, "End (" + timeUnit + ")");
            XLSUtil.setCellString(sheet, 4, 0, "Duration (" + timeUnit + ")");
            XLSUtil.setCellString(sheet, 5, 0, "Total disp. (" + spaceUnit + ")");
            XLSUtil.setCellString(sheet, 6, 0, "Net disp. (" + spaceUnit + ")");
            XLSUtil.setCellString(sheet, 7, 0, "Linearity (%)");
            XLSUtil.setCellString(sheet, 8, 0, "Search radius (" + spaceUnit + ")");
            XLSUtil.setCellString(sheet, 9, 0, "Min. " + speedUnit);
            XLSUtil.setCellString(sheet, 10, 0, "Max. " + speedUnit);
            XLSUtil.setCellString(sheet, 11, 0, "Avg. " + speedUnit);
        }
        List<TrackStatistic> stats = MotionProfiler.computeTracksStatistics(tracks, sequence, displaySpeed, ignoreFilteredDetection, xPlotPanel, yPlotPanel, zPlotPanel, globalPlotPanel);
        int row = 1;
        for (TrackStatistic ts : stats) {
            if (ts == null) continue;
            XLSUtil.setCellString(globalSheet, 0, row, ts.groupName);
            XLSUtil.setCellString(xSheet, 0, row, ts.groupName);
            XLSUtil.setCellString(ySheet, 0, row, ts.groupName);
            XLSUtil.setCellString(zSheet, 0, row, ts.groupName);
            XLSUtil.setCellNumber(globalSheet, 1, row, ts.id);
            XLSUtil.setCellNumber(xSheet, 1, row, ts.id);
            XLSUtil.setCellNumber(ySheet, 1, row, ts.id);
            XLSUtil.setCellNumber(zSheet, 1, row, ts.id);
            XLSUtil.setCellNumber(globalSheet, 2, row, ts.startTime);
            XLSUtil.setCellNumber(xSheet, 2, row, ts.startTime);
            XLSUtil.setCellNumber(ySheet, 2, row, ts.startTime);
            XLSUtil.setCellNumber(zSheet, 2, row, ts.startTime);
            XLSUtil.setCellNumber(globalSheet, 3, row, ts.endTime);
            XLSUtil.setCellNumber(xSheet, 3, row, ts.endTime);
            XLSUtil.setCellNumber(ySheet, 3, row, ts.endTime);
            XLSUtil.setCellNumber(zSheet, 3, row, ts.endTime);
            XLSUtil.setCellNumber(globalSheet, 4, row, ts.duration);
            XLSUtil.setCellNumber(xSheet, 4, row, ts.duration);
            XLSUtil.setCellNumber(ySheet, 4, row, ts.duration);
            XLSUtil.setCellNumber(zSheet, 4, row, ts.duration);
            XLSUtil.setCellNumber(globalSheet, 5, row, ts.global.totalDisp);
            XLSUtil.setCellNumber(xSheet, 5, row, ts.x.totalDisp);
            XLSUtil.setCellNumber(ySheet, 5, row, ts.y.totalDisp);
            XLSUtil.setCellNumber(zSheet, 5, row, ts.z.totalDisp);
            XLSUtil.setCellNumber(globalSheet, 6, row, ts.global.netDisp);
            XLSUtil.setCellNumber(xSheet, 6, row, ts.x.netDisp);
            XLSUtil.setCellNumber(ySheet, 6, row, ts.y.netDisp);
            XLSUtil.setCellNumber(zSheet, 6, row, ts.z.netDisp);
            XLSUtil.setCellNumber(globalSheet, 7, row, ts.global.linearity);
            XLSUtil.setCellNumber(xSheet, 7, row, ts.x.linearity);
            XLSUtil.setCellNumber(ySheet, 7, row, ts.y.linearity);
            XLSUtil.setCellNumber(zSheet, 7, row, ts.z.linearity);
            XLSUtil.setCellNumber(globalSheet, 8, row, ts.global.searchRadius);
            XLSUtil.setCellNumber(xSheet, 8, row, ts.x.searchRadius);
            XLSUtil.setCellNumber(ySheet, 8, row, ts.y.searchRadius);
            XLSUtil.setCellNumber(zSheet, 8, row, ts.z.searchRadius);
            XLSUtil.setCellNumber(globalSheet, 9, row, ts.global.minDispOrSpeed);
            XLSUtil.setCellNumber(xSheet, 9, row, ts.x.minDispOrSpeed);
            XLSUtil.setCellNumber(ySheet, 9, row, ts.y.minDispOrSpeed);
            XLSUtil.setCellNumber(zSheet, 9, row, ts.z.minDispOrSpeed);
            XLSUtil.setCellNumber(globalSheet, 10, row, ts.global.maxDispOrSpeed);
            XLSUtil.setCellNumber(xSheet, 10, row, ts.x.maxDispOrSpeed);
            XLSUtil.setCellNumber(ySheet, 10, row, ts.y.maxDispOrSpeed);
            XLSUtil.setCellNumber(zSheet, 10, row, ts.z.maxDispOrSpeed);
            XLSUtil.setCellNumber(globalSheet, 11, row, ts.global.meanDispOrSpeed);
            XLSUtil.setCellNumber(xSheet, 11, row, ts.x.meanDispOrSpeed);
            XLSUtil.setCellNumber(ySheet, 11, row, ts.y.meanDispOrSpeed);
            XLSUtil.setCellNumber(zSheet, 11, row, ts.z.meanDispOrSpeed);
            ++row;
        }
        return book;
    }

    public static WritableWorkbook getTrackMotionXLS(Collection<TrackSegment> tracks, Sequence sequence, boolean displaySpeed, boolean ignoreFilteredDetection, String outputPath) throws WriteException, IOException {
        return MotionProfiler.getTrackMotionXLS(tracks, sequence, displaySpeed, ignoreFilteredDetection, outputPath, null, null, null, null);
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("trackgroup", this.tracks);
        inputMap.add("sequence", this.sequence);
        inputMap.add("displaySpeed", this.displaySpeed);
        inputMap.add("output", this.outputFile);
    }

    @Override
    public void declareOutput(VarList outputMap) {
    }

    @Override
    public void run() {
        TrackGroup trackGroup = this.tracks.getValue();
        Object obj = this.outputFile.getValue();
        if (trackGroup != null && obj != null) {
            ArrayList<TrackSegment> tracksToExport = new ArrayList<TrackSegment>();
            for (TrackSegment track : trackGroup.getTrackSegmentList()) {
                if (!track.isAllDetectionEnabled()) continue;
                tracksToExport.add(track);
            }
            File f = obj instanceof String ? new File((String)obj) : (File)obj;
            try {
                WritableWorkbook wb = MotionProfiler.getTrackMotionXLS(tracksToExport, (Sequence)this.sequence.getValue(), (Boolean)this.displaySpeed.getValue(), true, f.getAbsolutePath());
                XLSUtil.saveAndClose(wb);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getMainPluginClassName() {
        return SpeedProfiler.class.getName();
    }
}

