/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.model;

import java.util.HashMap;
import plugins.adufour.vars.gui.model.RangeModel;

public class DoubleRangeModel
extends RangeModel<Double> {
    public DoubleRangeModel(Double defaultValue, Double min, Double max, Double step) {
        this(defaultValue, min, max, step, RangeModel.RangeEditorType.SPINNER, (HashMap<Double, String>)null);
    }

    public DoubleRangeModel(Double defaultValue, Double min, Double max, Double step, RangeModel.RangeEditorType editorType, HashMap<Double, String> labels) {
        super(defaultValue, min, max, step, editorType, labels);
    }

    @Override
    public boolean isValid(Double value) {
        return this.min.compareTo(value) <= 0 && this.max.compareTo(value) >= 0 && value % (Double)this.step == 0.0;
    }

    @Override
    public int getRangeSize() {
        return (int)Math.round(((Double)this.max - (Double)this.min) / (Double)this.step);
    }

    @Override
    public Double getValueForIndex(int index) {
        return (Double)this.min + (double)index * (Double)this.step;
    }

    @Override
    public int indexOf(Double value) {
        return (int)Math.round((value - (Double)this.min) / (Double)this.step);
    }
}

