/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.gui.component.sequence.SequencePreviewPanel;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;

public class SequenceViewer
extends SwingVarEditor<Sequence>
implements SequenceListener {
    private boolean mouseOver = false;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Sequence s;
            if (e.getClickCount() == 2 && (s = (Sequence)SequenceViewer.this.getVariable().getValue()) != null) {
                Icy.getMainInterface().addSequence(s);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SequenceViewer.this.mouseOver = true;
            SequenceViewer.this.getEditorComponent().repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SequenceViewer.this.mouseOver = false;
            SequenceViewer.this.getEditorComponent().repaint();
        }
    };

    public SequenceViewer(Var<Sequence> variable) {
        super(variable);
    }

    public SequenceViewer(VarMutable variable) {
        super(variable);
        if (!variable.getType().isAssignableFrom(Sequence.class)) {
            throw new ClassCastException("Variable " + variable.getName() + " is not a Sequence");
        }
    }

    @Override
    protected JComponent createEditorComponent() {
        SequencePreviewPanel editor = new SequencePreviewPanel(true){

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                if (SequenceViewer.this.mouseOver && SequenceViewer.this.getVariable().getValue() != null) {
                    g.setColor(Color.white);
                    GraphicsUtil.drawCenteredString(g, "(double-click to open)", this.getWidth() / 2, this.getHeight() - 20, true);
                }
            }
        };
        for (JPanel panel : new JPanel[]{editor.getMainPanel(), editor.getTPanel(), editor.getZPanel()}) {
            editor.setOpaque(false);
            panel.setOpaque(false);
            for (Component c : panel.getComponents()) {
                if (!(c instanceof JComponent)) continue;
                ((JComponent)c).setOpaque(false);
            }
        }
        return editor;
    }

    @Override
    protected void activateListeners() {
        this.getEditorComponent().addMouseListener(this.mouseAdapter);
    }

    @Override
    protected void deactivateListeners() {
        this.getEditorComponent().removeMouseListener(this.mouseAdapter);
    }

    @Override
    public SequencePreviewPanel getEditorComponent() {
        return (SequencePreviewPanel)super.getEditorComponent();
    }

    @Override
    protected void updateInterfaceValue() {
        Sequence s = (Sequence)this.variable.getValue();
        this.getEditorComponent().setModel(s);
    }

    @Override
    public boolean isComponentResizeable() {
        return true;
    }

    @Override
    public double getComponentVerticalResizeFactor() {
        return 1.0;
    }

    @Override
    public void valueChanged(Var<Sequence> source, Sequence oldValue, Sequence newValue) {
        if (oldValue != null) {
            oldValue.removeListener(this);
        }
        if (newValue != null) {
            newValue.addListener(this);
        }
        super.valueChanged(source, oldValue, newValue);
    }

    @Override
    public void referenceChanged(Var<Sequence> source, Var<? extends Sequence> oldReference, Var<? extends Sequence> newReference) {
        if (oldReference != null && oldReference.getValue() != null) {
            oldReference.getValue().removeListener(this);
        }
        super.referenceChanged(source, oldReference, newReference);
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
    }

    @Override
    public void sequenceChanged(SequenceEvent sequenceEvent) {
        this.getEditorComponent().dimensionChanged();
        this.getEditorComponent().imageChanged();
    }
}

