/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.gui.component.PopupPanel;
import icy.gui.util.GuiUtil;
import icy.plugin.abstract_.Plugin;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fab.trackmanager.TrackPool;

public abstract class PluginTrackManagerProcessor
extends Plugin {
    protected JPanel panel = new JPanel();
    private PopupPanel mainpanel = new PopupPanel("no name");
    protected TrackPool trackPool;
    protected JCheckBox enabledCheckBox = new JCheckBox("Enable");
    protected JButton closeButton = new JButton("X");
    protected JButton moveUpButton = new JButton("Up");
    protected JButton moveDownButton = new JButton("Down");
    protected JLabel performanceLabel = new JLabel("----");
    ActionButton actionButton = new ActionButton();

    public PluginTrackManagerProcessor() {
        this.mainpanel.expand();
        this.enabledCheckBox.setSelected(true);
        this.enabledCheckBox.addActionListener(this.actionButton);
        JPanel commandPanel = GuiUtil.createLineBoxPanel(this.enabledCheckBox, Box.createHorizontalGlue(), this.performanceLabel, this.moveUpButton, this.moveDownButton, this.closeButton);
        this.closeButton.addActionListener(this.actionButton);
        this.closeButton.setToolTipText("Close processor");
        this.moveUpButton.setToolTipText("Move up processor");
        this.moveDownButton.setToolTipText("Move down processor");
        this.performanceLabel.setToolTipText("Number of milliseconds used by this processor for its last run");
        this.moveUpButton.addActionListener(this.actionButton);
        this.moveDownButton.addActionListener(this.actionButton);
        this.mainpanel.getMainPanel().setLayout(new BoxLayout(this.mainpanel.getMainPanel(), 3));
        this.mainpanel.getMainPanel().add(GuiUtil.createLineBoxPanel(commandPanel));
        this.mainpanel.getMainPanel().add(GuiUtil.createLineBoxPanel(this.panel));
    }

    protected void setName(String name) {
        this.mainpanel.setTitle(name);
    }

    protected boolean isEnabled() {
        return this.enabledCheckBox.isSelected();
    }

    public abstract void Close();

    public abstract void Compute();

    public void setPerformance(int ms) {
        this.performanceLabel.setText(ms + " ms ");
    }

    private void removeTrackProcessor() {
        this.trackPool.removeTrackProcessor(this);
        JPanel parent = (JPanel)this.mainpanel.getParent();
        parent.remove(this.mainpanel);
        parent.revalidate();
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    @Override
    protected void finalize() throws Throwable {
        this.trackPool = null;
        super.finalize();
    }

    public final void setTrackPool(TrackPool trackPool) {
        this.trackPool = trackPool;
    }

    public abstract void displaySequenceChanged();

    class ActionButton
    implements ActionListener {
        ActionButton() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PluginTrackManagerProcessor.this.closeButton) {
                PluginTrackManagerProcessor.this.Close();
                PluginTrackManagerProcessor.this.removeTrackProcessor();
                PluginTrackManagerProcessor.this.trackPool.fireTrackEditorProcessorChange();
            }
            if (e.getSource() == PluginTrackManagerProcessor.this.enabledCheckBox) {
                PluginTrackManagerProcessor.this.trackPool.fireTrackEditorProcessorChange();
            }
            if (e.getSource() == PluginTrackManagerProcessor.this.moveUpButton) {
                PluginTrackManagerProcessor.this.trackPool.getTrackManager().moveTrackProcessor(PluginTrackManagerProcessor.this, -1);
            }
            if (e.getSource() == PluginTrackManagerProcessor.this.moveDownButton) {
                PluginTrackManagerProcessor.this.trackPool.getTrackManager().moveTrackProcessor(PluginTrackManagerProcessor.this, 1);
            }
        }
    }
}

