/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.image.filtering.selection;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import ome.xml.meta.MetadataRetrieve;
import plugins.kernel.image.filtering.selection.SelectionFilter;

public abstract class ThreadedSelectionFilter
implements SelectionFilter {
    private static final Processor service = new Processor(Runtime.getRuntime().availableProcessors());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence processSequence(Sequence sequence, int ... radius) throws RuntimeException, InterruptedException {
        int kHeight;
        Sequence out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequence.getOMEXMLMetadata(), true));
        out.setName(sequence.getName() + "_" + this.getFilterName());
        if (radius.length == 0) {
            throw new IllegalArgumentException("Provide at least one filter radius");
        }
        final int width = sequence.getSizeX();
        int height = sequence.getSizeY();
        int depth = sequence.getSizeZ();
        int channels = sequence.getSizeC();
        final DataType type = sequence.getDataType_();
        final boolean signed = sequence.isSignedDataType();
        final int kWidth = radius[0];
        int n = kHeight = radius.length == 1 ? kWidth : radius[1];
        int kDepth = radius.length == 1 ? kWidth : (radius.length == 2 ? 0 : radius[2]);
        final Object[] in_Z_XY = new Object[depth];
        final double[] cache = new double[width * height];
        ArrayList tasks = new ArrayList(height);
        for (int t = 0; t < sequence.getSizeT(); ++t) {
            for (int z = 0; z < depth; ++z) {
                out.setImage(t, z, (BufferedImage)new IcyBufferedImage(width, height, channels, type));
            }
            for (int c = 0; c < channels; ++c) {
                int z;
                for (z = 0; z < depth; ++z) {
                    in_Z_XY[z] = sequence.getImage(t, z, c).getDataXY(0);
                }
                for (z = 0; z < depth; ++z) {
                    final int minZinclusive = Math.max(z - kDepth, 0);
                    final int maxZexclusive = Math.min(z + kDepth + 1, depth);
                    final Object _inXY = in_Z_XY[z];
                    final Object _outXY = out.getDataXY(t, z, c);
                    tasks.clear();
                    for (int y = 0; y < height; ++y) {
                        final int n2 = Math.max(y - kHeight, 0);
                        final int maxYexclusive = Math.min(y + kHeight + 1, height);
                        final int lineOffset = y * width;
                        final int maxNeighbors = (1 + (maxZexclusive - minZinclusive) * 2) * (1 + (maxYexclusive - n2) * 2) * (1 + kWidth * 2);
                        tasks.add(this.submitTask(new Runnable(){
                            final /* synthetic */ ThreadedSelectionFilter this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void run() {
                                double[] neighborhood = new double[maxNeighbors];
                                int outXY = lineOffset;
                                int x = 0;
                                while (x < width) {
                                    double currentPixel = Array1DUtil.getValue(_inXY, outXY, type);
                                    int localNeighborHoodSize = 0;
                                    int minXinclusive = Math.max(x - kWidth, 0);
                                    int maxXexclusive = Math.min(x + kWidth + 1, width);
                                    for (int inZ = minZinclusive; inZ < maxZexclusive; ++inZ) {
                                        Object neighborSlice = in_Z_XY[inZ];
                                        for (int inY = n2; inY < maxYexclusive; ++inY) {
                                            int inXY = inY * width + minXinclusive;
                                            int inX = minXinclusive;
                                            while (inX < maxXexclusive) {
                                                neighborhood[localNeighborHoodSize] = Array1DUtil.getValue(neighborSlice, inXY, type);
                                                ++inX;
                                                ++inXY;
                                                ++localNeighborHoodSize;
                                            }
                                        }
                                    }
                                    cache[outXY] = this.this$0.processNeighborhood(currentPixel, neighborhood, localNeighborHoodSize);
                                    ++x;
                                    ++outXY;
                                }
                                Array1DUtil.doubleArrayToSafeArray(cache, lineOffset, _outXY, lineOffset, width, signed);
                            }
                        }));
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException("Selection filter process interrupted.");
                    }
                    try {
                        for (Future future : tasks) {
                            future.get();
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        Sequence sequence2 = out;
                        return sequence2;
                    }
                    catch (ExecutionException e) {
                        Thread.currentThread().interrupt();
                        Sequence sequence3 = out;
                        return sequence3;
                    }
                    finally {
                        out.setDataXY(t, z, c, _outXY);
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Selection filter process interrupted.");
                }
            }
        }
        return out;
    }

    private Future<?> submitTask(Runnable task) {
        return service.submit(task);
    }

    static {
        service.setThreadName("ThreadedFilter");
    }
}

