/*
 * Decompiled with CFR 0.152.
 */
package icy.file;

import icy.file.FileFormat;
import icy.file.FileUtil;
import icy.file.ImageFileFormat;
import icy.gui.frame.progress.FileFrame;
import icy.gui.menu.ApplicationMenu;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.colormodel.IcyColorModel;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.preferences.GeneralPreferences;
import icy.roi.ROI;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.type.DataType;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import loci.common.services.ServiceException;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.UnknownFormatException;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.APNGWriter;
import loci.formats.out.AVIWriter;
import loci.formats.out.JPEG2000Writer;
import loci.formats.out.JPEGWriter;
import loci.formats.out.OMETiffWriter;
import loci.formats.out.TiffWriter;

public class Saver {
    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType) throws ServiceException {
        return (OMEXMLMetadata)OMEUtil.generateMetaData(sizeX, sizeY, sizeC, sizeZ, sizeT, dataType, false);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, int dataType, boolean signedDataType) throws ServiceException {
        return (OMEXMLMetadata)OMEUtil.generateMetaData(sizeX, sizeY, sizeC, sizeZ, sizeT, DataType.getDataType(dataType, signedDataType), false);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, DataType dataType) throws ServiceException {
        return (OMEXMLMetadata)OMEUtil.generateMetaData(sizeX, sizeY, sizeC, 1, 1, dataType, false);
    }

    @Deprecated
    public static OMEXMLMetadata generateMetaData(int sizeX, int sizeY, int sizeC, int dataType, boolean signedDataType) throws ServiceException {
        return (OMEXMLMetadata)OMEUtil.generateMetaData(sizeX, sizeY, sizeC, DataType.getDataType(dataType, signedDataType), false);
    }

    public static ImageFileFormat getImageFileFormat(IFormatWriter writer, ImageFileFormat defaultValue) {
        if (writer instanceof TiffWriter) {
            return ImageFileFormat.TIFF;
        }
        if (writer instanceof APNGWriter) {
            return ImageFileFormat.PNG;
        }
        if (writer instanceof JPEGWriter) {
            return ImageFileFormat.JPG;
        }
        if (writer instanceof JPEG2000Writer) {
            return ImageFileFormat.JPG;
        }
        if (writer instanceof AVIWriter) {
            return ImageFileFormat.AVI;
        }
        return defaultValue;
    }

    @Deprecated
    public static FileFormat getFileFormat(IFormatWriter writer, FileFormat defaultValue) {
        return Saver.getImageFileFormat(writer, ImageFileFormat.getFormat(defaultValue)).toFileFormat();
    }

    public static IFormatWriter getWriter(ImageFileFormat format) {
        APNGWriter result;
        switch (format) {
            case PNG: {
                result = new APNGWriter();
                break;
            }
            case JPG: {
                result = new JPEGWriter();
                break;
            }
            case AVI: {
                result = new AVIWriter();
                break;
            }
            default: {
                result = new OMETiffWriter();
                try {
                    result.setCompression("LZW");
                    break;
                }
                catch (FormatException formatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Deprecated
    public static IFormatWriter getWriter(FileFormat fileFormat) {
        return Saver.getWriter(ImageFileFormat.getFormat(fileFormat));
    }

    public static IFormatWriter getWriter(String ext, ImageFileFormat defaultFormat) {
        return Saver.getWriter(ImageFileFormat.getWriteFormat(ext, defaultFormat));
    }

    @Deprecated
    public static IFormatWriter getWriter(String ext, FileFormat defaultFormat) {
        return Saver.getWriter(ext, ImageFileFormat.getFormat(defaultFormat));
    }

    @Deprecated
    public static IFormatWriter getWriter(String ext) {
        return Saver.getWriter(ext, ImageFileFormat.TIFF);
    }

    public static IFormatWriter getWriter(File file, ImageFileFormat defaultFormat) {
        return Saver.getWriter(FileUtil.getFileExtension(file.getName(), false), defaultFormat);
    }

    @Deprecated
    public static IFormatWriter getWriter(File file, FileFormat defaultFormat) {
        return Saver.getWriter(file, ImageFileFormat.getFormat(defaultFormat));
    }

    @Deprecated
    public static IFormatWriter getWriter(File file) {
        return Saver.getWriter(file, ImageFileFormat.TIFF);
    }

    public static IcyColorModel getCompatibleColorModel(ImageFileFormat imageFileFormat, int numChannel, DataType dataType) {
        int outNumChannel;
        DataType outDataType;
        switch (imageFileFormat) {
            default: {
                outDataType = dataType;
                outNumChannel = numChannel;
                break;
            }
            case PNG: {
                outDataType = dataType.getSize() > 1 ? DataType.UBYTE : dataType;
                outNumChannel = Math.min(numChannel, 4);
                break;
            }
            case JPG: 
            case AVI: {
                outDataType = dataType.getSize() > 1 ? DataType.UBYTE : dataType;
                outNumChannel = numChannel > 3 ? 3 : (numChannel == 2 ? 3 : numChannel);
            }
        }
        return IcyColorModel.createInstance(outNumChannel, outDataType);
    }

    public static IcyColorModel getCompatibleColorModel(ImageFileFormat imageFileFormat, IcyColorModel colorModel) {
        return Saver.getCompatibleColorModel(imageFileFormat, colorModel.getNumComponents(), colorModel.getDataType_());
    }

    public static boolean isCompatible(ImageFileFormat imageFileFormat, int numChannel, boolean alpha, DataType dataType) {
        return Saver.isCompatible(imageFileFormat, IcyColorModel.createInstance(numChannel, dataType));
    }

    public static boolean isCompatible(ImageFileFormat imageFileFormat, IcyColorModel colorModel) {
        return colorModel.isCompatible(Saver.getCompatibleColorModel(imageFileFormat, colorModel));
    }

    public static boolean isCompatible(ImageFileFormat imageFileFormat, Sequence sequence) {
        boolean multiZ = sequence.getSizeZ() > 1;
        boolean multiT = sequence.getSizeT() > 1;
        switch (imageFileFormat) {
            case PNG: 
            case JPG: {
                if (!multiZ && !multiT) break;
                return false;
            }
            case AVI: {
                if (!multiZ) break;
                return false;
            }
        }
        return Saver.isCompatible(imageFileFormat, sequence.getColorModel());
    }

    private static boolean getSeparateChannelFlag(ImageFileFormat imageFileFormat, int numChannel, DataType dataType) {
        if (numChannel > 1 && imageFileFormat.equals((Object)ImageFileFormat.TIFF)) {
            return numChannel != 3 || dataType.getSize() > 1;
        }
        return false;
    }

    private static boolean getSeparateChannelFlag(ImageFileFormat imageFileFormat, IcyColorModel colorModel) {
        return Saver.getSeparateChannelFlag(imageFileFormat, colorModel.getNumComponents(), colorModel.getDataType_());
    }

    public static IcyColorModel getCompatibleColorModel(IFormatWriter writer, int numChannel, DataType dataType) {
        return Saver.getCompatibleColorModel(Saver.getImageFileFormat(writer, ImageFileFormat.TIFF), numChannel, dataType);
    }

    public static IcyColorModel getCompatibleColorModel(IFormatWriter writer, IcyColorModel colorModel) {
        return Saver.getCompatibleColorModel(writer, colorModel.getNumComponents(), colorModel.getDataType_());
    }

    public static boolean isCompatible(IFormatWriter writer, int numChannel, boolean alpha, DataType dataType) {
        return Saver.isCompatible(writer, IcyColorModel.createInstance(numChannel, dataType));
    }

    public static boolean isCompatible(IFormatWriter writer, IcyColorModel colorModel) {
        return colorModel.isCompatible(Saver.getCompatibleColorModel(writer, colorModel));
    }

    public static boolean isCompatible(IFormatWriter writer, Sequence sequence) {
        return Saver.isCompatible(Saver.getImageFileFormat(writer, ImageFileFormat.TIFF), sequence);
    }

    private static boolean getSeparateChannelFlag(IFormatWriter writer, int numChannel, DataType dataType) {
        return Saver.getSeparateChannelFlag(Saver.getImageFileFormat(writer, ImageFileFormat.TIFF), numChannel, dataType);
    }

    private static boolean getSeparateChannelFlag(IFormatWriter writer, IcyColorModel colorModel) {
        return Saver.getSeparateChannelFlag(writer, colorModel.getNumComponents(), colorModel.getDataType_());
    }

    public static void save(Sequence sequence, File file) {
        Saver.save(sequence, file, 15, sequence.getSizeZ() * sequence.getSizeT() > 1, true);
    }

    @Deprecated
    public static void save(Sequence sequence, File file, boolean multipleFiles) {
        Saver.save(sequence, file, 0, sequence.getSizeZ() - 1, 0, sequence.getSizeT() - 1, 15, multipleFiles, true);
    }

    public static void save(Sequence sequence, File file, boolean multipleFiles, boolean showProgress) {
        Saver.save(sequence, file, 15, multipleFiles, showProgress);
    }

    @Deprecated
    public static void save(Sequence sequence, File file, int zMin, int zMax, int tMin, int tMax, int fps, boolean multipleFiles) {
        Saver.save(sequence, file, zMin, zMax, tMin, tMax, fps, multipleFiles, true);
    }

    @Deprecated
    public static void save(Sequence sequence, File file, int zMin, int zMax, int tMin, int tMax, int fps, boolean multipleFile, boolean showProgress) {
        Saver.save(null, sequence, file, fps, multipleFile, showProgress, true);
    }

    public static void save(Sequence sequence, File file, int fps, boolean multipleFile, boolean showProgress) {
        Saver.save(null, sequence, file, fps, multipleFile, showProgress, true);
    }

    @Deprecated
    public static void save(IFormatWriter formatWriter, Sequence sequence, File file, int zMin, int zMax, int tMin, int tMax, int fps, boolean multipleFile, boolean showProgress) {
        Saver.save(formatWriter, sequence, file, fps, multipleFile, showProgress, true);
    }

    @Deprecated
    public static void save(IFormatWriter formatWriter, Sequence sequence, File file, int zMin, int zMax, int tMin, int tMax, int fps, boolean multipleFile, boolean showProgress, boolean addToRecent) {
        Saver.save(formatWriter, sequence, file, fps, multipleFile, showProgress, addToRecent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(IFormatWriter formatWriter, Sequence sequence, File file, int fps, boolean multipleFile, boolean showProgress, boolean addToRecent) {
        String filePath = FileUtil.cleanPath(FileUtil.getGenericPath(file.getAbsolutePath()));
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        int numImages = sizeT * sizeZ;
        ApplicationMenu mainMenu = addToRecent ? Icy.getMainInterface().getApplicationMenu() : null;
        try (FileFrame saveFrame = showProgress && !Icy.getMainInterface().isHeadLess() ? new FileFrame("Saving", filePath) : null;){
            Sequence savedSequence;
            IFormatWriter writer;
            if (saveFrame != null) {
                saveFrame.setLength(numImages);
                saveFrame.setPosition(0.0);
            }
            if ((writer = formatWriter == null ? Saver.getWriter(file, ImageFileFormat.TIFF) : formatWriter) == null) {
                throw new UnknownFormatException("Can't find a valid image writer for the specified file: " + file);
            }
            if (numImages > 1 && multipleFile) {
                DecimalFormat decimalFormat = new DecimalFormat("0000");
                String fileName = FileUtil.getFileName(filePath, false);
                String fileExt = FileUtil.getFileExtension(filePath, true);
                String fileBaseDirectory = FileUtil.getDirectory(filePath);
                if (fileBaseDirectory.endsWith("/")) {
                    fileBaseDirectory = fileBaseDirectory.substring(0, fileBaseDirectory.length() - 1);
                }
                if (StringUtil.isEmpty(fileExt)) {
                    fileBaseDirectory = fileBaseDirectory + "/" + fileName;
                    fileExt = "." + Saver.getImageFileFormat(writer, ImageFileFormat.TIFF).getExtensions()[0];
                }
                String filePathWithoutExt = fileBaseDirectory + "/" + fileName;
                if (FileUtil.exists(fileBaseDirectory)) {
                    sequence.setVolatile(false);
                    sequence.loadAllData();
                    sequence.setImageProvider(null);
                }
                FileUtil.createDir(fileBaseDirectory);
                for (int t = 0; t < sizeT; ++t) {
                    for (int z = 0; z < sizeZ; ++z) {
                        String filename = filePathWithoutExt;
                        if (sizeT > 1) {
                            filename = filename + "_t" + decimalFormat.format(t);
                        }
                        if (sizeZ > 1) {
                            filename = filename + "_z" + decimalFormat.format(z);
                        }
                        filename = filename + fileExt;
                        Saver.save(writer, sequence, filename, t, z, fps, saveFrame);
                    }
                }
                if (sequence.isDefaultName()) {
                    sequence.setName(fileName);
                }
                sequence.setFilename(fileBaseDirectory);
                sequence.resetOriginInformation();
                sequence.setImageProvider(null);
                savedSequence = sequence;
                if (mainMenu != null) {
                    mainMenu.addRecentFile(fileBaseDirectory);
                }
            } else {
                String fileExt;
                ImageFileFormat iff = Saver.getImageFileFormat(writer, ImageFileFormat.TIFF);
                String fixedFilePath = iff.matches(fileExt = FileUtil.getFileExtension(filePath, false)) ? filePath : filePath + "." + iff.getExtensions()[0];
                if (FileUtil.exists(fixedFilePath)) {
                    sequence.setVolatile(false);
                    sequence.loadAllData();
                    sequence.setImageProvider(null);
                    System.gc();
                }
                if (sequence.isDefaultName()) {
                    sequence.setName(FileUtil.getFileName(filePath, false));
                }
                savedSequence = Saver.save(writer, sequence, fixedFilePath, -1, -1, fps, saveFrame);
                savedSequence.setFilename(filePath);
                sequence.resetOriginInformation();
                if (mainMenu != null) {
                    mainMenu.addRecentFile(fixedFilePath);
                }
            }
            if (GeneralPreferences.getSequencePersistence()) {
                savedSequence.saveXMLData();
            }
        }
    }

    private static void saveImage(IFormatWriter formatWriter, byte[] data, int width, int height, int numChannel, boolean separateChannel, DataType dataType, File file, boolean force) throws FormatException, IOException {
        IFormatWriter writer;
        String filePath = FileUtil.cleanPath(FileUtil.getGenericPath(file.getAbsolutePath()));
        if (FileUtil.exists(filePath)) {
            if (force) {
                FileUtil.delete(filePath, true);
            } else {
                throw new IOException("File already exists");
            }
        }
        FileUtil.ensureParentDirExist(filePath);
        if (formatWriter == null) {
            writer = Saver.getWriter(FileUtil.getFileExtension(filePath, false), ImageFileFormat.TIFF);
            try {
                boolean separateCh = Saver.getSeparateChannelFlag(writer, numChannel, dataType);
                writer.setMetadataRetrieve((MetadataRetrieve)MetaDataUtil.generateMetaData(width, height, numChannel, dataType, separateCh));
            }
            catch (ServiceException e) {
                System.err.println("Saver.saveImage(...) error :");
                IcyExceptionHandler.showErrorMessage(e, true);
            }
        } else {
            writer = formatWriter;
            boolean bl = separateChannel;
        }
        writer.setInterleaved(false);
        writer.setId(filePath);
        writer.setSeries(0);
        writer.setWriteSequentially(true);
        try {
            if (separateChannel) {
                int pitch = width * height * dataType.getSize();
                byte[] dataChannel = new byte[pitch];
                int offset = 0;
                for (int c = 0; c < numChannel; ++c) {
                    System.arraycopy(data, offset, dataChannel, 0, pitch);
                    writer.saveBytes(c, dataChannel);
                    offset += pitch;
                }
            } else {
                writer.saveBytes(0, data);
            }
        }
        catch (Exception e) {
            System.err.println("Saver.saveImage(...) error :");
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        writer.close();
    }

    public static void saveImage(byte[] data, int width, int height, int numChannel, DataType dataType, File file, boolean force) throws FormatException, IOException {
        Saver.saveImage(null, data, width, height, numChannel, false, dataType, file, force);
    }

    @Deprecated
    public static void saveImage(byte[] data, int width, int height, int numChannel, int dataType, boolean signedDataType, File file, boolean force) throws FormatException, IOException {
        Saver.saveImage(data, width, height, numChannel, DataType.getDataType(dataType, signedDataType), file, force);
    }

    public static void saveImage(IcyBufferedImage image, File file, boolean force) throws FormatException, IOException {
        IFormatWriter writer = Saver.getWriter(file, ImageFileFormat.TIFF);
        if (writer == null) {
            throw new UnknownFormatException("Can't find a valid image writer for the specified file: " + file);
        }
        boolean separateChannel = Saver.getSeparateChannelFlag(writer, image.getIcyColorModel());
        try {
            writer.setMetadataRetrieve((MetadataRetrieve)MetaDataUtil.generateMetaData(image, separateChannel));
        }
        catch (ServiceException e) {
            System.err.println("Saver.saveImage(...) error :");
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        boolean littleEndian = writer.getMetadataRetrieve().getPixelsBinDataBigEndian(0, 0) == false;
        Saver.saveImage(writer, image.getRawData(littleEndian), image.getSizeX(), image.getSizeY(), image.getSizeC(), separateChannel, image.getDataType_(), file, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Sequence save(IFormatWriter writer, Sequence sequence, String filePath, int posT, int posZ, int fps, FileFrame saveFrame) throws ServiceException, FormatException, IOException, IllegalArgumentException, InterruptedException {
        int zMax;
        int zMin;
        int tMax;
        int tMin;
        int adjT;
        int adjZ;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileUtil.ensureParentDirExist(file);
        ImageFileFormat saveFormat = Saver.getImageFileFormat(writer, ImageFileFormat.TIFF);
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        switch (saveFormat) {
            default: {
                adjZ = posZ;
                adjT = posT;
                break;
            }
            case AVI: {
                adjZ = posZ < 0 ? sizeZ / 2 : posZ;
                adjT = posT;
                break;
            }
            case PNG: 
            case JPG: {
                adjZ = posZ < 0 ? sizeZ / 2 : posZ;
                adjT = posT < 0 ? sizeT / 2 : posT;
            }
        }
        Sequence compatibleSequence = Saver.getCompatibleSequenceForWriter(writer, sequence, adjT, adjZ);
        boolean separateChannel = Saver.getSeparateChannelFlag(saveFormat, compatibleSequence.getColorModel());
        ome.xml.meta.OMEXMLMetadata metadata = MetaDataUtil.generateMetaData(compatibleSequence, separateChannel);
        MetaDataUtil.keepPlanes(metadata, 0, adjT, adjZ, -1);
        if (adjT < 0) {
            tMin = 0;
            tMax = sizeT - 1;
        } else {
            tMin = tMax = adjT;
            MetaDataUtil.setSizeT(metadata, 0, 1);
        }
        if (adjZ < 0) {
            zMin = 0;
            zMax = sizeZ - 1;
        } else {
            zMin = zMax = adjZ;
            MetaDataUtil.setSizeZ(metadata, 0, 1);
        }
        if (writer instanceof TiffWriter && MetaDataUtil.getDataSize(metadata, 0, 0) > 2000000000L) {
            ((TiffWriter)writer).setBigTiff(true);
        }
        if (saveFormat == ImageFileFormat.AVI && fps != 0) {
            MetaDataUtil.setTimeInterval(metadata, 0, 1.0 / (double)fps);
        }
        writer.setMetadataRetrieve((MetadataRetrieve)metadata);
        writer.setInterleaved(false);
        writer.setId(filePath);
        writer.setSeries(0);
        writer.setWriteSequentially(true);
        int sizeC = compatibleSequence.getSizeC();
        boolean littleEndian = writer.getMetadataRetrieve().getPixelsBinDataBigEndian(0, 0) == false;
        byte[] data = null;
        try {
            int imageIndex = 0;
            for (int t = tMin; t <= tMax; ++t) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (saveFrame != null && saveFrame.isCancelRequested()) {
                        Sequence sequence2 = compatibleSequence;
                        return sequence2;
                    }
                    IcyBufferedImage image = compatibleSequence.getImage(t, z);
                    if (separateChannel) {
                        for (int c = 0; c < sizeC; ++c) {
                            if (image != null) {
                                data = image.getRawData(c, data, 0, littleEndian);
                                writer.saveBytes(imageIndex, data);
                            }
                            ++imageIndex;
                        }
                    } else {
                        if (image != null) {
                            data = image.getRawData(data, 0, littleEndian);
                            writer.saveBytes(imageIndex, data);
                        }
                        ++imageIndex;
                    }
                    if (saveFrame == null) continue;
                    saveFrame.incPosition();
                }
            }
        }
        finally {
            writer.close();
        }
        return compatibleSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getCompatibleSequenceForWriter(IFormatWriter writer, Sequence sequence, int posT, int posZ) throws IllegalArgumentException, InterruptedException {
        int zMax;
        int zMin;
        int tMax;
        int tMin;
        boolean needConvert;
        int sizeC = sequence.getSizeC();
        DataType dataType = sequence.getDataType_();
        ImageFileFormat imageFormat = Saver.getImageFileFormat(writer, ImageFileFormat.TIFF);
        switch (imageFormat) {
            default: {
                needConvert = false;
                break;
            }
            case JPG: 
            case AVI: {
                needConvert = dataType.getSize() > 1 || sizeC == 2 || sizeC > 3;
                break;
            }
            case PNG: {
                boolean bl = needConvert = dataType.getSize() > 1 || sizeC > 4;
            }
        }
        if (!needConvert) {
            return sequence;
        }
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        if (posT < 0) {
            tMin = 0;
            tMax = sizeT - 1;
        } else {
            tMin = tMax = posT;
        }
        if (posZ < 0) {
            zMin = 0;
            zMax = sizeZ - 1;
        } else {
            zMin = zMax = posZ;
        }
        int imageType = sizeC > 1 ? 1 : 10;
        BufferedImage imgOut = new BufferedImage(sequence.getSizeX(), sequence.getSizeY(), imageType);
        LUT lut = sequence.getDefaultLUT();
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((ome.xml.meta.MetadataRetrieve)sequence.getOMEXMLMetadata(), false));
        result.beginUpdate();
        try {
            for (int t = tMin; t <= tMax; ++t) {
                for (int z = zMin; z <= zMax; ++z) {
                    result.setImage(t, z, IcyBufferedImageUtil.toBufferedImage(sequence.getImage(t, z), imgOut, lut));
                }
            }
            for (ROI roi : sequence.getROIs()) {
                result.addROI(roi);
            }
            for (Overlay overlay : sequence.getOverlays()) {
                result.addOverlay(overlay);
            }
            switch (imageType) {
                default: {
                    result.setChannelName(0, "red");
                    result.setChannelName(1, "green");
                    result.setChannelName(2, "blue");
                    break;
                }
                case 10: {
                    result.setChannelName(0, "gray");
                }
            }
            result.setName(sequence.getName() + " (" + (Object)((Object)imageFormat) + ")");
        }
        finally {
            result.endUpdate();
        }
        return result;
    }
}

