/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.math;

import icy.gui.component.BorderedPanel;
import icy.math.ArrayMath;
import icy.math.Histogram;
import icy.math.MathUtil;
import icy.type.collection.array.Array1DUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.EventListener;
import javax.swing.BorderFactory;

public class HistogramPanel
extends BorderedPanel {
    private static final long serialVersionUID = -3932807727576675217L;
    protected static final int BORDER_WIDTH = 2;
    protected static final int BORDER_HEIGHT = 2;
    protected static final int MIN_SIZE = 16;
    Histogram histogram;
    private double[] histogramData;
    double minValue;
    double maxValue;
    boolean integer;
    boolean logScaling;
    boolean useLAFColors;
    Color color;
    Color backgroundColor;
    boolean updating;

    public HistogramPanel(double minValue, double maxValue, boolean integer) {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMinimumSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.histogram = new Histogram(0.0, 1.0, 1, true);
        this.histogramData = new double[0];
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.integer = integer;
        this.logScaling = true;
        this.useLAFColors = true;
        this.color = Color.white;
        this.backgroundColor = Color.darkGray;
        this.buildHistogram(minValue, maxValue, integer);
        this.updating = false;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void reset() {
        this.histogram.reset();
        this.updating = true;
    }

    @Deprecated
    public void addValue(double value) {
        this.histogram.addValue(value);
    }

    @Deprecated
    public void addValues(Object array, boolean signed) {
        this.histogram.addValues(array, signed);
    }

    @Deprecated
    public void addValues(byte[] array, boolean signed) {
        this.histogram.addValues(array, signed);
    }

    @Deprecated
    public void addValues(short[] array, boolean signed) {
        this.histogram.addValues(array, signed);
    }

    @Deprecated
    public void addValues(int[] array, boolean signed) {
        this.histogram.addValues(array, signed);
    }

    @Deprecated
    public void addValues(long[] array, boolean signed) {
        this.histogram.addValues(array, signed);
    }

    @Deprecated
    public void addValues(float[] array) {
        this.histogram.addValues(array);
    }

    @Deprecated
    public void addValues(double[] array) {
        this.histogram.addValues(array);
    }

    public double getAdjustedBinSize(int index) {
        double[] data = this.histogramData;
        if (index >= 0 && index < data.length) {
            return data[index];
        }
        return 0.0;
    }

    public int getBinSize(int index) {
        return this.histogram.getBinSize(index);
    }

    public int getBinNumber() {
        return this.histogram.getBinNumber();
    }

    public double getBinWidth() {
        return this.histogram.getBinWidth();
    }

    public int[] getBins() {
        return this.histogram.getBins();
    }

    public void done() {
        this.refreshDataCache();
        this.updating = false;
    }

    public double getMinValue() {
        return this.histogram.getMinValue();
    }

    public double getMaxValue() {
        return this.histogram.getMaxValue();
    }

    public boolean isIntegerType() {
        return this.histogram.isIntegerType();
    }

    public boolean getLogScaling() {
        return this.logScaling;
    }

    public boolean getUseLAFColors() {
        return this.useLAFColors;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getBackgroundColor() {
        return this.color;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public double[] getHistogramData() {
        return this.histogramData;
    }

    public void setMinMaxIntValues(double min, double max, boolean intType) {
        if (this.minValue != min || this.maxValue != max || this.integer != intType) {
            this.buildHistogram(min, max, intType);
        } else if (this.histogram.getMinValue() != min || this.histogram.getMaxValue() != max || this.histogram.isIntegerType() != intType) {
            this.buildHistogram(min, max, intType);
        }
    }

    public void setLogScaling(boolean value) {
        if (this.logScaling != value) {
            this.logScaling = value;
            this.refreshDataCache();
        }
    }

    public void setUseLAFColors(boolean value) {
        if (this.useLAFColors != value) {
            this.useLAFColors = value;
            this.repaint();
        }
    }

    public void setColor(Color value) {
        if (!this.color.equals(value)) {
            this.color = value;
            if (!this.useLAFColors) {
                this.repaint();
            }
        }
    }

    public void setBackgroundColor(Color value) {
        if (!this.backgroundColor.equals(value)) {
            this.backgroundColor = value;
            if (!this.useLAFColors) {
                this.repaint();
            }
        }
    }

    protected void checkHisto() {
        Histogram newHisto = new Histogram(this.histogram.getMinValue(), this.histogram.getMaxValue(), Math.max(this.getClientWidth(), 16), this.histogram.isIntegerType());
        if (!this.hasSameProperties(newHisto)) {
            this.histogram = newHisto;
            this.fireHistogramNeedRefresh();
        }
    }

    protected void buildHistogram(double min, double max, boolean intType) {
        Histogram newHisto = new Histogram(min, max, Math.max(this.getClientWidth(), 16), intType);
        if (!this.hasSameProperties(newHisto)) {
            this.histogram = newHisto;
            this.fireHistogramNeedRefresh();
        }
    }

    protected boolean hasSameProperties(Histogram h) {
        return this.histogram.getBinNumber() == h.getBinNumber() && this.histogram.getMinValue() == h.getMinValue() && this.histogram.getMaxValue() == h.getMaxValue() && this.histogram.isIntegerType() == h.isIntegerType();
    }

    protected void refreshDataCache() {
        double[] newHistogramData = Array1DUtil.intArrayToDoubleArray(this.histogram.getBins(), false);
        double min = ArrayMath.min(newHistogramData);
        MathUtil.add(newHistogramData, min + 1.0);
        if (this.logScaling) {
            MathUtil.log(newHistogramData);
        }
        MathUtil.normalize(newHistogramData);
        this.histogramData = newHistogramData;
        this.minValue = this.getMinValue();
        this.maxValue = this.getMaxValue();
        this.integer = this.isIntegerType();
        this.repaint();
    }

    protected double getDataToPixelRatio() {
        double pixelRange = Math.max(this.getClientWidth() - 1, 32);
        double dataRange = this.maxValue - this.minValue;
        if (dataRange != 0.0) {
            return pixelRange / dataRange;
        }
        return 0.0;
    }

    protected double getPixelToDataRatio() {
        double pixelRange = Math.max(this.getClientWidth() - 1, 32);
        double dataRange = this.maxValue - this.minValue;
        if (pixelRange != 0.0) {
            return dataRange / pixelRange;
        }
        return 0.0;
    }

    protected double getPixelToHistoRatio() {
        double histogramRange = this.histogramData.length - 1;
        double pixelRange = Math.max(this.getClientWidth() - 1, 32);
        if (pixelRange != 0.0) {
            return histogramRange / pixelRange;
        }
        return 0.0;
    }

    public int dataToPixel(double value) {
        return (int)Math.round((value - this.minValue) * this.getDataToPixelRatio()) + this.getClientX();
    }

    public double pixelToData(int value) {
        double data = (double)(value - this.getClientX()) * this.getPixelToDataRatio() + this.minValue;
        return Math.min(Math.max(data, this.minValue), this.maxValue);
    }

    public int pixelToBin(int value) {
        int index = (int)Math.round((double)(value - this.getClientX()) * this.getPixelToHistoRatio());
        return Math.min(Math.max(index, 0), this.histogramData.length - 1);
    }

    protected void fireHistogramNeedRefresh() {
        for (HistogramPanelListener l : (HistogramPanelListener[])this.listenerList.getListeners(HistogramPanelListener.class)) {
            l.histogramNeedRefresh(this);
        }
    }

    public void addListener(HistogramPanelListener l) {
        this.listenerList.add(HistogramPanelListener.class, l);
    }

    public void removeListener(HistogramPanelListener l) {
        this.listenerList.remove(HistogramPanelListener.class, l);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color bc;
        Color fc;
        if (this.useLAFColors) {
            fc = this.getForeground();
            bc = this.getBackground();
        } else {
            fc = this.color;
            bc = this.backgroundColor;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(fc);
        g2.setBackground(bc);
        if (this.isOpaque()) {
            g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        }
        double ratio = this.getPixelToHistoRatio();
        double[] data = this.histogramData;
        if (data.length != 0) {
            int histoRange = data.length - 1;
            int hRange = this.getClientHeight() - 1;
            int bottom = this.getClientY() + hRange;
            int l = this.getClientX();
            int r = l + this.getClientWidth();
            for (int i = l; i < r; ++i) {
                int index = (int)Math.round((double)(i - l) * ratio);
                if (index < 0) {
                    index = 0;
                } else if (index > histoRange) {
                    index = histoRange;
                }
                g2.drawLine(i, bottom, i, bottom - (int)Math.round(data[index] * (double)hRange));
            }
        }
        if (data.length == 0 || this.updating) {
            int x = this.getWidth() / 2 - 60;
            int y = this.getHeight() / 2 - 20;
            g2.drawString("computing...", x, y);
        }
        g2.dispose();
        this.checkHisto();
    }

    public static interface HistogramPanelListener
    extends EventListener {
        public void histogramNeedRefresh(HistogramPanel var1);
    }
}

