/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu.search;

import icy.gui.component.IcyTextField;
import icy.gui.menu.search.SearchResultPanel;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.search.SearchEngine;
import icy.search.SearchResult;
import icy.util.StringUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.painter.BusyPainter;

public class SearchBar
extends IcyTextField
implements SearchEngine.SearchEngineListener {
    private static final long serialVersionUID = -931313822004038942L;
    private static final int DELAY = 20;
    private static final int BUSY_PAINTER_SIZE = 15;
    private static final int BUSY_PAINTER_POINTS = 40;
    private static final int BUSY_PAINTER_TRAIL = 20;
    final SearchEngine searchEngine = new SearchEngine();
    final SearchResultPanel resultsPanel;
    private final IcyIcon searchIcon;
    private Timer busyPainterTimer;
    final BusyPainter busyPainter;
    int frame;
    boolean lastSearchingState;
    boolean initialized = false;

    public SearchBar() {
        this.searchEngine.addListener(this);
        this.resultsPanel = new SearchResultPanel(this);
        this.searchIcon = new IcyIcon(ResourceUtil.ICON_SEARCH, 16);
        Insets margin = this.getMargin();
        this.setMargin(new Insets(margin.top, margin.left, margin.bottom, margin.right + 20));
        this.setFocusable(false);
        this.busyPainter = new BusyPainter(15);
        this.busyPainter.setFrame(0);
        this.busyPainter.setPoints(40);
        this.busyPainter.setTrailLength(20);
        this.busyPainter.setPointShape((Shape)new Rectangle2D.Float(0.0f, 0.0f, 2.0f, 1.0f));
        this.frame = 0;
        this.lastSearchingState = false;
        this.busyPainterTimer = new Timer("Search animation timer");
        this.addTextChangeListener(new IcyTextField.TextChangeListener(){

            @Override
            public void textChanged(IcyTextField source, boolean validate) {
                SearchBar.this.searchInternal(SearchBar.this.getText());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchBar.this.setFocus();
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                SearchBar.this.removeFocus();
            }

            @Override
            public void focusGained(FocusEvent e) {
                SearchBar.this.searchInternal(SearchBar.this.getText());
            }
        });
        this.getToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Point pt;
                MouseEvent evt;
                if (!SearchBar.this.initialized || !SearchBar.this.hasFocus()) {
                    return;
                }
                if (event instanceof MouseEvent && (evt = (MouseEvent)event).getID() == 501 && !SearchBar.this.isInsideSearchComponents(pt = evt.getLocationOnScreen())) {
                    SearchBar.this.removeFocus();
                }
            }
        }, 16L);
        this.buildActionMap();
        this.initialized = true;
    }

    void buildActionMap() {
        InputMap imap = this.getInputMap(0);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        imap.put(KeyStroke.getKeyStroke(40, 0), "MoveDown");
        imap.put(KeyStroke.getKeyStroke(38, 0), "MoveUp");
        imap.put(KeyStroke.getKeyStroke(10, 0), "Execute");
        amap.put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = 6690317671269902666L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.initialized) {
                    SearchBar.this.cancelSearch();
                }
            }
        });
        this.getActionMap().put("MoveDown", new AbstractAction(){
            private static final long serialVersionUID = 8864361043092897904L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.initialized) {
                    SearchBar.this.moveDown();
                }
            }
        });
        this.getActionMap().put("MoveUp", new AbstractAction(){
            private static final long serialVersionUID = 6258168037713535447L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.initialized) {
                    SearchBar.this.moveUp();
                }
            }
        });
        this.getActionMap().put("Execute", new AbstractAction(){
            private static final long serialVersionUID = 5363650211730888168L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchBar.this.initialized) {
                    SearchBar.this.execute();
                }
            }
        });
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    protected boolean isInsideSearchComponents(Point pt) {
        Rectangle bounds = new Rectangle();
        bounds.setLocation(this.getLocationOnScreen());
        bounds.setSize(this.getSize());
        if (bounds.contains(pt)) {
            return true;
        }
        if (this.initialized && this.resultsPanel.isVisible()) {
            bounds.setLocation(this.resultsPanel.getLocationOnScreen());
            bounds.setSize(this.resultsPanel.getSize());
            return bounds.contains(pt);
        }
        return false;
    }

    public void setFocus() {
        if (!this.hasFocus()) {
            this.setFocusable(true);
            this.requestFocus();
        }
    }

    public void removeFocus() {
        if (this.initialized) {
            this.resultsPanel.close(true);
            this.setFocusable(false);
        }
    }

    public void cancelSearch() {
        this.setText("");
    }

    public void search(String text) {
        this.setText(text);
    }

    protected void searchInternal(String text) {
        String filter = text.trim();
        if (StringUtil.isEmpty(filter)) {
            this.searchEngine.cancelSearch();
        } else {
            this.searchEngine.search(filter);
        }
    }

    protected void execute() {
        if (this.resultsPanel.isShowing()) {
            this.resultsPanel.executeSelected();
        } else {
            this.searchInternal(this.getText());
        }
    }

    protected void moveDown() {
        this.resultsPanel.moveSelection(1);
    }

    protected void moveUp() {
        this.resultsPanel.moveSelection(-1);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        int w = this.getWidth();
        int h = this.getHeight();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (StringUtil.isEmpty(this.getText()) && !this.hasFocus()) {
            Insets insets = this.getMargin();
            Color fg = this.getForeground();
            g2.setColor(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 100));
            g2.drawString("Search", insets.left + 2, h - g2.getFontMetrics().getHeight() / 2 + 2);
        }
        if (this.searchEngine.isSearching()) {
            g2.translate(w - 20, 3);
            this.busyPainter.paint(g2, (Object)this, 15, 15);
        } else {
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            this.searchIcon.paintIcon(this, g2, w - h, 2);
        }
        g2.dispose();
    }

    @Override
    public void resultChanged(SearchEngine source, SearchResult result) {
        if (this.initialized) {
            this.resultsPanel.resultChanged(result);
        }
    }

    @Override
    public void resultsChanged(SearchEngine source) {
        if (this.initialized) {
            this.resultsPanel.resultsChanged();
        }
    }

    @Override
    public void searchStarted(SearchEngine source) {
        if (!this.initialized) {
            return;
        }
        this.busyPainterTimer.cancel();
        Timer newTimer = new Timer("Search animation timer");
        newTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                SearchBar.this.frame = (SearchBar.this.frame + 1) % 40;
                SearchBar.this.busyPainter.setFrame(SearchBar.this.frame);
                boolean searching = SearchBar.this.searchEngine.isSearching();
                if (searching || searching != SearchBar.this.lastSearchingState) {
                    SearchBar.this.repaint();
                }
                SearchBar.this.lastSearchingState = searching;
            }
        }, 20L, 20L);
        this.busyPainterTimer = newTimer;
        this.repaint();
    }

    @Override
    public void searchCompleted(SearchEngine source) {
        this.busyPainterTimer.cancel();
        this.repaint();
    }
}

