/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.button.IcyButton;
import icy.gui.component.sequence.SequenceChooser;
import icy.gui.component.sequence.SequencePreviewPanel;
import icy.gui.dialog.MessageDialog;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SequenceDimensionMergePanel
extends JPanel {
    private static final long serialVersionUID = -5908902915282090447L;
    protected IcyButton addButton;
    protected IcyButton removeButton;
    protected IcyButton upButton;
    protected IcyButton downButton;
    protected JList sequenceList;
    protected SequenceChooser sequenceChooser;
    protected SequencePreviewPanel sequencePreview;
    protected JCheckBox interlaceCheckBox;
    protected JCheckBox fillEmptyImageCheckBox;
    protected JCheckBox fitCheckbox;
    private JLabel bottomArrowLabel;
    private JLabel dimLabel;
    protected DefaultListModel listModel;
    protected ListSelectionModel selectionModel;
    protected final DimensionId dim;

    public SequenceDimensionMergePanel(DimensionId dim) {
        this.dim = dim;
        this.listModel = new DefaultListModel();
        this.initialize();
        this.selectionModel = this.sequenceList.getSelectionModel();
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SequenceDimensionMergePanel.this.refreshButtonsState();
            }
        });
        this.interlaceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewImageChanged();
            }
        });
        this.fillEmptyImageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewImageChanged();
            }
        });
        this.fitCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewImageChanged();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sequence seq = SequenceDimensionMergePanel.this.sequenceChooser.getSelectedSequence();
                if (seq != null && SequenceDimensionMergePanel.this.checkSequenceIsCompatible(seq, true, true)) {
                    if (SequenceDimensionMergePanel.this.dim == DimensionId.C) {
                        for (int c = 0; c < seq.getSizeC(); ++c) {
                            SequenceDimensionMergePanel.this.listModel.addElement(new SequenceChannelEntry(seq, c));
                        }
                    } else {
                        SequenceDimensionMergePanel.this.listModel.addElement(new SequenceChannelEntry(seq));
                    }
                    SequenceDimensionMergePanel.this.refreshButtonsState();
                    SequenceDimensionMergePanel.this.fireChangedEvent();
                    SequenceDimensionMergePanel.this.previewDimensionChanged();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionMergePanel.this.listModel.remove(SequenceDimensionMergePanel.this.selectionModel.getMinSelectionIndex());
                SequenceDimensionMergePanel.this.refreshButtonsState();
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewDimensionChanged();
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SequenceDimensionMergePanel.this.selectionModel.getMinSelectionIndex();
                Object obj = SequenceDimensionMergePanel.this.listModel.getElementAt(index - 1);
                SequenceDimensionMergePanel.this.listModel.set(index - 1, SequenceDimensionMergePanel.this.listModel.getElementAt(index));
                SequenceDimensionMergePanel.this.listModel.set(index, obj);
                SequenceDimensionMergePanel.this.selectionModel.setSelectionInterval(index - 1, index - 1);
                SequenceDimensionMergePanel.this.refreshButtonsState();
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewImageChanged();
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = SequenceDimensionMergePanel.this.selectionModel.getMinSelectionIndex();
                Object obj = SequenceDimensionMergePanel.this.listModel.getElementAt(index + 1);
                SequenceDimensionMergePanel.this.listModel.set(index + 1, SequenceDimensionMergePanel.this.listModel.getElementAt(index));
                SequenceDimensionMergePanel.this.listModel.set(index, obj);
                SequenceDimensionMergePanel.this.selectionModel.setSelectionInterval(index + 1, index + 1);
                SequenceDimensionMergePanel.this.refreshButtonsState();
                SequenceDimensionMergePanel.this.fireChangedEvent();
                SequenceDimensionMergePanel.this.previewImageChanged();
            }
        });
        this.dimLabel.setText(dim.toString());
        IcyIcon icon = new IcyIcon(ResourceUtil.ICON_ARROW_DOWN);
        icon.setDimension(new Dimension(20, 60));
        this.bottomArrowLabel.setIcon((Icon)((Object)icon));
        this.interlaceCheckBox.setVisible(dim != DimensionId.C);
        this.refreshButtonsState();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{24, 80, 140, 100, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 26, 0, 0, 0, 0, 0, 174, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblSelectSequenceTo = new JLabel("Add sequence to merge in the list :");
        GridBagConstraints gbc_lblSelectSequenceTo = new GridBagConstraints();
        gbc_lblSelectSequenceTo.fill = 1;
        gbc_lblSelectSequenceTo.gridwidth = 4;
        gbc_lblSelectSequenceTo.insets = new Insets(0, 0, 5, 5);
        gbc_lblSelectSequenceTo.gridx = 0;
        gbc_lblSelectSequenceTo.gridy = 0;
        this.add((Component)lblSelectSequenceTo, gbc_lblSelectSequenceTo);
        this.sequenceChooser = new SequenceChooser();
        GridBagConstraints gbc_sequenceChooser = new GridBagConstraints();
        gbc_sequenceChooser.gridwidth = 4;
        gbc_sequenceChooser.insets = new Insets(0, 0, 5, 5);
        gbc_sequenceChooser.fill = 1;
        gbc_sequenceChooser.gridx = 0;
        gbc_sequenceChooser.gridy = 1;
        this.add((Component)this.sequenceChooser, gbc_sequenceChooser);
        this.addButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROUND_PLUS));
        this.addButton.setToolTipText("Add selected sequence to the list.");
        this.addButton.setFlat(true);
        GridBagConstraints gbc_addButton = new GridBagConstraints();
        gbc_addButton.fill = 1;
        gbc_addButton.insets = new Insets(0, 0, 5, 0);
        gbc_addButton.gridx = 4;
        gbc_addButton.gridy = 1;
        this.add((Component)this.addButton, gbc_addButton);
        this.dimLabel = new JLabel("Z");
        this.dimLabel.setHorizontalAlignment(0);
        this.dimLabel.setFont(new Font("Tahoma", 1, 14));
        GridBagConstraints gbc_dimLabel = new GridBagConstraints();
        gbc_dimLabel.fill = 2;
        gbc_dimLabel.anchor = 256;
        gbc_dimLabel.insets = new Insets(0, 0, 5, 5);
        gbc_dimLabel.gridx = 0;
        gbc_dimLabel.gridy = 2;
        this.add((Component)this.dimLabel, gbc_dimLabel);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridwidth = 3;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridheight = 4;
        gbc_scrollPane.insets = new Insets(0, 0, 5, 5);
        gbc_scrollPane.gridx = 1;
        gbc_scrollPane.gridy = 2;
        this.add((Component)scrollPane, gbc_scrollPane);
        this.sequenceList = new JList(this.listModel);
        scrollPane.setViewportView(this.sequenceList);
        this.sequenceList.setSelectionMode(0);
        this.removeButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROUND_MINUS));
        this.removeButton.setToolTipText("Remove selected sequence from the list.");
        this.removeButton.setFlat(true);
        GridBagConstraints gbc_removeButton = new GridBagConstraints();
        gbc_removeButton.fill = 1;
        gbc_removeButton.insets = new Insets(0, 0, 5, 0);
        gbc_removeButton.gridx = 4;
        gbc_removeButton.gridy = 2;
        this.add((Component)this.removeButton, gbc_removeButton);
        this.bottomArrowLabel = new JLabel("");
        this.bottomArrowLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc_bottomArrowLabel = new GridBagConstraints();
        gbc_bottomArrowLabel.gridheight = 3;
        gbc_bottomArrowLabel.insets = new Insets(0, 0, 5, 5);
        gbc_bottomArrowLabel.gridx = 0;
        gbc_bottomArrowLabel.gridy = 3;
        this.add((Component)this.bottomArrowLabel, gbc_bottomArrowLabel);
        this.upButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROUND_ARROW_UP));
        this.upButton.setToolTipText("Move up selected sequence.");
        this.upButton.setFlat(true);
        GridBagConstraints gbc_upButton = new GridBagConstraints();
        gbc_upButton.fill = 1;
        gbc_upButton.insets = new Insets(0, 0, 5, 0);
        gbc_upButton.gridx = 4;
        gbc_upButton.gridy = 3;
        this.add((Component)this.upButton, gbc_upButton);
        this.downButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROUND_ARROW_DOWN));
        this.downButton.setToolTipText("Move down selected sequence.");
        this.downButton.setFlat(true);
        GridBagConstraints gbc_downButton = new GridBagConstraints();
        gbc_downButton.fill = 1;
        gbc_downButton.insets = new Insets(0, 0, 5, 0);
        gbc_downButton.gridx = 4;
        gbc_downButton.gridy = 4;
        this.add((Component)this.downButton, gbc_downButton);
        this.fitCheckbox = new JCheckBox("Scale image");
        this.fitCheckbox.setToolTipText("Scale all image to the largest one");
        GridBagConstraints gbc_fitCheckbox = new GridBagConstraints();
        gbc_fitCheckbox.anchor = 17;
        gbc_fitCheckbox.gridwidth = 2;
        gbc_fitCheckbox.insets = new Insets(0, 0, 5, 5);
        gbc_fitCheckbox.gridx = 0;
        gbc_fitCheckbox.gridy = 6;
        this.add((Component)this.fitCheckbox, gbc_fitCheckbox);
        this.fillEmptyImageCheckBox = new JCheckBox("Fill empty image");
        this.fillEmptyImageCheckBox.setToolTipText("Replace empty image by the previous non empty one");
        GridBagConstraints gbc_noEmptyImageCheckBox = new GridBagConstraints();
        gbc_noEmptyImageCheckBox.fill = 3;
        gbc_noEmptyImageCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_noEmptyImageCheckBox.gridx = 2;
        gbc_noEmptyImageCheckBox.gridy = 6;
        this.add((Component)this.fillEmptyImageCheckBox, gbc_noEmptyImageCheckBox);
        this.interlaceCheckBox = new JCheckBox("Interlace image");
        this.interlaceCheckBox.setToolTipText("Interlace sequence image");
        GridBagConstraints gbc_interlaceCheckBox = new GridBagConstraints();
        gbc_interlaceCheckBox.anchor = 13;
        gbc_interlaceCheckBox.gridwidth = 2;
        gbc_interlaceCheckBox.fill = 3;
        gbc_interlaceCheckBox.insets = new Insets(0, 0, 5, 0);
        gbc_interlaceCheckBox.gridx = 3;
        gbc_interlaceCheckBox.gridy = 6;
        this.add((Component)this.interlaceCheckBox, gbc_interlaceCheckBox);
        this.sequencePreview = new SequencePreviewPanel();
        this.sequencePreview.setBorder(new TitledBorder(null, "Preview", 4, 2, null, null));
        GridBagConstraints gbc_sequencePreview = new GridBagConstraints();
        gbc_sequencePreview.gridwidth = 5;
        gbc_sequencePreview.fill = 1;
        gbc_sequencePreview.gridx = 0;
        gbc_sequencePreview.gridy = 7;
        this.add((Component)this.sequencePreview, gbc_sequencePreview);
    }

    public DimensionId getDimensionId() {
        return this.dim;
    }

    void refreshButtonsState() {
        int index = this.selectionModel.getMinSelectionIndex();
        boolean notEmpty = index != -1;
        int size = this.listModel.getSize();
        this.removeButton.setEnabled(notEmpty);
        this.upButton.setEnabled(notEmpty && index != 0);
        this.downButton.setEnabled(notEmpty && index != size - 1);
    }

    public int[] getSelectedChannels() {
        int[] result = new int[this.listModel.size()];
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            result[i] = ((SequenceChannelEntry)this.listModel.get((int)i)).c;
        }
        return result;
    }

    public Sequence[] getSequences() {
        Sequence[] result = new Sequence[this.listModel.size()];
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            result[i] = ((SequenceChannelEntry)this.listModel.get((int)i)).sequence;
        }
        return result;
    }

    boolean checkSequenceIsCompatible(Sequence seq, boolean showMessage, boolean showWarning) {
        boolean warningXYDone = false;
        for (Sequence sequence : this.getSequences()) {
            if (!seq.getDataType_().equals((Object)sequence.getDataType_())) {
                if (showMessage) {
                    MessageDialog.showDialog("You cannot merge sequences with different data type.");
                }
                return false;
            }
            if (this.isFitImagesEnabled() || seq.getSizeX() == sequence.getSizeX() && seq.getSizeY() == sequence.getSizeY() || !showWarning || warningXYDone) continue;
            MessageDialog.showDialog("Sequences have different XY size !\nYou can enable the \"Scale image\" option to resize images if needed.", 2);
            warningXYDone = true;
        }
        return true;
    }

    public SequenceModel getModel() {
        return this.sequencePreview.getModel();
    }

    public void setModel(SequenceModel model) {
        this.sequencePreview.setModel(model);
    }

    public void previewDimensionChanged() {
        this.sequencePreview.dimensionChanged();
    }

    public void previewImageChanged() {
        this.sequencePreview.imageChanged();
    }

    public boolean isInterlaceEnabled() {
        return this.interlaceCheckBox.isVisible() && this.interlaceCheckBox.isSelected();
    }

    public boolean isFillEmptyImageEnabled() {
        return this.fillEmptyImageCheckBox.isVisible() && this.fillEmptyImageCheckBox.isSelected();
    }

    public boolean isFitImagesEnabled() {
        return this.fitCheckbox.isVisible() && this.fitCheckbox.isSelected();
    }

    public boolean isInterlaceVisible() {
        return this.interlaceCheckBox.isVisible();
    }

    public void setInterlaceVisible(boolean value) {
        this.interlaceCheckBox.setVisible(value);
    }

    public boolean isFillEmptyImageVisible() {
        return this.fillEmptyImageCheckBox.isVisible();
    }

    public void setFillEmptyImageVisible(boolean value) {
        this.fillEmptyImageCheckBox.setVisible(value);
    }

    protected void fireChangedEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    static class SequenceChannelEntry {
        final Sequence sequence;
        final int c;

        public SequenceChannelEntry(Sequence sequence, int c) {
            this.sequence = sequence;
            this.c = c;
        }

        public SequenceChannelEntry(Sequence sequence) {
            this(sequence, -1);
        }

        public String toString() {
            if (this.c == -1) {
                return this.sequence.toString();
            }
            return this.sequence.toString() + "    [channel " + this.c + "]";
        }
    }
}

