/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.system;

import icy.image.ImageUtil;
import icy.image.cache.ImageCache;
import icy.math.UnitUtil;
import icy.network.NetworkUtil;
import icy.resource.ResourceUtil;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.ColorUtil;
import icy.util.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import vtk.vtkObjectBase;

public class MemoryMonitorPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 5629509450385435829L;
    private static int NBVAL = 94;
    private final double[][] valeur;
    private final String[] infos;
    private final Timer updateTimer;
    private final Color cacheTextColor = ColorUtil.mix(Color.yellow, Color.white);
    private final Color cpuColor = ColorUtil.mix(Color.blue, Color.white);
    private final Color cpuTextColor = ColorUtil.mix(this.cpuColor, Color.white);
    private final Color memColor = Color.green;
    private final Color memTextColor = ColorUtil.mix(this.memColor, Color.white);
    private final Color connectionColor = ColorUtil.mix(Color.red, Color.white);
    private final BasicStroke cpuStroke = new BasicStroke(2.0f);
    private final BasicStroke memStroke = new BasicStroke(3.0f);
    private final Font textFont = new Font("Arial", 1, 9);
    private BufferedImage background = new BufferedImage(1, 1, 1);
    private final Image networkImage = ImageUtil.getColorImageFromAlphaImage(ResourceUtil.ICON_NETWORK, Color.gray);
    private final Image deleteImage = ImageUtil.getColorImageFromAlphaImage(ResourceUtil.ICON_DELETE, Color.red);
    boolean displayHelpMessage = false;
    int lastCacheUpdate;

    public MemoryMonitorPanel() {
        int i;
        this.updateTimer = new Timer("Memory / CPU monitor");
        this.valeur = new double[NBVAL][2];
        for (i = 0; i < NBVAL; ++i) {
            this.valeur[i][0] = 0.0;
            this.valeur[i][1] = 0.0;
        }
        this.infos = new String[3];
        for (i = 0; i < 2; ++i) {
            this.infos[i] = "";
        }
        this.lastCacheUpdate = 10;
        this.setMinimumSize(new Dimension(120, 50));
        this.setPreferredSize(new Dimension(140, 55));
        this.addMouseListener(this);
        this.updateTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MemoryMonitorPanel.this.updateStats();
            }
        }, 100L, 100L);
    }

    @Override
    protected void paintComponent(Graphics g) {
        String text;
        Graphics2D g2 = (Graphics2D)g.create();
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.background.getWidth() != w || this.background.getHeight() != h) {
            this.background = new BufferedImage(w, h, 1);
            Graphics2D background_g2 = this.background.createGraphics();
            GraphicsUtil.paintIcyBackGround(w, h, background_g2);
        }
        g2.drawImage((Image)this.background, 0, 0, null);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.valeur != null) {
            int y2;
            int y1;
            double v2;
            double v1;
            int i;
            float step = (float)w / 100.0f;
            g2.setStroke(this.memStroke);
            g2.setColor(this.memColor);
            double max = SystemUtil.getJavaMaxMemory();
            double ymul = (double)(h - 8) / max;
            float x = 6.0f;
            for (i = 0; i < NBVAL - 1; ++i) {
                v1 = Math.min(this.valeur[i][0], max);
                v2 = Math.min(this.valeur[i + 1][0], max);
                y1 = h - (int)(v1 * ymul);
                y2 = h - (int)(v2 * ymul);
                g2.drawLine((int)x, y1 - 4, (int)(x + step), y2 - 4);
                x += step;
            }
            g2.setStroke(this.cpuStroke);
            g2.setColor(this.cpuColor);
            max = 100.0;
            ymul = (double)(h - 8) / max;
            x = 6.0f;
            for (i = 0; i < NBVAL - 1; ++i) {
                v1 = Math.min(this.valeur[i][1], max);
                v2 = Math.min(this.valeur[i + 1][1], max);
                y1 = h - (int)(v1 * ymul);
                y2 = h - (int)(v2 * ymul);
                g2.drawLine((int)x, y1 - 4, (int)(x + step), y2 - 4);
                x += step;
            }
        }
        g2.setFont(this.textFont);
        g2.setColor(Color.black);
        GraphicsUtil.drawHCenteredString(g2, this.infos[0], w / 2 + 1, 7, false);
        g2.setColor(this.memTextColor);
        GraphicsUtil.drawHCenteredString(g2, this.infos[0], w / 2, 6, false);
        g2.setColor(Color.black);
        GraphicsUtil.drawHCenteredString(g2, this.infos[1], w / 2 + 1, 19, false);
        g2.setColor(this.cpuTextColor);
        GraphicsUtil.drawHCenteredString(g2, this.infos[1], w / 2, 18, false);
        g2.setColor(Color.black);
        GraphicsUtil.drawHCenteredString(g2, this.infos[2], w / 2 + 1, 31, false);
        g2.setColor(this.cacheTextColor);
        GraphicsUtil.drawHCenteredString(g2, this.infos[2], w / 2, 30, false);
        if (!NetworkUtil.hasInternetAccess()) {
            g2.drawImage(this.networkImage, 10, 30, 16, 16, null);
            g2.drawImage(this.deleteImage, 13, 35, 10, 10, null);
            if (this.displayHelpMessage) {
                text = "Not connected to internet";
                g2.setColor(Color.black);
                GraphicsUtil.drawHCenteredString(g2, text, w / 2 + 1, 31, false);
                g2.setColor(this.connectionColor);
                GraphicsUtil.drawHCenteredString(g2, text, w / 2, 30, false);
            }
        }
        if (this.displayHelpMessage) {
            text = "click to force a garbage collector event";
            g2.setColor(Color.black);
            GraphicsUtil.drawHCenteredString(g2, text, w / 2 + 1, 45, false);
            g2.setColor(Color.white);
            GraphicsUtil.drawHCenteredString(g2, text, w / 2, 44, false);
        }
        g2.dispose();
    }

    void updateStats() {
        double usedMemory = SystemUtil.getJavaUsedMemory();
        int cpuLoad = SystemUtil.getCpuLoad();
        this.newValue(0, usedMemory);
        this.newValue(1, cpuLoad);
        this.setInfo(0, "Memory: " + UnitUtil.getBytesString(usedMemory) + " / " + UnitUtil.getBytesString(SystemUtil.getJavaMaxMemory()));
        this.setInfo(1, "CPU: " + cpuLoad + "%");
        if (ImageCache.isEnabled()) {
            if (--this.lastCacheUpdate == 0) {
                try {
                    this.setInfo(2, "Cache - Memory: " + UnitUtil.getBytesString(ImageCache.usedMemory()) + "  Disk: " + UnitUtil.getBytesString(ImageCache.usedDisk()));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.lastCacheUpdate = 10;
            }
        } else {
            this.setInfo(2, "Cache disabled");
        }
        this.repaint();
    }

    public void newValue(int curve, double val) {
        for (int i = 0; i < NBVAL - 1; ++i) {
            this.valeur[i][curve] = this.valeur[i + 1][curve];
        }
        this.valeur[MemoryMonitorPanel.NBVAL - 1][curve] = val;
    }

    public void setInfo(int infonb, String info) {
        this.infos[infonb] = info;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        MouseEvent e = event;
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                double freeBefore = SystemUtil.getJavaFreeMemory();
                System.gc();
                double freeAfter = SystemUtil.getJavaFreeMemory();
                double released = freeAfter - freeBefore;
                double usedMemory = SystemUtil.getJavaUsedMemory();
                System.out.println("Max / Used memory: " + UnitUtil.getBytesString(SystemUtil.getJavaMaxMemory()) + " / " + UnitUtil.getBytesString(usedMemory > 0.0 ? usedMemory : 0.0) + " (released by GC: " + UnitUtil.getBytesString(released > 0.0 ? released : 0.0) + ")");
            }
        });
        if (e.getClickCount() > 1) {
            vtkObjectBase.JAVA_OBJECT_MANAGER.gc(true);
            System.out.println("VTK GC forced");
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.displayHelpMessage = true;
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.displayHelpMessage = false;
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }
}

