/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

public class ImagePosition
implements Comparable<ImagePosition> {
    public static final char T_ID = 'T';
    public static final char Z_ID = 'Z';
    protected int t;
    protected int z;

    public ImagePosition(int t, int z) {
        this.t = t;
        this.z = z;
    }

    public ImagePosition() {
        this(-1, -1);
    }

    public void copyFrom(ImagePosition ip) {
        this.t = ip.t;
        this.z = ip.z;
    }

    public void switchLeft() {
        this.t = this.z;
        this.z = 0;
    }

    public void switchRight() {
        this.z = this.t;
        this.t = 0;
    }

    public int getT() {
        return this.t;
    }

    public void setT(int t) {
        this.t = t;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void set(int t, int z) {
        this.t = t;
        this.z = z;
    }

    public int get(char ident) {
        char id = Character.toUpperCase(ident);
        switch (id) {
            case 'T': {
                return this.t;
            }
            case 'Z': {
                return this.z;
            }
        }
        return -1;
    }

    public static boolean isValidIdentStatic(char ident) {
        char id = Character.toUpperCase(ident);
        return id == 'T' || id == 'Z';
    }

    public boolean isValidIdent(char ident) {
        return ImagePosition.isValidIdentStatic(ident);
    }

    public boolean isTUndefined() {
        return this.t == -1;
    }

    public boolean isZUndefined() {
        return this.z == -1;
    }

    public boolean isUndefined() {
        return this.isTUndefined() || this.isZUndefined();
    }

    public char getFirstEmptyPos() {
        if (this.isTUndefined()) {
            return 'T';
        }
        if (this.isZUndefined()) {
            return 'Z';
        }
        return ' ';
    }

    public char getLastEmptyPos() {
        if (this.isZUndefined()) {
            return 'Z';
        }
        if (this.isTUndefined()) {
            return 'T';
        }
        return ' ';
    }

    public boolean isSamePos(ImagePosition ip, char posIdent) {
        char id = Character.toUpperCase(posIdent);
        switch (id) {
            case 'T': {
                if (this.t == -1) {
                    return false;
                }
                return ip.t == this.t;
            }
            case 'Z': {
                if (this.t == -1 || this.z == -1) {
                    return false;
                }
                return ip.t == this.t && ip.z == this.z;
            }
        }
        return false;
    }

    @Override
    public int compareTo(ImagePosition o) {
        ImagePosition ip = o;
        int ot = ip.t;
        int oz = ip.z;
        if (this.t > ot) {
            return 1;
        }
        if (this.t < ot) {
            return -1;
        }
        if (this.z > oz) {
            return 1;
        }
        if (this.z < oz) {
            return -1;
        }
        return 0;
    }
}

