/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colorspace;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.image.colormap.FromRGBColorMap;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.IcyColorMapEvent;
import icy.image.colormap.IcyColorMapListener;
import icy.image.colormap.LinearColorMap;
import icy.image.colormodel.IcyColorModel;
import icy.image.colorspace.IcyColorSpaceEvent;
import icy.image.colorspace.IcyColorSpaceListener;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import icy.util.ColorUtil;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.List;

public class IcyColorSpace
extends ColorSpace
implements ChangeListener,
IcyColorMapListener {
    private static final long serialVersionUID = 6413334779215415163L;
    private final IcyColorMap[] toRGBmaps;
    private final FromRGBColorMap[] fromRGBmaps;
    private final List<IcyColorSpaceListener> listeners;
    private final UpdateEventHandler updater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcyColorSpace(int numComponents) {
        super(numComponents > 1 ? 10 + numComponents : 6, numComponents);
        int i;
        if (numComponents == 0) {
            throw new IllegalArgumentException("numComponents must be > 0");
        }
        this.toRGBmaps = new IcyColorMap[numComponents];
        for (i = 0; i < numComponents; ++i) {
            IcyColorMap colormap;
            this.toRGBmaps[i] = colormap = new IcyColorMap("component " + i);
            colormap.addListener(this);
        }
        this.fromRGBmaps = new FromRGBColorMap[4];
        for (i = 0; i < 4; ++i) {
            this.fromRGBmaps[i] = new FromRGBColorMap(numComponents);
        }
        this.listeners = new ArrayList<IcyColorSpaceListener>();
        this.updater = new UpdateEventHandler(this, false);
        this.beginUpdate();
        try {
            if (numComponents == 1) {
                this.setColorMap(0, LinearColorMap.white_, true);
            } else {
                block14: for (i = 0; i < numComponents; ++i) {
                    switch (i % 7) {
                        case 0: {
                            this.setColorMap(i, LinearColorMap.red_, true);
                            continue block14;
                        }
                        case 1: {
                            this.setColorMap(i, LinearColorMap.green_, true);
                            continue block14;
                        }
                        case 2: {
                            this.setColorMap(i, LinearColorMap.blue_, true);
                            continue block14;
                        }
                        case 3: {
                            this.setColorMap(i, LinearColorMap.cyan_, true);
                            continue block14;
                        }
                        case 4: {
                            this.setColorMap(i, LinearColorMap.magenta_, true);
                            continue block14;
                        }
                        case 5: {
                            this.setColorMap(i, LinearColorMap.yellow_, true);
                            continue block14;
                        }
                        case 6: {
                            this.setColorMap(i, LinearColorMap.white_, true);
                        }
                    }
                }
            }
        }
        finally {
            this.endUpdate();
        }
        this.generateFromRGBColorMaps();
    }

    public boolean hasAlphaComponent() {
        for (int comp = 0; comp < this.toRGBmaps.length; ++comp) {
            if (this.toRGBmaps[comp].getType() != IcyColorMap.IcyColorMapType.ALPHA) continue;
            return true;
        }
        return false;
    }

    private void generateFromRGBColorMaps() {
        for (int comp = 0; comp < this.toRGBmaps.length; ++comp) {
            IcyColorMap toRGBmap = this.toRGBmaps[comp];
            float step = 0.003921569f;
            for (float intensity = 0.0f; intensity <= 1.0f; intensity += 0.003921569f) {
                this.fromRGBmaps[0].setFromRGBColor(comp, intensity, toRGBmap.getNormalizedBlue(intensity));
                this.fromRGBmaps[1].setFromRGBColor(comp, intensity, toRGBmap.getNormalizedGreen(intensity));
                this.fromRGBmaps[2].setFromRGBColor(comp, intensity, toRGBmap.getNormalizedRed(intensity));
                this.fromRGBmaps[3].setFromRGBColor(comp, intensity, toRGBmap.getNormalizedAlpha(intensity));
            }
        }
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        return this.fromRGB(ColorUtil.sRGB.fromCIEXYZ(colorvalue));
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        return ColorUtil.sRGB.toCIEXYZ(this.toRGB(colorvalue));
    }

    @Override
    public float[] fromRGB(float[] rgb) {
        int numComponents = this.getNumComponents();
        float[] result = new float[numComponents];
        FromRGBColorMap blueMap = this.fromRGBmaps[0];
        FromRGBColorMap greenMap = this.fromRGBmaps[1];
        FromRGBColorMap redMap = this.fromRGBmaps[2];
        FromRGBColorMap alphaMap = this.fromRGBmaps[3];
        float blue = rgb[0];
        float green = rgb[1];
        float red = rgb[2];
        float alpha = rgb.length > 3 ? rgb[3] : 1.0f;
        for (int comp = 0; comp < numComponents; ++comp) {
            result[comp] = blueMap.getFromRGBColor(comp, blue);
            int n = comp;
            result[n] = result[n] + greenMap.getFromRGBColor(comp, green);
            int n2 = comp;
            result[n2] = result[n2] + redMap.getFromRGBColor(comp, red);
            int n3 = comp;
            result[n3] = result[n3] * alphaMap.getFromRGBColor(comp, alpha);
            if (!(result[comp] > 1.0f)) continue;
            result[comp] = 1.0f;
        }
        return result;
    }

    public float[] fromRGB(int rgb) {
        int numComponents = this.getNumComponents();
        float[] result = new float[numComponents];
        FromRGBColorMap blueMap = this.fromRGBmaps[0];
        FromRGBColorMap greenMap = this.fromRGBmaps[1];
        FromRGBColorMap redMap = this.fromRGBmaps[2];
        FromRGBColorMap alphaMap = this.fromRGBmaps[3];
        int alp = rgb >> 24 & 0xFF;
        int red = rgb >> 16 & 0xFF;
        int grn = rgb >> 8 & 0xFF;
        int blu = rgb & 0xFF;
        for (int comp = 0; comp < numComponents; ++comp) {
            result[comp] = blueMap.maps[comp][blu];
            int n = comp;
            result[n] = result[n] + greenMap.maps[comp][grn];
            int n2 = comp;
            result[n2] = result[n2] + redMap.maps[comp][red];
            int n3 = comp;
            result[n3] = result[n3] * alphaMap.maps[comp][alp];
            if (!(result[comp] > 1.0f)) continue;
            result[comp] = 1.0f;
        }
        return result;
    }

    public int toRGBUnnorm(int[] colorvalue) {
        int numComponents = Math.min(this.getNumComponents(), colorvalue.length);
        float alpha = 1.0f;
        float maxLocalAlpha = 0.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int comp = 0; comp < numComponents; ++comp) {
            IcyColorMap cm = this.toRGBmaps[comp];
            if (!cm.isEnabled()) continue;
            int value = colorvalue[comp];
            float alphaValue = cm.alpha.mapf[value];
            if (cm.getType() == IcyColorMap.IcyColorMapType.ALPHA) {
                alpha = alphaValue;
            } else if (alphaValue > maxLocalAlpha) {
                maxLocalAlpha = alphaValue;
            }
            int[] premulRGB = cm.getPremulRGB()[value];
            b += premulRGB[0];
            g += premulRGB[1];
            r += premulRGB[2];
        }
        int a = (int)(alpha * maxLocalAlpha * 255.0f);
        if (a != 0) {
            int inv = 65536 / a;
            b = b * inv >> 8;
            g = g * inv >> 8;
            r = r * inv >> 8;
        }
        return (b > 255 ? 255 : b) | (g > 255 ? 255 : g) << 8 | (r > 255 ? 255 : r) << 16 | a << 24;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float[] result = new float[4];
        int numComponents = Math.min(this.getNumComponents(), colorvalue.length);
        float alpha = 1.0f;
        float maxLocalAlpha = 0.0f;
        float rf = 0.0f;
        float gf = 0.0f;
        float bf = 0.0f;
        for (int comp = 0; comp < numComponents; ++comp) {
            IcyColorMap cm = this.toRGBmaps[comp];
            if (!cm.isEnabled()) continue;
            int value = (int)(colorvalue[comp] * 255.0f);
            float alphaValue = cm.alpha.mapf[value];
            if (cm.getType() == IcyColorMap.IcyColorMapType.ALPHA) {
                alpha = alphaValue;
            } else if (alphaValue > maxLocalAlpha) {
                maxLocalAlpha = alphaValue;
            }
            float[] premulRGBNorm = cm.getPremulRGBNorm()[value];
            bf += premulRGBNorm[0];
            gf += premulRGBNorm[1];
            rf += premulRGBNorm[2];
        }
        float af = alpha * maxLocalAlpha;
        if (af != 0.0f) {
            float inv = 1.0f / af;
            bf *= inv;
            gf *= inv;
            rf *= inv;
        }
        result[0] = bf > 1.0f ? 1.0f : bf;
        result[1] = gf > 1.0f ? 1.0f : gf;
        result[2] = rf > 1.0f ? 1.0f : rf;
        result[3] = af;
        return result;
    }

    public void fillARGBBuffer(int[][] unnormSrc, int[] dest, int offset, int length) {
        int numComponents = this.getNumComponents();
        if (numComponents > 0) {
            int[] input = new int[numComponents];
            for (int i = 0; i < length; ++i) {
                for (int comp = 0; comp < numComponents; ++comp) {
                    input[comp] = unnormSrc[comp][i];
                }
                dest[offset + i] = this.toRGBUnnorm(input);
            }
        }
    }

    public void fillARGBBuffer(int[][] unnormSrc, int[] dest) {
        if (unnormSrc == null || dest == null) {
            throw new IllegalArgumentException("Parameters 'unnormSrc' and 'destARGB' should not be null !");
        }
        int numComponents = this.getNumComponents();
        if (unnormSrc.length != numComponents) {
            throw new IllegalArgumentException("Parameters 'unnormSrc' size is [" + unnormSrc.length + "][..] where [" + numComponents + "][..] is expected !");
        }
        if (numComponents > 0) {
            int size = unnormSrc[0].length;
            int[] input = new int[numComponents];
            for (int i = 0; i < size; ++i) {
                for (int comp = 0; comp < numComponents; ++comp) {
                    input[comp] = unnormSrc[comp][i];
                }
                dest[i] = this.toRGBUnnorm(input);
            }
        }
    }

    @Override
    public int getNumComponents() {
        return this.toRGBmaps.length;
    }

    public IcyColorMap getColorMap(int component) {
        return this.toRGBmaps[component];
    }

    @Deprecated
    public IcyColorMap getColormap(int component) {
        return this.getColorMap(component);
    }

    public void setColorMap(int component, IcyColorMap colorMap, boolean setAlpha) {
        this.toRGBmaps[component].copyFrom(colorMap, setAlpha);
    }

    @Deprecated
    public void setColormap(int component, IcyColorMap map) {
        this.setColorMap(component, map, true);
    }

    @Deprecated
    public void copyColormap(int component, IcyColorMap map, boolean copyName, boolean copyAlpha) {
        this.setColorMap(component, map, copyAlpha);
        if (copyName) {
            this.toRGBmaps[component].setName(map.getName());
        }
    }

    @Deprecated
    public void copyColormap(int component, IcyColorMap map, boolean copyName) {
        this.setColorMap(component, map, true);
        if (copyName) {
            this.toRGBmaps[component].setName(map.getName());
        }
    }

    @Deprecated
    public void copyColormap(int component, IcyColorMap map) {
        this.setColorMap(component, map, true);
    }

    public FromRGBColorMap getFromRGBMap(int component) {
        return this.fromRGBmaps[component];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorMaps(ColorModel cm) {
        if (cm instanceof IcyColorModel) {
            this.setColorMaps((IcyColorSpace)cm.getColorSpace(), true);
        } else {
            Object srcElem = cm.getDataElements(0, null);
            DataType srcDataType = ArrayUtil.getDataType(srcElem);
            int srcNumComponents = ArrayUtil.getLength(srcElem);
            DataType dataType = DataType.getDataTypeFromDataBufferType(cm.getTransferType());
            int numComponents = this.getNumComponents();
            if (srcNumComponents != numComponents || srcDataType != dataType) {
                return;
            }
            boolean hasAlpha = cm.hasAlpha();
            for (int comp = 0; comp < numComponents; ++comp) {
                IcyColorMap map = this.toRGBmaps[comp];
                map.beginUpdate();
                try {
                    if (hasAlpha && comp == numComponents - 1) {
                        map.setType(IcyColorMap.IcyColorMapType.ALPHA);
                    } else {
                        map.setType(IcyColorMap.IcyColorMapType.RGB);
                    }
                    block12: for (int index = 0; index < 256; ++index) {
                        switch (dataType.getJavaType()) {
                            case BYTE: {
                                int i;
                                byte[] bvalues = new byte[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    bvalues[i] = i == comp ? (int)(index * 256 / 256) : (hasAlpha && i == numComponents - 1 ? -1 : 0);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(bvalues));
                                map.setRed(index, (short)cm.getRed(bvalues));
                                map.setGreen(index, (short)cm.getGreen(bvalues));
                                map.setBlue(index, (short)cm.getBlue(bvalues));
                                continue block12;
                            }
                            case SHORT: {
                                int i;
                                short[] svalues = new short[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    svalues[i] = i == comp ? (int)(index * 65536 / 256) : (hasAlpha && i == numComponents - 1 ? -256 : 0);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(svalues));
                                map.setRed(index, (short)cm.getRed(svalues));
                                map.setGreen(index, (short)cm.getGreen(svalues));
                                map.setBlue(index, (short)cm.getBlue(svalues));
                                continue block12;
                            }
                            case INT: {
                                int i;
                                int[] ivalues = new int[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    ivalues[i] = i == comp ? index * 1 / 256 : (hasAlpha && i == numComponents - 1 ? 0 : 0);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(ivalues));
                                map.setRed(index, (short)cm.getRed(ivalues));
                                map.setGreen(index, (short)cm.getGreen(ivalues));
                                map.setBlue(index, (short)cm.getBlue(ivalues));
                                continue block12;
                            }
                            case LONG: {
                                int i;
                                long[] lvalues = new long[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    lvalues[i] = i == comp ? (long)(index * 1 / 256) : (hasAlpha && i == numComponents - 1 ? 0L : 0L);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(lvalues));
                                map.setRed(index, (short)cm.getRed(lvalues));
                                map.setGreen(index, (short)cm.getGreen(lvalues));
                                map.setBlue(index, (short)cm.getBlue(lvalues));
                                continue block12;
                            }
                            case FLOAT: {
                                int i;
                                float[] fvalues = new float[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    fvalues[i] = i == comp ? (float)index / 256.0f : (hasAlpha && i == numComponents - 1 ? 0.99609375f : 0.0f);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(fvalues));
                                map.setRed(index, (short)cm.getRed(fvalues));
                                map.setGreen(index, (short)cm.getGreen(fvalues));
                                map.setBlue(index, (short)cm.getBlue(fvalues));
                                continue block12;
                            }
                            case DOUBLE: {
                                int i;
                                double[] dvalues = new double[numComponents];
                                for (i = 0; i < numComponents; ++i) {
                                    dvalues[i] = i == comp ? (double)index / 256.0 : (hasAlpha && i == numComponents - 1 ? 0.99609375 : 0.0);
                                }
                                map.setAlpha(index, (short)cm.getAlpha(dvalues));
                                map.setRed(index, (short)cm.getRed(dvalues));
                                map.setGreen(index, (short)cm.getGreen(dvalues));
                                map.setBlue(index, (short)cm.getBlue(dvalues));
                                continue block12;
                            }
                        }
                    }
                    continue;
                }
                finally {
                    map.endUpdate();
                }
            }
        }
    }

    @Deprecated
    public void setColormaps(ColorModel cm) {
        this.setColorMaps(cm);
    }

    @Deprecated
    public void copyColormaps(ColorModel cm) {
        this.setColorMaps(cm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorMaps(IcyColorSpace source, boolean setAlpha) {
        int numComponents = Math.min(source.getNumComponents(), this.getNumComponents());
        this.beginUpdate();
        try {
            for (int comp = 0; comp < numComponents; ++comp) {
                this.setColorMap(comp, source.getColorMap(comp), setAlpha);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public void setColormaps(IcyColorSpace source) {
        this.setColorMaps(source, true);
    }

    @Deprecated
    public void copyColormaps(IcyColorSpace source) {
        this.setColorMaps(source, true);
    }

    public int indexOfColorMap(IcyColorMap colormap) {
        for (int i = 0; i < this.toRGBmaps.length; ++i) {
            if (!this.toRGBmaps[i].equals(colormap)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getName(int idx) {
        return "Component #" + idx;
    }

    public void addListener(IcyColorSpaceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IcyColorSpaceListener listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(IcyColorSpaceEvent e) {
        for (IcyColorSpaceListener listener : new ArrayList<IcyColorSpaceListener>(this.listeners)) {
            listener.colorSpaceChanged(e);
        }
    }

    private void changed(int component) {
        IcyColorMap colorMap = this.getColorMap(component);
        if (colorMap != null && colorMap.getType() == IcyColorMap.IcyColorMapType.ALPHA) {
            for (IcyColorMap map : this.toRGBmaps) {
                if (map == colorMap || map.getType() != IcyColorMap.IcyColorMapType.ALPHA) continue;
                map.setType(IcyColorMap.IcyColorMapType.RGB);
            }
        }
        this.updater.changed(new IcyColorSpaceEvent(this, component));
    }

    @Override
    public void onChanged(CollapsibleEvent compare) {
        IcyColorSpaceEvent event = (IcyColorSpaceEvent)compare;
        this.generateFromRGBColorMaps();
        this.fireEvent(event);
    }

    @Override
    public void colorMapChanged(IcyColorMapEvent e) {
        int index = this.indexOfColorMap(e.getColormap());
        if (index != -1) {
            this.changed(index);
        }
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }
}

