/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.type.TypeUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;

public class ArrayMath {
    public static Object add(Object a1, Object a2, Object out) {
        switch (ArrayUtil.getDataType(a1)) {
            case BYTE: {
                return ArrayMath.add((byte[])a1, (byte[])a2, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.add((short[])a1, (short[])a2, (short[])out);
            }
            case INT: {
                return ArrayMath.add((int[])a1, (int[])a2, (int[])out);
            }
            case LONG: {
                return ArrayMath.add((long[])a1, (long[])a2, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.add((float[])a1, (float[])a2, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.add((double[])a1, (double[])a2, (double[])out);
            }
        }
        return null;
    }

    public static Object add(Object a1, Object a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static double[] add(double[] a1, double[] a2, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] + a2[i];
        }
        return result;
    }

    public static double[] add(double[] a1, double[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static float[] add(float[] a1, float[] a2, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] + a2[i];
        }
        return result;
    }

    public static float[] add(float[] a1, float[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static long[] add(long[] a1, long[] a2, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] + a2[i];
        }
        return result;
    }

    public static long[] add(long[] a1, long[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static int[] add(int[] a1, int[] a2, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] + a2[i];
        }
        return result;
    }

    public static int[] add(int[] a1, int[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static short[] add(short[] a1, short[] a2, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (short)(a1[i] + a2[i]);
        }
        return result;
    }

    public static short[] add(short[] a1, short[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static byte[] add(byte[] a1, byte[] a2, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (byte)(a1[i] + a2[i]);
        }
        return result;
    }

    public static byte[] add(byte[] a1, byte[] a2) {
        return ArrayMath.add(a1, a2, null);
    }

    public static Object add(Object array, Number value, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.add((byte[])array, value.byteValue(), (byte[])out);
            }
            case SHORT: {
                return ArrayMath.add((short[])array, value.shortValue(), (short[])out);
            }
            case INT: {
                return ArrayMath.add((int[])array, value.intValue(), (int[])out);
            }
            case LONG: {
                return ArrayMath.add((long[])array, value.longValue(), (long[])out);
            }
            case FLOAT: {
                return ArrayMath.add((float[])array, value.floatValue(), (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.add((double[])array, value.doubleValue(), (double[])out);
            }
        }
        return null;
    }

    public static Object add(Object array, Number value) {
        return ArrayMath.add(array, value, null);
    }

    public static double[] add(double[] array, double value, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] + value;
        }
        return result;
    }

    @Deprecated
    public static double[] add(double value, double[] array, double[] out) {
        return ArrayMath.add(array, value, out);
    }

    public static double[] add(double[] array, double value) {
        return ArrayMath.add(array, value, null);
    }

    public static float[] add(float[] array, float value, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] + value;
        }
        return result;
    }

    public static float[] add(float[] array, float value) {
        return ArrayMath.add(array, value, null);
    }

    public static long[] add(long[] array, long value, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] + value;
        }
        return result;
    }

    public static long[] add(long[] array, long value) {
        return ArrayMath.add(array, value, null);
    }

    public static int[] add(int[] array, int value, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] + value;
        }
        return result;
    }

    public static int[] add(int[] array, int value) {
        return ArrayMath.add(array, value, null);
    }

    public static short[] add(short[] array, short value, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(array[i] + value);
        }
        return result;
    }

    public static short[] add(short[] array, short value) {
        return ArrayMath.add(array, value, null);
    }

    public static byte[] add(byte[] array, byte value, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(array[i] + value);
        }
        return result;
    }

    public static byte[] add(byte[] array, byte value) {
        return ArrayMath.add(array, value, null);
    }

    public static Object subtract(Object a1, Object a2, Object out) {
        switch (ArrayUtil.getDataType(a1)) {
            case BYTE: {
                return ArrayMath.subtract((byte[])a1, (byte[])a2, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.subtract((short[])a1, (short[])a2, (short[])out);
            }
            case INT: {
                return ArrayMath.subtract((int[])a1, (int[])a2, (int[])out);
            }
            case LONG: {
                return ArrayMath.subtract((long[])a1, (long[])a2, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.subtract((float[])a1, (float[])a2, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.subtract((double[])a1, (double[])a2, (double[])out);
            }
        }
        return null;
    }

    public static Object subtract(Object a1, Object a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static double[] subtract(double[] a1, double[] a2, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] - a2[i];
        }
        return result;
    }

    public static double[] subtract(double[] a1, double[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static float[] subtract(float[] a1, float[] a2, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] - a2[i];
        }
        return result;
    }

    public static float[] subtract(float[] a1, float[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static long[] subtract(long[] a1, long[] a2, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] - a2[i];
        }
        return result;
    }

    public static long[] subtract(long[] a1, long[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static int[] subtract(int[] a1, int[] a2, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] - a2[i];
        }
        return result;
    }

    public static int[] subtract(int[] a1, int[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static short[] subtract(short[] a1, short[] a2, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (short)(a1[i] - a2[i]);
        }
        return result;
    }

    public static short[] subtract(short[] a1, short[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static byte[] subtract(byte[] a1, byte[] a2, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (byte)(a1[i] - a2[i]);
        }
        return result;
    }

    public static byte[] subtract(byte[] a1, byte[] a2) {
        return ArrayMath.subtract(a1, a2, null);
    }

    public static Object subtract(Object array, Number value, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.subtract((byte[])array, value.byteValue(), (byte[])out);
            }
            case SHORT: {
                return ArrayMath.subtract((short[])array, value.shortValue(), (short[])out);
            }
            case INT: {
                return ArrayMath.subtract((int[])array, value.intValue(), (int[])out);
            }
            case LONG: {
                return ArrayMath.subtract((long[])array, value.longValue(), (long[])out);
            }
            case FLOAT: {
                return ArrayMath.subtract((float[])array, value.floatValue(), (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.subtract((double[])array, value.doubleValue(), (double[])out);
            }
        }
        return null;
    }

    public static Object subtract(Object array, Number value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static double[] subtract(double[] array, double value, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] - value;
        }
        return result;
    }

    public static double[] subtract(double[] array, double value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static float[] subtract(float[] array, float value, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] - value;
        }
        return result;
    }

    public static float[] subtract(float[] array, float value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static long[] subtract(long[] array, long value, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] - value;
        }
        return result;
    }

    public static long[] subtract(long[] array, long value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static int[] subtract(int[] array, int value, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] - value;
        }
        return result;
    }

    public static int[] subtract(int[] array, int value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static short[] subtract(short[] array, short value, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(array[i] - value);
        }
        return result;
    }

    public static short[] subtract(short[] array, short value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static byte[] subtract(byte[] array, byte value, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(array[i] - value);
        }
        return result;
    }

    public static byte[] subtract(byte[] array, byte value) {
        return ArrayMath.subtract(array, value, null);
    }

    public static Object subtract(Number value, Object array, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.subtract(value.byteValue(), (byte[])array, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.subtract(value.shortValue(), (short[])array, (short[])out);
            }
            case INT: {
                return ArrayMath.subtract(value.intValue(), (int[])array, (int[])out);
            }
            case LONG: {
                return ArrayMath.subtract(value.longValue(), (long[])array, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.subtract(value.floatValue(), (float[])array, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.subtract(value.doubleValue(), (double[])array, (double[])out);
            }
        }
        return null;
    }

    public static Object subtract(Number value, Object array) {
        return ArrayMath.subtract(value, array, null);
    }

    public static double[] subtract(double value, double[] array, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value - array[i];
        }
        return result;
    }

    public static double[] subtract(double value, double[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static float[] subtract(float value, float[] array, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value - array[i];
        }
        return result;
    }

    public static float[] subtract(float value, float[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static long[] subtract(long value, long[] array, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value - array[i];
        }
        return result;
    }

    public static long[] subtract(long value, long[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static int[] subtract(int value, int[] array, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value - array[i];
        }
        return result;
    }

    public static int[] subtract(int value, int[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static short[] subtract(short value, short[] array, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(value - array[i]);
        }
        return result;
    }

    public static short[] subtract(short value, short[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static byte[] subtract(byte value, byte[] array, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(value - array[i]);
        }
        return result;
    }

    public static byte[] subtract(byte value, byte[] array) {
        return ArrayMath.subtract(array, value, null);
    }

    public static Object multiply(Object a1, Object a2, Object out) {
        switch (ArrayUtil.getDataType(a1)) {
            case BYTE: {
                return ArrayMath.multiply((byte[])a1, (byte[])a2, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.multiply((short[])a1, (short[])a2, (short[])out);
            }
            case INT: {
                return ArrayMath.multiply((int[])a1, (int[])a2, (int[])out);
            }
            case LONG: {
                return ArrayMath.multiply((long[])a1, (long[])a2, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.multiply((float[])a1, (float[])a2, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.multiply((double[])a1, (double[])a2, (double[])out);
            }
        }
        return null;
    }

    public static Object multiply(Object a1, Object a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static double[] multiply(double[] a1, double[] a2, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] * a2[i];
        }
        return result;
    }

    public static double[] multiply(double[] a1, double[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static float[] multiply(float[] a1, float[] a2, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] * a2[i];
        }
        return result;
    }

    public static float[] multiply(float[] a1, float[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static long[] multiply(long[] a1, long[] a2, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] * a2[i];
        }
        return result;
    }

    public static long[] multiply(long[] a1, long[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static int[] multiply(int[] a1, int[] a2, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] * a2[i];
        }
        return result;
    }

    public static int[] multiply(int[] a1, int[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static short[] multiply(short[] a1, short[] a2, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (short)(a1[i] * a2[i]);
        }
        return result;
    }

    public static short[] multiply(short[] a1, short[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static byte[] multiply(byte[] a1, byte[] a2, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (byte)(a1[i] * a2[i]);
        }
        return result;
    }

    public static byte[] multiply(byte[] a1, byte[] a2) {
        return ArrayMath.multiply(a1, a2, null);
    }

    public static Object multiply(Object array, Number value, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.multiply((byte[])array, value.byteValue(), (byte[])out);
            }
            case SHORT: {
                return ArrayMath.multiply((short[])array, value.shortValue(), (short[])out);
            }
            case INT: {
                return ArrayMath.multiply((int[])array, value.intValue(), (int[])out);
            }
            case LONG: {
                return ArrayMath.multiply((long[])array, value.longValue(), (long[])out);
            }
            case FLOAT: {
                return ArrayMath.multiply((float[])array, value.floatValue(), (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.multiply((double[])array, value.doubleValue(), (double[])out);
            }
        }
        return null;
    }

    public static Object multiply(Object array, Number value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static double[] multiply(double[] array, double value, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * value;
        }
        return result;
    }

    @Deprecated
    public static double[] multiply(double value, double[] array, double[] out) {
        return ArrayMath.multiply(array, value, out);
    }

    public static double[] multiply(double[] array, double value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static float[] multiply(float[] array, float value, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * value;
        }
        return result;
    }

    public static float[] multiply(float[] array, float value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static long[] multiply(long[] array, long value, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * value;
        }
        return result;
    }

    public static long[] multiply(long[] array, long value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static int[] multiply(int[] array, int value, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * value;
        }
        return result;
    }

    public static int[] multiply(int[] array, int value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static short[] multiply(short[] array, short value, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(array[i] * value);
        }
        return result;
    }

    public static short[] multiply(short[] array, short value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static byte[] multiply(byte[] array, byte value, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(array[i] * value);
        }
        return result;
    }

    public static byte[] multiply(byte[] array, byte value) {
        return ArrayMath.multiply(array, value, null);
    }

    public static Object divide(Object a1, Object a2, Object out) {
        switch (ArrayUtil.getDataType(a1)) {
            case BYTE: {
                return ArrayMath.divide((byte[])a1, (byte[])a2, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.divide((short[])a1, (short[])a2, (short[])out);
            }
            case INT: {
                return ArrayMath.divide((int[])a1, (int[])a2, (int[])out);
            }
            case LONG: {
                return ArrayMath.divide((long[])a1, (long[])a2, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.divide((float[])a1, (float[])a2, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.divide((double[])a1, (double[])a2, (double[])out);
            }
        }
        return null;
    }

    public static Object divide(Object a1, Object a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static double[] divide(double[] a1, double[] a2, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] / a2[i];
        }
        return result;
    }

    public static double[] divide(double[] a1, double[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static float[] divide(float[] a1, float[] a2, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] / a2[i];
        }
        return result;
    }

    public static float[] divide(float[] a1, float[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static long[] divide(long[] a1, long[] a2, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] / a2[i];
        }
        return result;
    }

    public static long[] divide(long[] a1, long[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static int[] divide(int[] a1, int[] a2, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = a1[i] / a2[i];
        }
        return result;
    }

    public static int[] divide(int[] a1, int[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static short[] divide(short[] a1, short[] a2, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (short)(a1[i] / a2[i]);
        }
        return result;
    }

    public static short[] divide(short[] a1, short[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static byte[] divide(byte[] a1, byte[] a2, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, a1.length);
        for (int i = 0; i < a1.length; ++i) {
            result[i] = (byte)(a1[i] / a2[i]);
        }
        return result;
    }

    public static byte[] divide(byte[] a1, byte[] a2) {
        return ArrayMath.divide(a1, a2, null);
    }

    public static Object divide(Object array, Number value, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.divide((byte[])array, value.byteValue(), (byte[])out);
            }
            case SHORT: {
                return ArrayMath.divide((short[])array, value.shortValue(), (short[])out);
            }
            case INT: {
                return ArrayMath.divide((int[])array, value.intValue(), (int[])out);
            }
            case LONG: {
                return ArrayMath.divide((long[])array, value.longValue(), (long[])out);
            }
            case FLOAT: {
                return ArrayMath.divide((float[])array, value.floatValue(), (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.divide((double[])array, value.doubleValue(), (double[])out);
            }
        }
        return null;
    }

    public static Object divide(Object array, Number value) {
        return ArrayMath.divide(array, value, null);
    }

    public static double[] divide(double[] array, double value, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / value;
        }
        return result;
    }

    public static double[] divide(double[] array, double value) {
        return ArrayMath.divide(array, value, null);
    }

    public static float[] divide(float[] array, float value, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / value;
        }
        return result;
    }

    public static float[] divide(float[] array, float value) {
        return ArrayMath.divide(array, value, null);
    }

    public static long[] divide(long[] array, long value, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / value;
        }
        return result;
    }

    public static long[] divide(long[] array, long value) {
        return ArrayMath.divide(array, value, null);
    }

    public static int[] divide(int[] array, int value, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] / value;
        }
        return result;
    }

    public static int[] divide(int[] array, int value) {
        return ArrayMath.divide(array, value, null);
    }

    public static short[] divide(short[] array, short value, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(array[i] / value);
        }
        return result;
    }

    public static short[] divide(short[] array, short value) {
        return ArrayMath.divide(array, value, null);
    }

    public static byte[] divide(byte[] array, byte value, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(array[i] / value);
        }
        return result;
    }

    public static byte[] divide(byte[] array, byte value) {
        return ArrayMath.divide(array, value, null);
    }

    public static Object divide(Number value, Object array, Object out) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.divide(value.byteValue(), (byte[])array, (byte[])out);
            }
            case SHORT: {
                return ArrayMath.divide(value.shortValue(), (short[])array, (short[])out);
            }
            case INT: {
                return ArrayMath.divide(value.intValue(), (int[])array, (int[])out);
            }
            case LONG: {
                return ArrayMath.divide(value.longValue(), (long[])array, (long[])out);
            }
            case FLOAT: {
                return ArrayMath.divide(value.floatValue(), (float[])array, (float[])out);
            }
            case DOUBLE: {
                return ArrayMath.divide(value.doubleValue(), (double[])array, (double[])out);
            }
        }
        return null;
    }

    public static Object divide(Number value, Object array) {
        return ArrayMath.divide(value, array, null);
    }

    public static double[] divide(double value, double[] array, double[] out) {
        double[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value / array[i];
        }
        return result;
    }

    public static double[] divide(double value, double[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static float[] divide(float value, float[] array, float[] out) {
        float[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value / array[i];
        }
        return result;
    }

    public static float[] divide(float value, float[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static long[] divide(long value, long[] array, long[] out) {
        long[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value / array[i];
        }
        return result;
    }

    public static long[] divide(long value, long[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static int[] divide(int value, int[] array, int[] out) {
        int[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = value / array[i];
        }
        return result;
    }

    public static int[] divide(int value, int[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static short[] divide(short value, short[] array, short[] out) {
        short[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(value / array[i]);
        }
        return result;
    }

    public static short[] divide(short value, short[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static byte[] divide(byte value, byte[] array, byte[] out) {
        byte[] result = Array1DUtil.allocIfNull(out, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (byte)(value / array[i]);
        }
        return result;
    }

    public static byte[] divide(byte value, byte[] array) {
        return ArrayMath.divide(array, value, null);
    }

    public static Object abs(Object array, boolean overwrite) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.abs((byte[])array, overwrite);
            }
            case SHORT: {
                return ArrayMath.abs((short[])array, overwrite);
            }
            case INT: {
                return ArrayMath.abs((int[])array, overwrite);
            }
            case LONG: {
                return ArrayMath.abs((long[])array, overwrite);
            }
            case FLOAT: {
                return ArrayMath.abs((float[])array, overwrite);
            }
            case DOUBLE: {
                return ArrayMath.abs((double[])array, overwrite);
            }
        }
        return null;
    }

    public static double[] abs(double[] input, boolean overwrite) {
        double[] result = overwrite ? input : new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = Math.abs(input[i]);
        }
        return result;
    }

    public static float[] abs(float[] input, boolean overwrite) {
        float[] result = overwrite ? input : new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = Math.abs(input[i]);
        }
        return result;
    }

    public static long[] abs(long[] input, boolean overwrite) {
        long[] result = overwrite ? input : new long[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = Math.abs(input[i]);
        }
        return result;
    }

    public static int[] abs(int[] input, boolean overwrite) {
        int[] result = overwrite ? input : new int[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = Math.abs(input[i]);
        }
        return result;
    }

    public static short[] abs(short[] input, boolean overwrite) {
        short[] result = overwrite ? input : new short[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (short)Math.abs(input[i]);
        }
        return result;
    }

    public static byte[] abs(byte[] input, boolean overwrite) {
        byte[] result = overwrite ? input : new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (byte)Math.abs(input[i]);
        }
        return result;
    }

    public static double min(Object array, boolean signed) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.min((byte[])array, signed);
            }
            case SHORT: {
                return ArrayMath.min((short[])array, signed);
            }
            case INT: {
                return ArrayMath.min((int[])array, signed);
            }
            case LONG: {
                return ArrayMath.min((long[])array, signed);
            }
            case FLOAT: {
                return ArrayMath.min((float[])array);
            }
            case DOUBLE: {
                return ArrayMath.min((double[])array);
            }
        }
        return 0.0;
    }

    public static int min(byte[] array, boolean signed) {
        if (signed) {
            byte min = 127;
            for (byte v : array) {
                if (v >= min) continue;
                min = v;
            }
            return min;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            int v = TypeUtil.unsign(array[i]);
            if (v >= min) continue;
            min = v;
        }
        return min;
    }

    public static int min(short[] array, boolean signed) {
        if (signed) {
            short min = Short.MAX_VALUE;
            for (short v : array) {
                if (v >= min) continue;
                min = v;
            }
            return min;
        }
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            int v = TypeUtil.unsign(array[i]);
            if (v >= min) continue;
            min = v;
        }
        return min;
    }

    public static long min(int[] array, boolean signed) {
        if (signed) {
            int min = Integer.MAX_VALUE;
            for (int v : array) {
                if (v >= min) continue;
                min = v;
            }
            return min;
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            long v = TypeUtil.unsign(array[i]);
            if (v >= min) continue;
            min = v;
        }
        return min;
    }

    public static long min(long[] array, boolean signed) {
        if (signed) {
            long min = Integer.MAX_VALUE;
            for (long v : array) {
                if (v >= min) continue;
                min = v;
            }
            return min;
        }
        double min = 9.223372036854776E18;
        for (int i = 0; i < array.length; ++i) {
            double v = TypeUtil.unsign(array[i]);
            if (!(v < min)) continue;
            min = v;
        }
        return TypeUtil.toLong(min);
    }

    public static float min(float[] array) {
        float min = Float.MAX_VALUE;
        for (float v : array) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double min(double[] array) {
        double min = Double.MAX_VALUE;
        for (double v : array) {
            if (!(v < min)) continue;
            min = v;
        }
        return min;
    }

    public static double max(Object array, boolean signed) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.max((byte[])array, signed);
            }
            case SHORT: {
                return ArrayMath.max((short[])array, signed);
            }
            case INT: {
                return ArrayMath.max((int[])array, signed);
            }
            case LONG: {
                return ArrayMath.max((long[])array, signed);
            }
            case FLOAT: {
                return ArrayMath.max((float[])array);
            }
            case DOUBLE: {
                return ArrayMath.max((double[])array);
            }
        }
        return 0.0;
    }

    public static int max(byte[] array, boolean signed) {
        if (signed) {
            byte max = -128;
            for (byte v : array) {
                if (v <= max) continue;
                max = v;
            }
            return max;
        }
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            int v = TypeUtil.unsign(array[i]);
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static int max(short[] array, boolean signed) {
        if (signed) {
            short max = Short.MIN_VALUE;
            for (short v : array) {
                if (v <= max) continue;
                max = v;
            }
            return max;
        }
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            int v = TypeUtil.unsign(array[i]);
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static long max(int[] array, boolean signed) {
        if (signed) {
            int max = Integer.MIN_VALUE;
            for (int v : array) {
                if (v <= max) continue;
                max = v;
            }
            return max;
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            long v = TypeUtil.unsign(array[i]);
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static long max(long[] array, boolean signed) {
        if (signed) {
            long max = Integer.MIN_VALUE;
            for (long v : array) {
                if (v <= max) continue;
                max = v;
            }
            return max;
        }
        double max = -9.223372036854776E18;
        for (int i = 0; i < array.length; ++i) {
            double v = TypeUtil.unsign(array[i]);
            if (!(v > max)) continue;
            max = v;
        }
        return TypeUtil.toLong(max);
    }

    public static float max(float[] array) {
        float max = -3.4028235E38f;
        for (float v : array) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static double max(double[] array) {
        double max = -1.7976931348623157E308;
        for (double v : array) {
            if (!(v > max)) continue;
            max = v;
        }
        return max;
    }

    public static void min(double[] a1, double[] a2, double[] output) {
        for (int i = 0; i < a1.length; ++i) {
            output[i] = a1[i] <= a2[i] ? a1[i] : a2[i];
        }
    }

    public static double[] min(double[] a1, double[] a2) {
        double[] result = new double[a1.length];
        ArrayMath.min(a1, a2, result);
        return result;
    }

    public static void max(double[] a1, double[] a2, double[] output) {
        for (int i = 0; i < a1.length; ++i) {
            output[i] = a1[i] >= a2[i] ? a1[i] : a2[i];
        }
    }

    public static double[] max(double[] a1, double[] a2) {
        double[] result = new double[a1.length];
        ArrayMath.max(a1, a2, result);
        return result;
    }

    public static double median(double[] input, boolean preserveData) {
        return ArrayMath.select(input.length / 2, preserveData ? (double[])input.clone() : input);
    }

    public static double mad(double[] input, boolean normalPopulation) {
        double[] temp = new double[input.length];
        double median = ArrayMath.median(input, true);
        if (normalPopulation) {
            for (int i = 0; i < input.length; ++i) {
                temp[i] = (double)1.4826f * (input[i] - median);
            }
        } else {
            for (int i = 0; i < input.length; ++i) {
                temp[i] = input[i] - median;
            }
        }
        ArrayMath.abs(temp, true);
        return ArrayMath.median(temp, false);
    }

    public static double select(int k, double[] data) {
        int l = 1;
        int ir = data.length;
        while (true) {
            double temp;
            if (ir <= l + 1) {
                if (ir == l + 1 && data[ir - 1] < data[l - 1]) {
                    temp = data[l - 1];
                    data[l - 1] = data[ir - 1];
                    data[ir - 1] = temp;
                }
                return data[k - 1];
            }
            int mid = l + ir >> 1;
            temp = data[mid - 1];
            data[mid - 1] = data[l];
            data[l] = temp;
            if (data[l] > data[ir - 1]) {
                temp = data[l + 1 - 1];
                data[l] = data[ir - 1];
                data[ir - 1] = temp;
            }
            if (data[l - 1] > data[ir - 1]) {
                temp = data[l - 1];
                data[l - 1] = data[ir - 1];
                data[ir - 1] = temp;
            }
            if (data[l] > data[l - 1]) {
                temp = data[l];
                data[l] = data[l - 1];
                data[l - 1] = temp;
            }
            int i = l + 1;
            int j = ir;
            double a = data[l - 1];
            while (true) {
                if (data[++i - 1] < a) {
                    continue;
                }
                while (data[--j - 1] > a) {
                }
                if (j < i) break;
                temp = data[i - 1];
                data[i - 1] = data[j - 1];
                data[j - 1] = temp;
            }
            data[l - 1] = data[j - 1];
            data[j - 1] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static double sum(Object array, boolean signed) {
        switch (ArrayUtil.getDataType(array)) {
            case BYTE: {
                return ArrayMath.sum((byte[])array, signed);
            }
            case SHORT: {
                return ArrayMath.sum((short[])array, signed);
            }
            case INT: {
                return ArrayMath.sum((int[])array, signed);
            }
            case LONG: {
                return ArrayMath.sum((long[])array, signed);
            }
            case FLOAT: {
                return ArrayMath.sum((float[])array);
            }
            case DOUBLE: {
                return ArrayMath.sum((double[])array);
            }
        }
        return 0.0;
    }

    public static double sum(byte[] input, boolean signed) {
        double sum = 0.0;
        if (signed) {
            for (byte b : input) {
                sum += (double)b;
            }
        } else {
            for (byte b : input) {
                sum += (double)TypeUtil.unsign(b);
            }
        }
        return sum;
    }

    public static double sum(short[] input, boolean signed) {
        double sum = 0.0;
        if (signed) {
            for (short s : input) {
                sum += (double)s;
            }
        } else {
            for (short s : input) {
                sum += (double)TypeUtil.unsign(s);
            }
        }
        return sum;
    }

    public static double sum(int[] input, boolean signed) {
        double sum = 0.0;
        if (signed) {
            for (int i : input) {
                sum += (double)i;
            }
        } else {
            for (int i : input) {
                sum += (double)TypeUtil.unsign(i);
            }
        }
        return sum;
    }

    public static double sum(long[] input, boolean signed) {
        double sum = 0.0;
        if (signed) {
            for (long l : input) {
                sum += (double)l;
            }
        } else {
            for (long l : input) {
                sum += TypeUtil.unsign(l);
            }
        }
        return sum;
    }

    public static double sum(float[] input) {
        double sum = 0.0;
        for (float f : input) {
            sum += (double)f;
        }
        return sum;
    }

    public static double sum(double[] input) {
        double sum = 0.0;
        for (double d : input) {
            sum += d;
        }
        return sum;
    }

    public static double mean(double[] input) {
        return ArrayMath.sum(input) / (double)input.length;
    }

    public static double var(double[] input, boolean unbiased) {
        double var = 0.0;
        double mean = ArrayMath.mean(input);
        for (double f : input) {
            var += (f - mean) * (f - mean);
        }
        return var / (double)(unbiased ? input.length - 1 : input.length);
    }

    public static double std(double[] input, boolean unbiased) {
        return Math.sqrt(ArrayMath.var(input, unbiased));
    }

    public static double[] rescale(double[] input, double newMin, double newMax, boolean overwrite) {
        double max;
        double min = ArrayMath.min(input);
        if (min == (max = ArrayMath.max(input)) || min == newMin && max == newMax) {
            return input;
        }
        double[] result = overwrite ? input : new double[input.length];
        double ratio = (newMax - newMin) / (max - min);
        double base = newMin - min * ratio;
        for (int i = 0; i < input.length; ++i) {
            result[i] = base + input[i] * ratio;
        }
        return result;
    }

    public static double[] standardize(double[] input, boolean overwrite) {
        double[] output = overwrite ? input : new double[input.length];
        ArrayMath.subtract(input, ArrayMath.mean(input), output);
        ArrayMath.divide(output, ArrayMath.std(output, true), output);
        return output;
    }

    public static double correlation(double[] a, double[] b) throws IllegalArgumentException {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Populations must have same size");
        }
        double sum = 0.0;
        double sqsum_a = 0.0;
        double sqsum_b = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double ai = a[i];
            double bi = b[i];
            sum += ai * bi;
            sqsum_a += ai * ai;
            sqsum_b += bi * bi;
        }
        return sum / Math.sqrt(sqsum_a * sqsum_b);
    }

    public static double correlationPearson(double[] a, double[] b) throws IllegalArgumentException {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Populations must have same size");
        }
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return (sum - (double)a.length * ArrayMath.mean(a) * ArrayMath.mean(b)) / ((double)(a.length - 1) * ArrayMath.std(a, true) * ArrayMath.std(b, true));
    }
}

