/*
 * Decompiled with CFR 0.152.
 */
package icy.network;

import icy.main.Icy;
import icy.math.UnitUtil;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.preferences.ApplicationPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.w3c.dom.Document;

public class WebInterface {
    public static final String BASE_URL = "https://icy.bioimageanalysis.org/interface/";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_CLIENT_ID = "clientId";
    public static final String PARAM_ID = "id";
    public static final String PARAM_CLASSNAME = "classname";
    public static final String PARAM_FIELD = "field";
    public static final String PARAM_SEARCH = "search";
    public static final String PARAM_POSTTYPE = "pt";
    public static final String PARAM_KERNELVERSION = "kernelVersion";
    public static final String PARAM_JAVANAME = "javaName";
    public static final String PARAM_JAVAVERSION = "javaVersion";
    public static final String PARAM_JAVABITS = "javaBits";
    public static final String PARAM_OSNAME = "osName";
    public static final String PARAM_OSVERSION = "osVersion";
    public static final String PARAM_OSARCH = "osArch";
    public static final String PARAM_PLUGINCLASSNAME = "pluginClassName";
    public static final String PARAM_PLUGINVERSION = "pluginVersion";
    public static final String PARAM_DEVELOPERID = "developerId";
    public static final String PARAM_ERRORLOG = "errorLog";
    public static final String ACTION_TYPE_SEARCH = "search";
    public static final String ACTION_TYPE_BUGREPORT = "bugReport";
    public static final String SEARCH_TYPE_PLUGIN = "plugin";
    public static final String SEARCH_TYPE_SCRIPT = "script";
    public static final String SEARCH_TYPE_PROTOCOL = "protocol";

    public static Document doSearch(String text, String type) throws UnsupportedEncodingException {
        String request = "https://icy.bioimageanalysis.org/interface/?action=search&search=" + URLEncoder.encode(text, "UTF-8");
        if (!StringUtil.isEmpty(type)) {
            request = request + "&pt=" + type;
        }
        request = request + "&clientId=" + ApplicationPreferences.getId();
        return XMLUtil.loadDocument(URLUtil.getURL(request), true);
    }

    public static Document doSearch(String text) throws UnsupportedEncodingException {
        return WebInterface.doSearch(text, null);
    }

    public static void reportError(PluginDescriptor plugin, String devId, String errorLog) {
        String pluginDepsId;
        String pluginId;
        final HashMap<String, String> values = new HashMap<String, String>();
        values.put(PARAM_ACTION, ACTION_TYPE_BUGREPORT);
        values.put(PARAM_KERNELVERSION, Icy.version.toString());
        values.put(PARAM_JAVANAME, SystemUtil.getJavaName());
        values.put(PARAM_JAVAVERSION, SystemUtil.getJavaVersion());
        values.put(PARAM_JAVABITS, Integer.toString(SystemUtil.getJavaArchDataModel()));
        values.put(PARAM_OSNAME, SystemUtil.getOSName());
        values.put(PARAM_OSVERSION, SystemUtil.getOSVersion());
        values.put(PARAM_OSARCH, SystemUtil.getOSArch());
        String icyId = "Icy Version " + Icy.version + "<br>";
        String javaId = SystemUtil.getJavaName() + " " + SystemUtil.getJavaVersion() + " (" + SystemUtil.getJavaArchDataModel() + " bit)<br>";
        String osId = "Running on " + SystemUtil.getOSName() + " " + SystemUtil.getOSVersion() + " (" + SystemUtil.getOSArch() + ")<br>";
        String memory = "Max java memory : " + UnitUtil.getBytesString(SystemUtil.getJavaMaxMemory()) + "<br>";
        if (plugin != null) {
            pluginId = "Plugin " + plugin.toString();
            PluginDescriptor mainPlugin = plugin;
            if (plugin.isBundled()) {
                mainPlugin = plugin.getMainPlugin();
                if (mainPlugin == null) {
                    pluginId = pluginId + " bundled (could not retrieve main plugin)";
                    mainPlugin = plugin;
                } else {
                    pluginId = pluginId + " bundled in " + mainPlugin.toString();
                }
            }
            pluginId = pluginId + "<br><br>";
            String className = mainPlugin.getClassName();
            values.put(PARAM_PLUGINCLASSNAME, className);
            values.put(PARAM_PLUGINVERSION, mainPlugin.getVersion().toString());
            if (mainPlugin.getRequired().size() > 0) {
                pluginDepsId = "Dependances:<br>";
                for (PluginDescriptor.PluginIdent ident : mainPlugin.getRequired()) {
                    PluginDescriptor installed = PluginLoader.getPlugin(ident.getClassName());
                    if (installed == null) {
                        pluginDepsId = pluginDepsId + "Class " + ident.getClassName() + " not found !<br>";
                        continue;
                    }
                    pluginDepsId = pluginDepsId + "Plugin " + installed.toString() + " is correctly installed<br>";
                }
                pluginDepsId = pluginDepsId + "<br>";
            } else {
                pluginDepsId = "";
            }
        } else {
            values.put(PARAM_PLUGINCLASSNAME, "");
            values.put(PARAM_PLUGINVERSION, "");
            pluginId = "";
            pluginDepsId = "";
        }
        if (!StringUtil.isEmpty(devId)) {
            values.put(PARAM_DEVELOPERID, devId);
        } else if (plugin != null) {
            values.put(PARAM_DEVELOPERID, plugin.getAuthorPackageName());
        } else {
            values.put(PARAM_DEVELOPERID, "");
        }
        values.put(PARAM_CLIENT_ID, Integer.toString(ApplicationPreferences.getId()));
        values.put(PARAM_ERRORLOG, icyId + javaId + osId + memory + "<br>" + pluginId + pluginDepsId + errorLog.replaceAll("\n", "<br>"));
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                try {
                    String result = NetworkUtil.postData(WebInterface.BASE_URL, values);
                    if (result == null) {
                        System.out.println("Error while reporting data, verifying your internet connection.");
                    }
                }
                catch (IOException e) {
                    System.out.println("Error while reporting data :");
                    IcyExceptionHandler.showErrorMessage(e, false, false);
                }
            }
        });
    }
}

