/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin.classloader;

import icy.plugin.classloader.Configuration;
import icy.plugin.classloader.ProxyClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractClassLoader
extends ClassLoader {
    protected final List<ProxyClassLoader> loaders = new ArrayList<ProxyClassLoader>();
    private final ProxyClassLoader systemLoader = new SystemLoader();
    private final ProxyClassLoader parentLoader = new ParentLoader();
    private final ProxyClassLoader currentLoader = new CurrentLoader();
    private final ProxyClassLoader threadLoader = new ThreadContextLoader();

    public AbstractClassLoader(ClassLoader parent) {
        super(parent);
        this.addDefaultLoaders();
    }

    public void addLoader(ProxyClassLoader loader) {
        this.loaders.add(loader);
        Collections.sort(this.loaders);
    }

    protected void addDefaultLoaders() {
        this.loaders.add(this.systemLoader);
        this.loaders.add(this.parentLoader);
        this.loaders.add(this.currentLoader);
        this.loaders.add(this.threadLoader);
        Collections.sort(this.loaders);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        if (className == null || className.trim().equals("")) {
            return null;
        }
        ArrayList<ProxyClassLoader> loadersDone = new ArrayList<ProxyClassLoader>();
        for (ProxyClassLoader l : this.loaders) {
            if (!l.isEnabled() || loadersDone.contains(l)) continue;
            Class clazz = l.loadClass(className, resolveIt);
            if (clazz != null) {
                return clazz;
            }
            loadersDone.add(l);
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        ArrayList<ProxyClassLoader> loadersDone = new ArrayList<ProxyClassLoader>();
        for (ProxyClassLoader l : this.loaders) {
            if (!l.isEnabled() || loadersDone.contains(l)) continue;
            InputStream is = l.getResourceAsStream(name);
            if (is != null) {
                return is;
            }
            loadersDone.add(l);
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        ArrayList<ProxyClassLoader> loadersDone = new ArrayList<ProxyClassLoader>();
        for (ProxyClassLoader l : this.loaders) {
            if (!l.isEnabled() || loadersDone.contains(l)) continue;
            URL url = l.getResource(name);
            if (url != null) {
                return url;
            }
            loadersDone.add(l);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (name == null || name.trim().equals("")) {
            return null;
        }
        HashSet<URL> result = new HashSet<URL>();
        ArrayList<ProxyClassLoader> loadersDone = new ArrayList<ProxyClassLoader>();
        for (ProxyClassLoader l : this.loaders) {
            if (!l.isEnabled() || loadersDone.contains(l)) continue;
            Enumeration<URL> urls = l.getResources(name);
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    result.add(urls.nextElement());
                }
            }
            loadersDone.add(l);
        }
        return Collections.enumeration(result);
    }

    public ProxyClassLoader getSystemLoader() {
        return this.systemLoader;
    }

    public ProxyClassLoader getParentLoader() {
        return this.parentLoader;
    }

    public ProxyClassLoader getCurrentLoader() {
        return this.currentLoader;
    }

    public ProxyClassLoader getThreadLoader() {
        return this.threadLoader;
    }

    class SystemLoader
    extends ProxyClassLoader {
        private final Logger logger;

        public SystemLoader() {
            super(10);
            this.logger = Logger.getLogger(SystemLoader.class.getName());
            this.enabled = Configuration.isSystemLoaderEnabled();
        }

        @Override
        public ClassLoader getLoader() {
            return ClassLoader.getSystemClassLoader();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class result;
            try {
                result = AbstractClassLoader.this.findSystemClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Returning system class " + className);
            }
            return result;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = ClassLoader.getSystemResourceAsStream(name);
            if (is != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning system resource " + name);
                }
                return is;
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            URL url = ClassLoader.getSystemResource(name);
            if (url != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning system resource " + name);
                }
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> urls = ClassLoader.getSystemResources(name);
            if (urls != null && urls.hasMoreElements()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning system resources " + name);
                }
                return urls;
            }
            return null;
        }
    }

    class ParentLoader
    extends ProxyClassLoader {
        private final Logger logger;

        public ParentLoader() {
            super(30);
            this.logger = Logger.getLogger(ParentLoader.class.getName());
            this.enabled = Configuration.isParentLoaderEnabled();
        }

        @Override
        public ClassLoader getLoader() {
            return AbstractClassLoader.this.getParent();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result;
            try {
                result = AbstractClassLoader.this.getParent().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Returning class " + className + " loaded with parent classloader");
            }
            return result;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = AbstractClassLoader.this.getParent().getResourceAsStream(name);
            if (is != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with parent classloader");
                }
                return is;
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            URL url = AbstractClassLoader.this.getParent().getResource(name);
            if (url != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with parent classloader");
                }
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> urls = AbstractClassLoader.this.getParent().getResources(name);
            if (urls != null && urls.hasMoreElements()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with parent classloader");
                }
                return urls;
            }
            return null;
        }
    }

    class CurrentLoader
    extends ProxyClassLoader {
        private final Logger logger;

        public CurrentLoader() {
            super(20);
            this.logger = Logger.getLogger(CurrentLoader.class.getName());
            this.enabled = Configuration.isCurrentLoaderEnabled();
        }

        @Override
        public ClassLoader getLoader() {
            return this.getClass().getClassLoader();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result;
            try {
                result = this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Returning class " + className + " loaded with current classloader");
            }
            return result;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(name);
            if (is != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with current classloader");
                }
                return is;
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            URL url = this.getClass().getClassLoader().getResource(name);
            if (url != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with current classloader");
                }
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(name);
            if (urls != null && urls.hasMoreElements()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resources " + name + " loaded with current classloader");
                }
                return urls;
            }
            return null;
        }
    }

    class ThreadContextLoader
    extends ProxyClassLoader {
        private final Logger logger;

        public ThreadContextLoader() {
            super(40);
            this.logger = Logger.getLogger(ThreadContextLoader.class.getName());
            this.enabled = Configuration.isThreadContextLoaderEnabled();
        }

        @Override
        public ClassLoader getLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) {
            Class<?> result;
            try {
                result = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Returning class " + className + " loaded with thread context classloader");
            }
            return result;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            if (is != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with thread context classloader");
                }
                return is;
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resource " + name + " loaded with thread context classloader");
                }
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(name);
            if (urls != null && urls.hasMoreElements()) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning resources " + name + " loaded with thread context classloader");
                }
                return urls;
            }
            return null;
        }
    }
}

