/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.BooleanMask2D;
import icy.type.Position2DIterator;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.NoSuchElementException;

public class BooleanMask2DIterator
implements Position2DIterator {
    protected final BooleanMask2D mask;
    protected final int w;
    protected final int h;
    protected int x;
    protected int y;
    protected int off;
    protected boolean done;

    public BooleanMask2DIterator(BooleanMask2D mask) {
        this.mask = mask;
        this.w = mask.bounds.width;
        this.h = mask.bounds.height;
        this.reset();
    }

    public int getMinX() {
        return this.mask.bounds.x;
    }

    public int getMaxX() {
        return this.mask.bounds.x + this.w - 1;
    }

    public int getMinY() {
        return this.mask.bounds.y;
    }

    public int getMaxY() {
        return this.mask.bounds.y + this.h - 1;
    }

    @Override
    public void reset() {
        this.done = this.mask.bounds.isEmpty();
        if (!this.done) {
            this.y = 0;
            this.x = -1;
            this.off = -1;
            this.next();
        }
    }

    @Override
    public void next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        do {
            this.nextPosition();
        } while (!this.done && !this.mask.mask[this.off]);
    }

    protected void nextPosition() {
        ++this.off;
        if (++this.x >= this.w) {
            this.x = 0;
            if (++this.y >= this.h) {
                this.done = true;
            }
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public Point2D get() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return new Point(this.getX(), this.getY());
    }

    @Override
    public int getX() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.x + this.mask.bounds.x;
    }

    @Override
    public int getY() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.y + this.mask.bounds.y;
    }
}

