/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.painter.Anchor3D;
import icy.roi.ROI3D;
import icy.roi.edit.AbstractPoint3DROIEdit;
import icy.type.point.Point3D;
import java.util.List;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import plugins.kernel.roi.roi3d.ROI3DPolyLine;

public class Point3DRemovedROIEdit
extends AbstractPoint3DROIEdit {
    Point3D position;
    final int index;

    public Point3DRemovedROIEdit(ROI3D roi, List<Anchor3D> previousPoints, Anchor3D point) {
        super(roi, point, "ROI point removed");
        this.position = point.getPosition();
        int i = 0;
        for (Anchor3D p : previousPoints) {
            if (p.getPosition().equals(this.position)) break;
            ++i;
        }
        this.index = i;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.point.setPosition(this.position);
        if (this.getROI3D() instanceof ROI3DPolyLine) {
            ROI3DPolyLine roi = (ROI3DPolyLine)this.getROI3D();
            roi.addPoint(this.point, Math.min(this.index, roi.getControlPoints().size()));
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        if (this.getROI3D() instanceof ROI3DPolyLine) {
            ROI3DPolyLine roi = (ROI3DPolyLine)this.getROI3D();
            roi.removePoint(this.point);
        }
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.position = null;
    }
}

