/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence.edit;

import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.edit.AbstractROIsSequenceEdit;
import java.util.Collection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class ROIReplacesSequenceEdit
extends AbstractROIsSequenceEdit {
    final Collection<ROI> oldRois;

    public ROIReplacesSequenceEdit(Sequence sequence, Collection<ROI> oldRois, Collection<ROI> newRois, String name) {
        super(sequence, newRois, name);
        this.oldRois = oldRois;
    }

    public ROIReplacesSequenceEdit(Sequence sequence, Collection<ROI> oldRois, Collection<ROI> newRois) {
        this(sequence, oldRois, newRois, newRois.size() > 1 ? "ROI group replaced" : "ROI replaced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        Sequence sequence = this.getSequence();
        sequence.beginUpdate();
        try {
            for (ROI roi : this.getROIs()) {
                sequence.removeROI(roi, false);
            }
            for (ROI roi : this.oldRois) {
                sequence.addROI(roi, false);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Sequence sequence = this.getSequence();
        sequence.beginUpdate();
        try {
            for (ROI roi : this.oldRois) {
                sequence.removeROI(roi, false);
            }
            for (ROI roi : this.getROIs()) {
                sequence.addROI(roi, false);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }
}

