/*
 * Decompiled with CFR 0.152.
 */
package icy.type;

import icy.math.MathUtil;
import java.util.ArrayList;
import ome.xml.model.enums.PixelType;

public enum DataType {
    UBYTE(8, true, false, 0.0, MathUtil.POW2_8_DOUBLE - 1.0, Byte.TYPE, 0, PixelType.UINT8, "unsigned byte (8 bits)", "8 bits"),
    BYTE(8, true, true, -128.0, 127.0, Byte.TYPE, 0, PixelType.INT8, "signed byte (8 bits)", "8 bits (signed)"),
    USHORT(16, true, false, 0.0, MathUtil.POW2_16_DOUBLE - 1.0, Short.TYPE, 1, PixelType.UINT16, "unsigned short (16 bits)", "16 bits"),
    SHORT(16, true, true, -32768.0, 32767.0, Short.TYPE, 2, PixelType.INT16, "signed short (16 bits)", "16 bits (signed)"),
    UINT(32, true, false, 0.0, MathUtil.POW2_32_DOUBLE - 1.0, Integer.TYPE, 3, PixelType.UINT32, "unsigned int (32 bits)", "32 bits"),
    INT(32, true, true, -2.147483648E9, 2.147483647E9, Integer.TYPE, 3, PixelType.INT32, "signed int (32 bits)", "32 bits (signed)"),
    ULONG(64, true, false, 0.0, MathUtil.POW2_64_DOUBLE - 1.0, Long.TYPE, 32, null, "unsigned long (64 bits)", "64 bits"),
    LONG(64, true, true, -9.223372036854776E18, 9.223372036854776E18, Long.TYPE, 32, null, "signed long (64 bits)", "64 bits (signed)"),
    FLOAT(32, false, true, -3.4028234663852886E38, 3.4028234663852886E38, Float.TYPE, 4, PixelType.FLOAT, "float (32 bits)", "float"),
    DOUBLE(64, false, true, -1.7976931348623157E308, Double.MAX_VALUE, Double.TYPE, 5, PixelType.DOUBLE, "double (64 bits)", "double"),
    UNDEFINED(0, true, false, 0.0, 0.0, null, 32, null, "undefined", "undefined");

    public static final double UBYTE_MAX_VALUE;
    public static final double USHORT_MAX_VALUE;
    public static final double UINT_MAX_VALUE;
    public static final double ULONG_MAX_VALUE;
    public static final double INT_MIN_VALUE = -2.147483648E9;
    public static final double LONG_MIN_VALUE = -9.223372036854776E18;
    public static final double INT_MAX_VALUE = 2.147483647E9;
    public static final double LONG_MAX_VALUE = 9.223372036854776E18;
    public static final float UBYTE_MAX_VALUE_F;
    public static final float USHORT_MAX_VALUE_F;
    public static final float UINT_MAX_VALUE_F;
    public static final float ULONG_MAX_VALUE_F;
    public static final float INT_MIN_VALUE_F = -2.1474836E9f;
    public static final float LONG_MIN_VALUE_F = -9.223372E18f;
    public static final float INT_MAX_VALUE_F = 2.1474836E9f;
    public static final float LONG_MAX_VALUE_F = 9.223372E18f;
    protected String longString;
    protected String string;
    protected int bitSize;
    protected boolean integer;
    protected boolean signed;
    protected double min;
    protected double max;
    protected Class<?> primitiveClass;
    protected int dataBufferType;
    protected PixelType pixelType;

    public static String[] getItems(boolean javaTypeOnly, boolean longString, boolean wantUndef) {
        ArrayList<String> result = new ArrayList<String>();
        for (DataType dataType : DataType.values()) {
            if (javaTypeOnly && !dataType.isJavaType() || !wantUndef && dataType == UNDEFINED) continue;
            result.add(dataType.toString(longString));
        }
        return result.toArray(new String[result.size()]);
    }

    public static DataType getDataType(String value) {
        for (DataType dataType : DataType.values()) {
            if (!dataType.toString(false).equals(value) && !dataType.toString(true).equals(value)) continue;
            return dataType;
        }
        return null;
    }

    public static DataType getDataType(int oldDataType, boolean signed) {
        switch (oldDataType) {
            case 0: {
                if (signed) {
                    return BYTE;
                }
                return UBYTE;
            }
            case 2: {
                if (signed) {
                    return SHORT;
                }
                return USHORT;
            }
            case 3: {
                if (signed) {
                    return INT;
                }
                return UINT;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
        }
        return null;
    }

    public static DataType getDataType(int oldDataType) {
        return DataType.getDataType(oldDataType, true);
    }

    public static DataType getDataType(Class<?> classType) {
        if (classType.equals(Byte.TYPE)) {
            return BYTE;
        }
        if (classType.equals(Short.TYPE)) {
            return SHORT;
        }
        if (classType.equals(Integer.TYPE)) {
            return INT;
        }
        if (classType.equals(Long.TYPE)) {
            return LONG;
        }
        if (classType.equals(Float.TYPE)) {
            return FLOAT;
        }
        if (classType.equals(Double.TYPE)) {
            return DOUBLE;
        }
        return null;
    }

    public static DataType getDataTypeFromVTKType(int vtkType) {
        switch (vtkType) {
            case 3: {
                return UBYTE;
            }
            case 2: 
            case 15: {
                return BYTE;
            }
            case 5: {
                return USHORT;
            }
            case 4: {
                return SHORT;
            }
            case 7: {
                return UINT;
            }
            case 6: {
                return INT;
            }
            case 10: {
                return FLOAT;
            }
            case 11: {
                return DOUBLE;
            }
            case 9: {
                return ULONG;
            }
            case 8: {
                return LONG;
            }
        }
        return null;
    }

    public static DataType getDataTypeFromDataBufferType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return UBYTE;
            }
            case 2: {
                return SHORT;
            }
            case 1: {
                return USHORT;
            }
            case 3: {
                return UINT;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
        }
        return null;
    }

    public static DataType getDataTypeFromFormatToolsType(int type) {
        switch (type) {
            case 0: {
                return BYTE;
            }
            case 1: {
                return UBYTE;
            }
            case 2: {
                return SHORT;
            }
            case 3: {
                return USHORT;
            }
            case 4: {
                return INT;
            }
            case 5: {
                return UINT;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return DOUBLE;
            }
        }
        return null;
    }

    public static DataType getDataTypeFromPixelType(PixelType type) {
        switch (type) {
            case INT8: {
                return BYTE;
            }
            case UINT8: {
                return UBYTE;
            }
            case INT16: {
                return SHORT;
            }
            case UINT16: {
                return USHORT;
            }
            case INT32: {
                return INT;
            }
            case UINT32: {
                return UINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        return null;
    }

    private DataType(int bitSize, boolean integer, boolean signed, double min, double max, Class<?> primitiveClass, int dataBufferType, PixelType pixelType, String longString, String string2) {
        this.bitSize = bitSize;
        this.integer = integer;
        this.signed = signed;
        this.min = min;
        this.max = max;
        this.primitiveClass = primitiveClass;
        this.dataBufferType = dataBufferType;
        this.pixelType = pixelType;
        this.longString = longString;
        this.string = string2;
    }

    public DataType getJavaType() {
        switch (this.ordinal()) {
            case 0: {
                return BYTE;
            }
            case 2: {
                return SHORT;
            }
            case 4: {
                return INT;
            }
            case 6: {
                return LONG;
            }
        }
        return this;
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public double[] getDefaultBounds() {
        if (!this.integer) {
            return new double[]{0.0, 1.0};
        }
        return new double[]{this.getMinValue(), this.getMaxValue()};
    }

    public double[] getBounds() {
        return new double[]{this.getMinValue(), this.getMaxValue()};
    }

    public boolean isJavaType() {
        return this == this.getJavaType();
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isFloat() {
        return !this.isInteger();
    }

    public boolean isInteger() {
        return this.integer;
    }

    @Deprecated
    public int sizeOf() {
        return this.getSize();
    }

    public int getSize() {
        return this.getBitSize() / 8;
    }

    public int getBitSize() {
        return this.bitSize;
    }

    public boolean isSameJavaType(DataType dataType) {
        return dataType.getJavaType() == this.getJavaType();
    }

    public Class<?> toPrimitiveClass() {
        return this.primitiveClass;
    }

    public int toDataBufferType() {
        return this.dataBufferType;
    }

    public PixelType toPixelType() {
        return this.pixelType;
    }

    public String toString(boolean longString) {
        if (longString) {
            return this.toLongString();
        }
        return this.toString();
    }

    public String toLongString() {
        return this.longString;
    }

    public String toString() {
        return this.string;
    }

    static {
        UBYTE_MAX_VALUE = MathUtil.POW2_8_DOUBLE - 1.0;
        USHORT_MAX_VALUE = MathUtil.POW2_16_DOUBLE - 1.0;
        UINT_MAX_VALUE = MathUtil.POW2_32_DOUBLE - 1.0;
        ULONG_MAX_VALUE = MathUtil.POW2_64_DOUBLE - 1.0;
        UBYTE_MAX_VALUE_F = MathUtil.POW2_8_FLOAT - 1.0f;
        USHORT_MAX_VALUE_F = MathUtil.POW2_16_FLOAT - 1.0f;
        UINT_MAX_VALUE_F = MathUtil.POW2_32_FLOAT - 1.0f;
        ULONG_MAX_VALUE_F = MathUtil.POW2_64_FLOAT - 1.0f;
    }
}

