/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.type.DataType;
import java.util.ArrayList;
import java.util.List;

public abstract class DynamicArray {
    final int blockSize;
    private final List<ArrayBlock> blocks;

    public static DynamicArray create(DataType type, int granularity) {
        switch (type.getJavaType()) {
            case BYTE: {
                return new Byte(granularity);
            }
            case SHORT: {
                return new Short();
            }
            case INT: {
                return new Int();
            }
            case LONG: {
                return new Long();
            }
            case FLOAT: {
                return new Float();
            }
            case DOUBLE: {
                return new Double();
            }
        }
        return null;
    }

    public static DynamicArray create(DataType type) {
        return DynamicArray.create(type, 4);
    }

    @Deprecated
    public static DynamicArray create(int type) {
        return DynamicArray.create(DataType.getDataType(type));
    }

    DynamicArray(int granularity) {
        this.blockSize = 1 << 8 + Math.min(Math.max(granularity, 0), 8);
        this.blocks = new ArrayList<ArrayBlock>();
    }

    DynamicArray() {
        this(4);
    }

    protected abstract Object createArray(int var1);

    protected abstract int getArraySize(Object var1);

    public void clear() {
        this.setSize(0);
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    protected ArrayBlock addBlock() {
        ArrayBlock result = new ArrayBlock();
        this.blocks.add(result);
        return result;
    }

    protected void removeBlock() {
        int numBlock = this.blocks.size();
        if (numBlock > 0) {
            this.blocks.remove(numBlock - 1);
        }
    }

    protected void checkCapacity(int size) {
        while (this.getCapacity() < size) {
            this.setSize(size);
        }
    }

    public int getCapacity() {
        return this.blocks.size() * this.blockSize;
    }

    public int getSize() {
        int lastBlockIndex = this.getLastBlockIndex();
        if (lastBlockIndex < 0) {
            return 0;
        }
        return this.blockSize * lastBlockIndex + this.blocks.get(lastBlockIndex).getSize();
    }

    protected int getLastBlockIndex() {
        return this.blocks.size() - 1;
    }

    protected ArrayBlock getLastBlock() {
        int lastBlockIndex = this.getLastBlockIndex();
        if (lastBlockIndex < 0) {
            return null;
        }
        return this.blocks.get(lastBlockIndex);
    }

    protected ArrayBlock getBlockFromOffset(int offset) {
        int blockIndex = offset / this.blockSize;
        if (blockIndex < this.blocks.size()) {
            return this.blocks.get(blockIndex);
        }
        return null;
    }

    protected ArrayBlock getAvailableBlock(boolean create) {
        ArrayBlock lastBlock = this.getLastBlock();
        if (lastBlock != null && lastBlock.getAvailable() > 0) {
            return lastBlock;
        }
        if (create) {
            return this.addBlock();
        }
        return null;
    }

    public void setSize(int size) {
        if (size == 0) {
            this.blocks.clear();
            return;
        }
        while (this.getCapacity() < size) {
            ArrayBlock block = this.addBlock();
            block.size = this.blockSize;
        }
        while (this.getCapacity() - this.blockSize > size) {
            this.removeBlock();
        }
        if (this.getCapacity() > size) {
            this.getLastBlock().size = this.getCapacity() - size;
        }
    }

    public void addAll(DynamicArray in) {
        Object array = in.asArray();
        this.add(array, 0, this.getArraySize(array));
    }

    public void add(Object in) {
        this.add(in, 0, this.getArraySize(in));
    }

    public void get(Object out, int inOffset, int outOffset, int len) {
        int subLen;
        int srcOffset = inOffset;
        int dstOffset = outOffset;
        for (int cnt = len; cnt > 0; cnt -= subLen) {
            ArrayBlock block = this.getBlockFromOffset(srcOffset);
            int subSrcOffset = srcOffset & this.blockSize - 1;
            subLen = Math.min(this.blockSize - subSrcOffset, cnt);
            block.get(out, subSrcOffset, dstOffset, subLen);
            srcOffset += subLen;
            dstOffset += subLen;
        }
    }

    public void add(Object in, int inOffset, int len) {
        int toCopy;
        int offset = inOffset;
        for (int cnt = len; cnt > 0; cnt -= toCopy) {
            ArrayBlock block = this.getAvailableBlock(true);
            int blockSpace = block.getAvailable();
            toCopy = Math.min(blockSpace, cnt);
            block.add(in, offset, toCopy);
            offset += toCopy;
        }
    }

    public void put(Object in, int inOffset, int outOffset, int len) {
        int subLen;
        this.checkCapacity(outOffset + len);
        int srcOffset = inOffset;
        int dstOffset = outOffset;
        for (int cnt = len; cnt > 0; cnt -= subLen) {
            ArrayBlock block = this.getBlockFromOffset(dstOffset);
            int subDstOffset = dstOffset & this.blockSize - 1;
            subLen = Math.min(this.blockSize - subDstOffset, cnt);
            block.put(in, srcOffset, subDstOffset, subLen);
            srcOffset += subLen;
            dstOffset += subLen;
        }
    }

    public Object asArray() {
        Object result = this.createArray(this.getSize());
        int offset = 0;
        for (ArrayBlock block : this.blocks) {
            int blockSize = block.getSize();
            block.get(result, 0, offset, blockSize);
            offset += blockSize;
        }
        return result;
    }

    public static class Byte
    extends DynamicArray {
        public Byte(int granularity) {
            super(granularity);
        }

        public Byte() {
        }

        public void addSingle(byte value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((byte[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new byte[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((byte[])array).length;
        }

        public byte[] asArray() {
            return (byte[])super.asArray();
        }
    }

    public static class Short
    extends DynamicArray {
        public Short(int granularity) {
            super(granularity);
        }

        public Short() {
        }

        public void addSingle(short value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((short[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new short[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((short[])array).length;
        }

        public short[] asArray() {
            return (short[])super.asArray();
        }
    }

    public static class Int
    extends DynamicArray {
        public Int(int granularity) {
            super(granularity);
        }

        public Int() {
        }

        public void addSingle(int value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((int[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new int[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((int[])array).length;
        }

        public int[] asArray() {
            return (int[])super.asArray();
        }
    }

    public static class Long
    extends DynamicArray {
        public Long(int granularity) {
            super(granularity);
        }

        public Long() {
        }

        public void addSingle(long value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((long[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new long[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((long[])array).length;
        }

        public long[] asArray() {
            return (long[])super.asArray();
        }
    }

    public static class Float
    extends DynamicArray {
        public Float(int granularity) {
            super(granularity);
        }

        public Float() {
        }

        public void addSingle(float value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((float[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new float[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((float[])array).length;
        }

        public float[] asArray() {
            return (float[])super.asArray();
        }
    }

    public static class Double
    extends DynamicArray {
        public Double(int granularity) {
            super(granularity);
        }

        public Double() {
        }

        public void addSingle(double value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((double[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new double[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((double[])array).length;
        }

        public double[] asArray() {
            return (double[])super.asArray();
        }
    }

    protected class ArrayBlock {
        protected Object array;
        protected int size;

        public ArrayBlock() {
            this.array = DynamicArray.this.createArray(DynamicArray.this.blockSize);
            this.size = 0;
        }

        protected void clear() {
            this.size = 0;
        }

        public int getSize() {
            return this.size;
        }

        @Deprecated
        public int getFreeSpace() {
            return this.getAvailable();
        }

        public int getAvailable() {
            return DynamicArray.this.blockSize - this.getSize();
        }

        protected void get(Object out, int inOffset, int outOffset, int len) {
            System.arraycopy(this.array, inOffset, out, outOffset, len);
        }

        protected void add(Object in, int inOffset, int len) {
            System.arraycopy(in, inOffset, this.array, this.size, len);
            this.size += len;
        }

        protected void put(Object in, int inOffset, int outOffset, int len) {
            System.arraycopy(in, inOffset, this.array, outOffset, len);
            this.size = Math.max(this.size, outOffset + len);
        }
    }

    public static class Generic
    extends DynamicArray {
        public void addSingle(Object value) {
            ArrayBlock block = this.getAvailableBlock(true);
            ((Object[])block.array)[block.size++] = value;
        }

        @Override
        protected Object createArray(int size) {
            return new Object[size];
        }

        @Override
        protected int getArraySize(Object array) {
            return ((Object[])array).length;
        }

        public Object[] asArray() {
            return (Object[])super.asArray();
        }
    }
}

