/*
 * Decompiled with CFR 0.152.
 */
package icy.type.rectangle;

import icy.type.dimension.Dimension3D;
import icy.type.geom.BoxShape3D;
import icy.type.geom.Line3D;
import icy.type.geom.Shape3D;
import icy.type.point.Point3D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public abstract class Rectangle3D
extends BoxShape3D
implements Shape3D,
Cloneable {
    public static boolean intersects(Line3D line, Rectangle3D rect) {
        double rMinX = rect.getMinX();
        double rMaxX = rect.getMaxX();
        double rMinY = rect.getMinY();
        double rMaxY = rect.getMaxY();
        double rMinZ = rect.getMinZ();
        double rMaxZ = rect.getMaxZ();
        if (line.getX2() < rMinX && line.getX1() < rMinX) {
            return false;
        }
        if (line.getX2() > rMaxX && line.getX1() > rMaxX) {
            return false;
        }
        if (line.getY2() < rMinY && line.getY1() < rMinY) {
            return false;
        }
        if (line.getY2() > rMaxY && line.getY1() > rMaxY) {
            return false;
        }
        if (line.getZ2() < rMinZ && line.getZ1() < rMinZ) {
            return false;
        }
        if (line.getZ2() > rMaxZ && line.getZ1() > rMaxZ) {
            return false;
        }
        if (line.getX1() > rMinX && line.getX1() < rMaxX && line.getY1() > rMinY && line.getY1() < rMaxY && line.getZ1() > rMinZ && line.getZ1() < rMaxZ) {
            return true;
        }
        return Rectangle3D.inBox(Rectangle3D.getIntersection(line.getX1() - rMinX, line.getX2() - rMinX, line), rect, 1) || Rectangle3D.inBox(Rectangle3D.getIntersection(line.getY1() - rMinY, line.getY2() - rMinY, line), rect, 2) || Rectangle3D.inBox(Rectangle3D.getIntersection(line.getZ1() - rMinZ, line.getZ2() - rMinZ, line), rect, 3) || Rectangle3D.inBox(Rectangle3D.getIntersection(line.getX1() - rMaxX, line.getX2() - rMaxX, line), rect, 1) || Rectangle3D.inBox(Rectangle3D.getIntersection(line.getY1() - rMaxY, line.getY2() - rMaxY, line), rect, 2) || Rectangle3D.inBox(Rectangle3D.getIntersection(line.getZ1() - rMaxZ, line.getZ2() - rMaxZ, line), rect, 3);
    }

    static Point3D getIntersection(double dst1, double dst2, Line3D line) {
        if (dst1 * dst2 >= 0.0) {
            return null;
        }
        if (dst1 == dst2) {
            return null;
        }
        double f = -dst1 / (dst2 - dst1);
        Point3D result = line.getVector();
        result = new Point3D.Double(result.getX() * f, result.getY() * f, result.getZ() * f);
        return new Point3D.Double(line.getX1() + result.getX(), line.getY1() + result.getY(), line.getZ1() + result.getZ());
    }

    static boolean inBox(Point3D hit, Rectangle3D rect, int axis) {
        if (hit == null || rect == null) {
            return false;
        }
        switch (axis) {
            default: {
                return false;
            }
            case 1: {
                return hit.getZ() > rect.getMinZ() && hit.getZ() < rect.getMaxZ() && hit.getY() > rect.getMinY() && hit.getY() < rect.getMaxY();
            }
            case 2: {
                return hit.getZ() > rect.getMinZ() && hit.getZ() < rect.getMaxZ() && hit.getX() > rect.getMinX() && hit.getX() < rect.getMaxX();
            }
            case 3: 
        }
        return hit.getX() > rect.getMinX() && hit.getX() < rect.getMaxX() && hit.getY() > rect.getMinY() && hit.getY() < rect.getMaxY();
    }

    public static Rectangle3D intersect(Rectangle3D src1, Rectangle3D src2, Rectangle3D dest) {
        Rectangle3D result = dest == null ? new Double() : dest;
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double z1 = Math.max(src1.getMinZ(), src2.getMinZ());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.min(src1.getMaxZ(), src2.getMaxZ());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        result.setRect(x1, y1, z1, dx, dy, dz);
        return result;
    }

    public abstract Rectangle3D createIntersection(Rectangle3D var1);

    public static Rectangle3D union(Rectangle3D src1, Rectangle3D src2, Rectangle3D dest) {
        Rectangle3D result = dest == null ? new Double() : dest;
        double x1 = Math.min(src1.getMinX(), src2.getMinX());
        double y1 = Math.min(src1.getMinY(), src2.getMinY());
        double z1 = Math.min(src1.getMinZ(), src2.getMinZ());
        double x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        double z2 = Math.max(src1.getMaxZ(), src2.getMaxZ());
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        result.setRect(x1, y1, z1, dx, dy, dz);
        return result;
    }

    public abstract Rectangle3D createUnion(Rectangle3D var1);

    public abstract void setRect(double var1, double var3, double var5, double var7, double var9, double var11);

    @Override
    public abstract double getX();

    @Override
    public abstract double getY();

    @Override
    public abstract double getZ();

    public abstract Point3D getPosition();

    public abstract Dimension3D getDimension();

    @Override
    public abstract double getSizeX();

    @Override
    public abstract double getSizeY();

    @Override
    public abstract double getSizeZ();

    public Integer toInteger() {
        double sx = this.getSizeX();
        double sy = this.getSizeY();
        double sz = this.getSizeZ();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        int ix = (int)Math.floor(x);
        int iy = (int)Math.floor(y);
        int iz = (int)Math.floor(z);
        int isx = sx < 0.0 ? 0 : (sx >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(x + sx) - ix);
        int isy = sy < 0.0 ? 0 : (sy >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(y + sy) - iy);
        int isz = sz < 0.0 ? 0 : (sz >= 2.147483647E9 ? java.lang.Integer.MAX_VALUE : (int)Math.ceil(z + sz) - iz);
        return new Integer(ix, iy, iz, isx, isy, isz);
    }

    public abstract void setX(double var1);

    public abstract void setY(double var1);

    @Override
    public abstract void setZ(double var1);

    public abstract void setSizeX(double var1);

    public abstract void setSizeY(double var1);

    @Override
    public abstract void setSizeZ(double var1);

    @Override
    public double getMinX() {
        return this.getX();
    }

    @Override
    public double getMinY() {
        return this.getY();
    }

    @Override
    public double getMinZ() {
        return this.getZ();
    }

    @Override
    public double getMaxX() {
        if (this.getSizeX() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getX() + this.getSizeX();
    }

    @Override
    public double getMaxY() {
        if (this.getSizeY() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getY() + this.getSizeY();
    }

    @Override
    public double getMaxZ() {
        if (this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY) {
            return java.lang.Double.POSITIVE_INFINITY;
        }
        return this.getZ() + this.getSizeZ();
    }

    @Override
    public double getCenterX() {
        if (this.isInfiniteX()) {
            return 0.0;
        }
        return this.getX() + this.getSizeX() / 2.0;
    }

    @Override
    public double getCenterY() {
        if (this.isInfiniteY()) {
            return 0.0;
        }
        return this.getY() + this.getSizeY() / 2.0;
    }

    @Override
    public double getCenterZ() {
        if (this.isInfiniteZ()) {
            return 0.0;
        }
        return this.getZ() + this.getSizeZ() / 2.0;
    }

    @Override
    public boolean isEmpty() {
        return this.getSizeX() <= 0.0 || this.getSizeY() <= 0.0 || this.getSizeZ() <= 0.0;
    }

    public boolean isInfiniteX() {
        return this.getX() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeX() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteY() {
        return this.getY() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeY() == java.lang.Double.POSITIVE_INFINITY;
    }

    public boolean isInfiniteZ() {
        return this.getZ() == java.lang.Double.NEGATIVE_INFINITY && this.getSizeZ() == java.lang.Double.POSITIVE_INFINITY;
    }

    public void setInfiniteX() {
        this.setX(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeX(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteY() {
        this.setY(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeY(java.lang.Double.POSITIVE_INFINITY);
    }

    public void setInfiniteZ() {
        this.setZ(java.lang.Double.NEGATIVE_INFINITY);
        this.setSizeZ(java.lang.Double.POSITIVE_INFINITY);
    }

    @Override
    public Rectangle3D getBounds() {
        return new Double(this);
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return x >= this.getMinX() && y >= this.getMinY() && z >= this.getMinZ() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ();
    }

    @Override
    public boolean contains(Point3D p) {
        return this.contains(p.getX(), p.getY(), p.getZ());
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        return x >= this.getMinX() && y >= this.getMinY() && z >= this.getMinZ() && maxX <= this.getMaxX() && maxY <= this.getMaxY() && maxZ <= this.getMaxZ();
    }

    @Override
    public boolean contains(Rectangle3D rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getZ(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ());
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        double maxX = sizeX == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x + sizeX;
        double maxY = sizeY == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y + sizeY;
        double maxZ = sizeZ == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z + sizeZ;
        return maxX > this.getMinX() && maxY > this.getMinY() && maxZ > this.getMinZ() && x < this.getMaxX() && y < this.getMaxY() && z < this.getMaxZ();
    }

    @Override
    public boolean intersects(Rectangle3D rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getZ(), rect.getSizeX(), rect.getSizeY(), rect.getSizeZ());
    }

    public boolean intersectsLine(Line3D line) {
        return Rectangle3D.intersects(line, this);
    }

    public boolean intersectsLine(Point3D pt1, Point3D pt2) {
        return Rectangle3D.intersects(new Line3D(pt1, pt2), this);
    }

    public boolean intersectsLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Rectangle3D.intersects(new Line3D(x1, y1, z1, x2, y2, z2), this);
    }

    public void add(double newx, double newy, double newz) {
        double x1 = Math.min(this.getMinX(), newx);
        double x2 = Math.max(this.getMaxX(), newx);
        double y1 = Math.min(this.getMinY(), newy);
        double y2 = Math.max(this.getMaxY(), newy);
        double z1 = Math.min(this.getMinZ(), newz);
        double z2 = Math.max(this.getMaxZ(), newz);
        double dx = x2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : x2 - x1;
        double dy = y2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : y2 - y1;
        double dz = z2 == java.lang.Double.POSITIVE_INFINITY ? java.lang.Double.POSITIVE_INFINITY : z2 - z1;
        this.setRect(x1, y1, z1, dx, dy, dz);
    }

    public void add(Point3D pt) {
        this.add(pt.getX(), pt.getY(), pt.getZ());
    }

    public void add(Rectangle3D r) {
        Rectangle3D.union(this, r, this);
    }

    public abstract Rectangle2D toRectangle2D();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle3D) {
            Rectangle3D rect = (Rectangle3D)obj;
            return this.getX() == rect.getX() && this.getY() == rect.getY() && this.getZ() == rect.getZ() && this.getSizeX() == rect.getSizeX() && this.getSizeY() == rect.getSizeY() && this.getSizeZ() == rect.getSizeZ();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        long bits = java.lang.Double.doubleToLongBits(this.getX());
        bits ^= java.lang.Double.doubleToLongBits(this.getY());
        bits ^= java.lang.Double.doubleToLongBits(this.getZ());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeX());
        bits ^= java.lang.Double.doubleToLongBits(this.getSizeY());
        return (int)(bits ^= java.lang.Double.doubleToLongBits(this.getSizeZ())) ^ (int)(bits >> 32);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getX() + "," + this.getY() + "," + this.getZ() + " - " + this.getSizeX() + "," + this.getSizeY() + "," + this.getSizeZ() + "]";
    }

    public static class Double
    extends Rectangle3D {
        public double x;
        public double y;
        public double z;
        public double sizeX;
        public double sizeY;
        public double sizeZ;

        public Double(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Double(Rectangle3D r) {
            this(r.getX(), r.getY(), r.getZ(), r.getSizeX(), r.getSizeY(), r.getSizeZ());
        }

        public Double() {
            this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }

        @Override
        public Object clone() {
            return new Double(this);
        }

        @Override
        public void setRect(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = value;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = value;
        }

        @Override
        public double getZ() {
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = value;
        }

        @Override
        public double getSizeX() {
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = value;
        }

        @Override
        public double getSizeY() {
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = value;
        }

        @Override
        public double getSizeZ() {
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = value;
        }

        @Override
        public Point3D.Double getPosition() {
            return new Point3D.Double(this.x, this.y, this.z);
        }

        @Override
        public Dimension3D.Double getDimension() {
            return new Dimension3D.Double(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Rectangle3D createIntersection(Rectangle3D r) {
            Double result = new Double();
            Double.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle3D createUnion(Rectangle3D r) {
            Double result = new Double();
            Double.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Double(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public void setFrame(double x, double y, double z, double sx, double sy, double sz) {
            this.setRect(x, y, z, sx, sy, sz);
        }

        @Override
        public Shape getShape2D() {
            return this.toRectangle2D();
        }
    }

    public static class Integer
    extends Rectangle3D {
        public int x;
        public int y;
        public int z;
        public int sizeX;
        public int sizeY;
        public int sizeZ;

        public Integer(int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Integer(Integer r) {
            this(r.x, r.y, r.z, r.sizeX, r.sizeY, r.sizeZ);
        }

        public Integer(Rectangle3D r) {
            this(r.toInteger());
        }

        public Integer() {
            this(0, 0, 0, 0, 0, 0);
        }

        @Override
        public Object clone() {
            return new Integer(this);
        }

        @Override
        public void setRect(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            Integer r = new Double(x, y, z, sizeX, sizeY, sizeZ).toInteger();
            this.setRect(r.x, r.y, r.z, r.sizeX, r.sizeY, r.sizeZ);
        }

        public void setRect(int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (int)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (int)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Integer.MIN_VALUE) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (int)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (int)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (int)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Integer.MAX_VALUE) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (int)value;
        }

        @Override
        public Point3D.Integer getPosition() {
            return new Point3D.Integer(this.x, this.y, this.z);
        }

        @Override
        public Dimension3D.Integer getDimension() {
            return new Dimension3D.Integer(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Integer toInteger() {
            return (Integer)this.clone();
        }

        @Override
        public Rectangle3D createIntersection(Rectangle3D r) {
            Integer result = new Integer();
            Integer.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle3D createUnion(Rectangle3D r) {
            Integer result = new Integer();
            Integer.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public void setFrame(double x, double y, double z, double sx, double sy, double sz) {
            this.setRect(x, y, z, sx, sy, sz);
        }

        @Override
        public Shape getShape2D() {
            return this.toRectangle2D();
        }
    }

    public static class Float
    extends Rectangle3D {
        public float x;
        public float y;
        public float z;
        public float sizeX;
        public float sizeY;
        public float sizeZ;

        public Float(float x, float y, float z, float sizeX, float sizeY, float sizeZ) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sizeX = sizeX;
            this.sizeY = sizeY;
            this.sizeZ = sizeZ;
        }

        public Float(Rectangle3D r) {
            this((float)r.getX(), (float)r.getY(), (float)r.getZ(), (float)r.getSizeX(), (float)r.getSizeY(), (float)r.getSizeZ());
        }

        public Float() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public Object clone() {
            return new Float(this);
        }

        @Override
        public void setRect(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            this.sizeX = (float)sizeX;
            this.sizeY = (float)sizeY;
            this.sizeZ = (float)sizeZ;
        }

        @Override
        public double getX() {
            if (this.x == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.x == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.x;
        }

        @Override
        public void setX(double value) {
            this.x = (float)value;
        }

        @Override
        public double getY() {
            if (this.y == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.y == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.y;
        }

        @Override
        public void setY(double value) {
            this.y = (float)value;
        }

        @Override
        public double getZ() {
            if (this.z == java.lang.Float.NEGATIVE_INFINITY) {
                return java.lang.Double.NEGATIVE_INFINITY;
            }
            if (this.z == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.z;
        }

        @Override
        public void setZ(double value) {
            this.z = (float)value;
        }

        @Override
        public double getSizeX() {
            if (this.sizeX == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeX;
        }

        @Override
        public void setSizeX(double value) {
            this.sizeX = (float)value;
        }

        @Override
        public double getSizeY() {
            if (this.sizeY == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeY;
        }

        @Override
        public void setSizeY(double value) {
            this.sizeY = (float)value;
        }

        @Override
        public double getSizeZ() {
            if (this.sizeZ == java.lang.Float.POSITIVE_INFINITY) {
                return java.lang.Double.POSITIVE_INFINITY;
            }
            return this.sizeZ;
        }

        @Override
        public void setSizeZ(double value) {
            this.sizeZ = (float)value;
        }

        @Override
        public Point3D.Float getPosition() {
            return new Point3D.Float(this.x, this.y, this.z);
        }

        @Override
        public Dimension3D.Float getDimension() {
            return new Dimension3D.Float(this.sizeX, this.sizeY, this.sizeZ);
        }

        @Override
        public Rectangle3D createIntersection(Rectangle3D r) {
            Float result = new Float();
            Float.intersect(this, r, result);
            return result;
        }

        @Override
        public Rectangle3D createUnion(Rectangle3D r) {
            Float result = new Float();
            Float.union(this, r, result);
            return result;
        }

        @Override
        public Rectangle2D toRectangle2D() {
            return new Rectangle2D.Float(this.x, this.y, this.sizeX, this.sizeY);
        }

        @Override
        public void setFrame(double x, double y, double z, double sx, double sy, double sz) {
            this.setRect(x, y, z, sx, sy, sz);
        }

        @Override
        public Shape getShape2D() {
            return this.toRectangle2D();
        }
    }
}

