/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.image.ImageUtil;
import icy.util.ColorUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class GraphicsUtil {
    public static float getAlpha(Graphics2D g) {
        Composite composite = g.getComposite();
        if (composite instanceof AlphaComposite) {
            return ((AlphaComposite)composite).getAlpha();
        }
        return 1.0f;
    }

    public static void mixAlpha(Graphics2D g, float factor) {
        GraphicsUtil.mixAlpha(g, 0, factor);
    }

    public static float mixAlpha(Graphics2D g, int rule, float factor) {
        Composite composite = g.getComposite();
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            float alpha = Math.min(1.0f, Math.max(0.0f, alphaComposite.getAlpha() * factor));
            if (rule == 0) {
                g.setComposite(AlphaComposite.getInstance(alphaComposite.getRule(), alpha));
            } else {
                g.setComposite(AlphaComposite.getInstance(rule, alpha));
            }
            return alpha;
        }
        g.setComposite(AlphaComposite.getInstance(3, factor));
        return factor;
    }

    public static void paintIcyBackGround(int width, int height, Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        float ray = (float)Math.max(width, height) * 0.05f;
        RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double(0.0, 0.0, width, height, Math.min(ray * 2.0f, 20.0f), Math.min(ray * 2.0f, 20.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.white.darker(), 0.0f, (float)height / 1.5f, Color.black));
        g2.fill(roundRect);
        g2.setPaint(Color.black);
        g2.setColor(Color.black);
        GraphicsUtil.mixAlpha(g2, 3, 0.33333334f);
        g2.fillOval(-width + width / 2, height / 2, width * 2, height);
        GraphicsUtil.mixAlpha(g2, 3, 3.0f);
        g2.setStroke(new BasicStroke(Math.max(1.0f, Math.min(5.0f, ray))));
        g2.draw(roundRect);
        g2.dispose();
    }

    public static void paintIcyBackGround(Component component, Graphics g) {
        GraphicsUtil.paintIcyBackGround(component.getWidth(), component.getHeight(), g);
    }

    public static void paintIcyBackGround(Image image) {
        Graphics g = image.getGraphics();
        ImageUtil.waitImageReady(image);
        GraphicsUtil.paintIcyBackGround(image.getWidth(null), image.getHeight(null), g);
        g.dispose();
    }

    public static boolean isVisible(Graphics g, Rectangle region) {
        if (g == null || region == null) {
            return false;
        }
        Rectangle clipRegion = g.getClipBounds();
        if (clipRegion == null) {
            return true;
        }
        if (region.width == 0) {
            if (region.height == 0) {
                return clipRegion.contains(region.x, region.y);
            }
            return clipRegion.contains((double)region.x, region.getMinY()) || clipRegion.contains((double)region.x, region.getMaxY());
        }
        if (region.height == 0) {
            return clipRegion.contains(region.getMinX(), (double)region.y) || clipRegion.contains(region.getMaxX(), (double)region.y);
        }
        return clipRegion.intersects(region);
    }

    public static boolean isVisible(Graphics g, Rectangle2D region) {
        if (g == null || region == null) {
            return false;
        }
        Rectangle clipRegion = g.getClipBounds();
        if (clipRegion == null) {
            return true;
        }
        if (region.getWidth() == 0.0) {
            if (region.getHeight() == 0.0) {
                return clipRegion.contains(region.getX(), region.getY());
            }
            return clipRegion.contains(region.getX(), region.getMinY()) || clipRegion.contains(region.getX(), region.getMaxY());
        }
        if (region.getHeight() == 0.0) {
            return clipRegion.contains(region.getMinX(), region.getY()) || clipRegion.contains(region.getMaxX(), region.getY());
        }
        return clipRegion.intersects(region);
    }

    public static Rectangle2D getStringBounds(Graphics g, Font f, String text) {
        Rectangle2D result = new Rectangle2D.Double();
        if (g != null) {
            FontMetrics fm = f == null ? g.getFontMetrics() : g.getFontMetrics(f);
            for (String s : text.split("\n")) {
                Rectangle2D r = fm.getStringBounds(s, g);
                if (result.isEmpty()) {
                    result = r;
                    continue;
                }
                result.setRect(result.getX(), result.getY(), Math.max(result.getWidth(), r.getWidth()), result.getHeight() + r.getHeight());
            }
        }
        return result;
    }

    public static String limitStringFor(Component c, String text, int width) {
        if (width <= 0) {
            return "";
        }
        int w = width - 20;
        if (w <= 0) {
            return "..";
        }
        String str = text;
        int textWidth = (int)GraphicsUtil.getStringBounds(c, str).getWidth();
        boolean changed = false;
        while (textWidth > w) {
            str = str.substring(0, str.length() * w / textWidth);
            textWidth = (int)GraphicsUtil.getStringBounds(c, str).getWidth();
            changed = true;
        }
        if (changed) {
            return str.trim() + "...";
        }
        return text;
    }

    public static Rectangle2D getStringBounds(Component c, String text) {
        return GraphicsUtil.getStringBounds(c.getGraphics(), text);
    }

    public static Rectangle2D getStringBounds(Graphics g, String text) {
        return GraphicsUtil.getStringBounds(g, null, text);
    }

    public static void drawString(Graphics g, String text, int x, int y, boolean shadow) {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        Color color = g.getColor();
        Color shadowColor = ColorUtil.getLuminance(color) > 128 ? ColorUtil.sub(color, Color.gray) : ColorUtil.add(color, Color.gray);
        Rectangle2D textRect = GraphicsUtil.getStringBounds(g, "M");
        double lineH = textRect.getHeight();
        int curX = (int)((double)x - textRect.getX());
        double curY = (double)y - textRect.getY();
        for (String s : text.split("\n")) {
            if (shadow) {
                g.setColor(shadowColor);
                g.drawString(s, curX + 1, (int)(curY + 1.0));
                g.setColor(color);
            }
            g.drawString(s, curX, (int)curY);
            curY += lineH;
        }
    }

    public static void drawHCenteredString(Graphics g, String text, int x, int y, boolean shadow) {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        Color color = g.getColor();
        Color shadowColor = ColorUtil.mix(color, Color.black);
        Rectangle2D textRect = GraphicsUtil.getStringBounds(g, "M");
        double offX = textRect.getX();
        double curY = (double)y - textRect.getY();
        for (String s : text.split("\n")) {
            Rectangle2D r = GraphicsUtil.getStringBounds(g, s);
            int curX = (int)((double)x - (offX + r.getWidth() / 2.0));
            if (shadow) {
                g.setColor(shadowColor);
                g.drawString(s, curX + 1, (int)(curY + 1.0));
                g.setColor(color);
            }
            g.drawString(s, curX, (int)curY);
            curY += r.getHeight();
        }
    }

    public static void drawCenteredString(Graphics g, String text, int x, int y, boolean shadow) {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        Color color = g.getColor();
        Color shadowColor = ColorUtil.mix(color, Color.black);
        Rectangle2D textRect = GraphicsUtil.getStringBounds(g, text);
        double offX = textRect.getX();
        double curY = (double)y - (textRect.getY() + textRect.getHeight() / 2.0);
        for (String s : text.split("\n")) {
            Rectangle2D r = GraphicsUtil.getStringBounds(g, s);
            int curX = (int)((double)x - (offX + r.getWidth() / 2.0));
            if (shadow) {
                g.setColor(shadowColor);
                g.drawString(s, curX + 1, (int)(curY + 1.0));
                g.setColor(color);
            }
            g.drawString(s, curX, (int)curY);
            curY += r.getHeight();
        }
    }

    public static Dimension getHintSize(Graphics2D g, String text) {
        Rectangle2D stringRect = GraphicsUtil.getStringBounds(g, text);
        return new Dimension((int)Math.ceil(stringRect.getWidth() + 10.0), (int)Math.ceil(stringRect.getHeight() + 8.0));
    }

    public static Rectangle getHintBounds(Graphics2D g, String text, int x, int y) {
        Dimension dim = GraphicsUtil.getHintSize(g, text);
        return new Rectangle(x, y, dim.width, dim.height);
    }

    public static void drawHint(Graphics2D g, String text, int x, int y, Color bgColor, Color textColor) {
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle2D stringRect = GraphicsUtil.getStringBounds(g, text);
        RoundRectangle2D.Double backgroundRect = new RoundRectangle2D.Double(x, y, (int)(stringRect.getWidth() + 10.0), (int)(stringRect.getHeight() + 8.0), 8.0, 8.0);
        g2.setStroke(new BasicStroke(1.3f));
        g2.setColor(bgColor);
        GraphicsUtil.mixAlpha(g2, 3, 0.5f);
        g2.fill(backgroundRect);
        g2.setColor(ColorUtil.mix(bgColor, Color.black));
        GraphicsUtil.mixAlpha(g2, 3, 2.0f);
        g2.draw(backgroundRect);
        g2.setColor(textColor);
        GraphicsUtil.drawString(g2, text, x + 5, y + 4, false);
        g2.dispose();
    }

    public static Rectangle getBounds(Point origin, Dimension dim, int xSpace, int ySpace, boolean top, boolean left) {
        int x = origin.x;
        int y = origin.y;
        x = left ? (x -= dim.width + xSpace) : (x += xSpace);
        y = top ? (y -= dim.height + ySpace) : (y += ySpace);
        return new Rectangle(x, y, dim.width, dim.height);
    }

    public static Rectangle getBounds(Point origin, Dimension dim, boolean top, boolean left) {
        return GraphicsUtil.getBounds(origin, dim, 0, 0, top, left);
    }

    public static Point getBestPosition(Point origin, Dimension dim, Rectangle region, int xSpace, int ySpace, boolean top, boolean left) {
        Rectangle bounds1 = GraphicsUtil.getBounds(origin, dim, xSpace, ySpace, top, left);
        if (region.contains(bounds1)) {
            return new Point(bounds1.x, bounds1.y);
        }
        Rectangle bounds2 = GraphicsUtil.getBounds(origin, dim, xSpace, ySpace, top, !left);
        if (region.contains(bounds2)) {
            return new Point(bounds2.x, bounds2.y);
        }
        Rectangle bounds3 = GraphicsUtil.getBounds(origin, dim, xSpace, ySpace, !top, left);
        if (region.contains(bounds3)) {
            return new Point(bounds3.x, bounds3.y);
        }
        Rectangle bounds4 = GraphicsUtil.getBounds(origin, dim, xSpace, ySpace, !top, !left);
        if (region.contains(bounds4)) {
            return new Point(bounds4.x, bounds4.y);
        }
        Rectangle r = region.intersection(bounds1);
        long size1 = r.width * r.height;
        r = region.intersection(bounds2);
        long size2 = r.width * r.height;
        r = region.intersection(bounds3);
        long size3 = r.width * r.height;
        r = region.intersection(bounds4);
        long size4 = r.width * r.height;
        long maxSize = Math.max(size1, Math.max(size2, Math.max(size3, size4)));
        if (maxSize == size1) {
            return new Point(bounds1.x, bounds1.y);
        }
        if (maxSize == size2) {
            return new Point(bounds2.x, bounds2.y);
        }
        if (maxSize == size3) {
            return new Point(bounds3.x, bounds3.y);
        }
        return new Point(bounds4.x, bounds4.y);
    }

    public static Point getBestPosition(Point origin, Dimension dim, Rectangle region, int xSpace, int ySpace) {
        return GraphicsUtil.getBestPosition(origin, dim, region, xSpace, ySpace, false, false);
    }

    public static Point getBestPosition(Point origin, Dimension dim, Rectangle region) {
        return GraphicsUtil.getBestPosition(origin, dim, region, 0, 0, false, false);
    }

    public static void drawPathIterator(PathIterator path, final Graphics2D g) {
        ShapeUtil.consumeShapeFromPath(path, new ShapeUtil.ShapeConsumer(){

            @Override
            public boolean consume(Shape shape) {
                g.draw(shape);
                return true;
            }
        });
    }
}

