/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import icy.preferences.CanvasPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.EventUtil;
import icy.vtk.VtkArrowObject;
import icy.vtk.VtkJoglPanel;
import icy.vtk.VtkPlaneObject;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import vtk.vtkActor;
import vtk.vtkActorCollection;
import vtk.vtkAxesActor;
import vtk.vtkCamera;
import vtk.vtkCellPicker;
import vtk.vtkLight;
import vtk.vtkPicker;
import vtk.vtkProp;
import vtk.vtkRenderer;
import vtk.vtkTransform;

public class IcyVtkPanel
extends VtkJoglPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
Runnable {
    private static final long serialVersionUID = -8455671369400627703L;
    protected Thread renderingMonitor;
    protected vtkCellPicker picker = new vtkCellPicker();
    protected vtkAxesActor axis;
    protected vtkRenderer axisRenderer;
    protected vtkCamera axisCam;
    protected int[] axisOffset;
    protected double axisScale;
    private final VtkArrowObject arrowClip;
    private final VtkPlaneObject planeClip;
    private vtkRenderer slicerRenderer;
    private vtkCamera slicerCam;
    private SlicerPickState slicerPickState;
    protected int[] slicerOffset;
    protected double slicerScale;
    protected boolean lightFollowCamera;
    protected volatile long fineRenderingTime;
    protected vtkProp pickedObject;

    public IcyVtkPanel() {
        this.picker.PickFromListOff();
        this.picker.PickTextureDataOff();
        this.picker.UseVolumeGradientOpacityOff();
        this.pickedObject = null;
        this.lgt.SetAmbientColor(1.0, 1.0, 1.0);
        this.lightFollowCamera = true;
        this.ren.SetLayer(0);
        this.axisRenderer = new vtkRenderer();
        this.axisRenderer.SetLayer(1);
        this.axisRenderer.InteractiveOff();
        this.slicerRenderer = new vtkRenderer();
        this.slicerRenderer.SetLayer(2);
        this.slicerRenderer.InteractiveOff();
        this.rw.AddRenderer(this.axisRenderer);
        this.rw.SetNumberOfLayers(2);
        this.axis = new vtkAxesActor();
        this.axis.GetXAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone();
        this.axis.GetYAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone();
        this.axis.GetZAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone();
        this.axisRenderer.AddActor((vtkProp)this.axis);
        this.axisCam = this.axisRenderer.GetActiveCamera();
        this.axisCam.SetViewUp(0.0, -1.0, 0.0);
        this.axisCam.Elevation(195.0);
        this.axisCam.SetParallelProjection(1);
        this.axisRenderer.ResetCamera();
        this.axisRenderer.ResetCameraClippingRange();
        this.axisOffset = new int[]{124, 124};
        this.axisScale = 1.0;
        this.arrowClip = new VtkArrowObject();
        this.arrowClip.getActor().SetOrientation(0.0, 0.0, -90.0);
        this.arrowClip.getActor().SetPosition(0.0, 0.5, 0.0);
        this.arrowClip.setColor(Color.green);
        this.planeClip = new VtkPlaneObject();
        this.planeClip.setNormal(0.0, -1.0, 0.0);
        this.planeClip.setColor(Color.white);
        this.planeClip.setEdgeColor(Color.darkGray);
        this.planeClip.setEdgeVisibile(false);
        this.planeClip.setWireframeMode();
        this.planeClip.getActor().GetProperty().SetAmbient(0.8);
        this.planeClip.getActor().GetProperty().SetDiffuse(0.2);
        this.planeClip.getActor().GetProperty().SetLineWidth(2.0f);
        this.slicerRenderer.AddActor((vtkProp)this.arrowClip.getActor());
        this.slicerRenderer.AddActor((vtkProp)this.planeClip.getActor());
        this.slicerCam = this.slicerRenderer.GetActiveCamera();
        this.slicerCam.SetViewUp(0.0, -1.0, 0.0);
        this.slicerCam.Elevation(195.0);
        this.slicerCam.SetParallelProjection(1);
        this.slicerRenderer.ResetCamera();
        this.slicerRenderer.ResetCameraClippingRange();
        this.slicerPickState = SlicerPickState.PICK_NONE;
        this.slicerOffset = new int[]{124, 124};
        this.slicerScale = 1.0;
        this.fineRenderingTime = 0L;
        this.renderingMonitor = new Thread((Runnable)this, "VTK panel rendering monitor");
        this.renderingMonitor.start();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    @Override
    protected void delete() {
        this.fineRenderingTime = 0L;
        this.renderingMonitor.interrupt();
        super.delete();
        this.lock.lock();
        try {
            this.arrowClip.release();
            this.planeClip.release();
            this.slicerCam.Delete();
            this.slicerRenderer.Delete();
            this.axisCam.Delete();
            this.axis.Delete();
            this.axisRenderer.Delete();
            this.picker.Delete();
            this.slicerCam = null;
            this.slicerRenderer = null;
            this.axisCam = null;
            this.axis = null;
            this.axisRenderer = null;
            this.picker = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeNotify() {
        this.fineRenderingTime = 0L;
        super.removeNotify();
    }

    @Override
    public void sizeChanged() {
        super.sizeChanged();
        this.updateAxisView();
        this.updateSlicerView();
    }

    public vtkPicker getPicker() {
        return this.picker;
    }

    public vtkProp getPickedObject() {
        return this.pickedObject;
    }

    public vtkAxesActor getAxesActor() {
        return this.axis;
    }

    public boolean getLightFollowCamera() {
        return this.lightFollowCamera;
    }

    public boolean isAxisOrientationDisplayEnable() {
        return this.axis.GetVisibility() != 0;
    }

    public int[] getAxisOrientationDisplayOffset() {
        return this.axisOffset;
    }

    public double getAxisOrientationDisplayScale() {
        return this.axisScale;
    }

    public void setLightFollowCamera(boolean value) {
        this.lightFollowCamera = value;
    }

    public void setAxisOrientationDisplayEnable(boolean value) {
        this.axis.SetVisibility(value ? 1 : 0);
        this.updateAxisView();
    }

    public void setAxisOrientationDisplayOffset(int[] value) {
        this.axisOffset = value;
        this.updateAxisView();
    }

    public void setAxisOrientationDisplayScale(double value) {
        this.axisScale = value;
        this.updateAxisView();
    }

    public boolean isSlicerEnable() {
        return this.rw.HasRenderer(this.slicerRenderer) != 0;
    }

    public void setSlicerEnable(boolean value) {
        if (!this.isWindowSet()) {
            return;
        }
        this.lock();
        try {
            if (value) {
                if (this.rw.HasRenderer(this.slicerRenderer) == 0) {
                    this.rw.AddRenderer(this.slicerRenderer);
                    this.rw.SetNumberOfLayers(3);
                }
            } else if (this.rw.HasRenderer(this.slicerRenderer) == 1) {
                this.rw.RemoveRenderer(this.slicerRenderer);
                this.rw.SetNumberOfLayers(2);
            }
        }
        finally {
            this.unlock();
        }
        this.updateSlicerView();
        this.planeClipChanged();
    }

    @Deprecated
    public void pickActor(int x, int y) {
        this.pick(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public vtkProp pick(int x, int y, vtkRenderer renderer) {
        this.lock();
        try {
            float[] scale = this.getCurrentSurfaceScale(new float[2]);
            this.picker.Pick((double)((float)x * scale[0]), (double)((float)this.rw.GetSize()[1] - (float)y * scale[1]), 0.0, renderer);
        }
        finally {
            this.unlock();
        }
        return this.picker.GetViewProp();
    }

    public vtkProp pick(int x, int y) {
        return this.pick(x, y, this.ren);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translateView(vtkCamera c, vtkRenderer r, double dx, double dy) {
        double[] APoint = new double[3];
        this.lock();
        try {
            double[] FPoint = c.GetFocalPoint();
            double[] PPoint = c.GetPosition();
            r.SetWorldPoint(FPoint[0], FPoint[1], FPoint[2], 1.0);
            r.WorldToDisplay();
            double focalDepth = r.GetDisplayPoint()[2];
            int[] size = this.rw.GetSize();
            APoint[0] = (double)size[0] / 2.0 + dx;
            APoint[1] = (double)size[1] / 2.0 + dy;
            APoint[2] = focalDepth;
            r.SetDisplayPoint(APoint);
            r.DisplayToWorld();
            double[] RPoint = r.GetWorldPoint();
            if (RPoint[3] != 0.0) {
                RPoint[0] = RPoint[0] / RPoint[3];
                RPoint[1] = RPoint[1] / RPoint[3];
                RPoint[2] = RPoint[2] / RPoint[3];
            }
            c.SetFocalPoint((FPoint[0] - RPoint[0]) / 2.0 + FPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + FPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + FPoint[2]);
            c.SetPosition((FPoint[0] - RPoint[0]) / 2.0 + PPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + PPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + PPoint[2]);
            r.ResetCameraClippingRange();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateView(vtkCamera c, vtkRenderer r, int dx, int dy) {
        this.lock();
        try {
            c.Azimuth((double)dx);
            c.Elevation((double)dy);
            c.OrthogonalizeViewUp();
            r.ResetCameraClippingRange();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomView(vtkCamera c, vtkRenderer r, double factor) {
        this.lock();
        try {
            if (c.GetParallelProjection() == 1) {
                c.SetParallelScale(c.GetParallelScale() / factor);
            } else {
                c.Dolly(factor);
                r.ResetCameraClippingRange();
            }
        }
        finally {
            this.unlock();
        }
    }

    public void translateView(double dx, double dy) {
        this.translateView(this.cam, this.ren, dx, dy);
        if (this.getLightFollowCamera()) {
            IcyVtkPanel.setLightToCameraPosition(this.lgt, this.cam);
        }
    }

    public void rotateView(int dx, int dy) {
        this.rotateView(this.cam, this.ren, dx, dy);
        if (this.getLightFollowCamera()) {
            IcyVtkPanel.setLightToCameraPosition(this.lgt, this.cam);
        }
        this.rotateSlicerView(dx, dy);
        this.updateAxisView();
    }

    public void zoomView(double factor) {
        this.zoomView(this.cam, this.ren, factor);
        this.updateAxisView();
    }

    public void rotateSlicerView(int dx, int dy) {
        this.slicerRenderer.ResetCamera();
        this.slicerRenderer.ResetCameraClippingRange();
        this.rotateView(this.slicerCam, this.slicerRenderer, dx, dy);
        this.updateSlicerView();
        this.planeClipChanged();
    }

    public static void setLightToCameraPosition(vtkLight l, vtkCamera c) {
        l.SetPosition(c.GetPosition());
        l.SetFocalPoint(c.GetFocalPoint());
    }

    public void setCoarseRendering() {
        this.fineRenderingTime = 0L;
        if (this.rw.GetDesiredUpdateRate() == 20.0) {
            return;
        }
        this.lock();
        try {
            this.rw.SetDesiredUpdateRate(20.0);
        }
        finally {
            this.unlock();
        }
    }

    public void setCoarseRendering(long time) {
        this.setCoarseRendering();
        if (time > 0L) {
            this.fineRenderingTime = System.currentTimeMillis() + time;
        }
    }

    public void setFineRendering() {
        this.fineRenderingTime = 0L;
        if (this.rw.GetDesiredUpdateRate() == 0.01) {
            return;
        }
        this.lock();
        try {
            this.rw.SetDesiredUpdateRate(0.01);
        }
        finally {
            this.unlock();
        }
    }

    public void setFineRendering(long delay) {
        if (delay > 0L) {
            this.fineRenderingTime = System.currentTimeMillis() + delay;
        } else {
            this.setFineRendering();
        }
    }

    public boolean isSlicerPicked() {
        return this.slicerPickState != SlicerPickState.PICK_NONE;
    }

    protected boolean slicerPick(MouseEvent e) {
        SlicerPickState oldPickState = this.slicerPickState;
        int[] size = this.rw.GetSize();
        int w = size[0];
        int h = size[1];
        float[] scale = this.getCurrentSurfaceScale(new float[2]);
        int x = (int)((float)e.getX() * scale[0]);
        int y = (int)((float)e.getY() * scale[1]);
        if ((double)x > (double)w * (1.0 - 0.25 * ((double)h / (double)w)) && (double)y > (double)h * 0.75) {
            this.slicerPickState = this.pick(e.getX(), e.getY(), this.slicerRenderer) == this.planeClip.getActor() ? SlicerPickState.PICK_PLANE : SlicerPickState.PICK_VECTOR;
            e.consume();
        } else {
            this.slicerPickState = SlicerPickState.PICK_NONE;
        }
        if (this.slicerPickState == SlicerPickState.PICK_PLANE) {
            this.planeClip.setColor(Color.white);
            this.planeClip.setSurfaceMode();
            this.planeClip.setEdgeVisibile(true);
        } else {
            this.planeClip.setColor(Color.gray);
            this.planeClip.setWireframeMode();
            this.planeClip.setEdgeVisibile(false);
        }
        if (this.slicerPickState == SlicerPickState.PICK_VECTOR) {
            this.arrowClip.setColor(Color.white);
        } else {
            this.arrowClip.setColor(Color.green);
        }
        return oldPickState != this.slicerPickState;
    }

    protected void translateSlicerPlane(int deltaX, int deltaY) {
        double[] pos = this.planeClip.getActor().GetPosition();
        double delta = Math.abs(deltaX) > Math.abs(deltaY) ? (this.slicerCam.GetOrientation()[2] < 0.0 ? (double)(-deltaX) : (double)deltaX) : (Math.abs(this.slicerCam.GetOrientation()[2]) > 90.0 ? (double)(-deltaY) : (double)deltaY);
        pos[1] = pos[1] + delta / 100.0;
        if (pos[1] > 0.7) {
            pos[1] = 0.7;
        } else if (pos[1] < -0.7) {
            pos[1] = -0.7;
        }
        this.planeClip.getActor().SetPosition(pos);
        this.planeClipChanged();
    }

    protected void planeClipChanged() {
    }

    public double[] getClipNormal() {
        double[] result = new double[]{0.0, -1.0, 0.0};
        vtkTransform camTrans = this.cam.GetModelViewTransformObject();
        vtkTransform slicerTrans = this.slicerCam.GetModelViewTransformObject();
        vtkTransform trans = new vtkTransform();
        trans.Identity();
        trans.Concatenate(camTrans.GetMatrix());
        trans.Inverse();
        trans.Concatenate(slicerTrans.GetMatrix());
        result = trans.TransformDoubleNormal(result);
        return result;
    }

    public double getClipPosition() {
        return this.planeClip.getActor().GetPosition()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAxisView() {
        if (!this.isWindowSet()) {
            return;
        }
        this.lock();
        try {
            double[] pos = this.cam.GetPosition();
            double[] fp = this.cam.GetFocalPoint();
            double[] viewup = this.cam.GetViewUp();
            this.axisCam.SetPosition(pos);
            this.axisCam.SetFocalPoint(fp);
            this.axisCam.SetViewUp(viewup);
            this.axisRenderer.ResetCamera();
            int[] size = this.rw.GetSize();
            double scale = (double)size[1] / 512.0;
            int w = (int)((double)size[0] - (double)this.axisOffset[0] * scale);
            int h = (int)((double)size[1] - (double)this.axisOffset[1] * scale);
            this.zoomView(this.axisCam, this.axisRenderer, this.axisScale * (this.axisCam.GetDistance() / 17.0));
            this.translateView(this.axisCam, this.axisRenderer, -w, -h);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlicerView() {
        if (!this.isWindowSet()) {
            return;
        }
        this.lock();
        try {
            int[] size = this.rw.GetSize();
            double scale = (double)size[1] / 512.0;
            int w = (int)((double)size[0] - (double)this.slicerOffset[0] * scale);
            int h = (int)((double)size[1] - (double)this.slicerOffset[1] * scale);
            this.slicerRenderer.ResetCamera();
            this.slicerRenderer.ResetCameraClippingRange();
            this.zoomView(this.slicerCam, this.slicerRenderer, this.slicerScale * (this.slicerCam.GetDistance() / 12.0));
            this.translateView(this.slicerCam, this.slicerRenderer, w, -h);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            if (this.fineRenderingTime == 0L) {
                ThreadUtil.sleep(1);
                continue;
            }
            if (System.currentTimeMillis() >= this.fineRenderingTime) {
                this.setFineRendering();
                this.repaint();
                this.fineRenderingTime = 0L;
                continue;
            }
            ThreadUtil.sleep(1);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
        if (this.isSlicerEnable() && this.slicerPick(e)) {
            this.repaint();
        }
        this.pickedObject = this.isSlicerEnable() && this.isSlicerPicked() ? null : this.pick(this.lastX, this.lastY);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.cam == null) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        float[] scale = this.getCurrentSurfaceScale(new float[2]);
        int deltaX = (int)((float)(this.lastX - x) * scale[0]);
        int deltaY = (int)((float)(this.lastY - y) * scale[1]);
        e.consume();
        this.setCoarseRendering();
        this.rw.SetAbortRender(1);
        if (this.isSlicerEnable() && this.isSlicerPicked()) {
            if (EventUtil.isLeftMouseButton(e) && !EventUtil.isShiftDown(e)) {
                if (this.slicerPickState == SlicerPickState.PICK_VECTOR) {
                    this.rotateSlicerView(deltaX, -deltaY);
                } else {
                    this.translateSlicerPlane(deltaX, deltaY);
                }
            }
        } else {
            if (EventUtil.isControlDown(e)) {
                deltaX *= 3;
                deltaY *= 3;
            }
            if (EventUtil.isRightMouseButton(e) || EventUtil.isLeftMouseButton(e) && EventUtil.isShiftDown(e)) {
                this.translateView(-deltaX * 2, deltaY * 2);
            } else if (EventUtil.isMiddleMouseButton(e)) {
                this.zoomView(Math.pow(1.02, -deltaY));
            } else {
                this.rotateView(deltaX, -deltaY);
            }
        }
        this.lastX = x;
        this.lastY = y;
        this.repaint();
        this.setFineRendering(1000L);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.cam == null) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        e.consume();
        this.setCoarseRendering();
        this.rw.SetAbortRender(1);
        double delta = (double)e.getWheelRotation() * CanvasPreferences.getMouseWheelSensitivity();
        if (CanvasPreferences.getInvertMouseWheelAxis()) {
            delta = -delta;
        }
        if (EventUtil.isControlDown(e)) {
            delta *= 3.0;
        }
        this.zoomView(Math.pow(1.02, delta));
        this.repaint();
        this.setFineRendering(1000L);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        switch (e.getKeyChar()) {
            case 'r': {
                this.resetCamera();
                this.repaint();
                e.consume();
                break;
            }
            case 'w': {
                this.lock();
                try {
                    vtkActorCollection ac = this.ren.GetActors();
                    ac.InitTraversal();
                    for (int i = 0; i < ac.GetNumberOfItems(); ++i) {
                        vtkActor anActor = ac.GetNextActor();
                        anActor.GetProperty().SetRepresentationToWireframe();
                    }
                }
                finally {
                    this.unlock();
                }
                this.repaint();
                e.consume();
                break;
            }
            case 's': {
                this.lock();
                try {
                    vtkActorCollection ac = this.ren.GetActors();
                    ac.InitTraversal();
                    for (int i = 0; i < ac.GetNumberOfItems(); ++i) {
                        vtkActor anActor = ac.GetNextActor();
                        anActor.GetProperty().SetRepresentationToSurface();
                    }
                }
                finally {
                    this.unlock();
                }
                this.repaint();
                e.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    private static enum SlicerPickState {
        PICK_NONE,
        PICK_VECTOR,
        PICK_PLANE;

    }
}

