/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import java.awt.Color;
import vtk.vtkActor;
import vtk.vtkCylinderSource;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;

public class VtkCylinderObject {
    private final vtkCylinderSource cylinderSource = new vtkCylinderSource();
    private final vtkMapper mapper;
    private final vtkActor actor;

    public VtkCylinderObject() {
        this.cylinderSource.SetCenter(0.0, 0.0, 0.0);
        this.cylinderSource.SetRadius(0.1);
        this.cylinderSource.SetHeight(1.0);
        this.cylinderSource.SetResolution(8);
        this.cylinderSource.SetCapping(1);
        this.mapper = new vtkPolyDataMapper();
        this.mapper.SetInputConnection(this.cylinderSource.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetPickable(1);
        this.actor.SetMapper(this.mapper);
    }

    public void release() {
        this.actor.Delete();
        this.mapper.Delete();
        this.cylinderSource.Delete();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public void setColor(Color color) {
        this.actor.GetProperty().SetColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }

    public double[] getCenter() {
        return this.cylinderSource.GetCenter();
    }

    public void setCenter(double[] value) {
        this.cylinderSource.SetCenter(value);
    }

    public void setCenter(double x, double y, double z) {
        this.cylinderSource.SetCenter(x, y, z);
    }

    public double getHeight() {
        return this.cylinderSource.GetHeight();
    }

    public void setHeight(double value) {
        this.cylinderSource.SetHeight(value);
    }

    public double getRadius() {
        return this.cylinderSource.GetRadius();
    }

    public void setRadius(double value) {
        this.cylinderSource.SetRadius(value);
    }

    public int getResolution() {
        return this.cylinderSource.GetResolution();
    }

    public void setResolution(int value) {
        this.cylinderSource.SetResolution(value);
    }

    public boolean getCapping() {
        return this.cylinderSource.GetCapping() != 0;
    }

    public void setCapping(boolean value) {
        this.cylinderSource.SetCapping(value ? 1 : 0);
    }
}

