/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.math.io.StringPrintable;
import org.math.plot.canvas.PlotCanvas;

public class ScalesFrame
extends JFrame
implements WindowFocusListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private PlotCanvas plotCanvas;
    private JPanel scalespanel;
    private ScalePanel[] scalepanels;
    boolean editable = true;

    public ScalesFrame(PlotCanvas p) {
        super("scales settings");
        this.plotCanvas = p;
        this.setPanel();
        this.setContentPane(this.scalespanel);
        this.setResizable(false);
        this.addWindowFocusListener(this);
        this.addWindowListener(this);
    }

    public void setEditable(boolean e) {
        this.editable = e;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setPanel();
        }
        super.setVisible(b);
    }

    private void setPanel() {
        this.scalespanel = new JPanel();
        if (this.plotCanvas.base == null) {
            return;
        }
        int nbAxes = this.plotCanvas.base.dimension;
        this.setSize(nbAxes * 300, 200);
        this.scalespanel.setLayout(new GridLayout(1, nbAxes));
        this.scalepanels = new ScalePanel[nbAxes];
        for (int i = 0; i < nbAxes; ++i) {
            this.scalepanels[i] = new ScalePanel(this.plotCanvas, i);
            this.scalespanel.add(this.scalepanels[i]);
            this.scalepanels[i].max_field.setEditable(this.editable);
            this.scalepanels[i].min_field.setEditable(this.editable);
            this.scalepanels[i].bounds_auto.setEnabled(this.editable);
            this.scalepanels[i].log_check.setEnabled(this.editable);
            this.scalepanels[i].linear_check.setEnabled(this.editable);
            this.scalepanels[i].title_field.setEnabled(this.editable);
        }
        this.setContentPane(this.scalespanel);
    }

    @Override
    public void setDefaultCloseOperation(int operation) {
        for (int i = 0; i < this.scalepanels.length; ++i) {
            this.scalepanels[i].updateBoundsFields();
        }
        super.setDefaultCloseOperation(operation);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        for (int i = 0; i < this.scalepanels.length; ++i) {
            this.scalepanels[i].update();
        }
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        for (int i = 0; i < this.scalepanels.length; ++i) {
            this.scalepanels[i].update();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public class ScalePanel
    extends JPanel
    implements StringPrintable {
        private static final long serialVersionUID = 1L;
        private int numAxe;
        private String title;
        private String scaleType;
        private double min;
        private double max;
        private JLabel title_label = new JLabel("Title");
        private JTextField title_field = new JTextField();
        private JLabel scale_label = new JLabel("Scale");
        private ButtonGroup scale_group = new ButtonGroup();
        private JRadioButton linear_check = new JRadioButton("Linear");
        private JRadioButton log_check = new JRadioButton("Logarithmic");
        private JLabel bounds_label = new JLabel("Bounds");
        private JLabel min_label = new JLabel("Min");
        private JLabel max_label = new JLabel("Max");
        private JTextField min_field = new JTextField();
        private JTextField max_field = new JTextField();
        private JButton bounds_auto = new JButton("Automatic");

        public ScalePanel(PlotCanvas p, int i) {
            this.numAxe = i;
            ScalesFrame.this.plotCanvas = p;
            this.update();
            this.addComponents();
            this.setListeners();
        }

        public void update() {
            this.title = ScalesFrame.this.plotCanvas.getGrid().getAxis(this.numAxe).getLegend();
            this.title_field.setText(this.title);
            this.scaleType = ScalesFrame.this.plotCanvas.getAxisScales()[this.numAxe];
            this.log_check.setSelected(this.scaleType.equalsIgnoreCase("log"));
            this.linear_check.setSelected(this.scaleType.equalsIgnoreCase("lin"));
            if (this.scaleType.equalsIgnoreCase("str")) {
                this.log_check.setEnabled(false);
                this.linear_check.setEnabled(false);
            }
            this.updateBoundsFields();
        }

        private void addComponents() {
            this.setSize(300, 200);
            this.scale_group.add(this.linear_check);
            this.scale_group.add(this.log_check);
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gbl);
            this.buildConstraints(c, 0, 0, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.title_label, c);
            this.add(this.title_label);
            this.buildConstraints(c, 1, 0, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.title_field, c);
            this.add(this.title_field);
            this.buildConstraints(c, 0, 1, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.scale_label, c);
            this.add(this.scale_label);
            this.buildConstraints(c, 1, 1, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.linear_check, c);
            this.add(this.linear_check);
            this.buildConstraints(c, 1, 2, 2, 1, 60, 20);
            c.fill = 2;
            gbl.setConstraints(this.log_check, c);
            this.add(this.log_check);
            this.buildConstraints(c, 0, 3, 1, 1, 40, 20);
            c.fill = 10;
            c.anchor = 10;
            gbl.setConstraints(this.bounds_label, c);
            this.add(this.bounds_label);
            this.buildConstraints(c, 1, 3, 1, 1, 20, 20);
            c.fill = 10;
            c.fill = 10;
            gbl.setConstraints(this.min_label, c);
            this.add(this.min_label);
            this.buildConstraints(c, 2, 3, 1, 1, 50, 20);
            c.fill = 2;
            gbl.setConstraints(this.min_field, c);
            this.add(this.min_field);
            this.buildConstraints(c, 1, 4, 1, 1, 20, 20);
            c.fill = 10;
            c.fill = 10;
            gbl.setConstraints(this.max_label, c);
            this.add(this.max_label);
            this.buildConstraints(c, 2, 4, 1, 1, 50, 20);
            c.fill = 2;
            gbl.setConstraints(this.max_field, c);
            this.add(this.max_field);
            this.buildConstraints(c, 1, 5, 2, 1, 60, 20);
            c.fill = 10;
            gbl.setConstraints(this.bounds_auto, c);
            this.add(this.bounds_auto);
        }

        private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }

        private void setListeners() {
            this.title_field.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ScalePanel.this.setTitle();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.log_check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.setScale();
                    ScalePanel.this.updateBoundsFields();
                }
            });
            this.linear_check.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.setScale();
                    ScalePanel.this.updateBoundsFields();
                }
            });
            this.min_field.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ScalePanel.this.setBounds();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.max_field.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    ScalePanel.this.setBounds();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.bounds_auto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.setBoundsAuto();
                }
            });
        }

        public String getText() {
            return "title = " + this.title + "\nscaleType = " + this.scaleType + "\nmin = " + this.min + "\nmax = " + this.max;
        }

        private void setTitle() {
            ScalesFrame.this.plotCanvas.setAxisLabel(this.numAxe, this.title_field.getText());
        }

        private void setBounds() {
            try {
                double min1 = Double.parseDouble(this.min_field.getText());
                double max1 = Double.parseDouble(this.max_field.getText());
                ScalesFrame.this.plotCanvas.setFixedBounds(this.numAxe, min1, max1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        private void setScale() {
            try {
                ScalesFrame.this.plotCanvas.setAxiScale(this.numAxe, this.log_check.isSelected() ? "log" : "lin");
            }
            catch (IllegalArgumentException iae) {
                JOptionPane.showConfirmDialog(null, iae.getMessage(), "Error", -1, 0);
                this.updateBoundsFields();
            }
        }

        private void setBoundsAuto() {
            ScalesFrame.this.plotCanvas.setAutoBounds(this.numAxe);
            this.updateBoundsFields();
        }

        private void updateBoundsFields() {
            this.min = ((ScalesFrame)ScalesFrame.this).plotCanvas.base.getMinBounds()[this.numAxe];
            this.max = ((ScalesFrame)ScalesFrame.this).plotCanvas.base.getMaxBounds()[this.numAxe];
            this.min_field.setText("" + this.min);
            this.max_field.setText("" + this.max);
        }
    }
}

