/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import java.awt.Color;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.render.AbstractDrawer;

public class Line
implements Plotable {
    protected double[][] extrem = new double[2][];
    protected Color color;
    protected Color gradientColor;
    boolean visible = true;

    public Line(Color col, double[] c1, double[] c2) {
        this.extrem[0] = c1;
        this.extrem[1] = c2;
        this.color = col;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setVisible(boolean v) {
        this.visible = v;
    }

    @Override
    public boolean getVisible() {
        return this.visible;
    }

    @Override
    public void plot(AbstractDrawer draw) {
        if (!this.visible) {
            return;
        }
        draw.setColor(this.color);
        if (this.gradientColor != null) {
            draw.setGradient(this.extrem[0], this.color, this.extrem[1], this.gradientColor);
        }
        draw.drawLine(this.extrem[0], this.extrem[1]);
        if (this.gradientColor != null) {
            draw.resetGradient();
        }
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color c) {
        this.gradientColor = c;
    }
}

