/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.plots.LayerPlot;
import org.math.plot.plots.Plot;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;

public class GaussianDensityLayerPlot
extends LayerPlot {
    public static int WIDHT = 2;
    int axis;
    Color gradC_0sigma;
    Color gradC_1sigma;
    Color gradC_2sigma;
    Color gradC_3sigma;
    double constant_sigma = 0.0;
    double[] sigma;
    private float[][] gausspdf_sigma;

    public GaussianDensityLayerPlot(Plot p, int ax, double sigma) {
        this(p, ax, null);
        this.constant_sigma = sigma;
        this.gausspdf_sigma = new float[1][4];
        for (int i = 0; i < this.gausspdf_sigma.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.gausspdf_sigma[i][j] = (float)Math.exp((double)(-(j * j)) / (2.0 * this.constant_sigma * this.constant_sigma));
            }
        }
    }

    public GaussianDensityLayerPlot(Plot p, int ax, double[] sigma) {
        super("Gauss quantile of " + p.name, p);
        if (sigma != null) {
            Array.checkLength(sigma, p.getData().length);
        }
        this.sigma = sigma;
        this.axis = ax;
        if (sigma != null) {
            this.gausspdf_sigma = new float[sigma.length][4];
            for (int i = 0; i < this.gausspdf_sigma.length; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.gausspdf_sigma[i][j] = (float)Math.exp((double)(-(j * j)) / (2.0 * sigma[i] * sigma[i]));
                }
            }
        }
    }

    public double getQuantilesValue(int numCoord) {
        return this.sigma[numCoord];
    }

    public int getAxe() {
        return this.axis;
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.plot.visible) {
            return;
        }
        draw.setColor(c);
        draw.setLineType(1);
        draw.setLineWidth(WIDHT);
        if (this.constant_sigma == 0.0) {
            for (int i = 0; i < this.plot.getData().length; ++i) {
                this.gradC_0sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[i][0]));
                this.gradC_1sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[i][1]));
                this.gradC_2sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[i][2]));
                this.gradC_3sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[i][3]));
                double[] d = Array.getRowCopy(this.plot.getData(), i);
                double[] d2 = Array.getRowCopy(this.plot.getData(), i);
                int n = this.axis;
                d2[n] = d2[n] + this.sigma[i];
                draw.setGradient(d, this.gradC_0sigma, d2, this.gradC_1sigma);
                draw.drawLine(d, d2);
                int n2 = this.axis;
                d[n2] = d[n2] + this.sigma[i];
                int n3 = this.axis;
                d2[n3] = d2[n3] + this.sigma[i];
                draw.setGradient(d, this.gradC_1sigma, d2, this.gradC_2sigma);
                draw.drawLine(d, d2);
                int n4 = this.axis;
                d[n4] = d[n4] + this.sigma[i];
                int n5 = this.axis;
                d2[n5] = d2[n5] + this.sigma[i];
                draw.setGradient(d, this.gradC_2sigma, d2, this.gradC_3sigma);
                draw.drawLine(d, d2);
                d = Array.getRowCopy(this.plot.getData(), i);
                d2 = Array.getRowCopy(this.plot.getData(), i);
                int n6 = this.axis;
                d2[n6] = d2[n6] - this.sigma[i];
                draw.setGradient(d2, this.gradC_1sigma, d, this.gradC_0sigma);
                draw.drawLine(d2, d);
                int n7 = this.axis;
                d[n7] = d[n7] - this.sigma[i];
                int n8 = this.axis;
                d2[n8] = d2[n8] - this.sigma[i];
                draw.setGradient(d2, this.gradC_2sigma, d, this.gradC_1sigma);
                draw.drawLine(d2, d);
                int n9 = this.axis;
                d[n9] = d[n9] - this.sigma[i];
                int n10 = this.axis;
                d2[n10] = d2[n10] - this.sigma[i];
                draw.setGradient(d2, this.gradC_3sigma, d, this.gradC_2sigma);
                draw.drawLine(d2, d);
            }
        } else {
            this.gradC_0sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[0][0]));
            this.gradC_1sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[0][1]));
            this.gradC_2sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[0][2]));
            this.gradC_3sigma = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(255.0 * (double)this.gausspdf_sigma[0][3]));
            for (int i = 0; i < this.plot.getData().length; ++i) {
                double[] d = Array.getRowCopy(this.plot.getData(), i);
                double[] d2 = Array.getRowCopy(this.plot.getData(), i);
                int n = this.axis;
                d2[n] = d2[n] + this.constant_sigma;
                draw.setGradient(d, this.gradC_0sigma, d2, this.gradC_1sigma);
                draw.drawLine(d, d2);
                int n11 = this.axis;
                d[n11] = d[n11] + this.constant_sigma;
                int n12 = this.axis;
                d2[n12] = d2[n12] + this.constant_sigma;
                draw.setGradient(d, this.gradC_1sigma, d2, this.gradC_2sigma);
                draw.drawLine(d, d2);
                int n13 = this.axis;
                d[n13] = d[n13] + this.constant_sigma;
                int n14 = this.axis;
                d2[n14] = d2[n14] + this.constant_sigma;
                draw.setGradient(d, this.gradC_2sigma, d2, this.gradC_3sigma);
                draw.drawLine(d, d2);
                d = Array.getRowCopy(this.plot.getData(), i);
                d2 = Array.getRowCopy(this.plot.getData(), i);
                int n15 = this.axis;
                d2[n15] = d2[n15] - this.constant_sigma;
                draw.setGradient(d2, this.gradC_1sigma, d, this.gradC_0sigma);
                draw.drawLine(d2, d);
                int n16 = this.axis;
                d[n16] = d[n16] - this.constant_sigma;
                int n17 = this.axis;
                d2[n17] = d2[n17] - this.constant_sigma;
                draw.setGradient(d2, this.gradC_2sigma, d, this.gradC_1sigma);
                draw.drawLine(d2, d);
                int n18 = this.axis;
                d[n18] = d[n18] - this.constant_sigma;
                int n19 = this.axis;
                d2[n19] = d2[n19] - this.constant_sigma;
                draw.setGradient(d2, this.gradC_3sigma, d, this.gradC_2sigma);
                draw.drawLine(d2, d);
            }
        }
        draw.resetGradient();
        draw.setLineWidth(1);
    }

    @Override
    public void setData(double[][] d) {
        this.sigma = d[0];
    }

    @Override
    public double[][] getData() {
        return new double[][]{this.sigma};
    }

    public static void main(String[] args) {
        double[] sXYZ = null;
        Plot2DPanel p2 = new Plot2DPanel();
        for (int i = 0; i < 2; ++i) {
            double[][] XYZ = new double[10][2];
            sXYZ = new double[10];
            for (int j = 0; j < XYZ.length; ++j) {
                XYZ[j][0] = Math.random();
                XYZ[j][1] = Math.random();
                sXYZ[j] = Math.random();
            }
            p2.addScatterPlot("toto" + i, XYZ);
        }
        p2.getPlot(0).addGaussQuantiles(0, sXYZ);
        p2.getPlot(1).addGaussQuantiles(1, 0.1);
        new FrameView(p2).setDefaultCloseOperation(3);
    }
}

