/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plots;

import java.awt.Color;
import org.math.plot.FrameView;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.plots.ScatterPlot;
import org.math.plot.render.AbstractDrawer;

public class LinePlot
extends ScatterPlot {
    public boolean draw_dot = false;

    public LinePlot(String n, Color c, boolean[][] _pattern, double[][] _XY) {
        super(n, c, _pattern, _XY);
    }

    public LinePlot(String n, Color c, int _type, int _radius, double[][] _XY) {
        super(n, c, _type, _radius, _XY);
    }

    public LinePlot(String n, Color c, double[][] _XY) {
        super(n, c, _XY);
    }

    @Override
    public void plot(AbstractDrawer draw, Color c) {
        if (!this.visible) {
            return;
        }
        if (this.draw_dot) {
            super.plot(draw, c);
        }
        draw.setColor(c);
        draw.setLineType(1);
        for (int i = 0; i < this.XY.length - 1; ++i) {
            draw.drawLine(this.XY[i], this.XY[i + 1]);
        }
    }

    public static void main(String[] args) {
        Plot2DPanel p2 = new Plot2DPanel();
        double[][] XYZ = new double[100][2];
        for (int j = 0; j < XYZ.length; ++j) {
            XYZ[j][0] = Math.PI * 2 * (double)j / (double)XYZ.length;
            XYZ[j][1] = Math.sin(XYZ[j][0]);
        }
        p2.addLinePlot("sin", XYZ);
        p2.setLegendOrientation("South");
        new FrameView(p2).setDefaultCloseOperation(3);
        Plot3DPanel p = new Plot3DPanel();
        XYZ = new double[100][3];
        for (int j = 0; j < XYZ.length; ++j) {
            XYZ[j][0] = Math.PI * 2 * (double)j / (double)XYZ.length;
            XYZ[j][1] = Math.sin(XYZ[j][0]);
            XYZ[j][2] = Math.sin(XYZ[j][0]) * Math.cos(XYZ[j][1]);
        }
        p.addLinePlot("toto", XYZ);
        p.setLegendOrientation("South");
        new FrameView(p).setDefaultCloseOperation(3);
    }
}

