/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.trackprocessors.speed;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.trackprocessors.speed.SpeedProfiler;
import plugins.adufour.trackprocessors.speed.TrackStatistic;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarSequence;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class FilterTracks
extends Plugin
implements Block,
PluginBundled {
    public final Var<TrackGroup> tracks = new Var<TrackGroup>("Track group", new TrackGroup(null));
    public final VarSequence sequence = new VarSequence("Sequence (used for units)", null);
    public final VarBoolean useRealUnits = new VarBoolean("Use real units (\u03bcm/sec)", false);
    public final VarEnum<Criterion> criterion = new VarEnum<Criterion>("Filter on", Criterion.CRITERION_DURATION);
    public final VarEnum<ComparisonType> operation = new VarEnum<ComparisonType>("Accept if", ComparisonType.GREATER_THAN);
    public final VarDouble value = new VarDouble("Value", 0.0);

    public static boolean isTrackEnabled(TrackSegment track) {
        for (Detection detection : track.getDetectionList()) {
            if (!detection.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean acceptTrack(TrackSegment track, Criterion criterion, ComparisonType comp, double value, double xScale, double yScale, double zScale, double tInterval, boolean setTrackEnabledFlag) {
        TrackStatistic stats = TrackStatistic.computeStatistic(track, xScale, yScale, zScale, tInterval, criterion == Criterion.CRITERION_EXTENT, true, true, null, null, null, null);
        boolean result = true;
        if (stats != null) {
            switch (criterion.ordinal()) {
                case 0: {
                    result = comp.compare(stats.startTime, value);
                    break;
                }
                case 1: {
                    if (!setTrackEnabledFlag) break;
                    for (Detection det : track.getDetectionList()) {
                        det.setEnabled(comp.compare((double)det.getT() * (tInterval != 0.0 ? tInterval : 1.0), value));
                    }
                    break;
                }
                case 2: {
                    result = comp.compare(stats.endTime, value);
                    break;
                }
                case 3: {
                    result = comp.compare(stats.duration, value);
                    break;
                }
                case 6: {
                    result = comp.compare(stats.global.linearity, value);
                    break;
                }
                case 7: {
                    result = comp.compare(stats.global.searchRadius, value);
                    break;
                }
                case 4: {
                    result = comp.compare(stats.global.totalDisp, value);
                    break;
                }
                case 5: {
                    result = comp.compare(stats.global.netDisp, value);
                    break;
                }
                case 8: {
                    result = comp.compare(stats.global.minDispOrSpeed, value);
                    break;
                }
                case 9: {
                    result = comp.compare(stats.global.maxDispOrSpeed, value);
                    break;
                }
                case 10: {
                    result = comp.compare(stats.global.meanDispOrSpeed, value);
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        if (setTrackEnabledFlag && !result) {
            track.setAllDetectionEnabled(false);
        }
        return result;
    }

    public static Set<TrackSegment> filterTracks(Collection<TrackSegment> tracks, Criterion criterion, ComparisonType comp, double value, Sequence sequence, boolean setTrackEnabledFlag) {
        double tInterval;
        double zScale;
        double yScale;
        double xScale;
        HashSet<TrackSegment> result = new HashSet<TrackSegment>();
        if (sequence != null) {
            xScale = sequence.getPixelSizeX();
            yScale = sequence.getPixelSizeY();
            zScale = sequence.getPixelSizeZ();
            tInterval = sequence.getTimeInterval();
        } else {
            xScale = 1.0;
            yScale = 1.0;
            zScale = 1.0;
            tInterval = 1.0;
        }
        for (TrackSegment track : tracks) {
            if (!FilterTracks.acceptTrack(track, criterion, comp, value, xScale, yScale, zScale, tInterval, setTrackEnabledFlag)) continue;
            result.add(track);
        }
        return result;
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("trackgroup", this.tracks);
        inputMap.add("sequence", this.sequence);
        inputMap.add("useRealUnitss", this.useRealUnits);
        inputMap.add("criterion", this.criterion);
        inputMap.add("comp", this.operation);
        inputMap.add("value", this.value);
    }

    @Override
    public void declareOutput(VarList outputMap) {
    }

    @Override
    public void run() {
        TrackGroup trackGroup = this.tracks.getValue();
        if (trackGroup != null) {
            ArrayList<TrackSegment> tracksToFilter = new ArrayList<TrackSegment>();
            for (TrackSegment track : trackGroup.getTrackSegmentList()) {
                if (!FilterTracks.isTrackEnabled(track)) continue;
                tracksToFilter.add(track);
            }
            FilterTracks.filterTracks(tracksToFilter, (Criterion)((Object)this.criterion.getValue()), (ComparisonType)((Object)this.operation.getValue()), this.value.getValue(), (Boolean)this.useRealUnits.getValue() != false ? (Sequence)this.sequence.getValue() : null, true);
        }
    }

    @Override
    public String getMainPluginClassName() {
        return SpeedProfiler.class.getName();
    }

    public static enum Criterion {
        CRITERION_T_START("start time"),
        CRITERION_CURRENT_T("current time"),
        CRITERION_T_END("end time"),
        CRITERION_DURATION("track duration"),
        CRITERION_TOT_DISP("total displacement"),
        CRITERION_NET_DISP("net displacement"),
        CRITERION_LINEARITY("linearity"),
        CRITERION_EXTENT("extent"),
        CRITERION_MIN_DISP("minimum displacement"),
        CRITERION_MAX_DISP("maximum displacement"),
        CRITERION_AVG_DISP("average displacement");

        String description;

        private Criterion(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum ComparisonType {
        GREATER_THAN(">"),
        LOWER_THAN("<");

        private String symbol;

        private ComparisonType(String symbol) {
            this.symbol = symbol;
        }

        boolean compare(double d1, double d2) {
            switch (this.ordinal()) {
                case 0: {
                    return d1 > d2;
                }
                case 1: {
                    return d1 < d2;
                }
            }
            throw new UnsupportedOperationException("Unknown operation: " + this.toString());
        }

        public String toString() {
            return this.symbol;
        }
    }
}

