/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.trackprocessors.speed;

import icy.file.FileUtil;
import icy.gui.component.ExcelTable;
import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.plugin.interface_.PluginBundled;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.util.XLSUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.PlotPanel;
import plugins.adufour.trackprocessors.speed.MotionProfiler;
import plugins.adufour.trackprocessors.speed.SpeedProfiler;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;

public class MotionProfilerProcessor
extends PluginTrackManagerProcessor
implements PluginBundled {
    private JPanel options;
    private JCheckBox useRealUnits;
    private JCheckBox showSpeed;
    private JTabbedPane statistics = new JTabbedPane();
    private JPanel xTab = new JPanel();
    private Plot2DPanel xPlot = new Plot2DPanel();
    private JPanel yTab = new JPanel();
    private Plot2DPanel yPlot = new Plot2DPanel();
    private JPanel zTab = new JPanel();
    private Plot2DPanel zPlot = new Plot2DPanel();
    private JPanel globalTab = new JPanel();
    private PlotPanel globalPlot;
    private JButton export = new JButton("Export statistics...");
    XMLPreferences preferences;
    private ActionListener updater = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            MotionProfilerProcessor.this.trackPool.fireTrackEditorProcessorChange();
        }
    };

    public MotionProfilerProcessor() {
        this.preferences = this.getPreferencesRoot();
        this.setName("Motion Profiler");
        this.buildGui();
    }

    void buildGui() {
        this.options = new JPanel();
        this.useRealUnits = new JCheckBox("Use real units");
        this.showSpeed = new JCheckBox("Show speed instead of displacement");
        this.statistics = new JTabbedPane();
        this.xTab = new JPanel();
        this.xPlot = new Plot2DPanel();
        this.yTab = new JPanel();
        this.yPlot = new Plot2DPanel();
        this.zTab = new JPanel();
        this.zPlot = new Plot2DPanel();
        this.globalTab = new JPanel();
        this.export = new JButton("Export statistics...");
        this.xTab.setLayout(new BoxLayout(this.xTab, 1));
        this.yTab.setLayout(new BoxLayout(this.yTab, 1));
        this.zTab.setLayout(new BoxLayout(this.zTab, 1));
        this.globalTab.setLayout(new BoxLayout(this.globalTab, 1));
        this.statistics.addTab("Global", this.globalTab);
        this.statistics.addTab("Along X", this.xTab);
        this.statistics.addTab("Along Y", this.yTab);
        this.statistics.addTab("Along Z", this.zTab);
        this.xPlot.setAxisLabels("Time", "Displacement along X");
        this.yPlot.setAxisLabels("Time", "Displacement along Y");
        this.zPlot.setAxisLabels("Time", "Displacement along Z");
        Dimension dim = this.statistics.getPreferredSize();
        dim.height = 900;
        this.statistics.setPreferredSize(dim);
        this.useRealUnits.setSelected(false);
        this.useRealUnits.addActionListener(this.updater);
        this.showSpeed.setSelected(false);
        this.showSpeed.addActionListener(this.updater);
        this.options.setLayout(new BoxLayout(this.options, 0));
        this.options.add(this.useRealUnits);
        this.options.add(this.showSpeed);
        this.options.add(Box.createHorizontalGlue());
        this.options.add(this.export);
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(this.options);
        this.panel.add(this.statistics);
        this.export.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String xlsFolder = MotionProfilerProcessor.this.preferences.get("xlsFolder", null);
                        String path = SaveDialog.chooseFile("Export motion data", xlsFolder, "Speed", ".xls");
                        if (path == null) {
                            return;
                        }
                        MotionProfilerProcessor.this.preferences.put("xlsFolder", FileUtil.getDirectory(path));
                        try (AnnounceFrame message = new AnnounceFrame("Saving motion data...", 0);){
                            MotionProfilerProcessor.this.export(path);
                        }
                    }
                }.start();
            }
        });
    }

    @Override
    public void Close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Compute() {
        if (!this.isEnabled()) {
            return;
        }
        Sequence sequence = this.trackPool.getDisplaySequence();
        if (sequence == null && this.useRealUnits.isSelected()) {
            this.useRealUnits.setSelected(false);
        }
        this.useRealUnits.setEnabled(sequence != null);
        this.panel.setVisible(false);
        try {
            boolean show3D;
            this.globalTab.removeAll();
            this.xTab.removeAll();
            this.yTab.removeAll();
            this.zTab.removeAll();
            if (this.statistics.getTabCount() > 3) {
                this.statistics.removeTabAt(3);
            }
            boolean bl = show3D = sequence == null || sequence.getSizeZ() > 1;
            if (show3D) {
                if (this.globalPlot == null || this.globalPlot instanceof Plot2DPanel) {
                    this.globalPlot = new Plot3DPanel();
                    this.globalPlot.setAxisLabels("X", "Y", "Z");
                }
                this.statistics.addTab("Along Z", this.zTab);
            } else if (this.globalPlot == null || this.globalPlot instanceof Plot3DPanel) {
                this.globalPlot = new Plot2DPanel();
                this.globalPlot.setAxisLabels("X", "Y");
            }
            try {
                File tmpFile = File.createTempFile("Motion profiler", "xls");
                WritableWorkbook workbook = this.getStatistics(tmpFile.getAbsolutePath(), this.xPlot, this.yPlot, this.zPlot, this.globalPlot);
                WritableSheet globalSheet = workbook.getSheet("Global");
                WritableSheet xSheet = workbook.getSheet("X");
                WritableSheet ySheet = workbook.getSheet("Y");
                WritableSheet zSheet = workbook.getSheet("Z");
                ExcelTable xTable = new ExcelTable(xSheet);
                xTable.setPreferredSize(new Dimension(0, 200));
                this.xTab.add(xTable);
                this.xPlot.setPreferredSize(new Dimension(0, 300));
                this.xTab.add(this.xPlot);
                ExcelTable yTable = new ExcelTable(ySheet);
                yTable.setPreferredSize(new Dimension(0, 200));
                this.yTab.add(yTable);
                this.yPlot.setPreferredSize(new Dimension(0, 300));
                this.yTab.add(this.yPlot);
                if (show3D) {
                    ExcelTable zTable = new ExcelTable(zSheet);
                    zTable.setPreferredSize(new Dimension(0, 200));
                    this.zTab.add(zTable);
                    this.zPlot.setPreferredSize(new Dimension(0, 300));
                    this.zTab.add(this.zPlot);
                }
                ExcelTable globalTable = new ExcelTable(globalSheet);
                globalTable.setPreferredSize(new Dimension(0, 200));
                this.globalTab.add(globalTable);
                this.globalPlot.setPreferredSize(new Dimension(0, 600));
                this.globalTab.add(this.globalPlot);
                workbook.close();
                if (!tmpFile.delete()) {
                    tmpFile.deleteOnExit();
                }
            }
            catch (Exception e) {
                System.err.println("[Motion Profiler] Unable to generate XLS motion statistics;");
                IcyExceptionHandler.showErrorMessage(e, true);
                this.panel.setVisible(true);
                return;
            }
        }
        finally {
            this.panel.setVisible(true);
        }
    }

    @Override
    public void displaySequenceChanged() {
        this.Compute();
    }

    private WritableWorkbook getStatistics(String path, Plot2DPanel xPlotPanel, Plot2DPanel yPlotPanel, Plot2DPanel zPlotPanel, PlotPanel globalPlotPanel) throws WriteException, IOException {
        return MotionProfiler.getTrackMotionXLS(this.trackPool.getTrackSegmentList(), this.useRealUnits.isSelected() ? this.trackPool.getDisplaySequence() : null, this.showSpeed.isSelected(), true, path, xPlotPanel, yPlotPanel, zPlotPanel, globalPlotPanel);
    }

    private WritableWorkbook getStatistics(String path) throws WriteException, IOException {
        return this.getStatistics(path, null, null, null, null);
    }

    void export(String path) {
        try {
            WritableWorkbook wb = this.getStatistics(path);
            XLSUtil.saveAndClose(wb);
        }
        catch (Exception e) {
            MessageDialog.showDialog("Cannot export file", 0);
        }
    }

    @Override
    public String getMainPluginClassName() {
        return SpeedProfiler.class.getName();
    }
}

