/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.trackprocessors.speed;

import icy.math.ArrayMath;
import java.awt.Color;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.PlotPanel;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackStatistic {
    public String groupName;
    public int id;
    public double startTime;
    public double endTime;
    public double duration;
    public final SingleStatistic global = new SingleStatistic();
    public final SingleStatistic x = new SingleStatistic();
    public final SingleStatistic y = new SingleStatistic();
    public final SingleStatistic z = new SingleStatistic();

    public static TrackStatistic computeStatistic(TrackSegment track, double xScale, double yScale, double zScale, double tInterval, boolean wantExtend, boolean computeSpeed, boolean ignoreFilteredDetection, Plot2DPanel xPlotPanel, Plot2DPanel yPlotPanel, Plot2DPanel zPlotPanel, PlotPanel globalPlotPanel) {
        int size;
        int lastIndex;
        int firstIndex;
        int nbDetections = track.getDetectionList().size();
        if (ignoreFilteredDetection) {
            int i;
            for (i = 0; i < nbDetections && !track.getDetectionAt(i).isEnabled(); ++i) {
            }
            firstIndex = i;
            while (i < nbDetections && track.getDetectionAt(i).isEnabled()) {
                ++i;
            }
            lastIndex = i - 1;
            size = i - firstIndex;
            while (i < nbDetections) {
                if (track.getDetectionAt(i).isEnabled()) {
                    return null;
                }
                ++i;
            }
        } else {
            firstIndex = 0;
            lastIndex = nbDetections - 1;
            size = nbDetections;
        }
        if (size < 2) {
            return null;
        }
        TrackStatistic result = new TrackStatistic();
        SingleStatistic global = result.global;
        SingleStatistic x = result.x;
        SingleStatistic y = result.y;
        SingleStatistic z = result.z;
        double[] xData = new double[size];
        double[] yData = new double[size];
        double[] zData = new double[size];
        double[] disp = new double[size - 1];
        double[] xDisp = new double[size - 1];
        double[] yDisp = new double[size - 1];
        double[] zDisp = new double[size - 1];
        for (int i = 0; i < size; ++i) {
            Detection det = track.getDetectionAt(i + firstIndex);
            xData[i] = det.getX() * xScale;
            yData[i] = det.getY() * yScale;
            zData[i] = det.getZ() * zScale;
            if (i <= 0) continue;
            int j = i - 1;
            xDisp[j] = xData[i] - xData[j];
            yDisp[j] = yData[i] - yData[j];
            zDisp[j] = zData[i] - zData[j];
            disp[j] = Math.sqrt(xDisp[j] * xDisp[j] + yDisp[j] * yDisp[j] + zDisp[j] * zDisp[j]);
        }
        result.startTime = track.getDetectionAt(firstIndex).getT();
        result.endTime = track.getDetectionAt(lastIndex).getT();
        result.duration = size - 1;
        if (tInterval != 0.0) {
            result.startTime *= tInterval;
            result.endTime *= tInterval;
            result.duration *= tInterval;
        }
        x.netDisp = Math.abs(xData[xData.length - 1] - xData[0]);
        y.netDisp = Math.abs(yData[yData.length - 1] - yData[0]);
        z.netDisp = Math.abs(zData[zData.length - 1] - zData[0]);
        global.netDisp = Math.sqrt(x.netDisp * x.netDisp + y.netDisp * y.netDisp + z.netDisp * z.netDisp);
        x.totalDisp = ArrayMath.sum(ArrayMath.abs(xDisp, false));
        y.totalDisp = ArrayMath.sum(ArrayMath.abs(yDisp, false));
        z.totalDisp = ArrayMath.sum(ArrayMath.abs(zDisp, false));
        global.totalDisp = ArrayMath.sum(ArrayMath.abs(disp, false));
        x.linearity = x.totalDisp == 0.0 ? 0.0 : x.netDisp / x.totalDisp;
        y.linearity = y.totalDisp == 0.0 ? 0.0 : y.netDisp / y.totalDisp;
        z.linearity = z.totalDisp == 0.0 ? 0.0 : z.netDisp / z.totalDisp;
        global.linearity = global.totalDisp == 0.0 ? 0.0 : global.netDisp / global.totalDisp;
        x.minDispOrSpeed = ArrayMath.min(xDisp);
        y.minDispOrSpeed = ArrayMath.min(yDisp);
        z.minDispOrSpeed = ArrayMath.min(zDisp);
        global.minDispOrSpeed = ArrayMath.min(disp);
        x.maxDispOrSpeed = ArrayMath.max(xDisp);
        y.maxDispOrSpeed = ArrayMath.max(yDisp);
        z.maxDispOrSpeed = ArrayMath.max(zDisp);
        global.maxDispOrSpeed = ArrayMath.max(disp);
        x.meanDispOrSpeed = ArrayMath.mean(xDisp);
        y.meanDispOrSpeed = ArrayMath.mean(yDisp);
        z.meanDispOrSpeed = ArrayMath.mean(zDisp);
        global.meanDispOrSpeed = ArrayMath.mean(disp);
        if (computeSpeed && tInterval != 0.0) {
            x.minDispOrSpeed /= tInterval;
            y.minDispOrSpeed /= tInterval;
            z.minDispOrSpeed /= tInterval;
            global.minDispOrSpeed /= tInterval;
            x.maxDispOrSpeed /= tInterval;
            y.maxDispOrSpeed /= tInterval;
            z.maxDispOrSpeed /= tInterval;
            global.maxDispOrSpeed /= tInterval;
            x.meanDispOrSpeed /= tInterval;
            y.meanDispOrSpeed /= tInterval;
            z.meanDispOrSpeed /= tInterval;
            global.meanDispOrSpeed /= tInterval;
        }
        double xSearchRadius = 0.0;
        double ySearchRadius = 0.0;
        double zSearchRadius = 0.0;
        double searchRadius = 0.0;
        if (wantExtend) {
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    double dz;
                    double dy;
                    double dx = Math.abs(xData[i] - xData[j]);
                    double dist = dx * dx + (dy = Math.abs(yData[i] - yData[j])) * dy + (dz = Math.abs(zData[i] - zData[j])) * dz;
                    if (dist > searchRadius) {
                        searchRadius = dist;
                    }
                    if (dx > xSearchRadius) {
                        xSearchRadius = dx;
                    }
                    if (dy > ySearchRadius) {
                        ySearchRadius = dy;
                    }
                    if (!(dz > zSearchRadius)) continue;
                    zSearchRadius = dz;
                }
            }
            searchRadius = Math.sqrt(searchRadius);
        }
        x.searchRadius = xSearchRadius;
        y.searchRadius = ySearchRadius;
        z.searchRadius = zSearchRadius;
        global.searchRadius = searchRadius;
        Color color = track.getFirstDetection().getColor();
        TrackGroup group = track.getOwnerTrackGroup();
        if (group != null) {
            result.groupName = group.getDescription();
            result.id = group.getTrackSegmentList().indexOf(track);
        } else {
            result.groupName = "";
            result.id = -1;
        }
        String trackName = result.groupName + " - Track " + result.id;
        ArrayMath.subtract(xData, xData[0], xData);
        ArrayMath.subtract(yData, yData[0], yData);
        ArrayMath.subtract(zData, zData[0], zData);
        if (xPlotPanel != null) {
            xPlotPanel.addLinePlot(trackName, color, xDisp);
        }
        if (yPlotPanel != null) {
            yPlotPanel.addLinePlot(trackName, color, yDisp);
        }
        if (zPlotPanel != null) {
            zPlotPanel.addLinePlot(trackName, color, zDisp);
        }
        if (globalPlotPanel instanceof Plot3DPanel) {
            ((Plot3DPanel)globalPlotPanel).addLinePlot(trackName, color, xData, yData, zData);
        } else if (globalPlotPanel instanceof Plot2DPanel) {
            ((Plot2DPanel)globalPlotPanel).addLinePlot(trackName, color, xData, yData);
        }
        return result;
    }

    public static class SingleStatistic {
        public double totalDisp;
        public double netDisp;
        public double linearity;
        public double searchRadius;
        public double minDispOrSpeed;
        public double maxDispOrSpeed;
        public double meanDispOrSpeed;
    }
}

