/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXTextArea;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class TextArea<T>
extends SwingVarEditor<T> {
    private FocusListener focusListener;
    private KeyListener keyListener;

    public TextArea(Var<T> variable, int rows) {
        super(variable);
        this.getTextArea().setRows(rows);
    }

    @Override
    public JComponent createEditorComponent() {
        final JXTextArea jTextArea = new JXTextArea();
        jTextArea.setText(this.getVariable().getValueAsString());
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TextArea.this.setVariableValue(jTextArea);
            }
        };
        this.keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                try {
                    TextArea.this.variable.parse(jTextArea.getText());
                    jTextArea.setForeground(Color.black);
                }
                catch (Exception ex) {
                    jTextArea.setForeground(Color.red);
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        JScrollPane scroll = new JScrollPane((Component)jTextArea, 21, 31);
        scroll.setAutoscrolls(true);
        return scroll;
    }

    private void setVariableValue(JXTextArea jTextArea) {
        try {
            if (this.variable.getReference() == null) {
                this.variable.setValue(this.variable.parse(jTextArea.getText()));
            }
            jTextArea.setForeground(Color.black);
            jTextArea.setToolTipText(null);
        }
        catch (RuntimeException e) {
            jTextArea.setForeground(Color.red);
            jTextArea.setToolTipText("Cannot convert input into a " + this.getVariable().getTypeAsString());
        }
    }

    @Override
    protected void updateInterfaceValue() {
        this.getTextArea().setText(this.variable.getValueAsString(true));
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public JScrollPane getEditorComponent() {
        return (JScrollPane)super.getEditorComponent();
    }

    public JXTextArea getTextArea() {
        return (JXTextArea)this.getEditorComponent().getViewport().getView();
    }

    @Override
    protected void activateListeners() {
        this.getTextArea().addFocusListener(this.focusListener);
        this.getTextArea().addKeyListener(this.keyListener);
    }

    @Override
    protected void deactivateListeners() {
        this.getTextArea().removeFocusListener(this.focusListener);
        this.getTextArea().removeKeyListener(this.keyListener);
    }
}

