/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import plugins.nchenouard.spot.Detection;

public class TrackDetection
extends JPanel {
    private static final long serialVersionUID = 7254806428248130683L;
    private boolean Selected = false;
    private Detection detection;

    public TrackDetection(Detection detection) {
        this.detection = detection;
    }

    public Detection getDetection() {
        return this.detection;
    }

    public void setSelected(boolean Selected) {
        this.Selected = Selected;
        this.updateUI();
    }

    public boolean isSelected(boolean Selected) {
        return Selected;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Graphics2D g2D = (Graphics2D)g;
        Point2D.Float p1 = new Point2D.Float(1.0f, (float)this.getHeight() * 1.3f);
        Point2D.Float p2 = new Point2D.Float(1.0f, (float)this.getHeight() / 2.0f);
        GradientPaint g1 = new GradientPaint(p1, Color.WHITE, p2, this.detection.getColor(), true);
        Rectangle2D.Float rect1 = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        g2D.setPaint(g1);
        g2D.fill(rect1);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        Rectangle2D.Float shape = new Rectangle2D.Float((float)this.getWidth() / 3.0f, (float)this.getHeight() / 3.0f, (float)this.getWidth() - (float)(2 * this.getWidth()) / 3.0f, (float)this.getHeight() - (float)(2 * this.getHeight()) / 3.0f);
        g2.fill(shape);
        if (this.Selected) {
            g2.setColor(Color.red);
            g2.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
        }
        if (this.detection.isSelected()) {
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(Color.black);
            g2.drawRect(0, 0, this.getWidth(), this.getHeight());
            g2.setStroke(new BasicStroke(1.0f));
        }
        if (this.detection.getDetectionType() == 2) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.white);
            g2.drawLine(0, 0, this.getWidth(), this.getHeight());
            g2.setStroke(new BasicStroke(1.0f));
        }
    }
}

