/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.gui.main.GlobalSequenceListener;
import icy.gui.main.GlobalViewerListener;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import plugins.fab.trackmanager.Link;
import plugins.fab.trackmanager.TrackDetection;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManagerProcessorListener;
import plugins.fab.trackmanager.TrackPainterChangeEvent;
import plugins.fab.trackmanager.TrackPainterListener;
import plugins.fab.trackmanager.TrackPool;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
TrackPainterListener,
TrackManagerProcessorListener,
ViewerListener,
GlobalSequenceListener,
GlobalViewerListener,
Runnable {
    private static final long serialVersionUID = 938480382468773601L;
    TimeCursor timeCursor = new TimeCursor();
    private Dimension detectDim = new Dimension(10, 10);
    private TrackPool trackPool;
    BufferedImage bufferedImage;
    boolean enableLeftPanelTrackDisplay = true;

    public TrackPanel(TrackPool trackPool, boolean enableLeftPanelTrackDisplay) {
        this.enableLeftPanelTrackDisplay = enableLeftPanelTrackDisplay;
        this.trackPool = trackPool;
        trackPool.addTrackProcessorListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(Color.gray);
        trackPool.getTrackPainter().addTrackPainterListener(this);
        this.clearDetectionsAndReDisplay();
        this.setupViewerListener();
        Icy.getMainInterface().addGlobalSequenceListener(this);
        Icy.getMainInterface().addGlobalViewerListener(this);
    }

    void setupViewerListener() {
        for (Viewer viewer : Icy.getMainInterface().getViewers()) {
            viewer.removeListener(this);
        }
        Sequence sequence = this.trackPool.getDisplaySequence();
        if (sequence == null) {
            return;
        }
        for (Viewer viewer : Icy.getMainInterface().getViewers(sequence)) {
            viewer.addListener(this);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.enableLeftPanelTrackDisplay) {
            return;
        }
        MouseLink.clear();
        TrackSegment ts = this.getTrackSegmentAt(e.getY());
        if (ts == null) {
            return;
        }
        ts.setAllDetectionSelected(!ts.isAllDetectionSelected());
        this.redrawDetection3();
    }

    private TrackSegment getTrackSegmentAt(int y) {
        TrackSegment tsResult = null;
        y /= this.getDetectDim().height;
        int currentLine = 0;
        block0: for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            for (TrackSegment ts : trackGroup.getTrackSegmentList()) {
                if (currentLine == y) {
                    tsResult = ts;
                    break block0;
                }
                ++currentLine;
            }
        }
        return tsResult;
    }

    private Detection getDetectionAt(int x, int y) {
        Detection detection = null;
        TrackSegment ts = this.getTrackSegmentAt(y);
        if (ts == null) {
            return null;
        }
        int t = x / this.getDetectDim().width;
        detection = ts.getDetectionAtTime(t);
        return detection;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.enableLeftPanelTrackDisplay) {
            return;
        }
        MouseLink.clear();
        MouseLink.xstart = e.getX();
        MouseLink.ystart = e.getY();
        MouseLink.xend = e.getX();
        MouseLink.yend = e.getY();
        Component component = this.getComponentAt(MouseLink.xstart, MouseLink.ystart);
        Detection detection = this.getDetectionAt(e.getX(), e.getY());
        if (detection != null) {
            MouseLink.xstart = e.getX();
            MouseLink.ystart = e.getY();
            MouseLink.detectionStart = detection;
            MouseLink.ispressed = true;
        }
        if (component == this) {
            if (this.timeCursor.contains(e.getX(), e.getY())) {
                this.timeCursor.dragging = true;
            } else {
                boolean oneAtLeast = false;
                for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
                    if (trackGroup.getTrackSegmentList().size() == 0) continue;
                    oneAtLeast = true;
                    break;
                }
                if (oneAtLeast) {
                    TrackDrag.dragging = true;
                    TrackDrag.ts = this.getCurrentTrackSegmentWithY(e.getY());
                    this.repaint();
                }
            }
        }
    }

    private TrackSegment getCurrentTrackSegmentWithY(int Y) {
        TrackSegment ts = null;
        ts = this.trackPool.getTrackSegmentList().get(this.getCurrentTrackSegmentIndexWithY(Y));
        return ts;
    }

    private int getCurrentTrackSegmentIndexWithY(int Y) {
        int index = (int)((double)Y / this.detectDim.getHeight());
        if (index < 0) {
            index = 0;
        }
        if (index >= this.trackPool.getTrackSegmentList().size()) {
            index = this.trackPool.getTrackSegmentList().size() - 1;
        }
        return index;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        MouseLink.xend = e.getX();
        MouseLink.yend = e.getY();
        if (MouseLink.ispressed) {
            Detection detection = this.getDetectionAt(e.getX(), e.getY());
            if (detection != null) {
                MouseLink.xend = e.getX();
                MouseLink.yend = e.getY();
                MouseLink.detectionEnd = detection;
            }
            this.finishMouseConnexion();
            this.repaint();
        }
        MouseLink.clear();
        if (TrackDrag.dragging) {
            TrackDrag.dragging = false;
            this.repaint();
        }
        if (this.timeCursor.dragging) {
            this.timeCursor.dragging = false;
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (MouseLink.ispressed) {
            MouseLink.xend = e.getX();
            MouseLink.yend = e.getY();
            this.repaint();
        }
        if (TrackDrag.dragging) {
            this.trackPool.moveTrackToIndex(TrackDrag.ts, this.getCurrentTrackSegmentIndexWithY(e.getY()));
            this.clearDetectionsAndReDisplay();
        }
        if (this.timeCursor.dragging) {
            this.timeCursor.currentT = (int)((double)e.getX() / this.detectDim.getWidth());
            if (this.timeCursor.currentT < 0) {
                this.timeCursor.currentT = 0;
            }
            this.trackPool.getTrackManager().timeCursorChanged(this.timeCursor.currentT);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public Dimension getDetectDim() {
        return this.detectDim;
    }

    public void setDetectDim(Dimension detectDim) {
        this.detectDim = detectDim;
    }

    public void setTrackPool(TrackPool trackPool) {
        this.trackPool = trackPool;
        this.clearDetectionsAndReDisplay();
    }

    private void clearDetectionsAndReDisplay() {
        ThreadUtil.bgRunSingle(this);
    }

    public void recomputeProcessors() {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                for (Detection d : TrackPanel.this.trackPool.getAllDetection()) {
                    d.reset();
                }
                TrackPanel.this.trackPool.computeTrackProcessor();
            }
        });
    }

    @Override
    public void run() {
        this.recomputeProcessors();
        this.redrawDetection3();
        Sequence sequence = this.trackPool.getDisplaySequence();
        if (sequence != null) {
            sequence.painterChanged(null);
        }
    }

    public void redrawDetection3() {
        int maxSize;
        int totalNumberOfTrack;
        int height;
        if (!this.enableLeftPanelTrackDisplay) {
            return;
        }
        int maxSizeT = this.trackPool.getLastDetectionTimePoint();
        int width = this.getDetectDim().width * (maxSizeT + 1);
        if (width * (height = this.getDetectDim().height * (totalNumberOfTrack = this.trackPool.getTotalNumberOfTrack())) > (maxSize = 100000000)) {
            height = maxSize / width;
            System.out.println("too much track to display them all in trackManager left panel. Still, they all appear on the sequence.");
        }
        Dimension trackingPanelSize = new Dimension(width, height);
        this.setPreferredSize(trackingPanelSize);
        this.revalidate();
        if (this.bufferedImage != null && (this.bufferedImage.getWidth() != trackingPanelSize.width || this.bufferedImage.getHeight() != trackingPanelSize.height)) {
            this.bufferedImage = null;
        }
        if (this.bufferedImage == null) {
            if (trackingPanelSize.width != 0 && trackingPanelSize.height != 0) {
                try {
                    this.bufferedImage = new BufferedImage(trackingPanelSize.width, trackingPanelSize.height, 1);
                }
                catch (OutOfMemoryError e) {
                    System.out.println("can't create " + trackingPanelSize.width + "x" + trackingPanelSize.height + " bitmap for track representation in trackPanel");
                    System.out.println("left panel disabled");
                    this.enableLeftPanelTrackDisplay = false;
                    return;
                }
            } else {
                return;
            }
        }
        Graphics2D g = this.bufferedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color c1 = new Color(0.8f, 0.8f, 0.8f);
        Color c2 = new Color(0.9f, 0.9f, 0.9f);
        int offsetY = 0;
        boolean switchBackground = true;
        g.setFont(new Font("Arial", 1, this.detectDim.height - 2));
        for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            for (int tracknb = 0; tracknb < trackGroup.getTrackSegmentList().size(); ++tracknb) {
                boolean bl = switchBackground = !switchBackground;
                if (switchBackground) {
                    g.setColor(c1);
                } else {
                    g.setColor(c2);
                }
                g.fillRect(0, this.detectDim.height * offsetY, this.detectDim.width * (maxSizeT + 1), this.detectDim.height);
                ++offsetY;
            }
        }
        int currentLine = 0;
        HashMap<Detection, Point2D.Float> detectionHashMap = new HashMap<Detection, Point2D.Float>();
        for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            for (TrackSegment ts : trackGroup.getTrackSegmentList()) {
                for (int detectionIndex = 0; detectionIndex < ts.getDetectionList().size(); ++detectionIndex) {
                    Detection d = ts.getDetectionList().get(detectionIndex);
                    Rectangle2D.Double bounds = new Rectangle2D.Double(0 + this.getDetectDim().width * d.getT(), 0 + this.getDetectDim().height * currentLine, 0 + this.getDetectDim().width, 0 + this.getDetectDim().height);
                    this.drawDetection(g, d, bounds);
                    detectionHashMap.put(d, new Point2D.Float(this.getDetectDim().width * d.getT(), this.getDetectDim().height * currentLine));
                }
                ++currentLine;
            }
        }
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(Color.red);
        g2.setStroke(new BasicStroke(3.0f));
        ArrayList<Link> links = this.trackPool.getLinks();
        int detectHeight = this.getDetectDim().height / 2;
        int detectWidth = this.getDetectDim().width / 2;
        for (Link link : links) {
            Detection startDetection = link.getStartDetection();
            Detection endDetection = link.getEndDetection();
            Point2D startDetectionPoint2D = (Point2D)detectionHashMap.get(startDetection);
            Point2D endDetectionPoint2D = (Point2D)detectionHashMap.get(endDetection);
            if (startDetectionPoint2D == null || endDetectionPoint2D == null) continue;
            g2.drawLine((int)startDetectionPoint2D.getX() + detectHeight, (int)startDetectionPoint2D.getY() + detectWidth, (int)endDetectionPoint2D.getX() + detectHeight, (int)endDetectionPoint2D.getY() + detectWidth);
        }
        int offsetY2 = 1;
        g.setColor(Color.white);
        for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            for (int tracknb = 0; tracknb < trackGroup.getTrackSegmentList().size(); ++tracknb) {
                g.drawString(trackGroup.getDescription() + " # " + tracknb, 10, this.detectDim.height * offsetY2 - 2);
                ++offsetY2;
            }
        }
        this.repaint();
    }

    private void drawDetection(Graphics2D g, Detection d, Rectangle2D bounds) {
        g.setColor(d.getColor());
        g.fill(bounds);
        g.setColor(d.getColor().darker());
        g.draw(bounds);
        if (d.isSelected()) {
            g.setStroke(new BasicStroke(3.0f));
            g.setColor(Color.white);
            g.draw(bounds);
            g.setStroke(new BasicStroke(1.0f));
        }
        if (d.getDetectionType() == 2) {
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.white);
            g.drawLine((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getMaxX(), (int)bounds.getMaxY());
            g.setStroke(new BasicStroke(1.0f));
        }
    }

    @Override
    protected void paintComponent(Graphics g1) {
        super.paintComponent(g1);
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!this.enableLeftPanelTrackDisplay) {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Display disabled. Enable selecting Display > Enable Track Panel", 20, 20);
            return;
        }
        int totalNumberOfTrack = this.trackPool.getTotalNumberOfTrack();
        if (totalNumberOfTrack == 0) {
            g.drawString("No track to display", 20, 20);
        }
        if (this.bufferedImage == null) {
            return;
        }
        g.drawImage(this.bufferedImage, null, 0, 0);
        if (MouseLink.ispressed) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.red);
            g.drawLine(MouseLink.xstart, MouseLink.ystart, MouseLink.xend, MouseLink.yend);
            g.setStroke(new BasicStroke(1.0f));
        }
        g.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g.setColor(Color.red);
        g.fillRect(this.getDetectDim().width * this.timeCursor.currentT, this.getVisibleRect().y, this.getDetectDim().width, this.getVisibleRect().height);
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
    }

    public void redrawDetection2() {
        this.setPreferredSize(new Dimension(this.getDetectDim().width * 400, this.getDetectDim().height * 400));
        this.removeAll();
        int ligne = 0;
        for (TrackGroup trackGroup : this.trackPool.getTrackGroupList()) {
            for (TrackSegment ts : trackGroup.getTrackSegmentList()) {
                for (int detectionIndex = 0; detectionIndex < ts.getDetectionList().size(); ++detectionIndex) {
                    Detection d = ts.getDetectionList().get(detectionIndex);
                    TrackDetection td = new TrackDetection(d);
                    td.setBounds(0 + this.getDetectDim().width * d.getT(), 0 + this.getDetectDim().height * ligne, 0 + this.getDetectDim().width, 0 + this.getDetectDim().height);
                    this.add(td);
                }
                ++ligne;
            }
        }
        this.updateUI();
    }

    public void finishMouseConnexion() {
        if (MouseLink.detectionStart != null && MouseLink.detectionEnd != null) {
            Detection d1 = MouseLink.detectionStart;
            Detection d2 = MouseLink.detectionEnd;
            if (d1.getT() + 1 == d2.getT() && this.trackPool.getTrackSegmentWithDetection(d1) == this.trackPool.getTrackSegmentWithDetection(d2)) {
                this.trackPool.cutTrackAfterDetection(d1);
                if (this.trackPool.getDisplaySequence() != null) {
                    this.trackPool.getDisplaySequence().painterChanged(null);
                }
                this.clearDetectionsAndReDisplay();
                this.updateUI();
                return;
            }
        }
        this.trackPool.createVirtualTrackWith2TrackDetection(MouseLink.detectionStart, MouseLink.detectionEnd);
        if (this.trackPool.getDisplaySequence() != null) {
            this.trackPool.getDisplaySequence().painterChanged(null);
        }
        this.clearDetectionsAndReDisplay();
        this.updateUI();
    }

    @Override
    public void trackPainterChanged(TrackPainterChangeEvent e) {
        this.redrawDetection3();
    }

    @Override
    public void TrackEditorProcessorChange(ChangeEvent e) {
        this.clearDetectionsAndReDisplay();
    }

    @Override
    public void viewerChanged(ViewerEvent event) {
        if (event.getDim() == DimensionId.T) {
            this.timeCursor.currentT = event.getSource().getPositionT();
            this.repaint();
        }
    }

    public void displaySequenceChanged() {
        this.setupViewerListener();
    }

    public void setEnableLeftPanelTrackDisplay(boolean selected) {
        this.enableLeftPanelTrackDisplay = selected;
        this.redrawDetection3();
    }

    @Override
    public void viewerClosed(Viewer viewer) {
        this.setupViewerListener();
    }

    @Override
    public void viewerOpened(Viewer viewer) {
        this.setupViewerListener();
    }

    @Override
    public void sequenceOpened(Sequence sequence) {
        this.setupViewerListener();
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
        this.setupViewerListener();
    }

    static class MouseLink {
        static Detection detectionEnd;
        static Detection detectionStart;
        static int xstart;
        static int ystart;
        static int xend;
        static int yend;
        static boolean ispressed;

        MouseLink() {
        }

        public static void clear() {
            ispressed = false;
            detectionStart = null;
            detectionEnd = null;
        }

        static {
            ispressed = false;
        }
    }

    private static class TrackDrag {
        static boolean dragging = false;
        static TrackSegment ts = null;

        private TrackDrag() {
        }
    }

    private class TimeCursor {
        int currentT = 0;
        boolean dragging = false;

        private TimeCursor() {
        }

        boolean contains(int x, int y) {
            Rectangle r = new Rectangle(this.currentT * (int)TrackPanel.this.detectDim.getWidth(), 0, (int)TrackPanel.this.detectDim.getWidth(), Integer.MAX_VALUE);
            return r.contains(x, y);
        }
    }
}

