/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.trackmanager;

import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import plugins.fab.trackmanager.Link;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackManagerPainter;
import plugins.fab.trackmanager.TrackManagerProcessorListener;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class TrackPool {
    private TrackManagerPainter tePainter;
    private ArrayList<PluginTrackManagerProcessor> trackManagerProcessorList = new ArrayList();
    private ArrayList<TrackManagerProcessorListener> trackEditorProcessorListener = new ArrayList();
    boolean isUpdating = false;
    private Sequence displaySequence = null;
    TrackManager trackManager;
    ArrayList<SwimmingObject> resultList = new ArrayList();

    public TrackPool() {
        this.tePainter = new TrackManagerPainter(this);
    }

    public ArrayList<PluginTrackManagerProcessor> getTrackManagerProcessorList() {
        return this.trackManagerProcessorList;
    }

    public void addTrackProcessor(PluginTrackManagerProcessor tep) {
        this.trackManagerProcessorList.add(tep);
        this.fireTrackEditorProcessorChange();
    }

    public void addTrackProcessorListener(TrackManagerProcessorListener tepl) {
        this.trackEditorProcessorListener.add(tepl);
    }

    public void computeTrackProcessor() {
        for (PluginTrackManagerProcessor tep : this.trackManagerProcessorList) {
            long startTimeInNs = System.nanoTime();
            tep.Compute();
            tep.setPerformance((int)((float)(System.nanoTime() - startTimeInNs) / 1000000.0f));
        }
    }

    public void clearTracks() {
        for (TrackGroup trackGroup : this.getTrackGroupList()) {
            trackGroup.getTrackSegmentList().clear();
        }
        this.fireTrackEditorProcessorChange();
    }

    public static boolean linkExists(List<Link> links, TrackSegment start, TrackSegment end) {
        for (Link link : links) {
            if (link.start != start || link.end != end) continue;
            return true;
        }
        return false;
    }

    public static boolean isLinkExists(List<TrackGroup> groups, TrackSegment start, TrackSegment end) {
        return TrackPool.linkExists(TrackPool.getLinks(groups), start, end);
    }

    public boolean isLinkExists(TrackSegment start, TrackSegment end) {
        return TrackPool.linkExists(this.getLinks(), start, end);
    }

    public static void createLink(List<TrackGroup> groups, TrackSegment start, TrackSegment end) {
        if (!TrackPool.isLinkExists(groups, start, end)) {
            start.nextList.add(end);
            end.previousList.add(start);
        }
    }

    public void createLink(TrackSegment start, TrackSegment end) {
        if (!this.isLinkExists(start, end)) {
            start.nextList.add(end);
            end.previousList.add(start);
        }
    }

    public void createVirtualTrackWith2Detection(Detection detectionStart, Detection detectionEnd) {
        ArrayList<TrackSegment> returnList;
        TrackSegment segmentEnd;
        TrackSegment segmentStart = this.getTrackSegmentWithDetection(detectionStart);
        if (segmentStart == (segmentEnd = this.getTrackSegmentWithDetection(detectionEnd))) {
            MessageDialog.showDialog("Can't link 2 detections belonging to the same track.", 1);
            return;
        }
        if (segmentStart.getOwnerTrackGroup() != segmentStart.getOwnerTrackGroup()) {
            MessageDialog.showDialog("The two tracks should be from the same track group.", 1);
            return;
        }
        if (detectionStart.getT() >= detectionEnd.getT()) {
            MessageDialog.showDialog("Can't create a backward link.", 1);
            return;
        }
        if (detectionStart != segmentStart.getLastDetection()) {
            returnList = this.splitTrackSegment(segmentStart, segmentStart.getDetectionIndex(detectionStart), true);
            detectionStart = returnList.get(0).getLastDetection();
            segmentStart = this.getTrackSegmentWithDetection(detectionStart);
        }
        if (detectionEnd != segmentEnd.getFirstDetection()) {
            returnList = this.splitTrackSegment(segmentEnd, segmentEnd.getDetectionIndex(detectionEnd) - 1, true);
            detectionEnd = returnList.get(1).getFirstDetection();
            segmentEnd = this.getTrackSegmentWithDetection(detectionEnd);
        }
        if (detectionEnd.getT() - detectionStart.getT() != 1) {
            TrackSegment vts = new TrackSegment();
            for (int t = detectionStart.getT() + 1; t < detectionEnd.getT(); ++t) {
                double xstart = detectionStart.getX();
                double ystart = detectionStart.getY();
                double zstart = detectionStart.getZ();
                double xend = detectionEnd.getX();
                double yend = detectionEnd.getY();
                double zend = detectionEnd.getZ();
                double nbt = detectionEnd.getT() - detectionStart.getT();
                double vx = (xend - xstart) / nbt;
                double vy = (yend - ystart) / nbt;
                double vz = (zend - zstart) / nbt;
                double x = xstart + vx * (double)(t - detectionStart.getT());
                double y = ystart + vy * (double)(t - detectionStart.getT());
                double z = zstart + vz * (double)(t - detectionStart.getT());
                Detection detect = new Detection(x, y, z, t);
                detect.setDetectionType(2);
                vts.addDetection(detect);
            }
            TrackGroup trackGroup = segmentStart.getOwnerTrackGroup();
            int indexSegmentStart = trackGroup.getTrackSegmentList().indexOf(segmentStart);
            trackGroup.getTrackSegmentList().add(indexSegmentStart, vts);
            vts.setOwnerTrackGroup(trackGroup);
            this.createLink(segmentStart, vts);
            this.createLink(vts, segmentEnd);
            new AnnounceFrame("Link(s) created", 2);
        } else if (this.isLinkExists(segmentStart, segmentEnd)) {
            this.removeLink(segmentStart, segmentEnd);
            new AnnounceFrame("Link deleted", 2);
        } else {
            this.createLink(segmentStart, segmentEnd);
            new AnnounceFrame("Link created", 2);
        }
        ArrayList<Link> linkList = this.getLinks();
        for (Link l1 : linkList) {
            for (Link l2 : linkList) {
                if (l1.getStartDetection() != l2.getStartDetection() || l1.getEndDetection() != l2.getEndDetection() || l1 == l2) continue;
                this.removeLink(l1.getStartSegment(), l2.getEndSegment());
            }
        }
    }

    public void createVirtualTrackWith2TrackDetection(Detection detectionStart, Detection detectionEnd) {
        if (detectionStart == null) {
            return;
        }
        if (detectionEnd == null) {
            return;
        }
        if (detectionStart == detectionEnd) {
            return;
        }
        this.createVirtualTrackWith2Detection(detectionStart, detectionEnd);
    }

    public void cutTrackAfterDetection(Detection d) {
        TrackSegment ts = this.getTrackSegmentWithDetection(d);
        this.splitTrackSegment(ts, ts.getDetectionList().indexOf(d), false);
        new AnnounceFrame("Track split", 2);
    }

    public void deleteSelectedLink() {
        ArrayList<Link> links = this.getLinks();
        ArrayList<Link> linksClone = new ArrayList<Link>(links);
        for (Link link : linksClone) {
            if (!link.getStartDetection().isSelected() || !link.getEndDetection().isSelected()) continue;
            links.remove(link);
            TrackSegment tsEnd = this.getTrackSegmentWithDetection(link.getEndDetection());
            TrackSegment tsStart = this.getTrackSegmentWithDetection(link.getStartDetection());
            tsEnd.removePrevious(tsStart);
            tsStart.removeNext(tsEnd);
        }
        this.fireTrackEditorProcessorChange();
    }

    public void deleteSelectedTracks() {
        this.beginUpdate();
        ArrayList<TrackSegment> tsListClone = new ArrayList<TrackSegment>(this.getTrackSegmentList());
        for (TrackSegment ts : tsListClone) {
            if (!ts.isAllDetectionSelected()) continue;
            this.deleteTrack(ts);
        }
        this.endUpdate();
        this.fireTrackEditorProcessorChange();
    }

    public TrackGroup getTrackGroupContainingSegment(TrackSegment ts) {
        return ts.getOwnerTrackGroup();
    }

    public void deleteTrack(TrackSegment ts) {
        TrackGroup trackGroup = this.getTrackGroupContainingSegment(ts);
        if (trackGroup == null) {
            System.out.println("Can't delete The track segment " + ts.toString() + " Reason: it is not in any trackGroup");
            return;
        }
        trackGroup.getTrackSegmentList().remove(ts);
        ArrayList<Link> links = this.getLinks();
        ArrayList<Link> linksClone = new ArrayList<Link>(links);
        for (Link link : linksClone) {
            if (ts.containsDetection(link.getStartDetection())) {
                links.remove(link);
                TrackSegment tsEnd = this.getTrackSegmentWithDetection(link.getEndDetection());
                tsEnd.removePrevious(ts);
            }
            if (!ts.containsDetection(link.getEndDetection())) continue;
            links.remove(link);
            TrackSegment tsStart = this.getTrackSegmentWithDetection(link.getStartDetection());
            tsStart.removeNext(ts);
        }
        ts.removeId();
        this.fireTrackEditorProcessorChange();
    }

    protected void finalize() throws Throwable {
        this.tePainter = null;
        super.finalize();
    }

    public void beginUpdate() {
        this.isUpdating = true;
    }

    public void endUpdate() {
        this.isUpdating = false;
    }

    public void fireTrackEditorProcessorChange() {
        if (!this.isUpdating) {
            for (TrackManagerProcessorListener tepl : this.trackEditorProcessorListener) {
                tepl.TrackEditorProcessorChange(new ChangeEvent(this));
            }
        }
    }

    public void fuseAllTracks() {
        boolean fuseOperationPerformed = true;
        block0: while (fuseOperationPerformed) {
            fuseOperationPerformed = false;
            ArrayList<TrackSegment> trackSegmentListClone = new ArrayList<TrackSegment>(this.getTrackSegmentList());
            for (TrackSegment ts : trackSegmentListClone) {
                if (ts.nextList.size() != 1 || ts.nextList.get((int)0).previousList.size() != 1) continue;
                this.fuseTrack(ts, ts.nextList.get(0));
                fuseOperationPerformed = true;
                continue block0;
            }
        }
        this.fireTrackEditorProcessorChange();
    }

    public void fuseTrack(TrackSegment ts1, TrackSegment ts2) {
        for (Detection detection : ts2.getDetectionList()) {
            ts1.addDetection(detection);
        }
        ts1.nextList = new ArrayList<TrackSegment>(new ArrayList<TrackSegment>(ts2.nextList));
        while (ts2.getDetectionList().size() > 0) {
            Detection detection = ts2.getFirstDetection();
            ts2.removeDetection(detection);
        }
        this.deleteTrack(ts2);
        this.fireTrackEditorProcessorChange();
    }

    public ArrayList<Detection> getAllDetection() {
        ArrayList<Detection> detectionList = new ArrayList<Detection>();
        for (TrackGroup trackGroup : this.getTrackGroupList()) {
            for (TrackSegment tracksegment : trackGroup.getTrackSegmentList()) {
                for (Detection detection : tracksegment.getDetectionList()) {
                    detectionList.add(detection);
                }
            }
        }
        return detectionList;
    }

    public double getDistance(Detection d1, Detection d2) {
        return this.getDistance(d1.getX(), d1.getY(), d1.getZ(), d2.getX(), d2.getY(), d2.getZ());
    }

    public double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double distance = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
        return distance;
    }

    public ArrayList<Link> getLinks() {
        ArrayList<Link> linkarray = new ArrayList<Link>();
        for (int trackSegmentIndex = 0; trackSegmentIndex < this.getTrackSegmentList().size(); ++trackSegmentIndex) {
            TrackSegment ts = this.getTrackSegmentList().get(trackSegmentIndex);
            for (int i = 0; i < ts.nextList.size(); ++i) {
                linkarray.add(new Link(ts, ts.nextList.get(i)));
            }
        }
        return linkarray;
    }

    public static List<Link> getLinks(List<TrackGroup> groups) {
        ArrayList<Link> result = new ArrayList<Link>();
        List<TrackSegment> segments = TrackPool.getTrackSegmentList(groups);
        for (TrackSegment segment : segments) {
            for (int i = 0; i < segment.nextList.size(); ++i) {
                result.add(new Link(segment, segment.nextList.get(i)));
            }
        }
        return result;
    }

    public void setDisplaySequence(Sequence displaySequence) {
        this.displaySequence = displaySequence;
        this.removePainter();
        if (displaySequence != null) {
            displaySequence.addOverlay(this.tePainter);
        }
        for (PluginTrackManagerProcessor ptmp : this.trackManagerProcessorList) {
            ptmp.displaySequenceChanged();
        }
        if (this.trackManager != null && this.trackManager.trackPanel != null) {
            this.trackManager.trackPanel.displaySequenceChanged();
        }
    }

    public Sequence getDisplaySequence() {
        return this.displaySequence;
    }

    public TrackManager getTrackEditor() {
        return this.trackManager;
    }

    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    public TrackManagerPainter getTrackPainter() {
        return this.tePainter;
    }

    public static List<TrackSegment> getTrackSegmentList(List<TrackGroup> groups) {
        ArrayList<TrackSegment> result = new ArrayList<TrackSegment>();
        for (TrackGroup group : groups) {
            result.addAll(group.getTrackSegmentList());
        }
        return result;
    }

    public ArrayList<TrackSegment> getTrackSegmentList() {
        ArrayList<TrackSegment> trackSegmentList = new ArrayList<TrackSegment>();
        for (TrackGroup group : this.getTrackGroupList()) {
            trackSegmentList.addAll(group.getTrackSegmentList());
        }
        return trackSegmentList;
    }

    public TrackSegment getTrackSegmentWithDetection(Detection detection) {
        ArrayList<TrackSegment> trackSegmentList = this.getTrackSegmentList();
        for (TrackSegment ts : trackSegmentList) {
            if (!ts.containsDetection(detection)) continue;
            return ts;
        }
        return null;
    }

    public static ArrayList<TrackSegment> loadTracks(File f) throws Exception {
        ArrayList inputTrackSegmentList = new ArrayList();
        ArrayList<TrackSegment> targetTrackSegmentList = new ArrayList<TrackSegment>();
        for (TrackSegment ts : inputTrackSegmentList) {
            if (ts.getFirstDetection() == null || ts.getLastDetection() == null) {
                System.out.println("Warning, found and removed empty track segment");
                continue;
            }
            boolean skipTrackSegment = false;
            for (TrackSegment ts2 : ts.nextList) {
                if (ts2.getFirstDetection() != null && ts2.getLastDetection() != null) continue;
                skipTrackSegment = true;
                break;
            }
            if (skipTrackSegment) {
                System.out.println("Warning, found and removed empty track segment");
                continue;
            }
            targetTrackSegmentList.add(ts);
        }
        return targetTrackSegmentList;
    }

    public void moveTrackToIndex(TrackSegment ts, int index) {
    }

    public void removeLink(TrackSegment start, TrackSegment end) {
        start.nextList.remove(end);
        end.previousList.remove(start);
    }

    public void removeTrackProcessor(PluginTrackManagerProcessor tep) {
        this.trackManagerProcessorList.remove(tep);
        this.fireTrackEditorProcessorChange();
    }

    public void removeTrackProcessorListener(TrackManagerProcessorListener tepl) {
        this.trackEditorProcessorListener.remove(tepl);
    }

    public void selectAllTracks() {
        for (TrackSegment ts : this.getTrackSegmentList()) {
            ts.setAllDetectionSelected(true);
        }
        this.fireTrackEditorProcessorChange();
    }

    public void selectTracksByLength(int lowVal, int highVal) {
        for (TrackSegment ts : this.getTrackSegmentList()) {
            if (ts.getDetectionList().size() < lowVal || ts.getDetectionList().size() > highVal) continue;
            ts.setAllDetectionSelected(true);
        }
        this.fireTrackEditorProcessorChange();
    }

    public void unselectAllTracks() {
        for (TrackSegment ts : this.getTrackSegmentList()) {
            ts.setAllDetectionSelected(false);
        }
        this.fireTrackEditorProcessorChange();
    }

    public void invertSelection() {
        for (TrackSegment ts : this.getTrackSegmentList()) {
            for (Detection d : ts.getDetectionList()) {
                d.setSelected(!d.isSelected());
            }
        }
        this.fireTrackEditorProcessorChange();
    }

    public ArrayList<TrackSegment> splitTrackSegment(TrackSegment ts, int lastIndexOfFirstTrack, boolean CreateLinkBetweenSplittedTrack) {
        int i;
        TrackSegment ts1 = new TrackSegment();
        TrackSegment ts2 = new TrackSegment();
        for (i = 0; i < lastIndexOfFirstTrack + 1; ++i) {
            ts1.addDetection(ts.getDetectionAt(i));
        }
        ts1.previousList.addAll(ts.previousList);
        for (i = lastIndexOfFirstTrack + 1; i < ts.getDetectionList().size(); ++i) {
            ts2.addDetection(ts.getDetectionAt(i));
        }
        ts2.nextList.addAll(ts.nextList);
        for (TrackSegment tracksegment : this.getTrackSegmentList()) {
            for (TrackSegment tracksegmentprevious : tracksegment.previousList) {
                if (tracksegmentprevious != ts) continue;
                tracksegmentprevious = ts2;
            }
            for (TrackSegment tracksegmentnext : tracksegment.nextList) {
                if (tracksegmentnext != ts) continue;
                tracksegmentnext = ts1;
            }
        }
        if (CreateLinkBetweenSplittedTrack) {
            this.createLink(ts1, ts2);
        }
        int indexOfTs = ts.getOwnerTrackGroup().getTrackSegmentList().indexOf(ts);
        ts.getOwnerTrackGroup().getTrackSegmentList().add(indexOfTs, ts2);
        ts.getOwnerTrackGroup().getTrackSegmentList().add(indexOfTs, ts1);
        ts1.setOwnerTrackGroup(ts.getOwnerTrackGroup());
        ts2.setOwnerTrackGroup(ts.getOwnerTrackGroup());
        ts.getOwnerTrackGroup().getTrackSegmentList().remove(ts);
        ts = null;
        ArrayList<TrackSegment> trackSegmentReturnList = new ArrayList<TrackSegment>();
        trackSegmentReturnList.add(ts1);
        trackSegmentReturnList.add(ts2);
        return trackSegmentReturnList;
    }

    public ArrayList<TrackGroup> getTrackGroupList() {
        ArrayList<TrackGroup> trackGroupList = new ArrayList<TrackGroup>();
        for (SwimmingObject result : this.resultList) {
            trackGroupList.add((TrackGroup)result.getObject());
        }
        return trackGroupList;
    }

    public void addResult(SwimmingObject result) {
        if (!(result.getObject() instanceof TrackGroup)) {
            return;
        }
        this.resultList.add(result);
    }

    public void removeResult(SwimmingObject result) {
        if (result == null) {
            return;
        }
        this.resultList.remove(result);
        if (result.getObject() instanceof TrackGroup) {
            TrackGroup tg = (TrackGroup)result.getObject();
            for (TrackSegment ts : tg.getTrackSegmentList()) {
                ts.removeId();
            }
        }
    }

    public void removePainter() {
        List<Sequence> sequenceList = Icy.getMainInterface().getSequencesContaining(this.tePainter);
        for (Sequence sequence : sequenceList) {
            sequence.removeOverlay(this.tePainter);
        }
    }

    public int getTrackIndex(TrackSegment ts) {
        return this.getTrackSegmentList().indexOf(ts);
    }

    public int getLastDetectionTimePoint() {
        int maxT = 0;
        for (TrackGroup tg : this.getTrackGroupList()) {
            for (TrackSegment ts : tg.getTrackSegmentList()) {
                Detection d = ts.getLastDetection();
                if (d == null || d.getT() <= maxT) continue;
                maxT = d.getT();
            }
        }
        return maxT;
    }

    public int getTotalNumberOfTrack() {
        int total = 0;
        for (TrackGroup tg : this.getTrackGroupList()) {
            total += tg.getTrackSegmentList().size();
        }
        return total;
    }
}

