/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.canvas;

import icy.gui.component.IcyTextField;
import icy.gui.component.NumberTextField;
import icy.gui.component.button.ColorChooserButton;
import icy.gui.component.button.IcyToggleButton;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.vtk.VtkImageVolume;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class VtkSettingPanel
extends JPanel
implements ActionListener,
IcyTextField.TextChangeListener,
ColorChooserButton.ColorChangeListener {
    private static final long serialVersionUID = 6433369095311474470L;
    protected static final Image ICON_GPU = ResourceUtil.getAlphaIconAsImage("gpu.png");
    protected static final Image ICON_SHADING = ResourceUtil.getColorIconAsImage("shading.png");
    public static final String PROPERTY_BG_COLOR = "renderBGColor";
    public static final String PROPERTY_MAPPER = "volumeMapper";
    public static final String PROPERTY_BLENDING = "volumeBlending";
    public static final String PROPERTY_SAMPLE = "volumeSample";
    public static final String PROPERTY_INTERPOLATION = "volumeInterpolation";
    public static final String PROPERTY_SHADING = "shading";
    public static final String PROPERTY_AMBIENT = "volumeAmbient";
    public static final String PROPERTY_DIFFUSE = "volumeDiffuse";
    public static final String PROPERTY_SPECULAR = "volumeSpecular";
    private ColorChooserButton bgColorButton;
    private JCheckBox gpuMapperCheckBox;
    private JComboBox volumeBlendingComboBox;
    private JComboBox volumeSampleComboBox;
    private JComboBox volumeInterpolationComboBox;
    private IcyToggleButton shadingButton;
    private NumberTextField volumeAmbientField;
    private NumberTextField volumeSpecularField;
    private NumberTextField volumeDiffuseField;

    public VtkSettingPanel() {
        this.initialize();
        this.updateState();
        this.bgColorButton.addColorChangeListener(this);
        this.gpuMapperCheckBox.addActionListener(this);
        this.volumeBlendingComboBox.addActionListener(this);
        this.volumeInterpolationComboBox.addActionListener(this);
        this.volumeSampleComboBox.addActionListener(this);
        this.shadingButton.addActionListener(this);
        this.volumeAmbientField.addTextChangeListener(this);
        this.volumeDiffuseField.addTextChangeListener(this);
        this.volumeSpecularField.addTextChangeListener(this);
    }

    protected void initialize() {
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblBackground = new JLabel("Background color ");
        lblBackground.setToolTipText("Change background color");
        GridBagConstraints gbc_lblBackground = new GridBagConstraints();
        gbc_lblBackground.anchor = 17;
        gbc_lblBackground.insets = new Insets(0, 0, 5, 5);
        gbc_lblBackground.gridx = 0;
        gbc_lblBackground.gridy = 0;
        this.add((Component)lblBackground, gbc_lblBackground);
        this.bgColorButton = new ColorChooserButton();
        this.bgColorButton.setToolTipText("Change background color");
        GridBagConstraints gbc_bgColorButton = new GridBagConstraints();
        gbc_bgColorButton.anchor = 17;
        gbc_bgColorButton.insets = new Insets(0, 0, 5, 5);
        gbc_bgColorButton.gridx = 1;
        gbc_bgColorButton.gridy = 0;
        this.add((Component)this.bgColorButton, gbc_bgColorButton);
        this.gpuMapperCheckBox = new JCheckBox("New check box");
        this.gpuMapperCheckBox.setFocusable(false);
        this.gpuMapperCheckBox.setIconTextGap(8);
        this.gpuMapperCheckBox.setText("GPU rendering");
        this.gpuMapperCheckBox.setToolTipText("Enable GPU volume rendering");
        GridBagConstraints gbc_gpuMapperCheckBox = new GridBagConstraints();
        gbc_gpuMapperCheckBox.anchor = 13;
        gbc_gpuMapperCheckBox.gridwidth = 2;
        gbc_gpuMapperCheckBox.insets = new Insets(0, 0, 5, 0);
        gbc_gpuMapperCheckBox.gridx = 2;
        gbc_gpuMapperCheckBox.gridy = 0;
        this.add((Component)this.gpuMapperCheckBox, gbc_gpuMapperCheckBox);
        JLabel lblInterpolation = new JLabel("Interpolation  ");
        lblInterpolation.setToolTipText("Select volume rendering interpolation method");
        GridBagConstraints gbc_lblInterpolation = new GridBagConstraints();
        gbc_lblInterpolation.anchor = 17;
        gbc_lblInterpolation.insets = new Insets(0, 0, 5, 5);
        gbc_lblInterpolation.gridx = 0;
        gbc_lblInterpolation.gridy = 1;
        this.add((Component)lblInterpolation, gbc_lblInterpolation);
        this.volumeInterpolationComboBox = new JComboBox();
        this.volumeInterpolationComboBox.setToolTipText("Select volume rendering interpolation method");
        this.volumeInterpolationComboBox.setMaximumRowCount(7);
        this.volumeInterpolationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Nearest (Fast)", "Linear", "Cubic (Slow)"}));
        this.volumeInterpolationComboBox.setSelectedIndex(1);
        GridBagConstraints gbc_volumeInterpolationComboBox = new GridBagConstraints();
        gbc_volumeInterpolationComboBox.fill = 2;
        gbc_volumeInterpolationComboBox.gridwidth = 3;
        gbc_volumeInterpolationComboBox.insets = new Insets(0, 0, 5, 0);
        gbc_volumeInterpolationComboBox.gridx = 1;
        gbc_volumeInterpolationComboBox.gridy = 1;
        this.add((Component)this.volumeInterpolationComboBox, gbc_volumeInterpolationComboBox);
        JLabel lblBlending = new JLabel("Blending");
        lblBlending.setToolTipText("Select volume rendering blending method");
        GridBagConstraints gbc_lblBlending = new GridBagConstraints();
        gbc_lblBlending.anchor = 17;
        gbc_lblBlending.insets = new Insets(0, 0, 5, 5);
        gbc_lblBlending.gridx = 0;
        gbc_lblBlending.gridy = 2;
        this.add((Component)lblBlending, gbc_lblBlending);
        this.volumeBlendingComboBox = new JComboBox();
        this.volumeBlendingComboBox.setToolTipText("Select volume rendering blending method");
        this.volumeBlendingComboBox.setModel(new DefaultComboBoxModel<VtkImageVolume.VtkVolumeBlendType>(VtkImageVolume.VtkVolumeBlendType.values()));
        GridBagConstraints gbc_volumeBlendingComboBox = new GridBagConstraints();
        gbc_volumeBlendingComboBox.fill = 2;
        gbc_volumeBlendingComboBox.gridwidth = 3;
        gbc_volumeBlendingComboBox.insets = new Insets(0, 0, 5, 0);
        gbc_volumeBlendingComboBox.gridx = 1;
        gbc_volumeBlendingComboBox.gridy = 2;
        this.add((Component)this.volumeBlendingComboBox, gbc_volumeBlendingComboBox);
        JLabel lblSample = new JLabel("Sample");
        lblSample.setToolTipText("Set volume sample resolution (raycaster mapper only)");
        GridBagConstraints gbc_lblSample = new GridBagConstraints();
        gbc_lblSample.anchor = 17;
        gbc_lblSample.insets = new Insets(0, 0, 5, 5);
        gbc_lblSample.gridx = 0;
        gbc_lblSample.gridy = 3;
        this.add((Component)lblSample, gbc_lblSample);
        this.volumeSampleComboBox = new JComboBox();
        this.volumeSampleComboBox.setToolTipText("Use low value for fine (but slow) rendering and high value for fast (but coarse) rendering");
        this.volumeSampleComboBox.setMaximumRowCount(11);
        this.volumeSampleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Auto", "1 (Slow)", "2", "3", "4", "5", "6", "7", "8", "9", "10 (Fast)"}));
        this.volumeSampleComboBox.setSelectedIndex(0);
        GridBagConstraints gbc_volumeSampleComboBox = new GridBagConstraints();
        gbc_volumeSampleComboBox.fill = 2;
        gbc_volumeSampleComboBox.gridwidth = 3;
        gbc_volumeSampleComboBox.insets = new Insets(0, 0, 5, 0);
        gbc_volumeSampleComboBox.gridx = 1;
        gbc_volumeSampleComboBox.gridy = 3;
        this.add((Component)this.volumeSampleComboBox, gbc_volumeSampleComboBox);
        this.shadingButton = new IcyToggleButton(new IcyIcon(ICON_SHADING, false));
        this.shadingButton.setIconTextGap(8);
        this.shadingButton.setText("Shading");
        this.shadingButton.setFocusable(false);
        this.shadingButton.setToolTipText("Enable volume shading");
        GridBagConstraints gbc_shadingBtn = new GridBagConstraints();
        gbc_shadingBtn.anchor = 17;
        gbc_shadingBtn.insets = new Insets(0, 0, 0, 5);
        gbc_shadingBtn.gridx = 0;
        gbc_shadingBtn.gridy = 4;
        this.add((Component)this.shadingButton, gbc_shadingBtn);
        this.volumeAmbientField = new NumberTextField();
        this.volumeAmbientField.setToolTipText("Ambient lighting coefficient");
        GridBagConstraints gbc_volumeAmbientField = new GridBagConstraints();
        gbc_volumeAmbientField.fill = 2;
        gbc_volumeAmbientField.insets = new Insets(0, 0, 0, 5);
        gbc_volumeAmbientField.gridx = 1;
        gbc_volumeAmbientField.gridy = 4;
        this.add((Component)this.volumeAmbientField, gbc_volumeAmbientField);
        this.volumeAmbientField.setColumns(3);
        this.volumeDiffuseField = new NumberTextField();
        this.volumeDiffuseField.setToolTipText("Diffuse lighting coefficient");
        GridBagConstraints gbc_volumeDiffuseField = new GridBagConstraints();
        gbc_volumeDiffuseField.insets = new Insets(0, 0, 0, 5);
        gbc_volumeDiffuseField.fill = 2;
        gbc_volumeDiffuseField.gridx = 2;
        gbc_volumeDiffuseField.gridy = 4;
        this.add((Component)this.volumeDiffuseField, gbc_volumeDiffuseField);
        this.volumeDiffuseField.setColumns(3);
        this.volumeSpecularField = new NumberTextField();
        this.volumeSpecularField.setToolTipText("Specular lighting coefficient");
        GridBagConstraints gbc_volumeSpecularField = new GridBagConstraints();
        gbc_volumeSpecularField.fill = 2;
        gbc_volumeSpecularField.gridx = 3;
        gbc_volumeSpecularField.gridy = 4;
        this.add((Component)this.volumeSpecularField, gbc_volumeSpecularField);
        this.volumeSpecularField.setColumns(3);
    }

    protected void updateState() {
    }

    public Color getBackgroundColor() {
        return this.bgColorButton.getColor();
    }

    public void setBackgroundColor(Color value) {
        this.bgColorButton.setColor(value);
    }

    public boolean getGPURendering() {
        return this.gpuMapperCheckBox.isSelected();
    }

    public void setGPURendering(boolean value) {
        this.gpuMapperCheckBox.setSelected(value);
    }

    public int getVolumeInterpolation() {
        return this.volumeInterpolationComboBox.getSelectedIndex();
    }

    public void setVolumeInterpolation(int value) {
        this.volumeInterpolationComboBox.setSelectedIndex(value);
    }

    public VtkImageVolume.VtkVolumeBlendType getVolumeBlendingMode() {
        if (this.volumeBlendingComboBox.getSelectedIndex() == -1) {
            return null;
        }
        return (VtkImageVolume.VtkVolumeBlendType)((Object)this.volumeBlendingComboBox.getSelectedItem());
    }

    public void setVolumeBlendingMode(VtkImageVolume.VtkVolumeBlendType value) {
        this.volumeBlendingComboBox.setSelectedItem((Object)value);
    }

    public int getVolumeSample() {
        return this.volumeSampleComboBox.getSelectedIndex();
    }

    public void setVolumeSample(int value) {
        this.volumeSampleComboBox.setSelectedIndex(value);
    }

    public double getVolumeAmbient() {
        return this.volumeAmbientField.getNumericValue();
    }

    public void setVolumeAmbient(double value) {
        this.volumeAmbientField.setNumericValue(value);
    }

    public double getVolumeDiffuse() {
        return this.volumeDiffuseField.getNumericValue();
    }

    public void setVolumeDiffuse(double value) {
        this.volumeDiffuseField.setNumericValue(value);
    }

    public double getVolumeSpecular() {
        return this.volumeSpecularField.getNumericValue();
    }

    public void setVolumeSpecular(double value) {
        this.volumeSpecularField.setNumericValue(value);
    }

    public boolean getVolumeShading() {
        return this.shadingButton.isSelected();
    }

    public void setVolumeShading(boolean value) {
        if (this.shadingButton.isSelected() != value) {
            this.shadingButton.doClick();
        }
    }

    public void addSettingChangeListener(SettingChangeListener listener) {
        this.listenerList.add(SettingChangeListener.class, listener);
    }

    public void removeSettingChangeListener(SettingChangeListener listener) {
        this.listenerList.remove(SettingChangeListener.class, listener);
    }

    public void fireSettingChange(Object source, String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        SettingChangeListener[] listeners = (SettingChangeListener[])this.getListeners(SettingChangeListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].settingChange(event);
        }
    }

    @Override
    public void colorChanged(ColorChooserButton source) {
        if (source == this.bgColorButton) {
            this.fireSettingChange(source, PROPERTY_BG_COLOR, null, source.getColor());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.gpuMapperCheckBox) {
            this.fireSettingChange(source, PROPERTY_MAPPER, !this.gpuMapperCheckBox.isSelected(), this.gpuMapperCheckBox.isSelected());
            if (this.gpuMapperCheckBox.isSelected()) {
                this.setVolumeSample(1);
            } else if (this.getVolumeSample() == 1) {
                this.setVolumeSample(0);
            }
        } else if (source == this.volumeBlendingComboBox) {
            this.fireSettingChange(source, PROPERTY_BLENDING, null, this.volumeBlendingComboBox.getSelectedItem());
        } else if (source == this.volumeSampleComboBox) {
            this.fireSettingChange(source, PROPERTY_SAMPLE, -1, this.volumeSampleComboBox.getSelectedIndex());
        } else if (source == this.volumeInterpolationComboBox) {
            this.fireSettingChange(source, PROPERTY_INTERPOLATION, -1, this.volumeInterpolationComboBox.getSelectedIndex());
        } else if (source == this.shadingButton) {
            this.fireSettingChange(source, PROPERTY_SHADING, -1, this.shadingButton.isSelected());
        }
        this.updateState();
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        if (!validate) {
            return;
        }
        if (source == this.volumeAmbientField) {
            this.fireSettingChange(source, PROPERTY_AMBIENT, -1.0, this.volumeAmbientField.getNumericValue());
        } else if (source == this.volumeDiffuseField) {
            this.fireSettingChange(source, PROPERTY_DIFFUSE, -1.0, this.volumeDiffuseField.getNumericValue());
        } else if (source == this.volumeSpecularField) {
            this.fireSettingChange(source, PROPERTY_SPECULAR, -1.0, this.volumeSpecularField.getNumericValue());
        }
        this.updateState();
    }

    public static interface SettingChangeListener
    extends EventListener {
        public void settingChange(PropertyChangeEvent var1);
    }
}

