/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.canvas.IcyCanvas;
import icy.painter.Anchor2D;
import icy.painter.LineAnchor2D;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.type.point.Point2DUtil;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ROI2DLine
extends ROI2DShape {
    public static final String ID_PT1 = "pt1";
    public static final String ID_PT2 = "pt2";
    protected final Anchor2D pt1;
    protected final Anchor2D pt2;

    public ROI2DLine(Point2D pt1, Point2D pt2) {
        super(new Line2D.Double());
        this.pt1 = this.createAnchor(pt1);
        this.pt2 = this.createAnchor(pt2);
        this.pt2.setSelected(true);
        this.addPoint(this.pt1);
        this.addPoint(this.pt2);
        this.setIcon(ResourceUtil.ICON_ROI_LINE);
    }

    public ROI2DLine(Line2D line) {
        this(line.getP1(), line.getP2());
    }

    @Deprecated
    public ROI2DLine(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DLine(Point2D pt) {
        this((Point2D)new Point2D.Double(pt.getX(), pt.getY()), pt);
    }

    public ROI2DLine(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DLine(double x1, double y1, double x2, double y2) {
        this((Point2D)new Point2D.Double(x1, y1), new Point2D.Double(x2, y2));
    }

    public ROI2DLine() {
        this((Point2D)new Point2D.Double(), new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Line2D";
    }

    @Override
    protected ROI2DShape.ROI2DShapePainter createPainter() {
        return new ROI2DLinePainter();
    }

    @Override
    protected Anchor2D createAnchor(Point2D pos) {
        return new ROI2DLineAnchor2D(pos);
    }

    public Line2D getLine() {
        return (Line2D)this.shape;
    }

    @Override
    public boolean canSetBounds() {
        return true;
    }

    @Override
    public void setBounds2D(Rectangle2D bounds) {
        this.beginUpdate();
        try {
            this.pt1.setPosition(bounds.getMinX(), bounds.getMinY());
            this.pt2.setPosition(bounds.getMaxX(), bounds.getMaxY());
        }
        finally {
            this.endUpdate();
        }
    }

    public void setLine(Line2D line) {
        this.beginUpdate();
        try {
            this.pt1.setPosition(line.getP1());
            this.pt2.setPosition(line.getP2());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void updateShape() {
        this.getLine().setLine(this.pt1.getPosition(), this.pt2.getPosition());
        super.updateShape();
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    public boolean canRemovePoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor2D pt) {
        return false;
    }

    @Override
    protected double getTotalDistance(List<Point2D> points, double factorX, double factorY) {
        return Point2DUtil.getTotalDistance(points, factorX, factorY, false);
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    @Override
    public boolean intersects(ROI r) throws InterruptedException {
        if (r instanceof ROI2DLine) {
            return this.onSamePos((ROI2DLine)r, false) && ((ROI2DLine)r).getLine().intersectsLine(this.getLine());
        }
        if (r instanceof ROI2DRectangle) {
            return this.onSamePos((ROI2DRectangle)r, false) && ((ROI2DRectangle)r).getRectangle().intersectsLine(this.getLine());
        }
        return super.intersects(r);
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.pt1.loadPositionFromXML(XMLUtil.getElement(node, ID_PT1));
            this.pt2.loadPositionFromXML(XMLUtil.getElement(node, ID_PT2));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.pt1.savePositionToXML(XMLUtil.setElement(node, ID_PT1));
        this.pt2.savePositionToXML(XMLUtil.setElement(node, ID_PT2));
        return true;
    }

    public class ROI2DLinePainter
    extends ROI2DShape.ROI2DShapePainter {
        @Override
        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI2DLine.this.isSelected()) {
                return false;
            }
            return super.isTiny(bounds, g, canvas);
        }
    }

    protected class ROI2DLineAnchor2D
    extends LineAnchor2D {
        public ROI2DLineAnchor2D(Point2D position) {
            super(position, ROI2DLine.this.getOverlay().getColor(), ROI2DLine.this.getOverlay().getFocusedColor());
        }

        @Override
        protected Anchor2D getPreviousPoint() {
            if (this == ROI2DLine.this.pt1) {
                return ROI2DLine.this.pt2;
            }
            return ROI2DLine.this.pt1;
        }
    }
}

