/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.cages;

import icy.gui.frame.IcyFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.tools.JComponents.TableModelCage;

public class InfosTable
extends JPanel {
    private static final long serialVersionUID = 7599620793495187279L;
    IcyFrame dialogFrame = null;
    private JTable tableView = new JTable();
    private TableModelCage viewModel = null;
    private JButton copyButton = new JButton("Copy table");
    private JButton pasteButton = new JButton("Paste");
    private JButton duplicateAllButton = new JButton("Duplicate cell to all");
    private MultiSPOTS parent0 = null;
    private List<Cage> cageArrayCopy = null;

    public void initialize(MultiSPOTS parent0, List<Cage> cageCopy) {
        this.parent0 = parent0;
        this.cageArrayCopy = cageCopy;
        this.viewModel = new TableModelCage(parent0.expListCombo);
        this.tableView.setModel(this.viewModel);
        this.tableView.setPreferredScrollableViewportSize(new Dimension(500, 400));
        this.tableView.setFillsViewportHeight(true);
        TableColumnModel columnModel = this.tableView.getColumnModel();
        for (int i = 0; i < 2; ++i) {
            this.setFixedColumnProperties(columnModel.getColumn(i));
        }
        JScrollPane scrollPane = new JScrollPane(this.tableView);
        JPanel topPanel = new JPanel(new GridLayout(2, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.copyButton);
        panel1.add(this.pasteButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.duplicateAllButton);
        topPanel.add(panel2);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Cages properties", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.center();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.pasteButton.setEnabled(this.cageArrayCopy.size() > 0);
    }

    private void defineActionListeners() {
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosTable)InfosTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    InfosTable.this.cageArrayCopy.clear();
                    for (Cage cage : exp.cagesArray.cagesList) {
                        InfosTable.this.cageArrayCopy.add(cage);
                    }
                    InfosTable.this.pasteButton.setEnabled(true);
                }
            }
        });
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosTable)InfosTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    for (Cage cageFrom : InfosTable.this.cageArrayCopy) {
                        cageFrom.valid = false;
                        for (Cage cageTo : exp.cagesArray.cagesList) {
                            if (!cageFrom.getRoi().getName().equals(cageTo.getRoi().getName())) continue;
                            cageFrom.valid = true;
                            cageTo.cageNFlies = cageFrom.cageNFlies;
                            cageTo.cageAge = cageFrom.cageAge;
                            cageTo.strCageComment = cageFrom.strCageComment;
                            cageTo.strCageSex = cageFrom.strCageSex;
                            cageTo.strCageStrain = cageFrom.strCageStrain;
                        }
                    }
                    InfosTable.this.viewModel.fireTableDataChanged();
                }
            }
        });
        this.duplicateAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((InfosTable)InfosTable.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    int rowIndex = InfosTable.this.tableView.getSelectedRow();
                    int columnIndex = InfosTable.this.tableView.getSelectedColumn();
                    if (rowIndex >= 0) {
                        Cage cage0 = exp.cagesArray.cagesList.get(rowIndex);
                        for (Cage cage : exp.cagesArray.cagesList) {
                            if (cage.getRoi().getName().equals(cage0.getRoi().getName())) continue;
                            switch (columnIndex) {
                                case 1: {
                                    cage.cageNFlies = cage0.cageNFlies;
                                    break;
                                }
                                case 2: {
                                    cage.strCageStrain = cage0.strCageStrain;
                                    break;
                                }
                                case 3: {
                                    cage.strCageSex = cage0.strCageSex;
                                    break;
                                }
                                case 4: {
                                    cage.cageAge = cage0.cageAge;
                                    break;
                                }
                                case 5: {
                                    cage.strCageComment = cage0.strCageComment;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    void close() {
        this.dialogFrame.close();
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            exp.cagesArray.transferNFliesFromCagesToSpots(exp.spotsArray);
            this.parent0.dlgSpots.tabFile.saveSpotsArray_file(exp);
        }
    }

    private void setFixedColumnProperties(TableColumn column) {
        column.setResizable(false);
        column.setPreferredWidth(50);
        column.setMaxWidth(50);
        column.setMinWidth(30);
    }
}

