/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.cages;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.FontUtil;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;

public class LoadSaveCages
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton openCagesButton = new JButton("Load...");
    private JButton saveCagesButton = new JButton("Save...");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(2);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        JLabel loadsaveText = new JLabel("-> File (xml) ", 4);
        loadsaveText.setFont(FontUtil.setStyle((Font)loadsaveText.getFont(), (int)2));
        panel1.add(loadsaveText);
        panel1.add(this.openCagesButton);
        panel1.add(this.saveCagesButton);
        panel1.validate();
        this.add(panel1);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.openCagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCages)LoadSaveCages.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCages.this.loadCages(exp);
                    LoadSaveCages.this.firePropertyChange("LOAD_DATA", false, true);
                }
            }
        });
        this.saveCagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((LoadSaveCages)LoadSaveCages.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    LoadSaveCages.this.saveCages(exp);
                }
            }
        });
    }

    public boolean loadCages(Experiment exp) {
        if (exp == null) {
            return false;
        }
        ProgressFrame progress = new ProgressFrame("load cages");
        boolean flag = exp.load_Cages();
        if (flag) {
            exp.cagesArray.transferCagesToSequenceAsROIs(exp.seqCamData.seq);
        }
        progress.close();
        return flag;
    }

    public void saveCages(Experiment exp) {
        if (exp != null) {
            exp.cagesArray.transferROIsFromSequenceToCages(exp.seqCamData.seq);
            exp.save_CagesMeasures();
        }
    }
}

