/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.excel;

import icy.gui.component.PopupPanel;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.excel.Options;
import plugins.fmp.multiSPOTS.dlg.excel.SpotsAreas;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.tools.JComponents.Dialog;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportOptions;
import plugins.fmp.multiSPOTS.tools.toExcel.XLSExportSpotMeasures;

public class _DlgExcel_
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -4296207607692017074L;
    public PopupPanel capPopupPanel = null;
    private JTabbedPane tabsPane = new JTabbedPane();
    public Options tabCommonOptions = new Options();
    private SpotsAreas tabAreas = new SpotsAreas();
    private MultiSPOTS parent0 = null;

    public void init(JPanel mainPanel, String string, final MultiSPOTS parent0) {
        this.parent0 = parent0;
        this.capPopupPanel = new PopupPanel(string);
        JPanel capPanel = this.capPopupPanel.getMainPanel();
        capPanel.setLayout(new BorderLayout());
        this.capPopupPanel.collapse();
        mainPanel.add((Component)this.capPopupPanel);
        GridLayout capLayout = new GridLayout(3, 2);
        this.tabCommonOptions.init(capLayout);
        this.tabsPane.addTab("Common options", null, this.tabCommonOptions, "Define common options");
        this.tabCommonOptions.addPropertyChangeListener(this);
        this.tabAreas.init(capLayout);
        this.tabsPane.addTab("Spots", null, this.tabAreas, "Export measures made on spots to file");
        this.tabAreas.addPropertyChangeListener(this);
        capPanel.add(this.tabsPane);
        this.tabsPane.setSelectedIndex(0);
        this.capPopupPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                parent0.mainFrame.revalidate();
                parent0.mainFrame.pack();
                parent0.mainFrame.repaint();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        if (evt.getPropertyName().equals("EXPORT_SPOTSMEASURES")) {
            final String file = this.defineXlsFileName(exp, "_spotsareas.xlsx");
            if (file == null) {
                return;
            }
            this.updateParametersCurrentExperiment(exp);
            ThreadUtil.bgRun((Runnable)new Runnable(){

                @Override
                public void run() {
                    XLSExportSpotMeasures xlsExport2 = new XLSExportSpotMeasures();
                    xlsExport2.exportToFile(file, _DlgExcel_.this.getLevelsOptions());
                }
            });
        }
    }

    private String defineXlsFileName(Experiment exp, String pattern) {
        String filename0 = exp.seqCamData.getFileNameFromImageList(0);
        Path directory = Paths.get(filename0, new String[0]).getParent();
        Path subpath = directory.getName(directory.getNameCount() - 1);
        String tentativeName = subpath.toString() + pattern;
        return Dialog.saveFileAs(tentativeName, directory.getParent().toString(), "xlsx");
    }

    private void updateParametersCurrentExperiment(Experiment exp) {
        this.parent0.dlgExperiment.tabInfos.getExperimentInfosFromDialog(exp);
    }

    private XLSExportOptions getLevelsOptions() {
        XLSExportOptions options = new XLSExportOptions();
        options.spotAreas = true;
        options.sum = this.tabAreas.sumCheckBox.isSelected();
        options.nPixels = this.tabAreas.nPixelsCheckBox.isSelected();
        options.lrPI = this.tabAreas.lrPICheckBox.isSelected();
        options.lrPIThreshold = (Double)this.tabAreas.lrPIThresholdJSpinner.getValue();
        options.sumPerCage = this.tabAreas.sumPerCageCheckBox.isSelected();
        options.relativeToT0 = this.tabAreas.t0CheckBox.isSelected();
        options.subtractEvaporation = false;
        this.getCommonOptions(options);
        return options;
    }

    private void getCommonOptions(XLSExportOptions options) {
        options.transpose = this.tabCommonOptions.transposeCheckBox.isSelected();
        options.buildExcelStepMs = this.tabCommonOptions.getExcelBuildStep();
        options.buildExcelUnitMs = this.tabCommonOptions.binUnit.getMsUnitValue();
        options.fixedIntervals = this.tabCommonOptions.isFixedFrameButton.isSelected();
        options.startAll_Ms = this.tabCommonOptions.getStartAllMs();
        options.endAll_Ms = this.tabCommonOptions.getEndAllMs();
        options.collateSeries = this.tabCommonOptions.collateSeriesCheckBox.isSelected();
        options.padIntervals = this.tabCommonOptions.padIntervalsCheckBox.isSelected();
        options.absoluteTime = false;
        options.onlyalive = this.tabCommonOptions.onlyAliveCheckBox.isSelected();
        options.exportAllFiles = this.tabCommonOptions.exportAllFilesCheckBox.isSelected();
        options.expList = this.parent0.expListCombo;
        if (this.tabCommonOptions.exportAllFilesCheckBox.isSelected()) {
            options.experimentIndexFirst = 0;
            options.experimentIndexLast = options.expList.getItemCount() - 1;
        } else {
            options.experimentIndexFirst = this.parent0.expListCombo.getSelectedIndex();
            options.experimentIndexLast = this.parent0.expListCombo.getSelectedIndex();
        }
    }
}

