/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.experiment;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ExperimentDirectories;
import plugins.fmp.multiSPOTS.tools.JComponents.JComboBoxMs;

public class Intervals
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = -5739112045358747277L;
    Long val = 1L;
    Long min = 0L;
    Long max = 10000L;
    Long step = 1L;
    Long maxLast = 99999999L;
    JSpinner indexFirstImageJSpinner = new JSpinner(new SpinnerNumberModel(this.val, this.min, this.max, this.step));
    JComboBox<String> clipNumberImagesCombo = new JComboBox<String>(new String[]{"up to last frame acquired", "clip number of frames to"});
    JSpinner fixedNumberOfImagesJSpinner = new JSpinner(new SpinnerNumberModel(this.maxLast, this.step, this.maxLast, this.step));
    JSpinner binSizeJSpinner = new JSpinner(new SpinnerNumberModel(1.0, 0.0, 1000.0, 1.0));
    JComboBoxMs binUnit = new JComboBoxMs();
    JButton applyButton = new JButton("Apply changes");
    JButton refreshButton = new JButton("Refresh");
    private MultiSPOTS parent0 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        int bWidth = 50;
        int bHeight = 21;
        Dimension dimension = new Dimension(bWidth, bHeight);
        this.indexFirstImageJSpinner.setPreferredSize(dimension);
        this.binSizeJSpinner.setPreferredSize(dimension);
        this.fixedNumberOfImagesJSpinner.setPreferredSize(dimension);
        FlowLayout layout1 = new FlowLayout(0);
        layout1.setVgap(1);
        JPanel panel0 = new JPanel(layout1);
        panel0.add(new JLabel("Frame:", 4));
        panel0.add(this.indexFirstImageJSpinner);
        panel0.add(this.clipNumberImagesCombo);
        panel0.add(this.fixedNumberOfImagesJSpinner);
        this.add(panel0);
        JPanel panel1 = new JPanel(layout1);
        panel1.add(new JLabel("Time between frames ", 4));
        panel1.add(this.binSizeJSpinner);
        panel1.add(this.binUnit);
        this.add(panel1);
        panel1.add(this.refreshButton);
        panel1.add(this.applyButton);
        this.fixedNumberOfImagesJSpinner.setVisible(false);
        this.defineActionListeners();
        this.clipNumberImagesCombo.addItemListener(this);
    }

    private void defineActionListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.setExperimentParameters(exp);
                }
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Intervals.this.refreshBinSize(exp);
                }
            }
        });
        this.indexFirstImageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                long newValue = (Long)Intervals.this.indexFirstImageJSpinner.getValue();
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null && exp.seqCamData.absoluteIndexFirstImage != newValue) {
                    exp.seqCamData.absoluteIndexFirstImage = newValue;
                    List<String> imagesList = ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.imagesDirectory, "jpg");
                    exp.seqCamData.loadImageList(imagesList);
                    long bin_ms = exp.seqCamData.binImage_ms;
                    exp.seqCamData.binFirst_ms = exp.seqCamData.absoluteIndexFirstImage * bin_ms;
                    exp.saveXML_MCExperiment();
                }
            }
        });
        this.fixedNumberOfImagesJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                long newValue = (Long)Intervals.this.fixedNumberOfImagesJSpinner.getValue();
                if (exp != null && exp.seqCamData.fixedNumberOfImages != newValue) {
                    exp.seqCamData.fixedNumberOfImages = newValue;
                    ArrayList imagesList = (ArrayList)ExperimentDirectories.getImagesListFromPathV2(exp.seqCamData.imagesDirectory, "jpg");
                    exp.seqCamData.loadImageList(imagesList);
                    long bin_ms = exp.seqCamData.binImage_ms;
                    exp.seqCamData.binLast_ms = ((Long)Intervals.this.fixedNumberOfImagesJSpinner.getValue() - exp.seqCamData.absoluteIndexFirstImage) * bin_ms;
                }
            }
        });
        this.binSizeJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((Intervals)Intervals.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    long bin_ms;
                    exp.seqCamData.binImage_ms = bin_ms = (long)((Double)Intervals.this.binSizeJSpinner.getValue() * (double)Intervals.this.binUnit.getMsUnitValue());
                    exp.seqCamData.binFirst_ms = exp.seqCamData.absoluteIndexFirstImage * bin_ms;
                    exp.seqCamData.binLast_ms = (exp.seqCamData.fixedNumberOfImages - 1L) * bin_ms;
                }
            }
        });
    }

    private void setExperimentParameters(Experiment exp) {
        long bin_ms = exp.seqCamData.binImage_ms = (long)((Double)this.binSizeJSpinner.getValue() * (double)this.binUnit.getMsUnitValue());
        exp.seqCamData.absoluteIndexFirstImage = (Long)this.indexFirstImageJSpinner.getValue();
        exp.seqCamData.binFirst_ms = exp.seqCamData.absoluteIndexFirstImage * bin_ms;
        exp.seqCamData.binLast_ms = exp.seqCamData.fixedNumberOfImages > 0L ? (exp.seqCamData.fixedNumberOfImages - 1L) * bin_ms : (long)(exp.seqCamData.nTotalFrames - 1) * bin_ms;
    }

    public void getExptParms(Experiment exp) {
        this.refreshBinSize(exp);
        long bin_ms = exp.seqCamData.binImage_ms;
        long dFirst = exp.seqCamData.absoluteIndexFirstImage;
        this.indexFirstImageJSpinner.setValue(dFirst);
        if (exp.seqCamData.binLast_ms <= 0L) {
            exp.seqCamData.binLast_ms = (long)(exp.seqCamData.nTotalFrames - 1) * bin_ms;
        }
        this.fixedNumberOfImagesJSpinner.setValue(exp.seqCamData.fixedNumberOfImages);
    }

    private void refreshBinSize(Experiment exp) {
        exp.loadFileIntervalsFromSeqCamData();
        this.binUnit.setSelectedIndex(1);
        this.binSizeJSpinner.setValue((double)exp.seqCamData.binImage_ms / (double)this.binUnit.getMsUnitValue());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Experiment exp;
        Object source;
        if (e.getStateChange() == 1 && (source = e.getSource()) instanceof JComboBox && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            boolean clipped = this.clipNumberImagesCombo.getSelectedIndex() == 1;
            this.fixedNumberOfImagesJSpinner.setVisible(clipped);
            if (!clipped) {
                this.fixedNumberOfImagesJSpinner.setValue(-1L);
            } else {
                this.fixedNumberOfImagesJSpinner.setValue(exp.seqCamData.nTotalFrames);
            }
        }
    }
}

