/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.flies;

import icy.painter.Overlay;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.series.FlyDetect1;
import plugins.fmp.multiSPOTS.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.overlay.OverlayThreshold;

public class Detect1
extends JPanel
implements ChangeListener,
ItemListener,
PropertyChangeListener,
PopupMenuListener {
    private static final long serialVersionUID = 6066671006689527651L;
    private MultiSPOTS parent0 = null;
    private String detectString = "Detect...";
    private JButton startComputationButton = new JButton(this.detectString);
    private JSpinner nFliesPresentSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 255, 1));
    JComboBox<ImageTransformEnums> transformComboBox = new JComboBox<ImageTransformEnums>(new ImageTransformEnums[]{ImageTransformEnums.R_RGB, ImageTransformEnums.G_RGB, ImageTransformEnums.B_RGB, ImageTransformEnums.R2MINUS_GB, ImageTransformEnums.G2MINUS_RB, ImageTransformEnums.B2MINUS_RG, ImageTransformEnums.NORM_BRMINUSG, ImageTransformEnums.RGB, ImageTransformEnums.H_HSB, ImageTransformEnums.S_HSB, ImageTransformEnums.B_HSB});
    private JComboBox<ImageTransformEnums> backgroundComboBox = new JComboBox<ImageTransformEnums>(new ImageTransformEnums[]{ImageTransformEnums.NONE, ImageTransformEnums.SUBTRACT_TM1, ImageTransformEnums.SUBTRACT_T0});
    private JComboBox<String> allCagesComboBox = new JComboBox<String>(new String[]{"all cages"});
    private JSpinner thresholdSpinner = new JSpinner(new SpinnerNumberModel(60, 0, 255, 1));
    private JSpinner jitterTextField = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    private JSpinner objectLowsizeSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 9999, 1));
    private JSpinner objectUpsizeSpinner = new JSpinner(new SpinnerNumberModel(500, 0, 9999, 1));
    private JCheckBox objectLowsizeCheckBox = new JCheckBox("object > ");
    private JCheckBox objectUpsizeCheckBox = new JCheckBox("object < ");
    private JSpinner limitRatioSpinner = new JSpinner(new SpinnerNumberModel(4, 0, 1000, 1));
    private JCheckBox whiteObjectCheckBox = new JCheckBox("white object");
    JCheckBox overlayCheckBox = new JCheckBox("overlay");
    private JCheckBox allCheckBox = new JCheckBox("ALL (current to last)", false);
    private OverlayThreshold overlayThreshold1 = null;
    private FlyDetect1 flyDetect1 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.startComputationButton);
        panel1.add(this.allCagesComboBox);
        panel1.add(this.allCheckBox);
        panel1.add(new JLabel("n flies "));
        panel1.add(this.nFliesPresentSpinner);
        this.add(panel1);
        this.allCagesComboBox.addPopupMenuListener(this);
        JPanel panel2 = new JPanel(flowLayout);
        this.transformComboBox.setSelectedIndex(1);
        panel2.add(new JLabel("source ", 4));
        panel2.add(this.transformComboBox);
        panel2.add(new JLabel("bkgnd ", 4));
        panel2.add(this.backgroundComboBox);
        panel2.add(new JLabel("threshold ", 4));
        panel2.add(this.thresholdSpinner);
        this.add(panel2);
        this.objectLowsizeCheckBox.setHorizontalAlignment(4);
        this.objectUpsizeCheckBox.setHorizontalAlignment(4);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.objectLowsizeCheckBox);
        panel3.add(this.objectLowsizeSpinner);
        panel3.add(this.objectUpsizeCheckBox);
        panel3.add(this.objectUpsizeSpinner);
        panel3.add(this.whiteObjectCheckBox);
        this.add(panel3);
        JPanel panel4 = new JPanel(flowLayout);
        panel4.add(new JLabel("length/width<", 4));
        panel4.add(this.limitRatioSpinner);
        panel4.add(new JLabel("         jitter <= ", 4));
        panel4.add(this.jitterTextField);
        panel4.add(this.overlayCheckBox);
        this.add(panel4);
        this.defineActionListeners();
        this.thresholdSpinner.addChangeListener(this);
        this.transformComboBox.addItemListener(this);
    }

    private void defineActionListeners() {
        this.overlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Detect1)Detect1.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Detect1.this.overlayCheckBox.isSelected()) {
                        if (Detect1.this.overlayThreshold1 == null) {
                            Detect1.this.overlayThreshold1 = new OverlayThreshold(exp.seqCamData.seq);
                        }
                        exp.seqCamData.seq.addOverlay((Overlay)Detect1.this.overlayThreshold1);
                        Detect1.this.updateOverlay(exp);
                    } else {
                        Detect1.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Detect1.this.startComputationButton.getText().equals(Detect1.this.detectString)) {
                    Detect1.this.startComputation();
                } else {
                    Detect1.this.stopComputation();
                }
            }
        });
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Detect1.this.allCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Detect1.this.allCheckBox.setForeground(color);
                Detect1.this.startComputationButton.setForeground(color);
            }
        });
    }

    public void updateOverlay(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData == null) {
            return;
        }
        if (this.overlayThreshold1 == null) {
            this.overlayThreshold1 = new OverlayThreshold(seqCamData.seq);
        } else {
            seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold1);
            this.overlayThreshold1.setSequence(seqCamData.seq);
        }
        seqCamData.seq.addOverlay((Overlay)this.overlayThreshold1);
        boolean ifGreater = true;
        ImageTransformEnums transformOp = (ImageTransformEnums)((Object)this.transformComboBox.getSelectedItem());
        this.overlayThreshold1.setThresholdSingle(exp.cagesArray.detect_threshold, transformOp, ifGreater);
        this.overlayThreshold1.painterChanged();
    }

    public void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Experiment exp;
        if (e.getSource() == this.thresholdSpinner && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            exp.cagesArray.detect_threshold = (Integer)this.thresholdSpinner.getValue();
            this.updateOverlay(exp);
        }
    }

    private BuildSeriesOptions initTrackParameters() {
        BuildSeriesOptions options = new BuildSeriesOptions();
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.btrackWhite = this.whiteObjectCheckBox.isSelected();
        options.blimitLow = this.objectLowsizeCheckBox.isSelected();
        options.blimitUp = this.objectUpsizeCheckBox.isSelected();
        options.limitLow = (Integer)this.objectLowsizeSpinner.getValue();
        options.limitUp = (Integer)this.objectUpsizeSpinner.getValue();
        options.limitRatio = (Integer)this.limitRatioSpinner.getValue();
        options.jitter = (Integer)this.jitterTextField.getValue();
        options.videoChannel = 0;
        options.transformop = (ImageTransformEnums)((Object)this.transformComboBox.getSelectedItem());
        options.nFliesPresent = (Integer)this.nFliesPresentSpinner.getValue();
        options.transformop = (ImageTransformEnums)((Object)this.backgroundComboBox.getSelectedItem());
        options.threshold = (Integer)this.thresholdSpinner.getValue();
        options.isFrameFixed = this.parent0.dlgExcel.tabCommonOptions.getIsFixedFrame();
        options.t_Ms_First = this.parent0.dlgExcel.tabCommonOptions.getStartMs();
        options.t_Ms_Last = this.parent0.dlgExcel.tabCommonOptions.getEndMs();
        options.t_Ms_BinDuration = this.parent0.dlgExcel.tabCommonOptions.getBinMs();
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.detectCage = this.allCagesComboBox.getSelectedIndex() - 1;
        return options;
    }

    void startComputation() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        this.parent0.dlgBrowse.panelLoadSave.closeViewsForCurrentExperiment(exp);
        this.flyDetect1 = new FlyDetect1();
        this.flyDetect1.options = this.initTrackParameters();
        this.flyDetect1.stopFlag = false;
        this.flyDetect1.buildBackground = false;
        this.flyDetect1.detectFlies = true;
        this.flyDetect1.addPropertyChangeListener(this);
        this.flyDetect1.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.flyDetect1 != null && !this.flyDetect1.stopFlag) {
            this.flyDetect1.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        int nitems = 1;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            nitems = exp.cagesArray.cagesList.size() + 1;
        }
        if (this.allCagesComboBox.getItemCount() != nitems) {
            this.allCagesComboBox.removeAllItems();
            this.allCagesComboBox.addItem("all cages");
            for (Cage cage : exp.cagesArray.cagesList) {
                this.allCagesComboBox.addItem(cage.getCageNumber());
            }
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source;
        if (e.getStateChange() == 1 && (source = e.getSource()) instanceof JComboBox) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            this.updateOverlay(exp);
        }
    }
}

