/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.flies;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.painter.Overlay;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.cages.Cage;
import plugins.fmp.multiSPOTS.series.BuildSeriesOptions;
import plugins.fmp.multiSPOTS.series.FlyDetect2;
import plugins.fmp.multiSPOTS.tools.canvas2D.Canvas2D_2Transforms;
import plugins.fmp.multiSPOTS.tools.imageTransform.ImageTransformEnums;
import plugins.fmp.multiSPOTS.tools.overlay.OverlayThreshold;

public class Detect2Flies
extends JPanel
implements ChangeListener,
PropertyChangeListener,
PopupMenuListener {
    private static final long serialVersionUID = -5257698990389571518L;
    private MultiSPOTS parent0 = null;
    private String detectString = "Detect...";
    private JButton startComputationButton = new JButton(this.detectString);
    private JCheckBox allCheckBox = new JCheckBox("ALL (current to last)", false);
    private String[] directions = new String[]{" threshold >", " threshold <"};
    private JComboBox<String> spotsDirectionComboBox = new JComboBox<String>(this.directions);
    private JSpinner thresholdSpinner = new JSpinner(new SpinnerNumberModel(100, 0, 255, 1));
    private JSpinner jitterTextField = new JSpinner(new SpinnerNumberModel(5, 0, 1000, 1));
    private JSpinner objectLowsizeSpinner = new JSpinner(new SpinnerNumberModel(50, 0, 9999, 1));
    private JSpinner objectUpsizeSpinner = new JSpinner(new SpinnerNumberModel(500, 0, 9999, 1));
    private JCheckBox objectLowsizeCheckBox = new JCheckBox("object > ");
    private JCheckBox objectUpsizeCheckBox = new JCheckBox("object < ");
    private JSpinner limitRatioSpinner = new JSpinner(new SpinnerNumberModel(4, 0, 1000, 1));
    private JComboBox<String> allCagesComboBox = new JComboBox<String>(new String[]{"all cages"});
    private JCheckBox overlayCheckBox = new JCheckBox("overlay");
    ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.SUBTRACT_REF};
    private FlyDetect2 flyDetect2 = null;
    private OverlayThreshold overlayThreshold2 = null;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.startComputationButton);
        panel1.add(this.allCagesComboBox);
        this.allCagesComboBox.addPopupMenuListener(this);
        panel1.add(this.allCheckBox);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.spotsDirectionComboBox);
        panel2.add(this.thresholdSpinner);
        panel2.add(this.overlayCheckBox);
        this.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.objectLowsizeCheckBox);
        panel3.add(this.objectLowsizeSpinner);
        panel3.add(this.objectUpsizeCheckBox);
        panel3.add(this.objectUpsizeSpinner);
        this.add(panel3);
        JPanel panel4 = new JPanel(flowLayout);
        panel4.add(new JLabel("ratio L/W <"));
        panel4.add(this.limitRatioSpinner);
        panel4.add(new JLabel("jitter <="));
        panel4.add(this.jitterTextField);
        this.add(panel4);
        this.defineActionListeners();
        this.thresholdSpinner.addChangeListener(this);
    }

    private void defineActionListeners() {
        this.startComputationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Detect2Flies.this.startComputationButton.getText().equals(Detect2Flies.this.detectString)) {
                    Detect2Flies.this.startComputation();
                } else {
                    Detect2Flies.this.stopComputation();
                }
            }
        });
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = Color.BLACK;
                if (Detect2Flies.this.allCheckBox.isSelected()) {
                    color = Color.RED;
                }
                Detect2Flies.this.allCheckBox.setForeground(color);
                Detect2Flies.this.startComputationButton.setForeground(color);
            }
        });
        this.overlayCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Experiment exp = (Experiment)((Detect2Flies)Detect2Flies.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    if (Detect2Flies.this.overlayCheckBox.isSelected()) {
                        Detect2Flies.this.updateOverlay(exp, (Integer)Detect2Flies.this.thresholdSpinner.getValue());
                    } else {
                        Detect2Flies.this.removeOverlay(exp);
                    }
                }
            }
        });
        this.thresholdSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Detect2Flies.this.updateOverlayThreshold();
            }
        });
        this.spotsDirectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Detect2Flies.this.updateOverlayThreshold();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Experiment exp;
        if (e.getSource() == this.thresholdSpinner && (exp = (Experiment)this.parent0.expListCombo.getSelectedItem()) != null) {
            exp.cagesArray.detect_threshold = (Integer)this.thresholdSpinner.getValue();
        }
    }

    private void updateOverlay(Experiment exp, int threshold) {
        SequenceCamData seqCamData = exp.seqCamData;
        if (seqCamData == null) {
            return;
        }
        this.updateTransformFunctionsOfCanvas(exp, true);
        if (this.overlayThreshold2 == null) {
            this.overlayThreshold2 = new OverlayThreshold(seqCamData.seq);
            exp.seqCamData.refImage = IcyBufferedImageUtil.getCopy((IcyBufferedImage)exp.seqCamData.getSeqImage(0, 0));
        } else {
            seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold2);
            this.overlayThreshold2.setSequence(seqCamData.seq);
        }
        seqCamData.seq.addOverlay((Overlay)this.overlayThreshold2);
        boolean ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        this.overlayThreshold2.setThresholdSingle(threshold, ImageTransformEnums.SUBTRACT_REF, ifGreater);
        this.overlayThreshold2.painterChanged();
    }

    void updateOverlayThreshold() {
        if (!this.overlayCheckBox.isSelected()) {
            return;
        }
        int threshold = (Integer)this.thresholdSpinner.getValue();
        if (this.overlayThreshold2 == null) {
            Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
            if (exp != null) {
                this.updateOverlay(exp, threshold);
            }
        } else {
            boolean ifGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
            this.overlayThreshold2.setThresholdSingle(threshold, ImageTransformEnums.SUBTRACT_REF, ifGreater);
            this.overlayThreshold2.painterChanged();
        }
    }

    void removeOverlay(Experiment exp) {
        if (exp.seqCamData != null && exp.seqCamData.seq != null) {
            exp.seqCamData.seq.removeOverlay((Overlay)this.overlayThreshold2);
            this.updateTransformFunctionsOfCanvas(exp, false);
        }
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp, boolean display) {
        Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqCamData.seq.getFirstViewer().getCanvas();
        if (display) {
            canvas.updateTransformsComboStep1(this.transforms);
            canvas.selectImageTransformFunctionStep1(1);
            exp.loadReferenceImage();
            canvas.setTransformStep1ReferenceImage(exp.seqCamData.refImage);
        } else {
            canvas.selectImageTransformFunctionStep1(0);
        }
    }

    private BuildSeriesOptions initTrackParameters() {
        BuildSeriesOptions options = this.flyDetect2.options;
        options.expList = this.parent0.expListCombo;
        options.expList.index0 = this.parent0.expListCombo.getSelectedIndex();
        options.expList.index1 = this.allCheckBox.isSelected() ? options.expList.getItemCount() - 1 : this.parent0.expListCombo.getSelectedIndex();
        options.btrackWhite = true;
        options.blimitLow = this.objectLowsizeCheckBox.isSelected();
        options.blimitUp = this.objectUpsizeCheckBox.isSelected();
        options.limitLow = (Integer)this.objectLowsizeSpinner.getValue();
        options.limitUp = (Integer)this.objectUpsizeSpinner.getValue();
        options.limitRatio = (Integer)this.limitRatioSpinner.getValue();
        options.jitter = (Integer)this.jitterTextField.getValue();
        options.thresholdDiff = (Integer)this.thresholdSpinner.getValue();
        options.overlayIfGreater = this.spotsDirectionComboBox.getSelectedIndex() == 0;
        options.detectFlies = true;
        options.parent0Rect = this.parent0.mainFrame.getBoundsInternal();
        options.isFrameFixed = this.parent0.dlgExcel.tabCommonOptions.getIsFixedFrame();
        options.t_Ms_First = this.parent0.dlgExcel.tabCommonOptions.getStartMs();
        options.t_Ms_Last = this.parent0.dlgExcel.tabCommonOptions.getEndMs();
        options.t_Ms_BinDuration = this.parent0.dlgExcel.tabCommonOptions.getBinMs();
        return options;
    }

    void startComputation() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        this.parent0.dlgBrowse.panelLoadSave.closeViewsForCurrentExperiment(exp);
        this.flyDetect2 = new FlyDetect2();
        this.flyDetect2.options = this.initTrackParameters();
        this.flyDetect2.stopFlag = false;
        this.flyDetect2.addPropertyChangeListener(this);
        this.flyDetect2.execute();
        this.startComputationButton.setText("STOP");
    }

    private void stopComputation() {
        if (this.flyDetect2 != null && !this.flyDetect2.stopFlag) {
            this.flyDetect2.stopFlag = true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (StringUtil.equals((String)"thread_ended", (String)evt.getPropertyName())) {
            this.startComputationButton.setText(this.detectString);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        int nitems = 1;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            nitems = exp.cagesArray.cagesList.size() + 1;
        }
        if (this.allCagesComboBox.getItemCount() != nitems) {
            this.allCagesComboBox.removeAllItems();
            this.allCagesComboBox.addItem("all cages");
            for (Cage cage : exp.cagesArray.cagesList) {
                this.allCagesComboBox.addItem(cage.getCageNumber());
            }
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

