/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.kymos;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.SequenceKymos;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS.tools.Directories;
import plugins.fmp.multiSPOTS.tools.ViewerFMP;
import plugins.fmp.multiSPOTS.tools.canvas2D.Canvas2D_2Transforms;
import plugins.fmp.multiSPOTS.tools.imageTransform.ImageTransformEnums;

public class Display
extends JPanel
implements ViewerListener {
    private static final long serialVersionUID = -2103052112476748890L;
    public int indexImagesCombo = -1;
    public JComboBox<String> kymographsCombo = new JComboBox<String>(new String[]{"none"});
    private JComboBox<String> viewsCombo = new JComboBox();
    private JButton previousButton = new JButton("<");
    private JButton nextButton = new JButton(">");
    private JCheckBox sumCheckbox = new JCheckBox("sum (black)", true);
    private JCheckBox sumCleanCheckbox = new JCheckBox("sumCLEAN (green)", true);
    private JCheckBox flyPresentCheckbox = new JCheckBox("fly present (blue)", true);
    private ImageTransformEnums[] transforms = new ImageTransformEnums[]{ImageTransformEnums.SORT_SUMDIFFCOLS, ImageTransformEnums.SORT_CHAN0COLS};
    JComboBox<ImageTransformEnums> spotsTransformsComboBox = new JComboBox<ImageTransformEnums>(this.transforms);
    JToggleButton spotsViewButton = new JToggleButton("View");
    private MultiSPOTS parent0 = null;
    private boolean isActionEnabled = true;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        this.parent0 = parent0;
        FlowLayout layout = new FlowLayout(0);
        layout.setVgap(0);
        JPanel panel1 = new JPanel(layout);
        panel1.add(new JLabel("views"));
        panel1.add(this.viewsCombo);
        panel1.add(new JLabel(" kymograph"));
        int bWidth = 30;
        int bHeight = 21;
        panel1.add((Component)this.previousButton, "West");
        this.previousButton.setPreferredSize(new Dimension(bWidth, bHeight));
        panel1.add(this.kymographsCombo, "Center");
        this.nextButton.setPreferredSize(new Dimension(bWidth, bHeight));
        panel1.add((Component)this.nextButton, "East");
        this.add(panel1);
        JPanel panel2 = new JPanel(layout);
        panel2.add(this.sumCheckbox);
        panel2.add(this.sumCleanCheckbox);
        panel2.add(this.flyPresentCheckbox);
        this.add(panel2);
        JPanel panel3 = new JPanel(layout);
        panel3.add(new JLabel("transform image"));
        panel3.add(this.spotsTransformsComboBox);
        panel3.add(this.spotsViewButton);
        this.add(panel3);
        this.defineActionListeners();
    }

    private void defineActionListeners() {
        this.kymographsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Display.this.isActionEnabled) {
                    Display.this.displayUpdateOnSwingThread();
                }
            }
        });
        this.sumCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("sum", Display.this.sumCheckbox.isSelected());
            }
        });
        this.sumCleanCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("clean", Display.this.sumCleanCheckbox.isSelected());
            }
        });
        this.flyPresentCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Display.this.displayROIs("flyPresent", Display.this.flyPresentCheckbox.isSelected());
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int isel = Display.this.kymographsCombo.getSelectedIndex() + 1;
                if (isel < Display.this.kymographsCombo.getItemCount()) {
                    isel = Display.this.selectKymographImage(isel);
                    Display.this.selectKymographComboItem(isel);
                }
            }
        });
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int isel = Display.this.kymographsCombo.getSelectedIndex() - 1;
                if (isel < Display.this.kymographsCombo.getItemCount()) {
                    isel = Display.this.selectKymographImage(isel);
                    Display.this.selectKymographComboItem(isel);
                }
            }
        });
        this.viewsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String localString = (String)Display.this.viewsCombo.getSelectedItem();
                if (localString != null && localString.contains(".")) {
                    localString = null;
                }
                if (Display.this.isActionEnabled) {
                    Display.this.changeBinSubdirectory(localString);
                }
            }
        });
        this.spotsViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Display)Display.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Display.this.displayTransform(exp);
                }
            }
        });
    }

    public void transferSpotNamesToComboBox(final Experiment exp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.kymographsCombo.removeAllItems();
                Collections.sort(exp.spotsArray.spotsList);
                int nspotsArray = exp.spotsArray.spotsList.size();
                for (int i = 0; i < nspotsArray; ++i) {
                    Spot spot = exp.spotsArray.spotsList.get(i);
                    String name = spot.getPlateCoordinatesAsString();
                    Display.this.kymographsCombo.addItem(name);
                }
            }
        });
    }

    public void displayROIsAccordingToUserSelection() {
        this.displayROIs("level", this.sumCheckbox.isSelected());
    }

    private void displayROIs(String filter, boolean visible) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Viewer v = exp.seqSpotKymos.seq.getFirstViewer();
        if (v == null) {
            return;
        }
        IcyCanvas canvas = v.getCanvas();
        List layers = canvas.getLayers(false);
        if (layers != null) {
            for (Layer layer : layers) {
                String cs;
                ROI roi = layer.getAttachedROI();
                if (roi == null || !(cs = roi.getName()).contains(filter)) continue;
                layer.setVisible(visible);
            }
        }
    }

    void displayON() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            SequenceKymos seqKymographs = exp.seqSpotKymos;
            if (seqKymographs == null || seqKymographs.seq == null) {
                return;
            }
            ArrayList vList = seqKymographs.seq.getViewers();
            if (vList.size() == 0) {
                ViewerFMP v = new ViewerFMP(seqKymographs.seq, true, true);
                List list = IcyCanvas.getCanvasPluginNames();
                String pluginName = list.stream().filter(s -> s.contains("Canvas2D_2Transforms")).findFirst().orElse(null);
                v.setCanvas(pluginName);
                v.setRepeat(false);
                v.addListener(this);
                JToolBar toolBar = v.getToolBar();
                Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)v.getCanvas();
                canvas.customizeToolbarStep2(toolBar);
                this.placeKymoViewerNextToCamViewer(exp);
                int isel = seqKymographs.currentFrame;
                isel = this.selectKymographImage(isel);
                this.selectKymographComboItem(isel);
                canvas.selectImageTransformFunctionStep2(2);
                String title = this.kymographsCombo.getItemAt(0);
                v.setTitle(title);
            }
        }
    }

    void placeKymoViewerNextToCamViewer(Experiment exp) {
        Sequence seqCamData = exp.seqCamData.seq;
        Viewer viewerCamData = seqCamData.getFirstViewer();
        if (viewerCamData == null) {
            return;
        }
        Rectangle rectViewerCamData = viewerCamData.getBounds();
        Sequence seqKymograph = exp.seqSpotKymos.seq;
        Rectangle rectViewerKymograph = (Rectangle)rectViewerCamData.clone();
        Rectangle rectImageKymograph = seqKymograph.getBounds2D();
        int desktopwidth = Icy.getMainInterface().getMainFrame().getDesktopWidth();
        rectViewerKymograph.width = (int)rectImageKymograph.getWidth();
        if (rectViewerKymograph.width + rectViewerKymograph.x > desktopwidth) {
            rectViewerKymograph.x = 0;
            rectViewerKymograph.y = rectViewerCamData.y + rectViewerCamData.height + 5;
            rectViewerKymograph.width = desktopwidth;
            rectViewerKymograph.height = rectImageKymograph.height;
        } else {
            rectViewerKymograph.translate(5 + rectViewerCamData.width, 0);
        }
        Viewer viewerKymograph = seqKymograph.getFirstViewer();
        if (viewerKymograph == null) {
            return;
        }
        viewerKymograph.setBounds(rectViewerKymograph);
        ((Canvas2D)viewerKymograph.getCanvas()).setFitToCanvas(false);
    }

    void displayOFF() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null || exp.seqSpotKymos == null) {
            return;
        }
        ArrayList vList = exp.seqSpotKymos.seq.getViewers();
        if (vList.size() > 0) {
            for (Viewer v : vList) {
                v.close();
            }
            vList.clear();
        }
    }

    public void displayUpdateOnSwingThread() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int isel = Display.this.selectKymographImage(Display.this.displayUpdate());
                Display.this.selectKymographComboItem(isel);
            }
        });
    }

    public void displayUpdateOnSwingThread2(final int isel, final int imethod) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Display.this.selectKymographImage(isel);
                Display.this.selectKymographComboItem(isel);
                Display.this.spotsTransformsComboBox.setSelectedIndex(imethod);
                ((Display)Display.this).parent0.dlgKymos.tabDisplay.spotsTransformsComboBox.setSelectedIndex(1);
                ((Display)Display.this).parent0.dlgKymos.tabDisplay.spotsViewButton.setSelected(true);
                Experiment exp = (Experiment)((Display)Display.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    Display.this.updateTransformFunctionsOfCanvas(exp);
                }
            }
        });
    }

    int displayUpdate() {
        int item = -1;
        if (this.kymographsCombo.getItemCount() < 1) {
            return item;
        }
        this.displayON();
        item = this.kymographsCombo.getSelectedIndex();
        if (item < 0) {
            item = this.indexImagesCombo >= 0 ? this.indexImagesCombo : 0;
            this.indexImagesCombo = -1;
        }
        return item;
    }

    private void selectKymographComboItem(int isel) {
        int icurrent = this.kymographsCombo.getSelectedIndex();
        if (isel >= 0 && isel != icurrent) {
            this.kymographsCombo.setSelectedIndex(isel);
        }
    }

    public int selectKymographImage(int isel) {
        int selectedImageIndex = -1;
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return selectedImageIndex;
        }
        SequenceKymos seqKymos = exp.seqSpotKymos;
        if (seqKymos == null || seqKymos.seq == null) {
            return selectedImageIndex;
        }
        if (seqKymos.seq.isUpdating()) {
            return selectedImageIndex;
        }
        if (isel < 0) {
            isel = 0;
        }
        if (isel >= seqKymos.getImagesList().size()) {
            isel = seqKymos.getImagesList().size() - 1;
        }
        seqKymos.seq.beginUpdate();
        Viewer v = seqKymos.seq.getFirstViewer();
        if (v != null) {
            int icurrent = v.getPositionT();
            if (icurrent != isel) {
                v.setPositionT(isel);
            }
            seqKymos.currentFrame = isel;
        }
        seqKymos.seq.endUpdate();
        selectedImageIndex = seqKymos.currentFrame;
        this.displayROIsAccordingToUserSelection();
        this.selectSpot(exp, selectedImageIndex);
        return selectedImageIndex;
    }

    private void selectSpot(Experiment exp, int isel) {
        SpotsArray spotsArray = exp.spotsArray;
        for (Spot spot : spotsArray.spotsList) {
            spot.getRoi().setSelected(false);
            spot.getRoi().setFocused(false);
        }
        if (isel >= 0) {
            Spot selectedSpot = spotsArray.spotsList.get(isel);
            selectedSpot.getRoi().setFocused(true);
        }
    }

    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED && event.getDim() == DimensionId.T) {
            Viewer v = event.getSource();
            int t = v.getPositionT();
            if (t >= 0) {
                this.selectKymographComboItem(t);
            }
            String title = this.kymographsCombo.getItemAt(t);
            v.setTitle(title);
        }
    }

    public void viewerClosed(Viewer viewer) {
        viewer.removeListener((ViewerListener)this);
    }

    public void updateResultsAvailable(Experiment exp) {
        this.isActionEnabled = false;
        this.viewsCombo.removeAllItems();
        List<String> list = Directories.getSortedListOfSubDirectoriesWithTIFF(exp.getResultsDirectory());
        for (int i = 0; i < list.size(); ++i) {
            String dirName = list.get(i);
            if (dirName == null || dirName.contains("results")) {
                dirName = ".";
            }
            this.viewsCombo.addItem(dirName);
        }
        this.isActionEnabled = true;
        String select = exp.getBinSubDirectory();
        if (select == null) {
            select = ".";
        }
        this.viewsCombo.setSelectedItem(select);
    }

    public String getBinSubdirectory() {
        String name = (String)this.viewsCombo.getSelectedItem();
        if (name != null && !name.contains("bin_")) {
            name = null;
        }
        return name;
    }

    private void changeBinSubdirectory(String localString) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null || localString == null || exp.getBinSubDirectory().contains(localString)) {
            return;
        }
        this.parent0.expListCombo.stringExpBinSubDirectory = localString;
        exp.setBinSubDirectory(localString);
        exp.seqSpotKymos.seq.close();
        exp.loadKymographs();
        this.parent0.dlgKymos.updateDialogs(exp);
    }

    private void displayTransform(Experiment exp) {
        if (this.spotsViewButton.isSelected()) {
            this.updateTransformFunctionsOfCanvas(exp);
        } else {
            Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)exp.seqSpotKymos.seq.getFirstViewer().getCanvas();
            canvas.transformsComboStep2.setSelectedIndex(0);
        }
    }

    private void updateTransformFunctionsOfCanvas(Experiment exp) {
        Viewer viewer = exp.seqSpotKymos.seq.getFirstViewer();
        if (viewer != null) {
            Canvas2D_2Transforms canvas = (Canvas2D_2Transforms)viewer.getCanvas();
            canvas.updateTransformsComboStep2(this.transforms);
            int index = this.spotsTransformsComboBox.getSelectedIndex();
            canvas.selectImageTransformFunctionStep2(index + 1);
        }
    }
}

