/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.frame.progress.AnnounceFrame;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.ExperimentUtils;
import plugins.fmp.multiSPOTS.experiment.SequenceCamData;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.experiment.spots.SpotsArray;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROIUtilities;
import plugins.fmp.multiSPOTS.tools.polyline.PolygonUtilities;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class CreateSpots
extends JPanel {
    private static final long serialVersionUID = -5257698990389571518L;
    private JButton displayFrameDButton = new JButton("(1) Display frame");
    private JButton createCirclesButton = new JButton("(2) Create circles");
    private JSpinner nColsPerCageJSpinner = new JSpinner(new SpinnerNumberModel(2, 1, 500, 1));
    private JSpinner nRowsPerCageJSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 500, 1));
    private JSpinner nFliesPerCageJSpinner = new JSpinner(new SpinnerNumberModel(1, 0, 500, 1));
    private JSpinner pixelRadiusSpinner = new JSpinner(new SpinnerNumberModel(10, 1, 1000, 1));
    private JSpinner nRowsJSpinner = new JSpinner(new SpinnerNumberModel(8, 2, 100, 1));
    private JSpinner nColumnsJSpinner = new JSpinner(new SpinnerNumberModel(12, 2, 100, 1));
    private Polygon2D polygon2D = null;
    private String[] flyString = new String[]{"fly", "flies"};
    private JLabel flyLabel = new JLabel(this.flyString[0]);
    private MultiSPOTS parent0 = null;
    private boolean silent = false;

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.displayFrameDButton);
        panel0.add(this.createCirclesButton);
        panel0.add(this.pixelRadiusSpinner);
        this.pixelRadiusSpinner.setPreferredSize(new Dimension(40, 20));
        panel0.add(new JLabel("pixels"));
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(new JLabel("Spots:"));
        panel1.add(new JLabel("cols"));
        panel1.add(this.nColumnsJSpinner);
        this.nColumnsJSpinner.setPreferredSize(new Dimension(40, 20));
        panel1.add(new JLabel("rows"));
        panel1.add(this.nRowsJSpinner);
        this.nRowsJSpinner.setPreferredSize(new Dimension(40, 20));
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(new JLabel("Grouped within n cols"));
        panel2.add(this.nColsPerCageJSpinner);
        this.nColsPerCageJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(new JLabel("& n rows"));
        panel2.add(this.nRowsPerCageJSpinner);
        this.nRowsPerCageJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(new JLabel("with"));
        panel2.add(this.nFliesPerCageJSpinner);
        this.nFliesPerCageJSpinner.setPreferredSize(new Dimension(40, 20));
        panel2.add(this.flyLabel);
        this.add(panel0);
        this.add(panel1);
        this.add(panel2);
        this.defineActionListeners();
        this.parent0 = parent0;
    }

    private void defineActionListeners() {
        this.displayFrameDButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateSpots.this.create2DPolygon();
            }
        });
        this.createCirclesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateSpots.this.polygon2D = CreateSpots.this.getPolygonEnclosingSpotsFromSelectedRoi(exp);
                    if (CreateSpots.this.polygon2D != null) {
                        CreateSpots.this.createSpotsFromPolygon(exp, CreateSpots.this.polygon2D);
                        ExperimentUtils.transferSpotsToCamDataSequence(exp);
                        int nbFliesPerCage = (Integer)CreateSpots.this.nFliesPerCageJSpinner.getValue();
                        exp.spotsArray.initSpotsWithNFlies(nbFliesPerCage);
                    }
                }
            }
        });
        this.nFliesPerCageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i = (Integer)CreateSpots.this.nFliesPerCageJSpinner.getValue() > 1 ? 1 : 0;
                CreateSpots.this.flyLabel.setText(CreateSpots.this.flyString[i]);
                CreateSpots.this.nFliesPerCageJSpinner.requestFocus();
            }
        });
        this.nColsPerCageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateSpots.this.updateCageDescriptorsOfSpots(exp);
                }
            }
        });
        this.nRowsPerCageJSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Experiment exp = (Experiment)((CreateSpots)CreateSpots.this).parent0.expListCombo.getSelectedItem();
                if (exp != null) {
                    CreateSpots.this.updateCageDescriptorsOfSpots(exp);
                }
            }
        });
    }

    private void create2DPolygon() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        SequenceCamData seqCamData = exp.seqCamData;
        String dummyname = "perimeter_enclosing_spots";
        if (this.isRoiPresent(seqCamData, "perimeter_enclosing_spots")) {
            return;
        }
        ROI2DPolygon roi = new ROI2DPolygon(this.getSpotsPolygon(exp));
        roi.setName("perimeter_enclosing_spots");
        seqCamData.seq.addROI((ROI)roi);
        seqCamData.seq.setSelectedROI((ROI)roi);
    }

    private boolean isRoiPresent(SequenceCamData seqCamData, String dummyname) {
        ArrayList listRois = seqCamData.seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!roi.getName().equals(dummyname)) continue;
            return true;
        }
        return false;
    }

    private Polygon2D getSpotsPolygon(Experiment exp) {
        if (this.polygon2D == null) {
            if (exp.spotsArray.spotsList.size() > 0) {
                this.polygon2D = exp.spotsArray.getPolygon2DEnclosingAllSpots();
            } else {
                Rectangle rect = exp.seqCamData.seq.getBounds2D();
                ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
                points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height / 5));
                points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height / 5));
                points.add(new Point2D.Double(rect.x + rect.width * 4 / 5, rect.y + rect.height * 2 / 3));
                points.add(new Point2D.Double(rect.x + rect.width / 5, rect.y + rect.height * 2 / 3));
                this.polygon2D = new Polygon2D(points);
            }
        }
        return this.polygon2D;
    }

    private Polygon2D getPolygonEnclosingSpotsFromSelectedRoi(Experiment exp) {
        SequenceCamData seqCamData = exp.seqCamData;
        ROI2D roi = seqCamData.seq.getSelectedROI2D();
        if (!(roi instanceof ROI2DPolygon)) {
            new AnnounceFrame("The frame must be a ROI2D Polygon");
            return null;
        }
        this.polygon2D = PolygonUtilities.orderVerticesOf4CornersPolygon(((ROI2DPolygon)roi).getPolygon());
        seqCamData.seq.removeROI((ROI)roi);
        return this.polygon2D;
    }

    private void createSpotsFromPolygon(Experiment exp, Polygon2D polygon2D) {
        int n_columns = 10;
        int n_rows = 1;
        int radius = 3;
        try {
            n_columns = (Integer)this.nColumnsJSpinner.getValue();
            n_rows = (Integer)this.nRowsJSpinner.getValue();
            radius = (Integer)this.pixelRadiusSpinner.getValue();
        }
        catch (Exception e) {
            new AnnounceFrame("Can't interpret one of the ROI parameters value");
        }
        exp.seqCamData.seq.removeROIs(ROIUtilities.getROIsContainingString("spot", exp.seqCamData.seq), false);
        exp.spotsArray.spotsList.clear();
        exp.spotsArray = new SpotsArray();
        Point2D.Double[][] arrayPoints = PolygonUtilities.createArrayOfPointsFromPolygon(polygon2D, n_columns, n_rows);
        this.convertPoint2DArrayToSpots(exp, arrayPoints, n_columns, n_rows, radius);
        this.updateCageDescriptorsOfSpots(exp);
    }

    private void convertPoint2DArrayToSpots(Experiment exp, Point2D.Double[][] arrayPoints, int nbcols, int nbrows, int radius) {
        exp.spotsArray.nColumnsPerPlate = nbcols;
        exp.spotsArray.nRowsPerPlate = nbrows;
        int spotIndex = 0;
        for (int row = 0; row < nbrows; ++row) {
            for (int column = 0; column < nbcols; ++column) {
                Point2D.Double point = arrayPoints[column][row];
                double x = ((Point2D)point).getX() - (double)radius;
                double y = ((Point2D)point).getY() - (double)radius;
                Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, 2 * radius, 2 * radius);
                ROI2DEllipse roiEllipse = new ROI2DEllipse((Ellipse2D)ellipse);
                roiEllipse.setName("spot_" + String.format("%03d", row) + String.format("%03d", column));
                Spot spot = new Spot((ROI2DShape)roiEllipse);
                spot.plateIndex = spotIndex;
                spot.plateColumn = column;
                spot.plateRow = row;
                spot.spotRadius = radius;
                spot.spotXCoord = (int)((Point2D)point).getX();
                spot.spotYCoord = (int)((Point2D)point).getY();
                try {
                    spot.spotNPixels = (int)roiEllipse.getNumberOfPoints();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                exp.spotsArray.spotsList.add(spot);
                ++spotIndex;
            }
        }
    }

    private void updateCageDescriptorsOfSpots(Experiment exp) {
        if (this.silent) {
            return;
        }
        int nColsPerCage = (Integer)this.nColsPerCageJSpinner.getValue();
        int nRowsPerCage = (Integer)this.nRowsPerCageJSpinner.getValue();
        exp.spotsArray.updatePlateIndexToCageIndexes(nColsPerCage, nRowsPerCage);
    }

    public void updateDialog(Experiment exp) {
        if (exp != null) {
            this.silent = true;
            this.nColsPerCageJSpinner.setValue(exp.spotsArray.nColumnsPerCage);
            this.nRowsPerCageJSpinner.setValue(exp.spotsArray.nRowsPerCage);
            this.silent = false;
        }
    }
}

