/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.dialog.ConfirmDialog;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.type.geom.Polygon2D;
import icy.type.geom.Polyline2D;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.dlg.spots.EditPositionWithTime;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Edit
extends JPanel {
    private static final long serialVersionUID = -7582410775062671523L;
    private JButton editSpotsButton = new JButton("Change spots position with time");
    private JCheckBox showFrameButton = new JCheckBox("Select spots within frame");
    private JToggleButton displaySnakeButton = new JToggleButton("Display snake over spots");
    private JButton updateSpotsFromSnakeButton = new JButton("Center spots to snake");
    private MultiSPOTS parent0 = null;
    private EditPositionWithTime editSpotsTable = null;
    private final String dummyname = "perimeter_enclosing";
    private ROI2DPolygon spotsFrame = null;
    private ArrayList<Spot> enclosedSpots = null;
    private ROI2DPolyLine snakeRoi = null;
    private JButton erodeButton = new JButton("Contract spots");
    private JButton dilateButton = new JButton("Dilate spots");

    void init(GridLayout capLayout, MultiSPOTS parent0) {
        this.parent0 = parent0;
        this.setLayout(capLayout);
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setVgap(0);
        JPanel panel0 = new JPanel(flowLayout);
        panel0.add(this.showFrameButton);
        panel0.add(this.displaySnakeButton);
        panel0.add(this.updateSpotsFromSnakeButton);
        this.add(panel0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(this.dilateButton);
        panel1.add(this.erodeButton);
        this.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.editSpotsButton);
        this.add(panel2);
        this.defineActionListeners();
        this.updateButtonsState(false);
    }

    private void updateButtonsState(boolean isFrameSelected) {
        this.displaySnakeButton.setEnabled(isFrameSelected);
        this.updateSpotsFromSnakeButton.setEnabled(this.displaySnakeButton.isSelected() ? isFrameSelected : false);
    }

    private void defineActionListeners() {
        this.editSpotsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                Edit.this.openDialog();
            }
        });
        this.showFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                Edit.this.updateButtonsState(Edit.this.showFrameButton.isSelected());
                Edit.this.showFrame(Edit.this.showFrameButton.isSelected());
            }
        });
        this.displaySnakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                if (Edit.this.displaySnakeButton.isSelected()) {
                    Edit.this.displaySnake(exp);
                } else {
                    Edit.this.removeSnake(exp);
                }
                Edit.this.updateButtonsState(Edit.this.showFrameButton.isSelected());
            }
        });
        this.updateSpotsFromSnakeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                Edit.this.updateSpotsFromSnake(exp);
            }
        });
        this.dilateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                Edit.this.resizeSpots(exp, 1);
            }
        });
        this.erodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Experiment exp = (Experiment)((Edit)Edit.this).parent0.expListCombo.getSelectedItem();
                if (exp == null) {
                    return;
                }
                Edit.this.resizeSpots(exp, -1);
            }
        });
    }

    private Point getFramePosition() {
        Point point = new Point();
        Container currComponent = this.editSpotsButton;
        int indexMax = 12;
        for (int index = 0; currComponent != null && index < indexMax; currComponent = currComponent.getParent(), ++index) {
            Point relativeLocation = currComponent.getLocation();
            point.translate(relativeLocation.x, relativeLocation.y);
        }
        return point;
    }

    public void openDialog() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp != null) {
            if (this.editSpotsTable == null) {
                this.editSpotsTable = new EditPositionWithTime();
            }
            this.editSpotsTable.initialize(this.parent0, this.getFramePosition());
        }
    }

    public void closeDialog() {
        this.editSpotsTable.close();
    }

    private void showFrame(boolean show) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        if (show) {
            int t = exp.seqCamData.seq.getFirstViewer().getPositionT();
            this.addFrameAroundSpots(t, exp);
        } else {
            this.removeSpotsFrame(exp);
            this.removeSnake(exp);
        }
    }

    private void addFrameAroundSpots(int t, Experiment exp) {
        if (this.spotsFrame == null) {
            ArrayList<ROI2D> listRoisAtT = new ArrayList<ROI2D>();
            for (Spot spot : exp.spotsArray.spotsList) {
                ROI2DAlongT kymoROI2D = spot.getROIAtT(t);
                listRoisAtT.add(kymoROI2D.getRoi_in());
            }
            Polygon2D polygon = ROI2DUtilities.getPolygonEnclosingROI2Ds(listRoisAtT);
            this.spotsFrame = new ROI2DPolygon(polygon);
            this.spotsFrame.setName("perimeter_enclosing");
            this.spotsFrame.setColor(Color.YELLOW);
        }
        exp.seqCamData.seq.removeROI((ROI)this.spotsFrame);
        exp.seqCamData.seq.addROI((ROI)this.spotsFrame);
        exp.seqCamData.seq.setSelectedROI((ROI)this.spotsFrame);
        this.removeSnake(exp);
    }

    private void displaySnake(Experiment exp) {
        this.enclosedSpots = exp.spotsArray.getSpotsEnclosed(this.spotsFrame);
        if (this.enclosedSpots.size() > 0) {
            ArrayList<Point2D.Double> listPoint = new ArrayList<Point2D.Double>();
            for (Spot spot : this.enclosedSpots) {
                listPoint.add(new Point2D.Double(spot.spotXCoord, spot.spotYCoord));
            }
            this.snakeRoi = new ROI2DPolyLine(listPoint);
            exp.seqCamData.seq.addROI((ROI)this.snakeRoi);
            exp.seqCamData.seq.setSelectedROI((ROI)this.snakeRoi);
        }
    }

    private void removeSnake(Experiment exp) {
        if (this.snakeRoi != null) {
            exp.seqCamData.seq.removeROI((ROI)this.snakeRoi);
        }
        this.snakeRoi = null;
    }

    private void removeSpotsFrame(Experiment exp) {
        if (this.spotsFrame != null) {
            exp.seqCamData.seq.removeROI((ROI)this.spotsFrame);
        }
        this.spotsFrame = null;
    }

    private void updateSpotsFromSnake(Experiment exp) {
        if (this.enclosedSpots != null && this.enclosedSpots.size() > 0 && this.snakeRoi != null) {
            Polyline2D snake = this.snakeRoi.getPolyline2D();
            int i = 0;
            for (Spot spot : this.enclosedSpots) {
                double deltax = snake.xpoints[i] - (double)spot.spotXCoord;
                double deltay = snake.ypoints[i] - (double)spot.spotYCoord;
                spot.spotXCoord = (int)snake.xpoints[i];
                spot.spotYCoord = (int)snake.ypoints[i];
                spot.getRoi().translate(deltax, deltay);
                ++i;
            }
        }
    }

    private void resizeSpots(Experiment exp, int delta) {
        this.enclosedSpots = exp.spotsArray.getSpotsEnclosed(this.spotsFrame);
        if (this.enclosedSpots.size() > 0) {
            for (Spot spot : this.enclosedSpots) {
                ROI2DShape roi = (ROI2DShape)spot.getRoi();
                exp.seqCamData.seq.removeROI((ROI)roi);
                roi = (ROI2DShape)ROI2DUtilities.resizeROI((ROI2D)roi, delta);
                spot.setRoi(roi);
                exp.seqCamData.seq.addROI((ROI)roi);
            }
        } else {
            ConfirmDialog.confirm((String)"At least one spot must be selected");
        }
    }
}

