/*
 * Decompiled with CFR 0.152.
 */
package plugins.fmp.multiSPOTS.dlg.spots;

import icy.gui.frame.IcyFrame;
import icy.gui.viewer.Viewer;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.type.geom.Polygon2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import plugins.fmp.multiSPOTS.MultiSPOTS;
import plugins.fmp.multiSPOTS.experiment.Experiment;
import plugins.fmp.multiSPOTS.experiment.spots.Spot;
import plugins.fmp.multiSPOTS.tools.JComponents.TableModelSpotWithTime;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DAlongT;
import plugins.fmp.multiSPOTS.tools.ROI2D.ROI2DUtilities;
import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class EditPositionWithTime
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    IcyFrame dialogFrame = null;
    private JButton addItemButton = new JButton("Add");
    private JButton deleteItemButton = new JButton("Delete");
    private JButton saveSpotsButton = new JButton("Save spots");
    private JCheckBox showFrameButton = new JCheckBox("Show frame");
    private JButton fitToFrameButton = new JButton("Fit spots to frame");
    private JTable tableView = new JTable();
    private final String dummyname = "perimeter_enclosing";
    private ROI2DPolygon envelopeRoi = null;
    private ROI2DPolygon envelopeRoi_initial = null;
    private MultiSPOTS parent0 = null;
    private TableModelSpotWithTime spotsWithTimeTablemodel = null;

    public void initialize(MultiSPOTS parent0, Point pt) {
        this.parent0 = parent0;
        this.spotsWithTimeTablemodel = new TableModelSpotWithTime(parent0.expListCombo);
        JPanel topPanel = new JPanel(new GridLayout(3, 1));
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel panel1 = new JPanel(flowLayout);
        panel1.add(new JLabel("Viewer frame T:"));
        panel1.add(this.addItemButton);
        panel1.add(this.deleteItemButton);
        topPanel.add(panel1);
        JPanel panel2 = new JPanel(flowLayout);
        panel2.add(this.showFrameButton);
        panel2.add(this.fitToFrameButton);
        panel2.add(this.saveSpotsButton);
        topPanel.add(panel2);
        JPanel panel3 = new JPanel(flowLayout);
        panel3.add(this.saveSpotsButton);
        topPanel.add(panel3);
        this.tableView.setModel(this.spotsWithTimeTablemodel);
        this.tableView.setSelectionMode(0);
        this.tableView.setPreferredScrollableViewportSize(new Dimension(180, 300));
        this.tableView.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.tableView);
        JPanel tablePanel = new JPanel();
        tablePanel.add(scrollPane);
        this.dialogFrame = new IcyFrame("Edit spots position", true, true);
        this.dialogFrame.add((Component)topPanel, (Object)"North");
        this.dialogFrame.add((Component)tablePanel, (Object)"Center");
        this.dialogFrame.setLocation(pt);
        this.dialogFrame.pack();
        this.dialogFrame.addToDesktopPane();
        this.dialogFrame.requestFocus();
        this.dialogFrame.setVisible(true);
        this.defineActionListeners();
        this.defineSelectionListener();
        this.fitToFrameButton.setEnabled(false);
    }

    private void defineActionListeners() {
        this.fitToFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPositionWithTime.this.moveAllSpots();
            }
        });
        this.showFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPositionWithTime.this.fitToFrameButton.setEnabled(EditPositionWithTime.this.showFrameButton.isSelected());
                EditPositionWithTime.this.showFrame(EditPositionWithTime.this.showFrameButton.isSelected());
            }
        });
        this.addItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPositionWithTime.this.addTableItem();
            }
        });
        this.deleteItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = EditPositionWithTime.this.tableView.getSelectedRow();
                EditPositionWithTime.this.deleteTableItem(selectedRow);
            }
        });
        this.saveSpotsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = EditPositionWithTime.this.tableView.getSelectedRow();
                EditPositionWithTime.this.saveSpots(selectedRow);
            }
        });
    }

    private void defineSelectionListener() {
        this.tableView.getSelectionModel().addListSelectionListener(this);
    }

    void close() {
        this.dialogFrame.close();
    }

    private void moveAllSpots() {
        if (this.envelopeRoi == null) {
            return;
        }
        Point2D pt0 = this.envelopeRoi_initial.getPosition2D();
        Point2D pt1 = this.envelopeRoi.getPosition2D();
        this.envelopeRoi_initial = new ROI2DPolygon(this.envelopeRoi.getPolygon2D());
        double deltaX = pt1.getX() - pt0.getX();
        double deltaY = pt1.getY() - pt0.getY();
        this.shiftPositionOfSpots(deltaX, deltaY);
    }

    private void shiftPositionOfSpots(double deltaX, double deltaY) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Sequence seq = exp.seqCamData.seq;
        ArrayList listRois = seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            if (!roi.getName().contains("spot")) continue;
            Point2D point2d = roi.getPosition2D();
            roi.setPosition2D((Point2D)new Point2D.Double(point2d.getX() + deltaX, point2d.getY() + deltaY));
        }
    }

    private void showFrame(boolean show) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        if (show) {
            int t = exp.seqCamData.seq.getFirstViewer().getPositionT();
            this.addFrameAroundSpots(t, exp);
        } else {
            this.removeFrameAroundSpots(exp.seqCamData.seq);
        }
    }

    private void addFrameAroundSpots(int t, Experiment exp) {
        ArrayList<ROI2D> listRoisAtT = new ArrayList<ROI2D>();
        for (Spot spot : exp.spotsArray.spotsList) {
            ROI2DAlongT kymoROI2D = spot.getROIAtT(t);
            listRoisAtT.add(kymoROI2D.getRoi_in());
        }
        Polygon2D polygon = ROI2DUtilities.getPolygonEnclosingROI2Ds(listRoisAtT);
        this.removeFrameAroundSpots(exp.seqCamData.seq);
        this.envelopeRoi_initial = new ROI2DPolygon(polygon);
        this.envelopeRoi = new ROI2DPolygon(polygon);
        this.envelopeRoi.setName("perimeter_enclosing");
        this.envelopeRoi.setColor(Color.YELLOW);
        exp.seqCamData.seq.addROI((ROI)this.envelopeRoi);
        exp.seqCamData.seq.setSelectedROI((ROI)this.envelopeRoi);
    }

    private void removeFrameAroundSpots(Sequence seq) {
        seq.removeROI((ROI)this.envelopeRoi);
        seq.removeROI((ROI)this.envelopeRoi_initial);
    }

    private void addTableItem() {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        long intervalT = v.getPositionT();
        if (exp.spotsArray.findKymoROI2DIntervalStart(intervalT) < 0) {
            exp.spotsArray.addKymoROI2DInterval(intervalT);
        }
    }

    private void deleteTableItem(int selectedRow) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Viewer v = exp.seqCamData.seq.getFirstViewer();
        long intervalT = v.getPositionT();
        if (exp.spotsArray.findKymoROI2DIntervalStart(intervalT) >= 0) {
            exp.spotsArray.deleteKymoROI2DInterval(intervalT);
        }
    }

    private void displaySpotsForSelectedInterval(int selectedRow) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Sequence seq = exp.seqCamData.seq;
        int intervalT = (int)exp.spotsArray.getKymoROI2DIntervalsStartAt(selectedRow);
        seq.removeAllROI();
        ArrayList<ROI2D> listRois = new ArrayList<ROI2D>();
        for (Spot spot : exp.spotsArray.spotsList) {
            listRois.add(spot.getROIAtT(intervalT).getRoi_in());
        }
        seq.addROIs(listRois, false);
        Viewer v = seq.getFirstViewer();
        v.setPositionT(intervalT);
    }

    private void saveSpots(int selectedRow) {
        Experiment exp = (Experiment)this.parent0.expListCombo.getSelectedItem();
        if (exp == null) {
            return;
        }
        Sequence seq = exp.seqCamData.seq;
        int intervalT = (int)exp.spotsArray.getKymoROI2DIntervalsStartAt(selectedRow);
        ArrayList listRois = seq.getROI2Ds();
        for (ROI2D roi : listRois) {
            Spot spot;
            if (!roi.getName().contains("line") || (spot = exp.spotsArray.getSpotFromName(roi.getName())) == null) continue;
            ROI2D roilocal = (ROI2D)roi.getCopy();
            spot.getROIAtT(intervalT).setRoi_in(roilocal);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selectedRow = this.tableView.getSelectedRow();
        if (selectedRow < 0) {
            this.tableView.setRowSelectionInterval(0, 0);
            selectedRow = 0;
        }
        this.displaySpotsForSelectedInterval(selectedRow);
        this.showFrame(this.showFrameButton.isSelected());
    }
}

